/*
 * BeeEncodedKeySpec.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto.spec;

import java.security.*;
import java.security.spec.*;

/**
 * This class specifies keys encoded in the "Bee" format. It is used by KeyFactory classes
 * in the com.beeyond.crypto package.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 * <p>
 * @see com.beeyond.crypto.ElGamalKeyFactory
 */
public class BeeEncodedKeySpec extends EncodedKeySpec
{
	private static final String
		FORMAT = "Bee";

	/**
	 * Constructor that takes a key encoded in the "Bee" format.
	 * @param encodedKey the bee-
	 */
	public BeeEncodedKeySpec(byte[] encodedKey)
	{
		super(encodedKey);
	}

	/**
	 * Returns the format of the encoded key, that is, "Bee".
	 * @return the format of the encoded key, that is, "Bee".
	 */
	public String getFormat()
	{
		return FORMAT;
	}
}
