/*
 * ElGamalParameterSpec.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto.spec;

import java.math.BigInteger;

/**
 * This class specifies the set of parameters used with the ElGamal algorithms.
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public class ElGamalParameterSpec extends DLParameterSpec
{
	/**
	 * Constructs a parameters set for ElGamal, using a prime modulus p,
	 * a prime factor q of (modulus-1), and a base generator g.
	 * @param p the prime modulus p
	 * @param q the prime factor q of (modulus-1)
	 * @param g the base generator g
	 */
	public ElGamalParameterSpec(BigInteger p, BigInteger q, BigInteger g)
	{
		super(p, q, g);
	}

	/**
	 * Constructs a parameters set for ElGamal, using a prime modulus p,
	 * a prime factor q of (modulus-1), a base generator g and the size in bits, l,
	 * of the random exponent (private value).
	 * @param p the prime modulus p
	 * @param q the prime factor q of (modulus-1)
	 * @param g the base generator g
	 * @param l the size in bits of the random exponent (private value)
	 */
	public ElGamalParameterSpec(BigInteger p, BigInteger q, BigInteger g, int l)
	{
		super(p, q, g, l);
	}
}
