/*
 * ElGamalPublicKeySpec.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.crypto.spec;

import java.math.BigInteger;

/**
 * This class specifies an ElGamal public key with its associated parameters.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 * <p>
 * @see ElGamalPrivateKeySpec
 */
public class ElGamalPublicKeySpec extends DLPublicKeySpec
{
	/**
	 * Constructor that takes a public value y, a prime modulus p, a prime factor q of (modulus-1)
	 * and a base generator g.
	 * @param y the public value y
	 * @param p the prime modulus p
	 * @param q the prime factor q of (modulus-1)
	 * @param g the base generator g
	 */
	public ElGamalPublicKeySpec(BigInteger y, BigInteger p, BigInteger q, BigInteger g)
	{
		super(y, p, q, g);
	}
}
