/*
 * BeeCertificateFactory.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.security.cert;

import com.beeyond.security.BeeInputStream;

import java.io.*;
import java.util.*;
import java.security.*;
import java.security.cert.*;

public class BeeCertificateFactory extends CertificateFactorySpi
{
	public BeeCertificateFactory()
	{
	}

	public java.security.cert.Certificate engineGenerateCertificate(InputStream inStream) throws CertificateException
	{
		DataInputStream in = new DataInputStream(inStream);
		try
		{
			int certLength = in.readInt();
			if (certLength <= 0) return null;
			byte[] cert = new byte[certLength];
			in.readFully(cert);
			in.close();
			return new BeeCertificate(cert);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new CertificateException();
		}
	}

	public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException
	{
		return null;
	}

	public CRL engineGenerateCRL(InputStream inStream) throws CRLException
	{
		throw new CRLException("No such thing as Bee CRLs");
	}

	public Collection engineGenerateCRLs(InputStream inStream) throws CRLException
	{
		throw new CRLException("No such thing as Bee CRLs");
	}
}
