/*
 * BeeCrypt.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 1999-2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.security.provider;

import java.security.*;

/**
 * This class specifies the set of providers defined by the
 * BeeCrypt JCE 1.2 Cryptography Provider.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */
public final class BeeCrypt extends Provider
{
	private static final String
		NAME = "BeeCrypt",
		INFO = "BeeCrypt JCE 1.2 Cryptography Provider";

	private static final double
		VERSION = 1.0;

	public BeeCrypt()
	{
		super(NAME, VERSION, INFO);
		
		AccessController.doPrivileged(new java.security.PrivilegedAction()
		{
			public Object run()
			{
				/* AlgorithmParameters */
				put("AlgorithmParameters.Blowfish", "com.beeyond.crypto.BlowfishParameters");
				put("AlgorithmParameters.DH", "com.beeyond.crypto.DHParameters");
				put("Alg.Alias.AlgorithmParameters.DiffieHellman", "DH");
				put("Alg.Alias.AlgorithmParameters.Diffie-Hellman", "DH");
				put("AlgorithmParameters.DL", "com.beeyond.crypto.DLParameters");
				put("AlgorithmParameters.ElGamal", "com.beeyond.crypto.ElGamalParameters");
				put("AlgorithmParameters.PBE", "com.beeyond.crypto.PBEParameters");
				put("AlgorithmParameters.Prime", "com.beeyond.security.PrimeParameters");
				/* AlgorithmParameterGenerator */
				put("AlgorithmParameterGenerator.DH", "com.beeyond.crypto.DHParameterGenerator");
				put("Alg.Alias.AlgorithmParameterGenerator.DiffieHellman", "DH");
				put("Alg.Alias.AlgorithmParameterGenerator.Diffie-Hellman", "DH");
				put("AlgorithmParameterGenerator.DL", "com.beeyond.crypto.DLParameterGenerator");
				put("AlgorithmParameterGenerator.ElGamal", "com.beeyond.crypto.ElGamalParameterGenerator");
				put("AlgorithmParameterGenerator.Prime", "com.beeyond.security.PrimeParameterGenerator");
				/* CertificateFactory */
				put("CertificateFactory.Bee", "com.beeyond.security.cert.BeeCertificateFactory");
				/* Cipher */
				put("Cipher.Blowfish", "com.beeyond.crypto.Blowfish");
				put("Cipher.PBEWithSHAAndBlowfish", "com.beeyond.crypto.PBEWithSHAAndBlowfish");
				/* KeyAgreement */
				put("KeyAgreement.DH", "com.beeyond.crypto.DHKeyAgreement");
				put("Alg.Alias.KeyAgreement.DiffieHellman", "DH");
				put("Alg.Alias.KeyAgreement.Diffie-Hellman", "DH");
				/* KeyFactory */
				put("KeyFactory.ElGamal", "com.beeyond.crypto.ElGamalKeyFactory");
				/* KeyGenerator */
				put("KeyGenerator.Blowfish", "com.beeyond.crypto.BlowfishKeyGenerator");
				/* KeyPairGenerator */
				put("KeyPairGenerator.DH", "com.beeyond.crypto.DHKeyPairGenerator");
				put("Alg.Alias.KeyPairGenerator.DiffieHellman", "DH");
				put("Alg.Alias.KeyPairGenerator.Diffie-Hellman", "DH");
				put("KeyPairGenerator.DL", "com.beeyond.crypto.DLKeyPairGenerator");
				put("KeyPairGenerator.ElGamal", "com.beeyond.crypto.ElGamalKeyPairGenerator");
				/* KeyStore */
				put("KeyStore.Bee", "com.beeyond.security.BeeKeyStore.java");
				/* Mac */
				put("Mac.SHA/HMAC", "com.beeyond.crypto.HMacWithSHA");
				put("Alg.Alias.Mac.SHA-1/HMAC", "SHA/HMAC");
				put("Alg.Alias.Mac.HMAC-SHA1", "SHA/HMAC");
				/* SecretKeyFactory */
				put("SecretKeyFactory.SHA/HMAC", "com.beeyond.crypto.HMacWithSHAKeyFactory");
				put("Alg.Alias.SecretKeyFactory.SHA-1/HMAC", "SHA/HMAC");
				put("Alg.Alias.SecretKeyFactory.HMAC-SHA1", "SHA/HMAC");
				/* Signature */
				put("Signature.SHA/ElGamal/v1", "com.beeyond.security.ElGamalV1WithSHA");
				put("Signature.SHA/ElGamal/v3", "com.beeyond.security.ElGamalV3WithSHA");
				put("Alg.Alias.Signature.SHA/ElGamal", "SHA/ElGamal/v1");
				put("Alg.Alias.Signature.SHA-1/ElGamal", "SHA/ElGamal/v1");
				put("Alg.Alias.Signature.SHA-1/ElGamal/v1", "SHA/ElGamal/v1");
				put("Alg.Alias.Signature.SHA-1/ElGamal/v3", "SHA/ElGamal/v3");
				put("Alg.Alias.Signature.ElGamal", "SHA/ElGamal/v1");
				put("Alg.Alias.Signature.ElGamal/v1", "SHA/ElGamal/v1");
				put("Alg.Alias.Signature.ElGamal/v3", "SHA/ElGamal/v3");

				return null;
			}
		});
	}
}
