/*
 * BeeCryptNative.java
 *
 * This class is part of our JCE 1.2 provider
 *
 * Copyright (c) 2000 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package com.beeyond.security.provider;

import java.security.*;

/**
 * This class specifies the set of native providers defined by the
 * BeeCrypt JCE 1.2 Cryptography Provider.
 * <p>
 * @author Bob Deblier &lt;bob@virtualunlimited.com&gt;
 */

public final class BeeCryptNative extends Provider
{
	private static final String
		NAME = "BeeCryptNative",
		INFO = "BeeCrypt Native JCE 1.2 Cryptography Provider";

	private static final double
		VERSION = 1.0;

	public BeeCryptNative()
	{
		super(NAME, VERSION, INFO);
		
		AccessController.doPrivileged(new java.security.PrivilegedAction()
		{
			public Object run()
			{
				put("Cipher.Blowfish", "com.beeyond.crypto.beecrypt.Blowfish");
				put("MessageDigest.SHA", "com.beeyond.security.beecrypt.SHA");
				put("Alg.Alias.MessageDigest.SHA-1", "SHA");
				put("SecureRandom.FIPS186", "com.beeyond.security.beecrypt.FIPS186");
				put("Alg.Alias.SecureRandom.FIPS-186", "FIPS186");
				return null;
			}
		});
	}
}
