
// CabWoman.h
// 01-20-1997 Sven B. Schreiber
// sbs@orgon.com

// =================================================================
// STRINGS
// =================================================================

#define MAIN_CAPTION  "SBS CabWoman V1.00"
#define MAIN_ERROR    "CabWoman Error"
#define MAIN_DIALOG   "DlgCabWomanMain"
#define MAIN_ICON     "IconCabWoman"

#define MAIN_CLASS    "CabWoman_100"

// -----------------------------------------------------------------

#define ABOUT_CAPTION "About CabWoman"
#define ABOUT_DIALOG  "DlgCabWomanAbout"
#define ABOUT_ICON    "IconCabWoman"

#define ABOUT_TEXT1   "SBS CabWoman.c"
#define ABOUT_TEXT2   "Windows Cabinet File Manager V1.00"
#define ABOUT_TEXT3   "01-20-1997 Sven B. Schreiber"
#define ABOUT_TEXT4   "sbs@orgon.com"

// -----------------------------------------------------------------

#define INFO_CAPTION  "Cabinet Info"
#define INFO_DIALOG   "DlgCabWomanInfo"

// =================================================================
// MESSAGE ID'S
// =================================================================

#define WMU_INIT             0x0101 + WM_USER

// =================================================================
// CONTROL ID'S
// =================================================================

#define IDT_VOLUMES          1000
#define IDL_VOLUMES          1001
#define IDT_DIRECTORIES      1002
#define IDL_DIRECTORIES      1003
#define IDT_CABINETS         1004
#define IDL_CABINETS         1005
#define IDT_FILES            1006
#define IDL_FILES            1007
#define IDT_PATH             1008
#define IDT_VOLTYPE          1009
#define IDT_SIZE             1010
#define IDT_DATE             1011
#define IDT_TIME             1012
#define IDT_ATTRIBUTES       1013
#define IDB_EXTRACT          1014
#define IDB_ABOUT            1015
#define IDB_EXIT             1016

// -----------------------------------------------------------------

#define IDT_THIS             1100
#define IDT_PREVIOUS         1101
#define IDT_NEXT             1102
#define IDT_RESERVED         1103
#define IDT_SET_ID           1104
#define IDT_CAB_NUMBER       1105
#define IDT_NFOLDERS         1106
#define IDT_NFILES           1107
#define IDT_EXTRA_DATA       1108
#define IDT_CAB_LIST         1109
#define IDT_FOLDER_LIST      1110
#define IDT_FILE_LIST        1111
#define IDT_FILE_DATA        1112
#define IDT_CAB_SIZE         1113

// =================================================================
// CONSTANTS
// =================================================================

#define DEFAULT_HANDLER      (MAXDWORD-0)
#define DEFAULT_RESULT       (MAXDWORD-1)

// =================================================================
// DATA TYPES
// =================================================================

typedef HMODULE *PHMODULE;
typedef PROC    *PPROC;

// -----------------------------------------------------------------

typedef struct _DISPATCH
    {
    DWORD   dEvent;
    WNDPROC xHandler;
    }
    DISPATCH, *PDISPATCH;
#define DISPATCH_ sizeof (DISPATCH)

// -----------------------------------------------------------------

typedef struct _LISTCTL
    {
    HWND hWnd;
    int  iCaption;
    int  iListBox;
    }
    LISTCTL, *PLISTCTL;
#define LISTCTL_ sizeof (LISTCTL)

// =================================================================
// END OF FILE
// =================================================================
