	/*************	history	************
*
*	COMPONENT: ISCGUARD	MODULE: ISCGUARD_UTILS.C
*	generated by Marion V2.5     2/6/90
*	from dev              db	on 31-JUL-1997
*****************************************************************
*
*	0	DUQUETTE	31-JUL-1997
*	history begins
*
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
*/

#include <stdlib.h>
#include <windows.h>
#include "../iscguard/iscguard.h"

int GetGuardStartupInfo (char *svrpath, char* opt)
{
/**************************************
 *
 *	G e t G u a r d S t a r t u p I n f o
 *
 **************************************
 *
 * Functional description
 *
 *  open the registry and read the startup information
 *  return in the buffer, the path to the executable. The
 *  function returns START_ONCE or START_FOREVER.  Returns 0
 *  if any function fails.
 *
 **************************************/

HKEY    hKeyResult;
LPCSTR  lpSubKey = "Software\\Borland\\InterBase\\CurrentVersion";
DWORD   buffSize, retval;

buffSize = MAX_PATH - 2; /* reserve place for null and the \ */

retval = RegOpenKeyEx(HKEY_LOCAL_MACHINE, lpSubKey, 0, KEY_QUERY_VALUE, &hKeyResult);
retval = RegQueryValueEx(hKeyResult, "ServerDirectory", NULL, NULL, svrpath, &buffSize);
/* if there is a value check for the last charecter if it is not a \ then
 * add a \ 
 */
if (buffSize)
    {
    /* buffSize includes the null character in its size hence it is strlen + 1 */
    if (svrpath[buffSize-2] != '\\')
        {
	svrpath[buffSize - 1] = '\\';
	svrpath[buffSize] = 0;
	}
    }
retval = RegQueryValueEx(hKeyResult, "GuardianOptions",NULL, NULL, opt, &buffSize);
RegCloseKey (hKeyResult);
return ( (retval == ERROR_SUCCESS ? 1 : 0));
}
