/* Lumberjack
 *
 * FX <fx@phenoelit.de>
 * Phenoelit (http://www.phenoelit.de)
 * (c) 1999, 2k
 *
 */
#include <stdio.h>
#include <string.h>

struct T_LIST_MEMBER {
    char *word;
    struct T_LIST_MEMBER *next;
};

static struct T_LIST_MEMBER *anchor,*current,*help,*last;
int list_verbose;

int list_next() {
    if (current->next==NULL) { return (-1); }
    current=current->next;
    return 0;
}

char *list_content() {
    return current->word;
}

void list_delete() {

    if (current==anchor) {
	anchor=anchor->next;
	free(current);
	current=anchor;
    } else {
	help=anchor;
	while (help->next!=current) { help=help->next; }
	help->next=current->next;
	free(current);
	current=help;
    }
}

int list_create() {

    if (anchor!=NULL) {
	fprintf(stderr,"create_list(): WARING: anchor not NULL\n");
    }
    anchor=current=help=NULL;

    anchor=(struct T_LIST_MEMBER *)malloc(sizeof(struct T_LIST_MEMBER));
    current=anchor;
    help=anchor;
    current->next=NULL;
    last=current;

    return 0;
}

void list_rewind() {
    current=anchor;
}

int list_append(char *a) {

    // list_rewind();
    // while (current->next!=NULL) current=current->next;
    current=last;

    help=(struct T_LIST_MEMBER *)malloc(sizeof(struct T_LIST_MEMBER));
    current->next=help;
    help->next=NULL;
    help->word=(char *)malloc(strlen(a)+1);
    strcpy(help->word,a);

    last=help;
    return 0;
}

void list_display() {
    list_rewind();
    current=current->next;
    while (current!=NULL) {
	printf("%s\n",current->word);
	current=current->next;
    }
    list_rewind();
}

void list_write_to(FILE *fa) {
    list_rewind();
    current=current->next;
    while (current!=NULL) {
	fputs(current->word,fa);
	fputs("\n",fa);
	current=current->next;
    }
    list_rewind();
}

int list_destroy() {
    list_rewind();
    while (current!=NULL) {
	help=current;
	current=current->next;
	free(help);
    }
    return 0;
}

void list_unique() {
    struct T_LIST_MEMBER *help2;
    
    if (list_verbose) fprintf(stderr,"making list unique ...");
    fflush(stderr);

    help2=anchor->next;
    while (help2!=NULL) {
	current=anchor->next;
	while(current!=NULL) {
	    if ((help2!=current)&&(strcmp(help2->word,current->word)==0)) {
		list_delete();
		current=NULL;
	    } else {
		current=current->next;
	    }
	}
	help2=help2->next;
    }
    if (list_verbose) fprintf(stderr,"done\n");
}

int list_find(char *a) {
    list_rewind();
    current=current->next;
    while (current!=NULL) {
	if (strcmp(current->word,a)==0) {
	    return 1;
	} else {
	    current=current->next;
	}
    }
    return 0;
}




