#!/usr/bin/perl
# admin.cgi - Part of NetSaint Easy Administration Tool (NEAT)
# by jason blakey - jblakey@frogboy.net - http://www.frogboy.net
#
# Release Date: August 14/2000
$VERSION = "3.0";

####################### CONFIGURATION ###############################
$CONFIG = "/usr/local/netsaint/neat.options";
##################### END CONFIGURATION ############################# 

# Read in the configuration file...
do ($CONFIG) or die ("Can't read the neat.options file $CONFIG: $!");

# Use the CGI lib...
use CGI":standard";

# Check to make sure that the hostfile is readable and writable...
if ((! -r $HOSTS) or (! -w $HOSTS)) {
	print <<EOF;
Content-type: text/html;

<HTML>
<HEAD>
<TITLE>Permission Error for $HOSTS</TITLE>
</HEAD>
 
<BODY BGCOLOR=WHITE>
<LI>ERROR - The file $HOSTS is not reable and/or writable - please fix.
</BODY>
</HTML>
EOF
	exit();
}    

################ Parse the HOSTS file ############################
open (HOSTS, "< $HOSTS") or die ("Can't open the file $HOSTS: $!");

while (defined ($line = <HOSTS>)) {

	# Skip comments...
	next if ($line =~ /^\s*#/);	

	# Skip commands...
	next if ($line =~ /^command/);

	# Skip blank lines...
	next if ($line !~ /\S+/);

	# Parse hostgroups...
	if ($line =~ /^hostgroup\[(\S+)\]=(.*)/) {
		$name = $1;
		$def = $2;

		# Remember this hostgroup...
		$entities{HOSTGROUPS}->{$name}->{DEF} = $def;

		# Now, pick the parts our of the $def that reference other entities...
		@fields = split (/;/, $def);

		# Determine what contact groups and hosts this hostgroup references...
		@contact_groups = split (/,/, $fields[1]);
		@hosts = split (/,/, $fields[2]);

		# Remember references...
		foreach $contact_group (@contact_groups) {
			$entities{CONTACTGROUPS}->{$contact_group}->{REFS} .= "hostgroup[$name]$DELIM";
		}

		foreach $host (@hosts) {
			$entities{HOSTS}->{$host}->{REFS} .= "hostgroup[$name]$DELIM";
		}

	}

	# Parse hosts...
	elsif ($line =~ /^host\[(\S+)\]=(.*)/) {
		$name = $1;
		$def = $2;

		# Remember this host...
		$entities{HOSTS}->{$name}->{DEF} = $def;

		# Remember who this host references...
		@fields = split (/;/, $def);
		
		$parent = $fields[2];

		if ($parent) {
			$entities{HOSTS}->{$parent}->{REFS} .= "host[$name]$DELIM";
		}

		$timeperiod = $fields[6];
		$entities{TIMEPERIODS}->{$timeperiod}->{REFS} = "host[$name]$DELIM";
	}
	
	# Parse services...
	elsif ($line =~ /service\[(\S+)\]=([^;]*);(.*)/) {
		$hostname = $1;
		$service_desc = $2;
		$def = $3;

		$grr = "$hostname$DELIM$service_desc";

		# Remember this service...
		$entities{SERVICES}->{$grr}->{DEF} = $def;

		# Remember who this service references...
		$entities{HOSTS}->{$hostname}->{REFS} .= "service[$hostname]=$service_desc$DELIM";

		@fields = split (/;/, $def);

		$timeperiod = $fields[1];
		$entities{TIMEPERIODS}->{$timeperiod}->{REFS} .= "service[$hostname]=$service_desc$DELIM";

		$timeperiod = $fields[7];
		$entities{TIMEPERIODS}->{$timeperiod}->{REFS} .= "service[$hostname]=$service_desc$DELIM";

		$contactgroup = $fields[5];
		$entities{CONTACTGROUPS}->{$contactgroup}->{REFS} .= "service[$hostname]=$service_desc$DELIM";
	}

	# Parse contacts...
	elsif ($line =~ /contact\[(\S+)\]=(.*)/) {
		$name = $1;
		$def = $2;

		$entities{CONTACTS}->{$name}->{DEF} = $def;

		# Now, remember who this contact group references...
		@fields = split (/;/, $def);

		$timeperiod = $fields[1];
		$entities{TIMEPERIODS}->{$timeperiod}->{REFS} .= "contact[$name]$DELIM";

		$timeperiod = $fields[2];
		$entities{TIMEPERIODS}->{$timeperiod}->{REFS} .= "contact[$name]$DELIM";
	}

	# Parse contact groups...
	elsif ($line =~ /contactgroup\[(\S+)\]=(.*)/) {
		$name = $1;
		$def = $2;

		$entities{CONTACTGROUPS}->{$name}->{DEF} = $def;

		# Now, remember who this contact group references...
		@fields = split (/;/, $def);

		@contacts = split (/,/, $fields[1]);

		foreach $contact (@contacts) {
			$entities{CONTACTS}->{$contact}->{REFS} .= "contactgroup[$name]$DELIM";
		}
	}

	# Parse timeperiods...
	elsif ($line =~ /^timeperiod\[(\S+)\]=(.*)/) {
		$name = $1;
		$def = $2;

		$entities{TIMEPERIODS}->{$name}->{DEF} = $def;
	}
}

close (HOSTS);

################## End of Parsing ###############################


# Figure the date and time...
($date, $time) = jbdatetime(1);

# Print out our HTML headers..
print <<EOF;
Content-type: text/html;

<HTML>
<HEAD>
<TITLE>
NetSaint Easy Administration Tool Version $VERSION
</TITLE>
</HEAD>

<BODY BGCOLOR=White>

<CENTER>
<TABLE WIDTH=600>

<TR><TD COLSPAN=5>

<TABLE WIDTH="100%">
<TR>
<TD BGCOLOR=$COLOR1>
<CENTER><H2>Netsaint Easy Administration Tool - Version $VERSION</H2></CENTER>
</TD>
</TR>
<TR BGCOLOR=$COLOR1><TD><CENTER>Comments / Suggestions to <A HREF="MAILTO:jblakey\@frogboy.net">jason blakey</A></CENTER></TD></TR>
<TR BGCOLOR=$COLOR1><TD><CENTER>This page generated on $date at $time</CENTER></TD></TR>
</TABLE>

</TD></TR>

<TR><TD COLSPAN=5>

<TABLE WIDTH="100%">
<TR VALIGN=MIDDLE BGCOLOR=$COLOR2>
<TD ALIGN=LEFT>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD="POST">
Create a new &nbsp;
<SELECT NAME="type">
EOF
foreach $entity (@entities) {
        print "<OPTION VALUE=\"$entity\">$entity</OPTION>\n";
}
print <<EOF;
</SELECT>
<INPUT TYPE="SUBMIT" VALUE="Go"></FORM>
</TD>
EOF

	print <<EOF;
<TD ALIGN=RIGHT>
<FORM ACTION="$CGIPATH/cmd.cgi" METHOD="POST">
<INPUT TYPE=HIDDEN NAME="cmd_typ" VALUE="13">
<INPUT TYPE=SUBMIT VALUE="Restart NetSaint/Activate Changes">
</FORM>
</TD>
EOF

print <<EOF;
</TR>
</TABLE>
</TD></TR>

EOF

# Now, we can print out whatever page we are asked for...

# Figure our which view we are working with...
$view = param ("view");

############### VIEW = NULL ############################
if (! $view) {
	# Then this is the default view
	# Show the following:
	# hostgroups
	# contactgroups
	# timeperiods

	# Print our column header...
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><B>Viewing:</B> Main Page</TD></TR>";
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Host Groups</B></CENTER></TD></TR>\n";

	# First, we print out hostgroups...
	@hostgroups = keys (%{$entities{HOSTGROUPS}});

	foreach $hostgroup (sort (@hostgroups)) {
		# Check to make sure the hostgroup we are about to print
		# has a definition...

		# Look up the description for this hostgroup...
		($description) = split (/;/, $entities{HOSTGROUPS}->{$hostgroup}->{DEF}, 2);

		# Print the entry...
		print <<EOF;
<TR>
<TD><B>$hostgroup</B></TD>
<TD>$description</TD>
<TD><A HREF="$CGIPATH/admin.cgi?view=hostgroup&name=$hostgroup">View / Modify</A></TD>
</TR>
EOF
	}

	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Contact Groups</B></CENTER></TD></TR>\n";

	# Next, we print out contact groups...
	@contactgroups = keys (%{$entities{CONTACTGROUPS}});

	foreach $contactgroup (sort (@contactgroups)) {
		# Check to make sure the entity has a definition...

		# Figure out the description for this contactgroup...
		($description) = split (/;/, $entities{CONTACTGROUPS}->{$contactgroup}->{DEF}, 2);

		# Print it...
		print <<EOF;
<TR>
<TD><B>$contactgroup</B></TD>
<TD>$description</TD>
<TD>
<A HREF="$CGIPATH/admin.cgi?view=contactgroup&name=$contactgroup">View / Modify</A>
<! $entities{CONTACTGROUPS}->{$contactgroup}->{REFS}>
</TD>
</TR>
EOF
	}

	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Time Periods</B></CENTER></TD></TR>\n";

	# Next, we print out our time periods...
	@timeperiods = keys (%{$entities{TIMEPERIODS}});

	foreach $timeperiod (sort (@timeperiods)) {

		# Look up the description for this time period...
		($description) = split (/;/, $entities{TIMEPERIODS}->{$timeperiod}->{DEF}, 2);

		# Print it...
		print <<EOF;
<TR>
<TD><B>$timeperiod</B></TD>
<TD>$description</TD>
<TD><A HREF="$CGIPATH/admin.cgi?view=timeperiod&name=$timeperiod">View / Modify</A></TD>
</TR>
EOF
	}


	# Next, we print out hosts not part of any hostgroup...

	# Check the ref list for each host... if it does not contact 'hostgroup[' 
	# then it is not part of a hostgroup...
	foreach $host (sort (keys (%{$entities{HOSTS}}))) {
		if ($entities{HOSTS}->{$host}->{REFS} !~ /hostgroup\[/) {
			print <<EOF;
<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Hosts NOT Part of Any Host Group</B></CENTER></TD></TR>
EOF
		last;
		}
	}

	# Now, print 'em...
	foreach $host (sort (keys %{$entities{HOSTS}})) {
		if ($entities{HOSTS}->{$host}->{REFS} !~ /hostgroup\[/) {

		# Prepare the info...
		($description) = split (/;/, $entities{HOSTS}->{$host}->{DEF}, 2);

		# Print it...
		print <<EOF;

<TR>
<TD><B>$host</B></TD>
<TD>$description</TD>
<TD><A HREF="$CGIPATH/admin.cgi?view=host&name=$host">View / Modify</A></TD>
</TD>
</TR>
EOF
		}
	}

	# Check if we have any contacts not part of any contactgroup...
	foreach $contact (sort (keys (%{$entities{CONTACTS}}))) {
		if ($entities{CONTACTS}->{$contact}->{REFS} !~ /contactgroup\[/) {
			print <<EOF;
<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Contacts NOT Part of Any Contact Group</B></CENTER></TD></TR>
EOF
		last;
		}
	}

	# And finally, we print out contacts not part of any contactgroup...
	foreach $contact (sort (keys (%{$entities{CONTACTS}}))) {

		# If the list of REFS for this contact does NOT contain a contactgroup...
		if ($entities{CONTACTS}->{$contact}->{REFS} !~ /contactgroup\[/) {

			# Prepare the info...
			($description) = split (/;/, $entities{CONTACTS}->{$contact}->{DEF}, 2);
			$entryname = "contact[$contact]";

			# Print it...
			print <<EOF;
<TR>
<TD><B>$contact</B></TD>
<TD>$description</TD>
<TD>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="contact">
<INPUT TYPE=HIDDEN NAME="modify" VALUE=1>
<INPUT TYPE="SUBMIT" VALUE="Modify">
</FORM>
</TD>
 
<TD>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="delete">
<INPUT TYPE="CHECKBOX" NAME="really_delete" VALUE=1">
<INPUT TYPE="SUBMIT" VALUE="Delete">
</FORM>
</TD>    
EOF
		}
	}
}

########## VIEW = HOSTGROUP ####################
elsif ($view eq "hostgroup") {
	# Then we are displaying a particular hostgroup - show:
	# hostgroup
	# host members

	# Get the name of the hostgroup...and build our entryname...
	$name = param ("name");
	$entryname = "hostgroup[$name]";

	# Print our column headers
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><B>Viewing:</B> <B>HostGroup:</B> $name</TD></TR>";
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Host Group</B></CENTER></TD></TR>\n";

	# Figure out our description for this hostgroup...
	($description) = split (/;/, $entities{HOSTGROUPS}->{$name}->{DEF}, 2);

	# Print the hostgroup entry...
	print <<EOF;
<TR>
<TD><B>$name</B></TD>
<TD>$description</TD>
<TD>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="hostgroup">
<INPUT TYPE=HIDDEN NAME="modify" VALUE=1>
<INPUT TYPE="SUBMIT" VALUE="Modify">
</FORM>
</TD>
 
<TD>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="delete">
<INPUT TYPE=CHECKBOX NAME="really_delete" VALUE=1>
<INPUT TYPE=SUBMIT VALUE="Delete">
</FORM>
</TD>     
</TR>
EOF

	# Now, print the members of the hostgroup
	@fields = split(/;/, $entities{HOSTGROUPS}->{$name}->{DEF});
	@hosts = split (/,/, $fields[2]);

	# If there are no hosts in this hostgroup, tell 'em...
	if (! @hosts) {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Host Group $name Contains No Hosts</B></CENTER></TD></TR>\n";
	}
	
	else {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=4><CENTER><B>Hosts in Host Group $name</B></CENTER></TD></TR>\n";

		foreach $host (sort (@hosts)) {

			# Look up the description...
			if (! $entities{HOSTS}->{$host}->{DEF}) {
				print "<TR><TD>HOST - $entities{HOSTS}->{$host}->{REFS}<TD></TR>\n";
			}
			($description) = split (/;/, $entities{HOSTS}->{$host}->{DEF}, 2);
	
				# Print it...	
			print <<EOF;
<TR>
<TD><B>$host</B></TD>
<TD>$description</TD>
<TD><A HREF="$CGIPATH/admin.cgi?view=host&name=$host">View / Modify</A></TD>
</TR>

EOF
		}
	}
}

############### VIEW = CONTACTGROUP ##################
elsif ($view eq "contactgroup") {
	# Then we are displaying a particular contactgroup - show:
	# contact group
	# contact group members

	# get the name of the contactgroup and build our entryname...
	$name = param ("name");
	$entryname= "contactgroup[$name]";

	# Print our column headers
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><B>Viewing:</B> <B>ContactGroup:</B> $name</TD></TR>";
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><CENTER><B>Contact Group</B></CENTER></TD></TR>\n";

	# Look up the description...
	($description) = split (/;/, $entities{CONTACTGROUPS}->{$name}->{DEF}, 2);

	# Calculate the reference count...	
	@refs = split (/$DELIM/, $entities{CONTACTGROUPS}->{$name}->{REFS});
	$num_refs = $#refs + 1;

	# Print our information...
	print <<EOF;
<TR>
<TD><B>$name</B></TD>
<TD>$description</TD>
<TD>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="contactgroup">
<INPUT TYPE=HIDDEN NAME="modify" VALUE=1>
<INPUT TYPE="SUBMIT" VALUE="Modify">
</FORM>
</TD>
 
<TD>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="delete">
<INPUT TYPE=HIDDEN NAME="reflist" VALUE="$entities{CONTACTGROUPS}->{$name}->{DEF}">
<INPUT TYPE="CHECKBOX" NAME="really_delete" VALUE=1">
<INPUT TYPE="SUBMIT" VALUE="Delete">
</FORM>
</TD>        
<TD>Refs: $num_refs</TD>
</TR>

EOF

	# Now, we print out the members of the contact group...
	@fields = split (/;/, $entities{CONTACTGROUPS}->{$name}->{DEF});
	@contacts = split (/,/, $fields[1]);

	# If there are no contacts in the contact group, tell 'em...
	if (! @contacts) {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><CENTER><B>Contact Group $name Contains No Contacts</B></CENTER></TD></TR>\n";
	}

	else {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><CENTER><B>Contacts in Contact Group $name</B></CENTER></TD></TR>\n";

		foreach $contact (sort (@contacts)) {
			@refs = split (/$DELIM/, $entities{CONTACTS}->{$contact}->{REFS});
			$num_refs = $#refs + 1;

			# Build the entryname
			$entryname = "contact[$contact]";

			# Look up the description...
			($description) = split (/;/, $entities{CONTACTS}->{$contact}->{DEF}, 2);

			# Print it...
			print <<EOF;
<TR>
<TD><B>$contact</B></TD>
<TD>$description</TD>
<TD>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="contact">
<INPUT TYPE=HIDDEN NAME="modify" VALUE=1>
<INPUT TYPE="SUBMIT" VALUE="Modify">
</FORM>
</TD>
 
<TD>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="delete">
<INPUT TYPE=HIDDEN NAME="reflist" VALUE="$entities{CONTACTS}->{$contact}->{REFS}">
<INPUT TYPE="CHECKBOX" NAME="really_delete" VALUE=1">
<INPUT TYPE="SUBMIT" VALUE="Delete">
</FORM>
</TD>       
<TD>Refs: $num_refs</TD>
</TR>
EOF
		}
	}

}

############### VIEW = HOST ########################
elsif ($view eq "host") {
	# Then we are displaying a particular host - show:
	# host
	# services under host

	# get the name of the host and create the entryname...
	$name = param ("name");
	$entryname = "host[$name]";

	# Print our column headers and location...
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><B>Viewing:</B> <B>Host:</B> $name</TD></TR>";
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><CENTER><B>Host</B></CENTER></TD></TR>\n";

	# Figure the number of refs to this host...
	@refs = split (/$DELIM/, $entities{HOSTS}->{$name}->{REFS});
	$num_refs = $#refs + 1;

	# Look up the description for this host...
	($description) = split (/;/, $entities{HOSTS}->{$name}->{DEF}, 2);

	# Print the info...
	print <<EOF;
<TR>
<TD><B>$name</B></TD>
<TD>$description</TD>
<TD>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="host">
<INPUT TYPE=HIDDEN NAME="modify" VALUE=1>
<INPUT TYPE="SUBMIT" VALUE="Modify">
</FORM>
</TD>
 
<TD>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD=POST>
<INPUT TYPE=CHECKBOX VALUE=1 NAME="really_delete">
<INPUT TYPE=SUBMIT VALUE="Delete Host and Services">
<INPUT TYPE=HIDDEN NAME="type" VALUE="delete">
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="delreflist" VALUE="$entities{HOSTS}->{$name}->{REFS}">
</FORM>
</TD>
<TD>Refs: $num_refs</TD>
</TR>

EOF

	# Now, print the services that apply to that host...
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><CENTER><B>Services Defined for $name</B></CENTER></TD></TR>\n";

	# Start off assuming that there are no services defined for this host...
	$at_least_one_service = 0;

	foreach $service (sort (keys (%{$entities{SERVICES}}))) {
		# if the service descriptor contains our host name in square brackets...
		if ($service =~ /^$name$DELIM(.*)/) {
			# Then it is applied to this host...
			# So print it...
			$description = $1;

			# Remember that there is at least one service for this guy...
			$at_least_one_service = 1;
			
			# Make our entryname...
			$entryname = "service[$name]";

			print <<EOF;
<TR>
<TD>&nbsp;</TD>
<TD>$description</TD>
<TD>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="service">
<INPUT TYPE=HIDDEN NAME="description" VALUE="$description">
<INPUT TYPE=HIDDEN NAME="modify" VALUE=1>
<INPUT TYPE="SUBMIT" VALUE="Modify">
</FORM>
</TD>
 
<TD>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="delete">
<INPUT TYPE=HIDDEN NAME="description" VALUE="$description">
<INPUT TYPE="CHECKBOX" NAME="really_delete" VALUE=1">
<INPUT TYPE="SUBMIT" VALUE="Delete">
</FORM>
</TD>            
<TD>&nbsp;</TD>
</TR>

EOF
		}
	}

	# Check to see if we need to tell the users there are no services for this host...
	if (! $at_least_one_service) {
		print "<TR><TD COLSPAN=5><CENTER><B>There Are No Services Defined For This Host</B></CENTER></TD></TR>\n";
	}

}

############## VIEW = TIMEPERIOD ####################
elsif ($view eq "timeperiod") {

	# Get our name, and make our entryname...
	$name = param ("name");
	$entryname = "timeperiod[$name]";

	# Print our column headers...
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><B>Viewing:</B> <B>TimePeriod:</B> $name</TD></TR>";
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><CENTER><B>Time Period</B></CENTER></TD></TR>\n";

	# Figure our number of references...
	@refs = split (/;/, $entities{TIMEPERIODS}->{$name}->{REFS});
	$num_refs = $#refs + 1;

	# Look up our description for this time period...
	($description) = split (/;/, $entities{TIMEPERIODS}->{$name}->{DEF}, 2);

	# Print it out...
	print <<EOF;

<TR>
<TD><B>$name</B></TD>
<TD>$description</TD>
<TD>
<FORM ACTION="$CGIPATH/display_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="timeperiod">
<INPUT TYPE=HIDDEN NAME="modify" VALUE=1>
<INPUT TYPE="SUBMIT" VALUE="Modify">
</FORM>
</TD>
 
<TD>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME="entryname" VALUE="$entryname">
<INPUT TYPE=HIDDEN NAME="type" VALUE="delete">
<INPUT TYPE=HIDDEN NAME="reflist" VALUE="$entities{TIMEPERIODS}->{$name}->{REFS}">
<INPUT TYPE="CHECKBOX" NAME="really_delete" VALUE=1">
<INPUT TYPE="SUBMIT" VALUE="Delete">
</FORM>
</TD>
<TD>Refs: $num_refs</TD>
</TR>         
EOF
}

# Finish printing our HTML page...

# If there is no view, that means we are at the main page - just print a colored row... 
if (! $view) {
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5>&nbsp;</TD></TR>\n";
}
# Otherwise, print a javascript back button...
else {
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=5><CENTER><A HREF=\"javascript:history.back()\">Back One Page</A></CENTER></TD></TR>\n";
}

print <<EOF;
</TABLE>
</CENTER>
</BODY>
</HTML>
EOF

# and exit...
exit ();


###################### SUBROUTINES ##########################
sub jbdatetime {
	my ($sec, $min, $hour, $dayofmonth, $month, $year) = localtime (time ());

	# Fix the year...
	$year = $year + 1900;

	# Fix the month...
	$month++;

	# Make sure the date/time fields are two digits long...
	grep (s/^(\d)$/0$1/, $month, $dayofmonth, $sec, $min, $hour);

	# If we have no calling arguments - return the naked date and time... 
	if (! @_) {
		return ("$year$month$dayofmonth", "$hour$min$sec");
	}

	# Otherwise, return a slighly nicer looking date and time...
	return ("$year/$month/$dayofmonth", "$hour:$min:$sec");
}
