#!/usr/bin/perl
# display_entry.cgi - Part of NetSaint Easy Administration Tool (NEAT)
# by jason blakey - jblakey@frogboy.net   http://www.frogboy.net
# Release Date: August 10/2000
#
$VERSION = "3.0";

####################### CONFIGURATION ###############################
$CONFIG = "/usr/local/netsaint/neat.options";
##################### END CONFIGURATION #############################

# Load the configuration file...
do ($CONFIG) or die ("Can't load the neat.options file $CONFIG: $!");

# Use the CGI module...
use CGI":standard";

# Find out what mode we are running in - if modify is set, we will attempt
# to read an entry from the config file...
# If modify is not set, then it must be a brand-new creation...
$modify = param ("modify");

# What type of entity are we dealing with?
$type = param ("type");

# Read in the $HOSTS file...
open (HOSTS, "< $HOSTS");
while (defined ($line = <HOSTS>)) {
	# Skip comments...
	next if ($line =~ /^#/);

	# Check to see if the input contains a definition...
	if ($line =~ /^((\S+)\[(\S+)\]\=([^;]*))(.*)/) {
		$fullname = $1;
		$kind = $2;
		$name = $3;
		$desc = $4;
		$def = $5;

		# Services are special - have to deal with them specially...
		if ($kind ne "service") {
			$fullname = $name;
		}

		# Store it in a hash of hashes...
		$DATA{$kind}->{$fullname} = $desc . $def;
	}
}
close (HOSTS);

# Print out HTML...
print <<EOF;
Content-type: text/html

<HTML>
<HEAD>
<TITLE>NetSaint Easy Administration Tool Version $VERSION</TITLE>
</HEAD>

<BODY BGCOLOR=White>
<CENTER>
<TABLE>
<FORM ACTION="$CGIPATH/write_entry.cgi" METHOD="POST">
EOF

########
########   TIMEPERIOD  #########
########
if ($type eq "timeperiod") {

	if ($modify) {
		$entryname = param ("entryname");

		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><H2>TimePeriod Modification</H2></CENTER></TD></TR>\n";
		($name, $description, $range0, $range1, $range2, $range3,$range4, $range5, $range6) = get_line ($entryname);
	}
	else {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><H2>TimePeriod Creation</H2></CENTER></TD></TR>\n";
		($name, $description, $range0, $range1, $range2, $range3, $range4, $range5, $range6) = "";
	}

	print <<EOF;
<TR BGCOLOR=$COLOR2>
EOF
	if (! $modify) {
		print <<EOF;
<TD>Name :</TD><TD><INPUT TYPE="TEXT" NAME="name" SIZE="15" MAXLENGTH="15" VALUE="$name"> (No Spaces Allowed)</TD></TR>
EOF
	}
	else {
		print <<EOF;
	<TD>Name :</TD><TD>$name<INPUT TYPE="HIDDEN" NAME="name" VALUE="$name"></TD></TR>
EOF
	}
	print <<EOF;
<TR BGCOLOR=$COLOR2>
<TD>Description :</TD><TD><INPUT TYPE="TEXT" NAME="description" SIZE="30" MAXLENGTH="30" VALUE="$description"></TD></TR>
<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><B>Time Range Definition (in format hh:mm-hh:mm)</B></CENTER></TD></TR>
<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><B>(For days with no valid times, leave blank)</B></CENTER></TD></TR>
<TR>
EOF
	foreach $i (0..6) {
		$ran = "range"."$i";
		print "<TR BGCOLOR=$COLOR2><TD>$weekdays[$i] Time Range :</TD><TD><INPUT TYPE=\"TEXT\" NAME=\"range$i\" SIZE=\"11\" MAXLENGTH=\"11\" VALUE=\"${$ran}\"></TD></TR>\n";
	}

	print "<INPUT TYPE=\"HIDDEN\" NAME=\"type\" VALUE=\"timeperiod\">\n";

	if ($modify) {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Modify Time Period\"></CENTER></TD></TR>\n";
	}

	else {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Create Time Period\"></CENTER></TD></TR>\n";
	}
}

########
########    SERVICE   ########
########

elsif ($type eq "service") {

	if ($modify) {
		$entryname = param ("entryname");
		$description = param ("description");
		$description =~ s/\_/ /g;

		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Service Modification</H2></CENTER></TD></TR>\n";

		($host, $description, $volatile, $timeperiod, $maxattempts, $checkinterval, $retryinterval, $notificationgroups, $notificationinterval, $notificationperiod, $notifyrecovery, $notifycritical, $notifywarning, $eventhandler, $checkcommand, $checkcommandargs) = get_line ("${entryname}=${description}");
	}
	else {
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Service Creation</H2></CENTER></TD></TR>\n";
		($host, $description, $volatile, $timeperiod, $maxattempts, $checkinterval, $retryinterval, $notificationgroups, $notificationinterval, $notificationperiod, $notifyrecovery, $notifycritical, $notifywarning, $eventhandler, $checkcommand, $checkcommandargs) = ("", "", 0, "", 10, 5, 1, "", 30, "", 1, 1, 0, "", "", "");
	}

	print <<EOF;
<TR BGCOLOR=$COLOR2>
EOF

	if ($modify) {
		print <<EOF;

	<TD>Host :</TD><TD><INPUT TYPE=HIDDEN NAME="host" VALUE="$host"><B>$host</B></TD></TR>
EOF
	}
	else {
		print <<EOF;
<TD>Host :</TD>
<TD>
<SELECT NAME="host">
EOF

	foreach $possible_host (sort (keys (%{$DATA{host}}))) {
		if ($possible_host eq $host) {
			print "<OPTION SELECTED VALUE=\"$host\">$host</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$possible_host\">$possible_host</OPTION>\n";
		}
	}
	print <<EOF;
</SELECT>
</TD></TR>
EOF
	}

	print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Description :</TD>
EOF

	if ($modify) {
		print <<EOF;
<TD><INPUT TYPE=HIDDEN NAME="description" VALUE="$description"><B>$description</B></TD>
EOF
	}
	else {
		print <<EOF;
<TD><INPUT TYPE="TEXT" SIZE="30" MAXLENGTH="30" NAME="description" VALUE="$description"></TD>
EOF
	}

	if ($volatile) {
		print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Volatile Service:</TD><TD><INPUT TYPE=CHECKBOX NAME="volatile" VALUE="1" CHECKED></TD></TR>
EOF
	}
	else {
		print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Volatile Service:</TD><TD><INPUT TYPE=CHECKBOX NAME="volatile" VALUE="1"></TD></TR>
EOF
	}

	print <<EOF;
</TR>
<TR BGCOLOR=$COLOR2>
<TD>Monitoring Time Period :</TD>
<TD>
<SELECT NAME="timeperiod">
EOF

	foreach $possible_timeperiod (sort (keys (%{$DATA{timeperiod}}))) {
		if ($possible_timeperiod eq $timeperiod) {
			print "<OPTION SELECTED VALUE=\"$timeperiod\">$timeperiod</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$possible_timeperiod\">$possible_timeperiod</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT>
</TD>
</TR>
<TR BGCOLOR=$COLOR2><TD>Number of Attempts to Check :</TD><TD><INPUT TYPE="TEXT" NAME="maxattempts" SIZE="2" MAXLENGTH="2" VALUE="$maxattempts"></TD></TR>

<TR BGCOLOR=$COLOR2><TD>Check Interval :</TD><TD><INPUT TYPE="TEXT" NAME="checkinterval" SIZE="2" MAXLENGTH="2" VALUE="$checkinterval"> Minutes</TD></TR>

<TR BGCOLOR=$COLOR2><TD>Retry Interval :</TD><TD><INPUT TYPE="TEXT" NAME="retryinterval" SIZE="2" MAXLENGTH="2" VALUE="$retryinterval"> Minutes</TD></TR>

<TR BGCOLOR=$COLOR2><TD>Groups to Notify :</TD><TD><SELECT NAME="notificationgroups" SIZE=3 MULTIPLE>
EOF

	@notificationgroups = split (/,/, $notificationgroups);
	foreach $group (@notificationgroups) {
		$selected_groups{$group} = 1;
	}

	foreach $possible_contactgroup (sort (keys (%{$DATA{contactgroup}}))) {
		if ($selected_groups{$possible_contactgroup}) {
			print "<OPTION SELECTED VALUE=\"$possible_contactgroup\">$possible_contactgroup</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$possible_contactgroup\">$possible_contactgroup</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT>
</TD></TR>

<TR BGCOLOR=$COLOR2><TD>Re-Notification Interval :</TD><TD><INPUT TYPE="TEXT" NAME="notificationinterval" SIZE="2" MAXLENGTH="2" VALUE="$notificationinterval"> Minutes</TD></TR>

<TR BGCOLOR=$COLOR2><TD>TimePeriod to Notify</TD><TD><SELECT NAME="notificationperiod">
EOF

	foreach $possible_timeperiod (sort (keys (%{$DATA{timeperiod}}))) {
		if ($possible_timeperiod eq $notificationperiod) {
			print "<OPTION SELECTED VALUE=\"$possible_timeperiod\">$possible_timeperiod</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$possible_timeperiod\">$possible_timeperiod</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT></TD></TR>
EOF
	if ($notifyrecovery) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifyrecovery\" VALUE=\"1\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifyrecovery\" VALUE=\"1\"></TD></TR>\n";
	}

	if ($notifycritical) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Critical :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifycritical\" VALUE=\"1\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Critical :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifycritical\" VALUE=\"1\"></TD></TR>\n";
	}

	if ($notifywarning) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Warning :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifywarning\" VALUE=\"1\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Warning :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifywarning\" VALUE=\"1\"></TD></TR>\n";
	}
	print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Event Handler (Optional) :</TD><TD><INPUT TYPE=TEXT NAME="eventhandler" SIZE=60 MAXLENGTH=60 VALUE="$eventhandler"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Check Command :</TD>
<TD>
<SELECT NAME="checkcommand">
EOF

	foreach $possible_command (sort (keys (%{$DATA{command}}))) {
		if ($possible_command eq $checkcommand) {
			print "<OPTION SELECTED VALUE=\"$checkcommand\">$checkcommand</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$possible_command\">$possible_command</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT>
Optional Args (\! delimited) <INPUT TYPE="TEXT" NAME="checkcommandargs" SIZE="30" MAXLENGTH="60" VALUE="$checkcommandargs">
</TD></TR>
<INPUT TYPE="HIDDEN" NAME="type" VALUE="service">
EOF
	if ($modify) {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Modify Service\"></CENTER></TD></TR>\n";
	}

	else {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Create Service\"></CENTER></TD></TR>\n";
	}
}

##########
##########    CONTACT GROUP #########
##########

elsif ($type eq "contactgroup") {
	if ($modify) {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Contact Group Modification</H2></CENTER></TD></TR>\n";
		$entryname = param ("entryname");
		($name, $description, $contacts) = get_line ("$entryname");
		
		# Split up and work with the @contacts list...
		@contacts = split (/,/, $contacts);
		foreach $contact (@contacts) {
			$contacts{$contact} = 1;
		}
	}
	else {
	print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Contact Group Creation</H2></CENTER></TD></TR>\n";
		($name, $description) = "";
	}
	print "<TR BGCOLOR=$COLOR2>\n";

	if ($modify) {
		print <<EOF;
<TD>Name :</TD><TD><INPUT TYPE=HIDDEN NAME="name" VALUE="$name"><B>$name</B></TD>
EOF
	}
	else {
		print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Name :</TD><TD><INPUT TYPE="TEXT" NAME="name" SIZE="20" MAXLENGTH="20" VALUE="$name"> (No Spaces Allowed)</TD></TR>
EOF
	}

print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Description :</TD><TD><INPUT TYPE="TEXT" NAME="description" SIZE="30" MAXLENGTH="30" VALUE="$description"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Members :</TD>
<TD>
<SELECT NAME="contacts" SIZE=3 MULTIPLE>
EOF
foreach $contact (sort (keys (%{$DATA{contact}}))) {
	if ($contacts{$contact}) {
		print "<OPTION SELECTED VALUE=\"$contact\">$contact</OPTION>\n";
	}
	else {
		print "<OPTION VALUE=\"$contact\">$contact</OPTION>\n";
	}
}
print <<EOF;
</SELECT>
</TD>
</TR>
<INPUT TYPE="HIDDEN" NAME="type" VALUE="contactgroup">
EOF

	if ($modify) {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Modify Contact Group\"></CENTER></TD></TR>\n";
	}

	else {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Create Contact Group\"></CENTER></TD></TR>\n";
	}
}

##########  CONTACT ##########
elsif ($type eq "contact") {

	if ($modify) {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Contact Modification</H2></CENTER></TD></TR>\n";
		$entryname = param ("entryname");
		($name, $description, $timeperiod, $nosr, $nosc, $nosw, $nohr, $nohd, $nohu, $snc, $ncommands, $hncommands, $email, $pager) = get_line ("$entryname");
		@ncommands = split (/,/, $ncommands);
		foreach $ncommand (@ncommands) {
			$ncommands{$ncommand} = 1;
		}
		@hncommands = split (/,/, $hncommands);
		foreach $hncommand (@hncommands) {
			$hncommands{$hncommand} = 1;
		}
	}
	else {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Contact Creation</H2></CENTER></TD></TR>\n";
		($name, $description, $timeperiod, $nosr, $nosc, $nosw, $nohr, $nohd, $nohu, $snc, $ncommands, $hncommands, $email, $pager) = ("", "", "", 1, 1, 1, 1, 1, 1, "", "", "", "", "");
	}

	print "<TR BGCOLOR=$COLOR2>\n";

	if ($modify) {
		print <<EOF;
<TD>Name :</TD><TD><INPUT TYPE=HIDDEN NAME="name" VALUE="$name"><B>$name</B></TD>
EOF
	}
	else {
		print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Name :</TD><TD><INPUT TYPE="TEXT" NAME="name" SIZE="20" MAXLENGTH="20" VALUE="$name"> (No Spaces Allowed)</TD></TR>
EOF
	}

	print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Description :</TD><TD><INPUT TYPE="TEXT" NAME="description" SIZE="20" MAXLENGTH="30" VALUE="$description"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Notification Times :</TD>
<TD>
<SELECT NAME="timeperiod">
EOF

	foreach $possible_timeperiod (sort (keys (%{$DATA{timeperiod}}))) {
		if ($possible_timeperiod eq $timeperiod) {
			print "<OPTION SELECTED VALUE=\"$timeperiod\">$timeperiod</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$possible_timeperiod\">$possible_timeperiod</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT></TD></TR>
EOF
	if ($nosr) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Service Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nosr\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Service Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nosr\"></TD></TR>\n";
	}

	if ($nosc) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Service Critical :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nosc\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Service Critical :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nosc\"></TD></TR>\n";
	}

	if ($nosw) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Service Warning :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nosw\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Service Warning :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nosw\"></TD></TR>\n";
	}

	if ($nohr) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Host Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nohr\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Host Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nohr\"></TD></TR>\n";
	}

	if ($nohd) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Host Down :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nohd\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Host Down :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nohd\"></TD></TR>\n";
	}

	if ($nohu) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Host Unreachable :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nohu\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Host Unreachable :</TD><TD><INPUT TYPE=\"CHECKBOX\" VALUE=\"1\" NAME=\"nohu\" ></TD></TR>\n";
	}

	print "<TR BGCOLOR=$COLOR2><TD>How to Notify on Service Failure :</TD><TD><SELECT NAME=\"snc\" SIZE=\"3\" MULTIPLE>\n";

	foreach $snotifycmd (@snotifycmds) {
		if ($ncommands{$snotifycmd}) {
			print "<OPTION VALUE=\"$snotifycmd\" SELECTED>$snotifycmd</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$snotifycmd\">$snotifycmd</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT></TD></TR>
<TR BGCOLOR=$COLOR2><TD>How to Notify on Host Failure :</TD><TD><SELECT NAME="hnc" SIZE="3" MULTIPLE>
EOF

	foreach $hnotifycmd (@hnotifycmds) {
		if ($hncommands{$hnotifycmd}) {
			print "<OPTION VALUE=\"$hnotifycmd\" SELECTED>$hnotifycmd</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$hnotifycmd\">$hnotifycmd</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Email Address :</TD><TD><INPUT TYPE="TEXT" NAME="email" SIZE="30" MAXLENGTH="30" VALUE="$email"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Pager Name :</TD><TD><INPUT TYPE="TEXT" NAME="pager" SIZE="30" MAXLENGTH="30" VALUE="$pager"></TD></TR>
<INPUT TYPE="HIDDEN" NAME="type" VALUE="contact">
EOF
	if ($modify) {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Modify Contact\"></CENTER></TD></TR>\n";
	}

	else {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Create Contact\"></CENTER></TD></TR>\n";
	}
}

#########
#########  HOST GROUP #########
#########
elsif ($type eq "hostgroup") {

	if ($modify) {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Host Group Modification</H2></CENTER></TD></TR>\n";
		$entryname = param ("entryname");
		($name, $description, $contactgroups, $hosts) = get_line ("$entryname");
		@contactgroups = split (/,/, $contactgroups);
		foreach $contactgrp (@contactgroups) {
			$contactgroups{$contactgrp} = 1;
		}

		@hosts = split (/,/, $hosts);
		foreach $host (@hosts) {
			$hosts{$host} = 1;
		}
	}
	else {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Host Group Creation</H2></CENTER></TD></TR>\n";
		($name, $description, $contactgroups, $hosts) = "";
	}

	print "<TR BGCOLOR=$COLOR2>\n";

	if ($modify) {
		print <<EOF;
<TD>Name :</TD><TD><INPUT TYPE=HIDDEN NAME="name" VALUE="$name"><B>$name</B></TD></TR>
EOF
	}

	else {
		print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Name :</TD><TD><INPUT TYPE="TEXT" NAME="name" SIZE="20" MAXLENGTH="20" VALUE="$name"> (No Spaces Allowed)</TD></TR>
EOF
	}

	print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Description :</TD><TD><INPUT TYPE="TEXT" NAME="description" SIZE="30 MAXLENGTH="30" VALUE="$description"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Groups to Contact :</TD><TD><SELECT NAME="contactgroups" MULTIPLE SIZE="3">
EOF

	foreach $contactgroup (sort (keys (%{$DATA{contactgroup}}))) {
		if ($contactgroups{$contactgroup}) {
			print "<OPTION VALUE=\"$contactgroup\" SELECTED>$contactgroup</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$contactgroup\">$contactgroup</OPTION>\n";
		}
	}

	print "</SELECT></TD></TR>\n<TR BGCOLOR=$COLOR2><TD>Hosts in Group :</TD><TD><SELECT NAME=\"hosts\" MULTIPLE SIZE=\"10\">\n";

	foreach $host (sort (keys (%{$DATA{host}}))) {
		if ($hosts{$host}) {
			print "<OPTION VALUE=\"$host\" SELECTED>$host</OPTION>\n";
		}
		else {
       			print "<OPTION VALUE=\"$host\">$host</OPTION>\n";
		}
	}

	print "</SELECT>\n</TD></TR>\n<INPUT TYPE=\"HIDDEN\" NAME=\"type\" VALUE=\"hostgroup\">\n";

	if ($modify) {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Modify Host Group\"></CENTER></TD></TR>\n";
	}

	else {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Create Host Group\"></CENTER></TD></TR>\n";
	}
}

#########  HOST ##########
elsif ($type eq "host") {

	if ($modify) {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Host Modification</H2></CENTER></TD></TR>\n";
		$entryname = param ("entryname");
		($name, $description, $ip, $parent, $hcheckcmd, $maxattempts, $ninterval, $timeperiod, $notifyrecovery, $notifydown, $notifyunreachable) = get_line ("$entryname");
	}
	else {
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Host Creation</H2></CENTER></TD></TR>\n";
		#Set default values...
		($name, $description, $ip, $parent, $hcheckcmd, $maxattempts, $ninterval, $timeperiod, $notifyrecovery, $notifydown, $notifyunreachable) = ("", "", "", "", "", 5, 15, "", 1, 1, 1);
	}

	print <<EOF;
<TR BGCOLOR=$COLOR2>
<INPUT TYPE="HIDDEN" NAME="type" VALUE="host">
EOF

	if ($modify) {
		print <<EOF;
<TD>Name :</TD><TD><INPUT TYPE=HIDDEN NAME="name" VALUE="$name"><B>$name</B></TD></TR>
EOF
	}

	else {
		print <<EOF;
<TD>Name :</TD><TD><INPUT TYPE="TEXT" NAME="name" SIZE="20" MAXLENGTH="20" VALUE="$name"> (No Spaces Allowed)</TD></TR>
EOF
	}

	print <<EOF;
<TR BGCOLOR=$COLOR2><TD>Description :</TD><TD><INPUT TYPE="TEXT" NAME="description" SIZE="30" MAXLENGTH="30" VALUE="$description"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>IP Address or FQDN :</TD><TD><INPUT TYPE="TEXT" NAME="ip" SIZE="30" MAXLENGTH="40" VALUE="$ip"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Parent :</TD>
<TD><SELECT NAME="parent">
EOF

	# Print the None option...
	print "<OPTION VALUE=\"\"";
	if (!$parent) {
		print "SELECTED";
	}
	print "> -- None -- </OPTION>\n";

	# If we have a parent, be sure to select it when we print...
	if ($parent) {
		foreach $host (sort (keys (%{$DATA{host}}))) {
			if ($host eq $parent) {
				print "<OPTION SELECTED VALUE=\"$host\">$host</OPTION>\n";
			}
			else {
				print "<OPTION VALUE=\"$host\">$host</OPTION>\n";
			}
		}
	}
	# Otherwise, just print the hosts, and let the user choose...
	else {
		foreach $host (sort (keys (%{$DATA{host}}))) {
			print "<OPTION VALUE=\"$host\">$host</OPTION>\n";
		}
	}

	print "</SELECT></TD></TR>\n<TR BGCOLOR=$COLOR2><TD>Host Check Command :</TD>\n<TD><SELECT NAME=\"hostcheckcommand\">\n";

	# In the case where we want no host check command...
	print "<OPTION VALUE=\"\"";
	if (!$hcheckcmd) {
		print "SELECTED";
	}
	print "> -- None -- </OPTION>\n";

	foreach $hostcheckcommand (@hostcheckcommands) {
		if ($hostcheckcommand eq $hcheckcmd) {
			print "<OPTION SELECTED VALUE=\"$hostcheckcommand\">$hostcheckcommand</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$hostcheckcommand\">$hostcheckcommand</OPTION>\n";
		}
	}

	print <<EOF;
</SELECT>
</TD></TR>
<TR BGCOLOR=$COLOR2><TD>Number of Tries to Reach :</TD><TD><INPUT TYPE="TEXT" NAME="maxattempts" SIZE="2" MAXLENGTH="2" VALUE="$maxattempts"></TD></TR>

<TR BGCOLOR=$COLOR2><TD>Notification Interval :</TD><TD><INPUT TYPE="TEXT" NAME="notificationinterval" SIZE="3" MAXLENGTH="3" VALUE="$ninterval"> Minutes</TD></TR>

<TR BGCOLOR=$COLOR2><TD>Notification Period :</TD><TD><SELECT NAME="timeperiod">
EOF

	foreach $possible_timeperiod (sort (keys (%{$DATA{timeperiod}}))) {
		if ($possible_timeperiod eq $timeperiod) {
			print "<OPTION SELECTED VALUE=\"$timeperiod\">$timeperiod</OPTION>\n";
		}
		else {
			print "<OPTION VALUE=\"$possible_timeperiod\">$possible_timeperiod</OPTION>\n";
		}
	}

	print "</SELECT></TD></TR>\n";

	if ($notifyrecovery) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifyrecovery\" VALUE=\"1\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Recovery :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifyrecovery\" VALUE=\"1\"></TD></TR>\n";
	}

	if ($notifydown) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Down :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifydown\" VALUE=\"1\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Down :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifydown\" VALUE=\"1\"></TD></TR>\n";
	}

	if ($notifyunreachable) {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Unreachable :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifyunreachable\" VALUE=\"1\" CHECKED></TD></TR>\n";
	}
	else {
		print "<TR BGCOLOR=$COLOR2><TD>Notify on Unreachable :</TD><TD><INPUT TYPE=\"CHECKBOX\" NAME=\"notifyunreachable\" VALUE=\"1\"></TD></TR>\n";
	}

	if ($modify) {
		print "<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><INPUT TYPE=\"SUBMIT\" VALUE=\"Modify Host\"></CENTER></TD></TR>\n";
	}

    ###########################################################################
	else {
		print "<INPUT TYPE=\"HIDDEN\" NAME=\"initial\" VALUE=1>\n";
		# print out other screen - initial service selection and hostgroup selection...
		print "<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Initial Service Creation</H2></CENTER></TD></TR>\n";

		# Set some default values...
		($host, $description, $volatile, $timeperiod, $maxattempts, $checkinterval, $retryinterval, $notificationgroup, $notificationinterval, $notificationperiod, $notifyrecovery, $notifycritical, $notifywarning, $eventhandler, $checkcommand, $checkcommandargs) = ("", "", 0, "", 10, 5, 1, "", 30, "", 1, 1, 0, "", "", "");

	print <<EOF;

<TR BGCOLOR=$COLOR2><TD>Service Description :</TD>
<TD><INPUT TYPE="TEXT" SIZE="30" MAXLENGTH="30" NAME="sdescription" VALUE="$description"></TD>
</TR>
<TR BGCOLOR=$COLOR2>
<TD>Volatile Service:</TD>
<TD><INPUT TYPE=CHECKBOX NAME="svolatile" VALUE=1"></TD>
</TR>
<TR BGCOLOR=$COLOR2>
<TD>Monitoring Time Period :</TD>
<TD>
<SELECT NAME="stimeperiod">
EOF

	foreach $timeperiod (sort (keys (%{$DATA{timeperiod}}))) {
		print "<OPTION VALUE=\"$timeperiod\">$timeperiod</OPTION>\n";
	}

	print <<EOF;
</SELECT>
</TD>
</TR>
<TR BGCOLOR=$COLOR2><TD>Number of Attempts to Check :</TD><TD><INPUT TYPE="TEXT" NAME="smaxattempts" SIZE="2" MAXLENGTH="2" VALUE="$maxattempts"></TD></TR>

<TR BGCOLOR=$COLOR2><TD>Time Between Checks :</TD><TD><INPUT TYPE="TEXT" NAME="scheckinterval" SIZE="2" MAXLENGTH="2" VALUE="$checkinterval"> Minutes</TD></TR>

<TR BGCOLOR=$COLOR2><TD>Time Between Retries :</TD><TD><INPUT TYPE="TEXT" NAME="sretryinterval" SIZE="2" MAXLENGTH="2" VALUE="$retryinterval"> Minutes</TD></TR>

<TR BGCOLOR=$COLOR2><TD>Group to Notify :</TD><TD><SELECT NAME="snotificationgroup">
EOF
	foreach $contactgroup (sort (keys (%{$DATA{contactgroup}}))) {
		print "<OPTION VALUE=\"$contactgroup\">$contactgroup</OPTION>\n";
	}

	print <<EOF;
</SELECT>
</TD></TR>

<TR BGCOLOR=$COLOR2><TD>Re-Notification Interval :</TD><TD><INPUT TYPE="TEXT" NAME="snotificationinterval" SIZE="2" MAXLENGTH="2" VALUE="$notificationinterval"> Minutes</TD></TR>

<TR BGCOLOR=$COLOR2><TD>TimePeriod to Notify</TD><TD><SELECT NAME="snotificationperiod">
EOF

	foreach $timeperiod (sort (keys (%{$DATA{timeperiod}}))) {
		print "<OPTION VALUE=\"$timeperiod\">$timeperiod</OPTION>\n";
	}

	print <<EOF;
</SELECT></TD></TR>

<TR BGCOLOR=$COLOR2><TD>Notify on Recovery :</TD><TD><INPUT TYPE="CHECKBOX" NAME="snotifyrecovery" VALUE="1" CHECKED></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Notify on Critical :</TD><TD><INPUT TYPE="CHECKBOX" NAME="snotifycritical" VALUE="1" CHECKED></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Notify on Warning :</TD><TD><INPUT TYPE="CHECKBOX" NAME="snotifywarning" VALUE="1"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Event Handler (Optional) :</TD><TD><INPUT TYPE=TEXT NAME="seventhandler" SIZE=60 MAXLENGTH=60 VALUE="$eventhandler"></TD></TR>
<TR BGCOLOR=$COLOR2><TD>Check Command :</TD>
<TD>
<SELECT NAME="scheckcommand">
EOF

	foreach $command (sort (keys (%{$DATA{command}}))) {
		print "<OPTION VALUE=\"$command\">$command</OPTION>\n";
	}

	print <<EOF;
</SELECT>
Optional Args (\! delimited) <INPUT TYPE="TEXT" NAME="scheckcommandargs" SIZE="30" MAXLENGTH="60" VALUE="$checkcommandargs">
</TD></TR>

<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><H2>Initial HostGroup Selection</H2></CENTER></TD></TR>
<TR BGCOLOR=$COLOR2><TD>HostGroup :</TD><TD>
<SELECT NAME="shostgroup">
EOF
	foreach $hostgroup (sort (keys (%{$DATA{hostgroup}}))) {
		print "<OPTION VALUE=\"$hostgroup\">$hostgroup</OPTION>\n";
	}
print <<EOF;
</SELECT>
</TD></TR>
<TR BGCOLOR=$COLOR1><TD COLSPAN=2><CENTER><INPUT TYPE="SUBMIT" VALUE="Create Host"></CENTER></TD></TR>
EOF
	}
}

else {
	print "<TR><TD>ERROR - No such type</TD></TR>\n";
}

# Print out the end of this form...
print <<EOF;
<TR><TD COLSPAN=2 BGCOLOR=$COLOR1><CENTER><A HREF="javascript:history.back()">Back One Page</A></CENTER></TD></TR>
</FORM>
</TABLE>
</CENTER>
</BODY>
</HTML>
EOF

exit ();

############################### SUBROUTINES ###################################################

sub get_line {
	# This function takes an entryname (in one of two formats :
	# for services, format should be type[name]=desc
	# for other types, format should be type[name]
	
	# This function returns a list of the definitions for that entity...
	# starting with name, desc, etc...

	my ($entryname) = $_[0];
	my ($name, @contents, $type, $fullname, $command, $args);

	# If we are working with a service...
	if ($entryname =~ /^service/) {
		$entryname =~ /((\S+)\[(\S+)\]=[^;]*)/;
		$fullname = $1;
		$type = $2;
		$name = $3;
	}

	# Otherwise...
	else {
		$entryname =~ /(\S+)\[(\S+)\]/;
		$type = $1;
		$name = $2;
		$fullname = $name;
	}

	@contents = split (/;/, $DATA{$type}->{$fullname});

	# Special case for services...
	if ($type eq "service") {
		# Check to see if the command has optional arguments - if so, handle 'em
		if ($contents[$#contents] =~ /([^!]*)(!.*)/) {
			$command = $1;
			$args = $2;
			$contents[$#contents] = $command;
			push (@contents, $args);
		}
	}

	return ($name, @contents);
}
