#!/usr/bin/perl
# write_entry.cgi - Part of NetSaint Easy Administration Tool (NEAT)
# by jason blakey - jblakey@frogboy.net - http://www.frogboy.net
# Release Date: August 14/2000
#
$VERSION= "3.0";

####################### CONFIGURATION ###############################
$CONFIG = "/usr/local/netsaint/neat.options";
##################### END CONFIGURATION ############################# 

# Load the configuration file...
do ($CONFIG) or die ("Can't read the neat.options file $CONFIG: $!");

# Use the CGI module...
use CGI":standard";

# Print out our HTML headers...
print <<EOF;
Content-type: text/html

<HTML>
<HEAD>
<TITLE>
NetSaint Easy Administration Tool Version $VERSION
</TITLE>
</HEAD>

<BODY BGCOLOR=White>
<CENTER>
EOF

# Check to make sure that we can read and write the config file...
if ((! -w $HOSTS) and (! -r $HOSTS)) {
	finish_html ("<H2>ERROR - $HOSTS is not readable and writable - please fix</H2>");
	exit ();
}

# Find out what type we are dealing with...
$type = param ("type");

print <<EOF;
<TABLE WIDTH=600>
<TR><TD BGCOLOR=$COLOR2 COLSPAN=2><CENTER><H2>Results of $type Operation</H2></CENTER></TD></TR>
<TR><TD>
<BR>
EOF

##################  Delete? ##############

if ($type eq "delete") {

	# Get the entryname...
	$entryname = param ("entryname");

	# Check to see if "really delete" was checked
	$really_delete = param ("really_delete");

	# If we didn't check the delete confirm checkbox, refuse to delete...
	if (! $really_delete) {
		finish_html ("<BR>ERROR: If you really want to delete $entryname, check the check box and try again<BR>");
		exit ();
	}

	# Figure out if any entities reference this entity...
	$reflist = param ("reflist");

	# If , don't allow it to be deleted...
	if ($reflist) {
		print "Sorry, there are entities that reference <B>$entryname</B>\n";
		print "<BR>Please delete these entities, and try again<BR>\n";
		print "<H2><FONT COLOR=Red>Entities that reference</FONT> $entryname</H2>\n";
		@refs = split (/$DELIM/, $reflist);

		foreach $ref (@refs) {
			print "<LI><B>$ref</B></LI>\n";
		}

		finish_html ("<H3>Action Unsuccessful</H3>");
		exit ();
	}

	# Otherwise, happily continue...
	else {
		if ($entryname =~ /^service/) {
			# Then it is a service type ... special case...  grr....

			$description = param ("description");
			$entryname = $entryname . "=" . $description;

			modify_cfg ($entryname, "DELETE");
		}

		# Check if we are deleting a host and its associated services and 
		# Host group entry.......
		elsif (($entryname =~ /^host\[/)) {

			# Delete the host entry...
			modify_cfg ($entryname, "DELETE");

			# Next, get our list of references for this host...
			$delreflist = param ("delreflist");
			@refs = split (/$DELIM/, $delreflist);

			foreach $ref (@refs) {

				# If the ref is a host, remove myself from its parent spot...
				if ($ref =~ /host\[/) {

					# Get our entry...
					$entry = modify_cfg ($ref, "QUERY");

					# Break the entry into its fields...
					@parts = split (/;/, $entry);

					# Rebuild the entry without $parts[3] - which is the parental
					# host...
					$parts[3] = "";
					$entry = join (";", @parts);

					# Do the modify...
					modify_cfg ($entry);
				}

				# Elsif the ref is service, delete the service...
				if ($ref =~ /service\[/) {
					modify_cfg ($ref, "DELETE");
				}

				# Else the ref is a hostgroup, remove myself from the hostgroup...
				elsif ($ref =~ /hostgroup\[/) {
				
					# Get our hostgroup entry...
					$entry = modify_cfg ($ref, "QUERY");

					# Break the entry into its fields...
					@parts = split (/;/, $entry);

					# Break the hosts field into its parts...
					@hosts = split (/,/, $parts[2]);

					$entryname =~ /host\[(\S+)\]/;
					$hostname = $1;

					# Recreate the hosts field...
					$parts[2] = "";
					foreach $host (@hosts) {
						# Skip the hostname that we are removing...
						next if ($host eq $hostname); 
						$parts[2] .= "$host,";
					}

					# Remove the trailing , ...
					chop ($parts[2]);

					# Rebuild the entry...
					$entry = join (";", @parts);

					# Do the modify...
					modify_cfg ($entry);	
				}
			}
		}

		# Otherwise, just do the modify_cfg - its not a special case...
		else {
			modify_cfg ($entryname, "DELETE");
		}
	}
}

#########
#########     Time Period    #########
#########

elsif ($type eq "timeperiod") {
	$name = param ("name");
	$description = param ("description");

	#Check our input...
	if (check_input ("name", $name, 1, 1, 1, 1, 1)) { 
		exit (); 
	}

	if (check_input ("description", $description, 0, 1, 1, 1, 1)) {
		exit ();
	}
	
	# Get our variables from param...
	# And check 'em...
	foreach $i (0 .. 6) {
		$tp = "timeperiod"."$i";
		${$tp} = param ("range$i");

		if ((${$tp} !~ /\d\d\:\d\d\-\d\d\:\d\d/) and ${$tp}) {
			$day  = $weekdays[$i];
			finish_html ("ERROR:  the <B>Time Range for $day</B> is not in the format <B>hh:mm-hh:mm</B> ${$tp}");
			exit ();
		}
	}

	# Build our line that will be put into $HOSTS...
	$line = "timeperiod[$name]=$description;";
	foreach $i (0 .. 6) {
		$tp = "timeperiod"."$i";
		if (! ${$tp}) {
			$line .= ";";
		}
		else {
			$line .= "${$tp};";
		}
	}

	# Do our modification to the $HOSTS file...
	modify_cfg ($line);
}

###########
###########     Contact #########
###########
elsif ($type eq "contact") {
	# Get our parameters...
	$name = param ("name");
	$description = param ("description");
	$timeperiod = param ("timeperiod");

	if (check_input ("name", $name, 1, 1, 1, 1, 1)) {
		exit ();
	}

	if (check_input ("description", $description, 0, 1, 1, 1, 1)) {
		exit ();
	}

	if (!($nosr = param ("nosr"))) {
		$nosr = "0";
	}

	if (! ($nosc = param ("nosc"))) {
		$nosc = "0";
	}

	if (! ($nosw = param ("nosw"))) {
		$nosw = "0";
	}

	if (! ($nohr = param ("nohr"))) {
			$nohr = "0";
	}

	if (! ($nohd = param ("nohd"))) {
		$nohd = "0";
	}

	if (! ($nohu = param ("nohu"))) {
		$nohu = "0";
	}

	@snc = param ("snc");
	@hnc = param ("hnc");
	$email = param ("email");
	$pager = param ("pager");

	# Build the full_snc...
	$full_snc = join (",", @snc);

	# Build the  full_hnc...
	$full_hnc = join (",", @hnc);

	# Write out the input...
	modify_cfg ("contact[$name]=$description;$timeperiod;$timeperiod;$nosr;$nosc;$nosw;$nohr;$nohd;$nohu;$full_snc;$full_hnc;$email;$pager;");
}

##########
##########  Contact Group  #########
##########
elsif ($type eq "contactgroup") {
	$name = param ("name");
	$description = param ("description");
	@contacts = param ("contacts");

	if (check_input ("name", $name, 1, 1, 1, 1, 1)) {
		exit ();
	}

	if (check_input ("description", $description, 0, 1, 1, 1, 1)) {
		exit ();
	}

	# Build our contact list...
	$clist = join (",", @contacts);

	if (check_input ("Contacts", $clist, 1, 1, 1, 1, 1)) {
		exit ();
	}

	modify_cfg ("contactgroup[$name]=$description;$clist");
}

###########
########### Host ############
###########
	
elsif ($type eq "host") {

	# Check if we are running in initial creation mode...
	$initial = param ("initial");

	$name = param ("name");
	$description = param ("description");
	$ip = param ("ip");
	$parent = param ("parent");
	$hostcheckcommand = param ("hostcheckcommand");
	$maxattempts = param ("maxattempts");
	$notificationinterval = param ("notificationinterval");
	$timeperiod = param ("timeperiod");

	if (!($notifyrecovery = param ("notifyrecovery"))) {
		$notifyrecovery = "0";
	}

	if (!($notifydown = param ("notifydown"))) {
		$notifydown = "0";
	}
	if (!($notifyunreachable = param ("notifyunreachable"))) {
		$notifyunreachable = "0";
	}

	# If this is an initial creation, we need to get the service details
	# as well...
	if ($initial) {
		$sdescription = param ("sdescription");
		$stimeperiod = param ("stimeperiod");
		$smaxattempts = param ("smaxattempts");
		$scheckinterval = param ("scheckinterval");
		$sretryinterval = param ("sretryinterval");
		$snotificationgroup = param ("snotificationgroup");
		$snotificationinterval = param ("snotificationinterval");
		$snotificationperiod = param ("snotificationperiod");
		
		if (!($svolatile = param ("svolatile"))) {
			$svolatile = "0";
		}
	
		if (!($snotifyrecovery = param ("snotifyrecovery"))) {
			$snotifyrecovery = "0";
		}

		if (!($snotifycritical= param ("snotifycritical"))) {
			$snotifycritical = "0";
		}

		if (!($snotifywarning = param ("snotifywarning"))) {
			$snotifywarning = "0";
		}

		$scheckcommand = param ("scheckcommand");
		$scheckcommandargs = param ("scheckcommandargs");
		$seventhandler = param ("seventhandler");
		$shostgroup = param ("shostgroup");

		if (check_input ("Service Description", $sdescription, 0, 1, 1, 1, 1)) {
			exit ();
		}
		if (check_input ("Number of Attempts to Check", $smaxattempts, 1, 1, 1, 1, 1, 1)) {
			exit ();
		}
		if (check_input ("Time Between Checks", $scheckinterval, 1, 1, 1, 1, 1, 1)) {
			exit ();
		}
		if (check_input ("Time Between Retries", $sretryinterval, 1, 1, 1, 1, 1, 1)) {
			exit ();
		}
		if (check_input ("Re-Notification Interval", $snotificationinterval, 1, 1, 1, 1, 1, 1)) {
			exit ();
		}
	}


	if  (check_input ("Name", $name, 1, 1, 1, 1, 1)) {
		exit ();
	}

	if (check_input ("Description", $description, 0, 1, 1, 1, 1)) {
		exit ();
	}
			
	if (check_input ("IP or FQDN", $ip, 1, 1, 1, 1, 1, 0, 1)) {
		exit ();
	}

	modify_cfg ("host[$name]=$description;$ip;$parent;$hostcheckcommand;$maxattempts;$notificationinterval;$timeperiod;$notifyrecovery;$notifydown;$notifyunreachable;");

	if ($initial) {
		# We have to store the service , and modify the host group...
		modify_cfg ("service[$name]=$sdescription;$svolatile;$stimeperiod;$smaxattempts;$scheckinterval;$sretryinterval;$snotificationgroup;$snotificationinterval;$snotificationperiod;$snotifyrecovery;$snotifycritical;$snotifywarning;$seventhandler;$scheckcommand$scheckcommandargs");

		# Get the line for the hostgroup in question...
		$hostgroupdef = modify_cfg("hostgroup[$shostgroup]", "QUERY");

		# Break it apart to get at the insides...
		@fields = split (/;/, $hostgroupdef);

		# See if we have any hosts in the hostgroup already...
		if ($fields[2]) {
			# If yes...
			# Add our name onto the list of names in the hostgroup...
			$fields[2] .= ",$name";
		}

		else {
			# Otherwise, just make it the name..
			$fields[2] = "$name";
		}

		# Rebuilt our hostgroup entry...
		$entry = join (";", @fields);

		# And finally, modify the hostgroup...
		modify_cfg ("$entry");
	}	
}

###########
###########   Host Group #########
###########

elsif ($type eq "hostgroup") {
	$name = param ("name");
	$description = param ("description");
	@contactgroups = param ("contactgroups");
	@hosts = param ("hosts");

	if (check_input ("Name", $name, 1, 1, 1, 1, 1)) {
		exit ();
	}
	if (check_input ("Description", $description, 0, 1, 1, 1, 1)) {
		exit ();
	}

	# Build our contactgroup list and host list...
	$cg_list = join (",", @contactgroups);
	$host_list = join (",", @hosts);

	modify_cfg ("hostgroup[$name]=$description;$cg_list;$host_list");
}

############
############   Service ###########
############

elsif ($type eq "service") {
	$host = param ("host");
	$description = param ("description");
	$timeperiod = param ("timeperiod");
	$maxattempts = param ("maxattempts");
	$checkinterval = param ("checkinterval");
	$retryinterval = param ("retryinterval");
	@notificationgroups = param ("notificationgroups");
	$notificationinterval = param ("notificationinterval");
	$notificationperiod = param ("notificationperiod");

	if (!($volatile = param ("volatile"))) {
		$volatile = "0";
	}

	if (!($notifyrecovery = param ("notifyrecovery"))) {
		$notifyrecovery = "0";
	}

	if (!($notifycritical = param ("notifycritical"))) {
		$notifycritical = "0";
	}

	if (!($notifywarning = param ("notifywarning"))) {
		$notifywarning = "0";
	}

	$checkcommand = param ("checkcommand");
	$checkcommandargs = param ("checkcommandargs");
	$eventhandler = param ("eventhandler");

	if (check_input ("Description", $description, 0, 1, 1, 1, 1)) {
		exit ()
	}

	if (check_input ("Number of Attempts to Check", $maxattempts, 1, 1, 1, 1, 1, 1)) {
		exit ()
	}

	if (check_input ("Time Between Checks", $checkinterval, 1, 1, 1, 1, 1, 1)) {
		exit ()
	}

	if (check_input ("Time Between Retries", $retryinterval, 1, 1, 1, 1, 1, 1)) {
		exit ()
	}

	if (check_input ("Re-Notification Interval", $notificationinterval, 1, 1, 1, 1, 1, 1)) {
		exit ()
	}

	# Build our notificationgroups...
	$notificationgroups = join (",", @notificationgroups);

	# Write the line...
	modify_cfg ("service[$host]=$description;$volatile;$timeperiod;$maxattempts;$checkinterval;$retryinterval;$notificationgroups;$notificationinterval;$notificationperiod;$notifyrecovery;$notifycritical;$notifywarning;$eventhandler;$checkcommand$checkcommandargs");
}

else {
	finish_html("Error - no type given?  type - $type");
	exit ();
}

# Finish printing our HTML...
# If we get this far we've been successful...\n";
finish_html ("Action Successful");

# And exit...
exit ();

########################################
############## SUBROUTINES #############
########################################

sub finish_html {
	my ($message) = $_[0];
	print <<EOF;
$message
<BR>
</TD>
</TR>
<TR BGCOLOR=$COLOR2>
<TD>
<CENTER><A HREF="$CGIPATH/admin.cgi"><FONT SIZE=+1>Back to NetSaint Administration</FONT></A></CENTER>
</TD>
<TD>
<A HREF="javascript:history.back()">Back One Page</A>
</TD>
</TR>
</TABLE>
</CENTER>
</BODY>
</HTML>
EOF

	return ();
}

################## CHECK INPUT SUBROUTINE ########################
sub check_input {
	my ($fieldname) = $_[0];
	my ($input) = $_[1];
	my ($nospace) = $_[2];
	my ($nosemicolon) = $_[3];
	my ($noquotes) = $_[4];
	my ($noslash) = $_[5];
	my ($noempty) = $_[6];
	my ($noalpha) = $_[7];
	my ($notip_and_notfqdn) = $_[8];

	if ($nospace) {
		if ($input =~ /\s/) {
			finish_html ("ERROR: The <B>$fieldname</B> field contains one or more space characters");
			return (1);
		}
	}

	if ($nosemicolon) {
		if ($input =~ /\;/) {
			finish_html ("ERROR: The <B>$fieldname</B> field contains one or more semicolons - nice try");
			return (1);
		}
	}

	if ($noquotes) {
		if ($input =~ /[\"\'\`]/) {
			finish_html ("ERROR: The <B>$fieldname</B> field contains one or more quotes");
			return (1);
		}
	}

	if ($noslash) {
		if ($input =~ /[\\\/]/) {
			finish_html ("ERROR: The <B>$fieldname</B> field contains one or more slashes");
			return (1);
		}
	}

	if ($noempty) {
		if ($input eq "") {
			finish_html ("ERROR: The <B>$fieldname</B> field contains nothing - should contain something");
			return (1);
		}
	}
	
	if ($noalpha) {
		if ($input =~ /[^\d]/) {
			finish_html ("ERROR: The <B>$fieldname</B> field contains one or more non-numeric characters");
			return (1);
		}
	}

	if ($notip_and_notfqdn) {
		if (($input !~ /^\d+\.\d+\.\d+\.\d+$/) and ($input !~ /^\S+\.\S+$/)) {
			finish_html ("ERROR: The <B>$fieldname</B> field contains something other than an IP address or fully qualified domain name: <B>$input</B>");
			return (1);
		}
	}
			


	else {
		return ();
	}

} 

##################### MODIFY CFG SUBROUTINE ###############################
# This subroutine will modify the hosts file...
# Possible modes DELETE and QUERY (and of course, none for modify)...
sub modify_cfg {
	my ($entry) = $_[0];
	my ($mode) = $_[1];
	my ($line, $fullname, $kind, $name, $desc, %entries, $current_type, $type, $upper_case);

	# First, we read in the config file...
	open (HOSTS, "< $HOSTS");
	while (defined ($line = <HOSTS>)) {
		next if ($line =~ /^#/);
		chomp ($line);

		if ($line =~ /^((\S+)\[(\S+)\]=([^;]*))/) {
			$fullname = $1;
			$kind = $2;
			$name = $3;
			$desc = $4;

			# Service is a special case...
			if ($kind ne "service") {
				$fullname = "${kind}"."[${name}]";
			
			}

			$entries{$fullname} = $line;
		}
	}
	close (HOSTS);

	# Check which mode we are in...
	# If the optional arg mode is set, then we are deleting...
	if ($mode eq "DELETE") {
		# So we undefine the entry in %entries for $name...
		undef ($entries{$entry});
	}

	elsif ($mode eq "QUERY") {
		# Return the entry in question...
			return ($entries{$entry});
	}
		
	else {
		# We are in add/modify mode...
		# And we either write over, or assign a brand new entry in %entries

		$entry =~ /^((\S+)\[(\S+)\]=([^;]*))/;
		$fullname = $1;
		$kind = $2;
		$name = $3;
		$desc = $4;

		if ($kind ne "service") {
			$fullname = "${kind}"."[${name}]";
		}
		# insert into %entries...
		$entries{$fullname} = $entry;
	}

	# Now, we write the config out with the changes...

	# Initialize current_type...
	$current_type = "";

	# Open the hosts file for writing, and throw the ordered stuff in it...
	open (HOSTS, "> $HOSTS");
	foreach $name (sort (keys (%entries))) {

			# Figure out what type of entry we are dealing with...
			$name =~ /^(\S+)\[/;
			$type = $1;
		
			# If the type is different from the current type,
			# print a header saying what kind of type this is...
			if ($type ne $current_type) {
				$upper_case = uc($type);
				print HOSTS "\n\# $upper_case ENTRIES\n\n"; 
				$current_type = $type;
			}
		print HOSTS "$entries{$name}\n";
	}
	close (HOSTS);

	# And return...
	return ();
}
