Program Nicole;

{$I-}

Uses CRT;


Const
  MaxWords        = 30;
	Version         = '1.2b';
	Legalcharacters = ['A'..'Z'];
	Nicolepath      = 'c:\nicole\';
	Configfilename  = 'c:\nicole\nicole.cfg';
	IndexFilename   = 'c:\nicole\index.nic';
	Topfilename     = 'c:\nicole\top.nic';

Type
  Indexrec = record
      Wordst : String[15];
    End;
  Toprec   = record
      Wordnum : Integer;
      Occurance : Integer;
    End;
  Wordrec  = record
      PrevWord : Integer;
      Occurance : Integer;
      NextWord : Integer;
    End;

Var
  Sentence : String;
  Wordlist : array [1..Maxwords] of string[15];
  Indexfile : File of IndexRec;
  Topfile : File of Toprec;
  Wordfile : File of Wordrec;
  QuitSelected : Boolean;
  StartWord : Integer;
  Command : Boolean;

function FileExists(FileName: string) : Boolean;

var
  F: File;

begin
  Assign(f, FileName);
  Reset(f);
  Close(f);
  FileExists := (IOResult = 0) and (FileName <> '');
end;

Function RecNum(ST : String) : Integer;

Var
  Number : Integer;
  Tmp : IndexRec;

Begin
  Number := 0;
    Reset(Indexfile);
    Repeat
      Read(Indexfile,Tmp);
      If Tmp.wordST = ST then
        Number := FilePos(Indexfile);
    Until (EOF(Indexfile)) or (Number <> 0);
  Close(Indexfile);
  Recnum := Number
End;

Function Wordst(Num : Integer) : String;

Var
  Tmp : Indexrec;

Begin
  If Num > 0 then
    Begin
      Wordst := '';
      Reset(Indexfile);
      Seek(Indexfile,Num-1);
      Read(Indexfile,tmp);
      Close(Indexfile);
      Wordst := Tmp.Wordst;
    End;
End;

Function InIndex(ST : String):Boolean;

Var
  Tmp : IndexRec;
  Foundit : Boolean;

Begin
  Foundit := False;
  Reset(Indexfile);
  If not EOF(Indexfile) then
    Begin
      Repeat
        Read(Indexfile,Tmp);
        If Tmp.wordST = ST then
          Foundit := True;
      Until (EOF(Indexfile)) or Foundit;
      Close(Indexfile);
    End;
  Inindex := Foundit;
End;

Procedure InsertintoIndex(St : String);

Var
  Tmp : Indexrec;

Begin
  If not Inindex(ST) then
    Begin
      Reset(Indexfile);
      Seek(Indexfile,Filesize(Indexfile));
      Tmp.Wordst := ST + '';
      Write(Indexfile,Tmp);
      Close(Indexfile);
    End;
End;

Function InTop(ST : String) : Boolean;

Var
  Tmp : TopRec;
  Foundit : Boolean;

Begin
  InTop := False;
  Foundit := False;
  Reset(Topfile);
  If not EOF(Topfile) then
    Begin
      Repeat
        Read(Topfile,Tmp);
        If Tmp.WordNum = RecNum(ST) then
          Foundit := True;
      Until (EOF(Topfile)) or (Foundit = True);
      Close(Topfile);
    End;
  Intop := Foundit;
End;

Procedure InsertFirstWord(ST : String);

Var
  Tmp : Toprec;

Begin
  If not InTop(ST) then
    Begin
      Reset(Topfile);
      Seek(Topfile,FileSize(Topfile));
      Tmp.WordNum := RecNum(ST);
      Tmp.Occurance := 1;
      Write(Topfile,Tmp);
      Close(Topfile);
    End
  Else
    Begin
      Reset(Topfile);
      Repeat
        Read(Topfile,Tmp);
      Until Tmp.Wordnum = RecNum(ST);
      Inc(Tmp.Occurance);
      Seek(Topfile,(FilePos(Topfile) - 1));
      Write(Topfile,Tmp);
      Close(Topfile);
    End;
End;

Function filename(Curr : Integer) : String;

Var
  Tmp : String;

Begin
  Tmp := '';
  Str(Curr,Tmp);
  While Length(Tmp) < 8 do
    Tmp := '0' + Tmp;
  Tmp := NicolePath + Tmp + '.nic';
  Filename := Tmp;
End;

Function InWord(Prev, Curr, Next : Integer) : Boolean;

Var
  Tmp : WordRec;
  Foundit : Boolean;

Begin
  InWord := False;
  Foundit := False;
  If Fileexists(Filename(Curr)) then
    Begin
      Foundit := False;
      Assign(Wordfile,filename(Curr));
      Reset(wordfile);
      If not EOF(Wordfile) then
        Begin
          Repeat
            Read(wordfile,Tmp);
            If (Tmp.PrevWord = Prev) and (Tmp.Nextword = Next) then
                Foundit := True;
          Until (EOF(Wordfile)) or (Foundit = True);
        End;
      Close(Wordfile);
      Inword := Foundit;
    End;
End;

Procedure InsertWordRec(Prev, Curr, Next : Integer);

Var
  Tmp : Wordrec;

Begin
  If not InWord(Prev, Curr, Next) then
    Begin
      Assign(Wordfile,Filename(Curr));
      If FileExists(Filename(Curr)) then
        Begin
          Reset(Wordfile);
          Seek(Wordfile,Filesize(Wordfile));
        End
      Else
        ReWrite(Wordfile);
      Tmp.PrevWord := Prev;
      Tmp.Occurance := 1;
      Tmp.NextWord := Next;
      Write(Wordfile,Tmp);
      Close(Wordfile);
    End
  Else
    Begin
      Assign(Wordfile,Filename(Curr));
      Reset(Wordfile);
      Repeat
        Read(Wordfile,Tmp);
      Until (Tmp.PrevWord = Prev) and (Tmp.Nextword = Next);
      Inc(Tmp.Occurance);
      Seek(Wordfile,(FilePos(Wordfile) - 1));
      Write(Wordfile,Tmp);
      Close(Wordfile);
    End;
End;

Procedure CheckSyntax;

Var
  I : Byte;
  Newsentence : String;

Begin
  I := 0;
  Newsentence := '';
  While I < Length(Sentence) do
    Begin
      I := I + 1;
      If (Sentence[I] in Legalcharacters) then
        Newsentence := Newsentence + Sentence[I];
    End;
  Sentence := Newsentence;
End;

Procedure InputSentence;

Var
  I : Byte;

Begin
  Textcolor(Green);
  Write('>');
  Textcolor(White);
  Readln(Sentence);
  For I := 1 to Length(Sentence) do
    Sentence[I] := Upcase(Sentence[I]);
  Command := False;
  If (Sentence[1] = '#') or (Sentence = '') then
    Command := True;
End;

Procedure ChooseStartofSentence;

Var
  Tmp : Toprec;
  Total : Integer;
  Choice : Integer;

Begin
  Total := 0;
  Reset(Topfile);
  While not EOF(Topfile) do
    Begin
      Read(Topfile,Tmp);
      Total := Total + Tmp.Occurance;
    End;
  Choice := Random(Total) + 1;
  Seek(Topfile,0);
	Total := 0;
	Repeat
    Read(Topfile,Tmp);
    Total := Total + Tmp.Occurance;
	Until (EOF(Topfile)) or (Total >= Choice);
	Startword := Tmp.WordNum;
	Textcolor(LightRed);
	Write('Nicole > ');
	Textcolor(Yellow);
	Write(Wordst(StartWord));
	Close(Topfile);
End;

Procedure ChooseRestofSentence(Prev,Curr : Integer);

Var
  Tmp : Wordrec;
  Total : Integer;
  Choice : Integer;

Begin
  Total := 0;
  Assign(wordfile,filename(curr));
	Reset(Wordfile);
  While not EOF(Wordfile) do
    Begin
      Read(Wordfile,Tmp);
      If Tmp.Prevword = Prev then
          Total := Total + Tmp.Occurance;
    End;
  Choice := Random (Total) + 1;
  Seek(Wordfile,0);
	Total := 0;
	Repeat
    Read(Wordfile,Tmp);
    If Tmp.Prevword = Prev then
      Total := Total + Tmp.Occurance;
	Until (EOF(Wordfile)) or (Total >= Choice);
	Close(Wordfile);
  If Tmp.Nextword = 0 then
    Writeln('.')
  Else
    Begin
      Write(' ',Wordst(Tmp.Nextword));
      ChooseRestofSentence(Curr,Tmp.Nextword);
    End;
End;

Procedure Reply;

Begin
  ChooseStartofSentence;
  ChooseRestofSentence(-1,StartWord);
End;

Procedure Splitintowords(ST : String);

Var
  J : Integer;

Begin
  If Not QuitSelected then
    Begin
      J := 0;
      While (ST[1] <> ' ') and ( j < Maxwords) and (Length(ST) > 0)do
        Begin
          J := J + 1;
          While (ST[1] = ' ') and (Length(ST) > 0) do
            Delete(ST,1,1);
          While(ST[1] <> ' ') and (Length(ST) > 0) do
            Begin
              Wordlist[J] := Wordlist[J] + ST[1];
              Delete(ST,1,1);
            End;
          While (ST[1] = ' ') and (Length(ST) > 0) do
            Delete(ST,1,1);
        End;
      J := 1;
      While Wordlist[J] <> '' do
        Begin
          InsertintoIndex(Wordlist[J]);
          J := J + 1;
        End;
      InsertFirstword(Wordlist[1]);
      J := 1;
      While Wordlist[J] <> '' do
        Begin
          If J = 1 then
            InsertWordRec(-1,Recnum(Wordlist[j]),Recnum(Wordlist[j+1]))
          Else
            InsertWordRec(Recnum(Wordlist[J-1]),Recnum(Wordlist[J]),Recnum(Wordlist[J+1]));
          J := J + 1;
        End;
      For J := 1 to Maxwords do
      Wordlist[J] := '';
    End;
End;

Procedure CountWords;

Var
  Total : Integer;

Begin
  Textcolor(Yellow);
  Writeln;
  Reset(Indexfile);
  Writeln('Vocabulary consists of ',Filesize(Indexfile),' unique words');
	Close(Indexfile);
  Writeln;
End;

Procedure ShowHelp;

Begin
  Textcolor(Yellow);
  Writeln;
  Writeln(' #HELP - Displays this help screen.');
  Writeln(' #COUNT - Display number of words NICOLE knows.');
  Writeln(' #QUIT - Quit Programs.');
  Writeln;
End;

Procedure Initialise;

Var
  I : Integer;

Begin
  Randomize;
  Assign(Indexfile,Indexfilename);
  If not FileExists(Indexfilename) then
    Begin
      Rewrite(Indexfile);
      close(Indexfile);
    End;
  Assign(Topfile,Topfilename);
  If not FileExists(Topfilename) then
    Begin
      Rewrite(Topfile);
      Close(Topfile);
    End;
  For I := 1 to Maxwords do
    Wordlist[I] := '';
  Sentence := '';
  QuitSelected := False;
  Command := False;
  ClrScr;
  Textcolor(LightBlue);
  Writeln('    ---=== Nearly Intelligent Computer Operated Language Examiner ===---');
  Textcolor(White);
  Writeln('                Version ',Version,' By Philip Howlett. (C) April 1993');
  Textcolor(LightRed);
  Writeln('Conditions:');
  Writeln('===========');
  Textcolor(Yellow);
  Writeln('1. Sentences must not be more than 20 words long.');
  Writeln('2. Dont use punctuation.');
  Writeln('3. Type #HELP for Help.');
  Writeln;
  Textcolor(Cyan);
  Writeln('+-----------------------------------------------------------------------------+');
  For I := 1 to 13 do
    Writeln('|                                                                             |');
  Writeln('+-----------------------------------------------------------------------------+');
  Window(2,10,78,22);
End;

Procedure Finish;

Begin
	Window(1,1,80,25);
  ClrScr;
End;

Begin
  Initialise;
  Repeat
    InputSentence;
    If Command then
      Begin
        If Sentence = '#QUIT' then
          QuitSelected := True
        Else
        If Sentence = '#COUNT' then
          CountWords
        Else
        If Sentence = '#HELP' then
					ShowHelp;
				End
    Else
      Begin
        If Sentence <> '' then
          Splitintowords(Sentence);
        Reply;
      End;
  Until QuitSelected;
  Finish;
End.
