Unit BtreeDat;

{ btree1 -- a general unit for manipulating alphabetized strings
  on the heap }

{ Copyright 1989, by J. W. Rider  }

{ Modified for readability by Philip Howlett 1993 }

Interface

Type
  Dat_recptr = ^Dat_btrec;
  Dat_btrec = record
      upper,
      right,
      left       : Dat_recptr;
      counter    : integer;
      WordSt,
      Prevword,
      Nextword   : string[15];
    end;

Procedure Dat_firstrec(var current : Dat_recptr);
Procedure Dat_lastrec(var current : Dat_recptr);
Procedure Dat_delrec(var root,current: Dat_recptr);
Function Dat_findrec(var current : Dat_recptr; prev, currWd, next : string) : boolean;
Procedure Dat_nextrec(var current: Dat_recptr);
Procedure Dat_prevrec(var current: Dat_recptr);
Function Dat_storec(var root : Dat_recptr; var Prev, CurrWd, Next : string) : Dat_recptr;

Implementation

Procedure Dat_firstrec(var current : Dat_recptr);

{ returns the address of the first record in the btree branch
  from "current". if no btree has been entered, returns nil. }

Begin
  If current<>nil then
    While current^.left<>nil do
      current:=current^.left;
End;


Procedure Dat_lastrec(var current : Dat_recptr);

{ returns the address of the last record in the btree branch
  from "current". if no btree has been entered, returns nil. }

Begin
  If current<>nil then
    While current^.right<>nil do
      current:=current^.right;
End;


Procedure Dat_delrec(var root, current : Dat_recptr);

Var
  tr : Dat_recptr;

{ delete the current record }

Begin
  tr:=current;
  If tr<>nil then
    Begin

   { replace the current node with the right hand branches }

      If tr^.right<>nil then
        Begin
          current := tr^.right;
          Dat_firstrec(current);
          current^.left := tr^.left;
          tr^.right^.upper := tr^.upper;
          If tr^.left<>nil then
            tr^.left^.upper:=current;
          If tr^.upper<>nil then
            If tr^.upper^.left=tr then
              tr^.upper^.left := tr^.right
            Else
              tr^.upper^.right := tr^.right
          Else
            root:=tr^.right;
        End

   { replace the current node with the left hand branches }

      Else
        If tr^.left<>nil then
          Begin
            tr^.left^.upper  :=  tr^.upper;
            If tr^.upper<>nil then
              If tr^.upper^.right=tr then
                tr^.upper^.right := tr^.left
              Else
                tr^.upper^.left := tr^.left
            Else
              root := tr^.left;
          End

   { current node is a leaf }

        Else
          If tr^.upper<>nil then
            If tr^.upper^.right=tr then
              tr^.upper^.right := nil
            Else
              tr^.upper^.left := nil

   { current node is only node in tree }

          Else
            root:=nil;

   { always return the "parent" as current }

      current := tr^.upper;

   { free up the memory }

      freemem(tr,sizeof(Dat_btrec));
    End;
End;


Function Dat_findrec(var current : Dat_recptr; prev, currWd, next : string) : boolean;

{ find the record that matches the string }

Begin
  Dat_findrec := false;
  While current<>nil do
    If ((current^.WordST = CurrWd) and (current^.prevword = prev) and (current^.nextword = next)) then
      Begin
        Dat_findrec := true;
        exit;
      End
    Else
      If current^.WordST>CurrWd then
        If current^.left<>nil then
          current := current^.left
        Else
          exit
      Else
        If current^.right<>nil then
          current := current^.right
        Else
          exit;
End;


Procedure Dat_nextrec(var current : Dat_recptr);

{ makes current the record following current record }

Begin
  If current<>nil then
    If current^.right<>nil then
      Begin
        current := current^.right;
        While current^.left<>nil do
          current := current^.left;
      End
    Else
      Begin
        While (current^.upper<>nil) and (current^.upper^.right=current) do
          current := current^.upper;
        If current^.upper<>nil then
          current := current^.upper
        Else
          current := nil;
      End;
End;


Procedure Dat_prevrec(var current : Dat_recptr);

{ makes current the record preceding current record }

Begin
  If current<>nil then
    If current^.left<>nil then
      Begin
        current := current^.left;
        While current^.right<>nil do
          current := current^.right;
      End
    Else
      Begin
        While (current^.upper<>nil) and (current^.upper^.left=current) do
          current := current^.upper;
        If current^.upper<>nil then
          current := current^.upper
        Else current := nil;
      End;
End;


Function Dat_storec(var root : Dat_recptr; var Prev, CurrWd, Next : string) : Dat_recptr;

{ stores a btree record }

Var
  current,
  newrec : Dat_recptr;

Function Dat_incrrec : boolean;

{ if record already exists, just increment its count '.c' }

Begin
  current := root;
  Dat_incrrec := true;
  If Dat_findrec(current, prev, CurrWd, next) then
    inc(current^.counter)
  Else
    Dat_incrrec := false;
End;

Begin { procedure storec }

   { if the record already exists, just increment the count c }

  If not Dat_incrrec then

   { if there is enough room to store the record }

    If (maxavail>=(sizeof(Dat_btrec))) then
      Begin

   { allocate room for the record }

        Getmem(newrec,Sizeof(Dat_btrec));
        newrec^.counter := 1;
        newrec^.right := nil;
        newrec^.left := nil;
        Dat_storec := newrec;

   { store the record into the btree }

        newrec^.prevword := prev;
        Newrec^.WordST := CurrWd;
        newrec^.nextword := next;
        newrec^.upper := current;
        If current<>nil then
          If current^.WordST > CurrWd then
            current^.left := newrec
          Else
            current^.right := newrec
        Else
          root := newrec;
      End
    Else
      Dat_storec := nil
  Else
    Dat_storec := current;
End; { procedure storec }

End.
