Unit Btreeidx;

{ btree1 -- a general unit for manipulating alphabetized strings
  on the heap }

{ Copyright 1989, by J. W. Rider  }

{ Modified for readability by Philip Howlett 1993 }

Interface

Type
  idx_recptr = ^idx_btrec;
  idx_btrec = record
      upper,
      right,
      left      : idx_recptr;
      counter   : integer;
      data      : string[15];
    end;

Procedure idx_firstrec(var current : idx_recptr);
Procedure idx_lastrec(var current : idx_recptr);
Procedure idx_delrec(var root,current: idx_recptr);
Function idx_findrec(var current: idx_recptr; s: string) : Boolean;
Procedure idx_nextrec(var current: idx_recptr);
Procedure idx_prevrec(var current: idx_recptr);
Function idx_storec(var root: idx_recptr; var s: string) : idx_recptr;

Implementation

Procedure idx_firstrec(var current : idx_recptr);

{ returns the address of the first record in the btree branch
  from "current". if no btree has been entered, returns nil. }

Begin
  If current<>nil then
    While current^.left<>nil do
      current:=current^.left;
End;


Procedure idx_lastrec(var current : idx_recptr);

{ returns the address of the last record in the btree branch
  from "current". if no btree has been entered, returns nil. }

Begin
  If current<>nil then
    While current^.right<>nil do
      current:=current^.right;
End;


Procedure idx_delrec(var root, current : idx_recptr);

Var
  tr : idx_recptr;

{ delete the current record }

Begin
  tr:=current;
  If tr<>nil then
    Begin

   { replace the current node with the right hand branches }

      If tr^.right<>nil then
        Begin
          current := tr^.right;
          idx_firstrec(current);
          current^.left := tr^.left;
          tr^.right^.upper := tr^.upper;
          If tr^.left<>nil then
            tr^.left^.upper:=current;
          If tr^.upper<>nil then
            If tr^.upper^.left=tr then
              tr^.upper^.left := tr^.right
            Else
              tr^.upper^.right := tr^.right
          Else
            root:=tr^.right;
        End

   { replace the current node with the left hand branches }

      Else
        If tr^.left<>nil then
          Begin
            tr^.left^.upper  :=  tr^.upper;
            If tr^.upper<>nil then
              If tr^.upper^.right=tr then
                tr^.upper^.right := tr^.left
              Else
                tr^.upper^.left := tr^.left
            Else
              root := tr^.left;
          End

   { current node is a leaf }

        Else
          If tr^.upper<>nil then
            If tr^.upper^.right=tr then
              tr^.upper^.right := nil
            Else
              tr^.upper^.left := nil

   { current node is only node in tree }

          Else
            root:=nil;

   { always return the "parent" as current }

      current := tr^.upper;

   { free up the memory }

      freemem(tr,sizeof(idx_btrec));
    End;
End;


Function idx_findrec(var current : idx_recptr; s : string) : boolean;

{ find the record that matches the string }

Begin
  idx_findrec := false;
  While current<>nil do
    If current^.data=s then
      Begin
        idx_findrec := true;
        exit;
      End
    Else
      If current^.data>s then
        If current^.left<>nil then
          current := current^.left
        Else
          exit
      Else
        If current^.right<>nil then
          current := current^.right
        Else
          exit;
End;


Procedure idx_nextrec(var current : idx_recptr);

{ makes current the record following current record }

Begin
  If current<>nil then
    If current^.right<>nil then
      Begin
        current := current^.right;
        While current^.left<>nil do
          current := current^.left;
      End
    Else
      Begin
        While (current^.upper<>nil) and (current^.upper^.right=current) do
          current := current^.upper;
        If current^.upper<>nil then
          current := current^.upper
        Else
          current := nil;
      End;
End;


Procedure idx_prevrec(var current : idx_recptr);

{ makes current the record preceding current record }

Begin
  If current<>nil then
    If current^.left<>nil then
      Begin
        current := current^.left;
        While current^.right<>nil do
          current := current^.right;
      End
    Else
      Begin
        While (current^.upper<>nil) and (current^.upper^.left=current) do
          current := current^.upper;
        If current^.upper<>nil then
          current := current^.upper
        Else current := nil;
      End;
End;


Function idx_storec(var root : idx_recptr; var s : string) : idx_recptr;

{ stores a btree record }

Var
  current,
  newrec : idx_recptr;

Function idx_incrrec : boolean;

{ if record already exists, just increment its count '.c' }

Begin
  current := root;
  idx_incrrec := true;
  If idx_findrec(current,s) then
    inc(current^.counter)
  Else
    idx_incrrec := false;
End;

Begin { procedure storec }

   { if the record already exists, just increment the count c }

  If not idx_incrrec then

   { if there is enough room to store the record }

    If (maxavail>=(sizeof(idx_btrec))) then
      Begin

   { allocate room for the record }

        Getmem(newrec,sizeof(idx_btrec));
        newrec^.counter := 1;
        newrec^.right := nil;
        newrec^.left := nil;
        idx_storec := newrec;

   { store the record into the btree }

        newrec^.data := s;
        newrec^.upper := current;
        If current<>nil then
          If current^.data>s then
            current^.left := newrec
          Else
            current^.right := newrec
        Else
          root := newrec;
      End
    Else
      idx_storec := nil
  Else
    idx_storec := current;
End; { procedure storec }

End.
