Program Nicole;

{
  NICOLE.EXE

  Version     Feature

  1.0         Basic NICOLE.EXE - For every word there was a file so if the
              database had 400 words you ended up with over 400 files.

  1.2         Added Help and Commands 'COUNT'

  2.0         Made the data structure into binary trees and moved the
              Datafile into one file. Now there are only 3 files.

              NICOLE.IDX - Indexfile.
              NICOLE.TOP - Starting word file.
              NICOLE.DAT - Dictionary file.

  2.1         Some minor Adjustments and Optimization.

  3.0         Nicole now links the previous sentence to the last sentence.
              A MAJOR BREAKTHROUGH (If only I can get it working.

  3.1         Fixes a few minor Bugs.
}

{$I-}

Uses CRT, Btreeidx, Btreetop, Btreedat;


Const
  MaxWords        = 30;
  Version         = '3.1';
  Legalcharacters = ['A'..'Z', 'a'..'z',' ','.','/'];
  Nicolepath      = 'c:\nicole3\';
  IndexFilename   = 'c:\nicole3\nicole.idx';
  Topfilename     = 'c:\nicole3\nicole.top';
  Datafilename    = 'c:\nicole3\nicole.dat';

Type

  Indexrec = record
      Occurance : Integer;
      Wordst : String[15];
    End;

  Toprec   = record
      Firstword,
      Nextword  : String[15];
      Occurance : Integer;
    End;

  Wordrec  = record
      PrevWord,
      WordSt,
      Nextword  : String[15];
      Occurance : Integer;
    End;

Var
  Index,
  idx_Current : idx_Recptr;
  Top,
  top_Current : top_recptr;
  Data,
  Dat_Current : Dat_Recptr;

  Sentence : String;
  Wordlist : array [1..Maxwords] of string[15];

  Indexfile : File of Indexrec;
  Topfile : File of Toprec;
  Datafile : File of Wordrec;

  QuitSelected : Boolean;
  Command : Boolean;
  StartWord : String[15];

  Link : record
      HFirst :  String[15];
      HLast : String[15];
      NLast : String[15];
    End;

Function FileExists(FileName : String) : Boolean;

Var
  F : File;

Begin
  Assign(f, FileName);
  Reset(f);
  Close(f);
  FileExists := (IOResult = 0) and (FileName <> '');
End;

Procedure InsertintoIndex(St : String);

Begin
  idx_storec(Index,St);
End;

Procedure InsertFirstWord(Start, Next : String);

Begin
  If Next = '' then
    Next := '.';
  top_storec(Top, Start, Next);
End;

Procedure InsertintoData(Prev, Curr, Next : String);

Begin
  If Next = '' then
    Next := '.';
  dat_storec(Data, Prev, Curr, Next);
End;

Procedure InputSentence;

Var
  I : Byte;

Begin
  Textcolor(LightMagenta);
  Write('Human');
  Textcolor(Green);
  Write('>');
  Textcolor(White);
  Readln(Sentence);
  If Sentence[Length(Sentence)] <> '.' then
    Sentence := Sentence + '.';
  For I := 1 to Length(Sentence) do
    Sentence[I] := Upcase(Sentence[I]);
  Command := False;
  If (Sentence[1] = '/') or (Sentence = '') then
    Command := True;
End;

Procedure ChooseSentence(Prev, Wordst : String);

Var
  Total,
  Choice : Integer;
  A, B, C : String;
  TmpIdx,
  TmpIdx_Current : Idx_Recptr;

Begin
  Dat_current := Data;
  Dat_firstrec(dat_current);
  Total := 0;
  TmpIdx := Nil;
  TmpIdx_Current := Nil;

  While dat_current <> Nil do
    Begin
      If (Dat_current^.WordST = WordST) and (Dat_current^.Prevword = Prev) then
        Begin
          Idx_Storec(TmpIdx, Dat_Current^.NextWord);
          Inc(Total);
        End;
      Dat_nextrec(Dat_current);
    End;

  Choice := Random(Total) + 1;
  TmpIdx_Current := TmpIdx;
  Idx_FirstRec(TmpIdx_Current);
  While Choice > 1 do
    Begin
      Idx_NextRec(TmpIdx_Current);
      Dec(Choice);
    End;
  If TmpIdx_current^.Data <> '.' then
    Begin
      Write(' ',TmpIdx_current^.Data);
      Link.NLast := TmpIdx_current^.Data;
      ChooseSentence(WordSt, TmpIdx_Current^.Data);
    End;
End;

Procedure ChooseStart(Wordst : String);

Var
  Total,
  Choice : Integer;
  TmpIdx,
  TmpIdx_Current : Idx_Recptr;

Begin
  Dat_current := Data;
  Dat_firstrec(dat_current);
  Total := 0;
  TmpIdx := Nil;
  TmpIdx_Current := Nil;

  {Search Database for link between Sentences}

  While dat_current <> Nil do
    Begin
      If (Dat_current^.PrevWord = WordST) and (Dat_current^.WordST <> '.') then
        Begin
          Idx_Storec(TmpIdx, Dat_Current^.WordSt);
          Inc(Total);
        End;
      Dat_nextrec(Dat_current);
    End;

  If Total <> 0 then
    Begin
      Choice := Random(Total) + 1;
      TmpIdx_Current := TmpIdx;
      Idx_Firstrec(TmpIdx_Current);
      While Choice > 1 do
        Begin
          Idx_NextRec(TmpIdx_Current);
          Dec(Choice);
        End;
      Startword := tmpIdx_Current^.Data;
      Write(TmpIdx_current^.Data);
      ChooseSentence(Link.HLast,TmpIdx_Current^.data);
    End
  Else
    Begin
      Top_Current := Top;
      Top_FirstRec(Top_Current);
      Total := 0;
      While Top_Current <> Nil do
        Begin
          Inc(Total);
          Top_Nextrec(Top_Current);
        End;
      Choice := Random(Total) + 1;
      Top_Current := Top;
      Top_FirstRec(Top_Current);
      While Total > Choice do
        Begin
          Dec(Total);
          Top_Nextrec(Top_Current);
        End;
      Startword := Top_Current^.Startword;
      Textcolor(LightGreen);
      Write('Change Subject: ');
      Textcolor(Yellow);
      write(Top_Current^.Startword,' ',Top_Current^.Nextword);
      ChooseSentence(Top_Current^.Startword,Top_Current^.Nextword);
    End;
End;


Procedure Reply;

Begin
  Writeln;
  Textcolor(LightRed);
  Write('Nicole');
  Textcolor(LightGray);
  Write('>');
  Textcolor(Yellow);
  ChooseStart(Link.HLast);
  Writeln;
  Writeln;
End;

Procedure Splitintowords(ST : String);

Var
  J : Integer;

Begin
  If Not QuitSelected then
    Begin
      J := 0;
      While (ST[1] <> ' ') and ( j < Maxwords) and (Length(ST) > 0)do
        Begin
          J := J + 1;
          While (ST[1] = ' ') and (Length(ST) > 0) do
            Delete(ST,1,1);
          While(ST[1] <> ' ') and (Length(ST) > 0) do
            Begin
              Wordlist[J] := Wordlist[J] + ST[1];
              Delete(ST,1,1);
            End;
          While (ST[1] = ' ') and (Length(ST) > 0) do
            Delete(ST,1,1);
        End;

      J := 1;
      Link.Hfirst := Wordlist[1];
      While Wordlist[J] <> '' do
        Begin
          InsertintoIndex(Wordlist[J]);
          Link.Hlast := wordlist[J];
          Inc(J);
        End;

      Wordlist[J] := Wordlist[J] + '.';

      InsertFirstword(Wordlist[1],Wordlist[2]);

      J := 1;
      While Wordlist[J] <> '' do
        Begin
          If J = 1 then
            InsertintoData(Link.NLast,Wordlist[J],Wordlist[J+1])
          Else
            InsertintoData(Wordlist[J-1],Wordlist[J],Wordlist[J+1]);
          Inc(J);
        End;

      For J := 1 to Maxwords do
      Wordlist[J] := '';
    End;
End;

Procedure CountWords;

Var
  Count : Integer;

Begin
  Idx_Current := Index;
  Idx_Firstrec(Idx_Current);
  Count := 0;
  While Idx_Current <> Nil do
    Begin
      Idx_NextRec(Idx_Current);
      Inc(Count);
    End;
  Textcolor(Yellow);
  Writeln;
  Writeln('I now know ',Count,' words.');
  Writeln;
End;

Procedure ShowHelp;

Begin
  Textcolor(Yellow);
  Writeln;
  Writeln(' /HELP  - Displays this help screen.');
  Writeln(' /SAVE  - Saves all data.');
  Writeln(' /MEM   - Shows Avaliable Memory.');
  Writeln(' /COUNT - Count Words in Dictionary.');
  Writeln(' /QUIT  - Quits Program and saves Database.');
  Writeln;
End;

Procedure ShowMem;

Begin
  Textcolor(Yellow);
  Writeln;
  Writeln(Memavail,' bytes free.');
  Writeln;
End;

Procedure LoadData;

Var
  IdxLoad : Indexrec;
  Loop    : Integer;
  Idx_Tmp : Indexrec;
  Top_Tmp : Toprec;
  TopLoad : TopRec;
  Dat_tmp : Wordrec;
  DatLoad : WordRec;

Begin
  If Fileexists(Indexfilename) then
    Begin
      Assign(Indexfile, Indexfilename);
      {$I-}
      ReSet(Indexfile);
      idx_Current := Index;
      While Not EOF(Indexfile) do
        Begin
          Read(Indexfile, IdxLoad);
          For Loop := 1 to IdxLoad.Occurance do
            Idx_Storec(Index, IdxLoad.WordSt);
        End;
      Close(Indexfile);
      {$I+}
      If IOResult <> 0 then
        Begin
          Textcolor(Red + Blink);
          Writeln('---=== A Fatal Error has occured with the Indexfile. ===---');
          Textcolor(White);
          Halt;
        End;
      Assign(Topfile,Topfilename);
      {$I-}
      ReSet(Topfile);
      top_Current := Top;
      top_firstrec(top_current);
      While Not EOF(Topfile) do
        Begin
          Read(Topfile,TopLoad);
          For Loop := 1 to TopLoad.Occurance Do
            Top_Storec(Top, TopLoad.FirstWord, TopLoad.NextWord);
        End;
      Close(Topfile);
      {$I-}
      If IOResult <> 0 then
        Begin
          Textcolor(Red + Blink);
          Writeln('---=== A Fatal Error has occured with the Topfile. ===---');
          Textcolor(White);
          Halt;
        End;
      Assign(Datafile, Datafilename);
      {$I-}
      ReSet(Datafile);
      Dat_Current := Data;
      Dat_firstrec(Dat_current);
      While Not EOF(Datafile) do
        Begin
          Read(Datafile, DatLoad);
          For Loop := 1 to DatLoad.Occurance do
            Dat_Storec(Data, DatLoad.Prevword, DatLoad.WordST, DatLoad.Nextword);
        End;
      Close(Datafile);
      {$I+}
      If IOResult <> 0 then
        Begin
          Textcolor(Red + Blink);
          Writeln('---=== A Fatal Error has occured with the Datafile. ===---');
          Textcolor(White);
          Halt;
        End;
    End
  Else
    Begin
      Textcolor(LightGreen);
      Writeln('---=== WARNING ===--- Starting new Dictionary');
    End;
End;


Procedure SaveData;

Var
  Idx_Tmp : Indexrec;
  Top_Tmp : Toprec;
  Dat_tmp : Wordrec;

Begin
  Assign(Indexfile, Indexfilename);
  {$I-}
  Rewrite(Indexfile);
  idx_Current := Index;
  idx_firstrec(idx_current);
  While idx_current<>nil do
    Begin
      With idx_Tmp do
        Begin
          Occurance := idx_current^.counter;
          WordST := idx_current^.Data;
        End;
      Write(Indexfile,idx_Tmp);
      idx_nextrec(idx_current);
    End;
  Close(Indexfile);
  {$I+}
  If IOResult <> 0 then
    Begin
      Textcolor(Red + Blink);
      Writeln('---=== A Fatal Error has occured with the Indexfile. ===---');
      Textcolor(White);
      Halt;
    End;
  Assign(Topfile,Topfilename);
  {$I-}
  Rewrite(Topfile);
  top_Current := Top;
  top_firstrec(top_current);
  While top_current<>nil do
    Begin
      With top_Tmp do
        Begin
          Firstword := top_current^.startword;
          Nextword := Top_current^.nextword;
          Occurance := Top_current^.Counter;
        End;
      write(Topfile,Top_tmp);
      top_nextrec(top_current);
    End;
  Close(Topfile);
  {$I-}
  If IOResult <> 0 then
    Begin
      Textcolor(Red + Blink);
      Writeln('---=== A Fatal Error has occured with the Topfile. ===---');
      Textcolor(White);
      Halt;
    End;
  Assign(Datafile, Datafilename);
  {$I-}
  Rewrite(Datafile);
  Dat_Current := Data;
  Dat_firstrec(Dat_current);
  While Dat_current<>nil do
    Begin
      With Dat_Tmp do
        Begin
          PrevWord := Dat_current^.Prevword;
          WordST := Dat_current^.WordSt;
          NextWord := Dat_current^.Nextword;
          Occurance := Dat_Current^.counter;
        End;
      write(Datafile,Dat_tmp);
      dat_nextrec(dat_current);
    End;
  Close(Datafile);
  {$I+}
  If IOResult <> 0 then
    Begin
      Textcolor(Red + Blink);
      Writeln('---=== A Fatal Error has occured with the Datafile. ===---');
      Textcolor(White);
      Halt;
    End;
End;

Procedure Initialise;

Var
  I : Integer;

Begin
  Randomize;
  Index := Nil;
  Top := Nil;
  Data := Nil;

  idx_Current := nil;
  top_Current := nil;
  Dat_Current := nil;

  Link.Hfirst := '';
  Link.Hlast := '';
  Link.Nlast := '';

  For I := 1 to Maxwords do
    Wordlist[I] := '';
  Sentence := '';
  QuitSelected := False;
  Command := False;
  ClrScr;
  Textcolor(LightBlue);
  Writeln('    ---=== Nearly Intelligent Computer Operated Language Examiner ===---');
  Textcolor(White);
  Writeln('                Version ',Version,' By Philip Howlett. (C) April 1993');
  Writeln('+----------------------------------------------------------------------------+');
  Textcolor(LightRed);
  Writeln('Conditions:');
  Textcolor(Yellow);
  Writeln('1. Sentences must not be more than ',Maxwords ,' words long.');
  Writeln('2. Type /HELP for Help.');
  Writeln;
  Textcolor(Cyan);
  Window(1,8,79,24);
  ClrScr;
  Writeln('Please wait......');
  LoadData;
  Writeln;
  Textcolor(LightRed);
  Write('Nicole');
  Textcolor(LightGray);
  Write('>');
  Textcolor(Yellow);
  Writeln('HELLO.');
  Writeln;
  Link.NLast := 'HELLO.';
End;

Procedure Finish;

Begin
  Window(1,1,80,25);
  ClrScr;
End;

Begin
  Initialise;
  Repeat
    InputSentence;
    If Command then
      Begin
        If Sentence = '/QUIT.' then
          Begin
            QuitSelected := True;
            SaveData;
          End
        Else
        If Sentence = '/HELP.' then
	  ShowHelp
        Else
        If Sentence = '/COUNT.' then
          CountWords
        Else
        If Sentence = '/MEM.' then
          ShowMem
        Else
        If Sentence = '/SAVE.' then
          Savedata;
      End
    Else
      Begin
        If Sentence <> '' then
          Splitintowords(Sentence);
          Reply;
      End;
  Until QuitSelected;
  Finish;
End.
