#/bin/bash
#
# Automate the creation of the NICOLE database
#
# Written by Phil Howlett
#

clear
echo NICOLE Database Installation script.
echo

#
# First check to see if we are running as root, if not then abort.
#
echo 'Checking to see if you are logged in as root.'
if [ $UID -eq 0 ]; then
	echo '- Good, you are root.';
else
	echo
	echo '***'
	echo '*** Script Aborted.'
	echo '***'
	echo
	echo 'ROOT access is required to run this Database Setup script.'
	echo
	exit 1;
fi

#
# Lets now see if we can find the mysql client
#
echo 'Checking for a MySQL client.'

if [ -e `which mysql` ]; then
	echo '- Good, found the MySQL client.'
else
	echo
	echo '***'
	echo '*** Script Aborted.'
	echo '***'
	echo
	echo 'Unable to find the MySQL client anywhere on the path.'
	echo
	exit 1;
fi

#
# Now Create the NICOLE database and create 2 users, nicoleadm and nicoleusr
#
echo 'Creating the NICOLE database.'
mysql -p < users.sql || { echo
                       echo '***'
                       echo '*** Script Aborted.'
                       echo '***'
                       echo
                       echo 'Failed to create a Database and create new MySQL users.'
                       echo
                       exit 1; }
echo '- Done.'

#
# Now create the database tables
#
echo 'Creating NICOLE tables and indexes.'
mysql -p < tables.sql || { echo
                       echo '***'
                       echo '*** Script Aborted.'
                       echo '***'
                       echo
                       echo 'Failed to create NICOLE tables.'
                       echo
                       exit 1; }
echo '- Done.'
echo
echo 'The pre-install of NICOLE is now complete.'
