// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// database object
//

#ifndef _DATABASE_H_
#define _DATABASE_H_

#include <string>

#include <mysql/mysql.h>

#include "dbresult.h"

#define DB_CONNECTION_NONE  0
#define DB_CONNECTION_OK    1
#define DB_CONNECTION_BAD   2

#define DB_COMMAND_OK   0				// OK - command executed
#define DB_EMPTY_QUERY  1				// Query didn't return tuples
#define DB_TUPLES_OK    2				// Query returned tuples
#define DB_ERROR        5				// A database error
#define DB_BAD_RESPONSE 6				// Bad response from Database
#define DB_UNEXPECTED   7				// This shouldn't ever happen

/**
 * A MySQL C++ wrapper object, based on the mysql C++ wrapper library written
 * \author Roland Haenel <rh@ginster.net>
 * \author Modified somewhat for use in NICOLE by Phil Howlett <pghowlett@ozemail.com.au>
 * \bug There are no known bugs with this code.. so far
 * \warning I didn't write this class, I only modified it for its use in NICOLE.
 *          I haven't come across any issues with it at this stage and I haven't
 *          encountered any problems. However this doesn't mean that there isn't
 *          any (see Bugs and Limitations above).
 */

class Database
{
private:
	MYSQL mysql;
	/**
	 * TRUE if a we are connected to a database, FALSE if not
	 */
	int connected;
	/**
	 * a string containing the error message/status
	 */
	string error;
	
	/**
	 * a string containing the username connecting to the database
	 */
	string username;
	/**
	 * a string containing the password to connect to the database
	 */
	string password;

public:
	  Database (  );
	int init (  );
	string error_message (  );
	void SetUser(const string *user, const string *pwd);
	int connect ( string host, string db );
	int status (  );							// Return status information

	void disconnect (  );					// Disconnect from database
	int reset (  );								// Reset connection

	DBResult *exec ( char *sqlFormat, ... );	// Execute arbitrary SQL cmd
	// Same as above, reuse res
	void exec ( DBResult * res, char *sqlFormat, ... );

	 ~Database (  );

};

#endif
