// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// dbresult.cpp
//

#include <string>
#include <iostream>
using namespace std;

#include <mysql/mysql.h>

#include "database.h"
#include "dbresult.h"

DBResult::DBResult (  )
{
	result = NULL;
	haveError = false;
}

DBResult::DBResult ( MYSQL * mysql, char *query )
{
	result = NULL;
	haveError = false;
	init ( mysql, query );
}

DBResult::~DBResult (  )
{
	if ( result != NULL )					// Free memory resources
		mysql_free_result ( result );
}

void DBResult::init ( MYSQL * mysql, char *query )
{
	if ( result != NULL )
	{
		// clear the result pointer
		mysql_free_result ( result );
		result = NULL;
	}
	if ( mysql_query ( mysql, query ) == 0 )	// if query successful
	{
		result = mysql_store_result ( mysql );
		if ( result != NULL )				// if the result not is empty
		{
			if ( mysql_num_fields ( result ) == 0 )	// if we return 0 fields
			{
				//cerr << "DBRESULT: zero fields" << endl;
				haveError = true;				// return an error
			}
			else
			{
				//cerr << "DBRESULT: no errors found" << endl;
				haveError = false;
			}
		}
		//
		// Its not true that query failed if there is noresult for it (remove this line),
		// however it isn't really needed to fixup because NICOLE doesn't use it. It should however
		// be looked into at some stage.
			haveError = false;				

	}
	else
	{
		//cerr << "DBRESULT: Query failed" << endl;
		haveError = true;						// The query failed
	}
}

int DBResult::status (  )
{
	if ( haveError )
	{
		//cerr << "DBRESULT: db-error" << endl;
		return DB_ERROR;
	}
	if ( result == NULL )
	{
		//cerr << "DBRESULT: NULL Result" << endl;
		return DB_EMPTY_QUERY;
	}
	//cerr << "DBRESULT: Tuples OK" << endl;
	return DB_TUPLES_OK;
}

int DBResult::nrTuples (  )
{
	if ( result == NULL )
		return 0;
	return mysql_num_rows ( result );
}

int DBResult::nrFields (  )
{
	if ( result == NULL )
		return 0;
	return mysql_num_fields ( result );
}

char *DBResult::fieldName ( int n )
{
	MYSQL_FIELD *field;

	if ( result == NULL )
		return NULL;
	mysql_field_seek ( result, n );
	field = mysql_fetch_field ( result );
	if ( field == NULL )
		return NULL;
	return field->name;
}

int DBResult::fieldSize ( int n )
{
	MYSQL_FIELD *field;

	if ( result == NULL )
		return 0;
	mysql_field_seek ( result, n );
	field = mysql_fetch_field ( result );
	if ( field == NULL )
		return 0;
	return field->length;
}

int DBResult::fieldSize ( char *name )
{
	int i;

	if ( result == NULL )
		return 0;
	for ( i = 0; i < nrFields (  ); i++ )
		if ( !strcmp ( name, fieldName ( i ) ) )
			return fieldSize ( i );
	return 0;
}

void DBResult::seekTuple ( int tuple )
{
	if ( result == NULL )
		return;
	mysql_data_seek ( result, tuple );
}

char **DBResult::getTuple (  )
{
	MYSQL_ROW row;

	if ( result == NULL )
		return NULL;
	row = mysql_fetch_row ( result );
	return row;
}

char **DBResult::getTuple ( int tuple )
{
	seekTuple ( tuple );
	return getTuple (  );
}
