// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// dbresult.h
//

#ifndef _DBRESULT_H_
#define _DBRESULT_H_

class DBResult
{
private:
	bool haveError;
	MYSQL_RES *result;
public:
	  DBResult (  );
	  DBResult ( MYSQL * mysql, char *query );
	 ~DBResult (  );

	void init ( MYSQL * mysql, char *query );

	int status (  );							// Return query status

	int nrTuples (  );						// Number of fetched tuples
	int nrFields (  );						// Number of fields per tuple

	char *fieldName ( int n );		// Name of nth fiel
	int fieldSize ( int n );			// Size of nth field
	int fieldSize ( char *name );	// Size of nth field

	void seekTuple ( int tuple );	// Sets internal cursor to tuple
	char **getTuple (  );					// Return the next tuple or NULL
	char **getTuple ( int tuple );	// Return tuple
};

#endif
