// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// dictionary.cpp
//

#include <string>
#include <iostream>
using namespace std;

#include "nicole.h"
#include "dictionary.h"

Dictionary::Dictionary (  )
{
	//
	// establish a connection to the database
	//
	if ( db.init (  ) != DB_COMMAND_OK )
	{
		cerr << "Unable to initialize database: " << db.error_message (  ) <<
			endl;
		exit ( 1 );
	}

	// Connect to database on localhost
	if ( db.connect ( DB_HOST, DB_NAME ) != DB_CONNECTION_OK )
	{
		cerr << "Unable connect to database 'NICOLE': "
			<< db.error_message (  ) << endl;
		exit ( 1 );
	}

}

bool Dictionary::add ( string s )
{

	if ( !exists ( s ) )
	{
		// DEBUG: cout << "Adding word ->" << s.c_str() << "<-" << endl;
		// Insert a single row into the dictionary table
		db.exec ( &dbres, "INSERT INTO dictionary VALUES (\"%s\", 1)",
							s.c_str (  ) );
		//cerr << "DBRES STATUS: " << dbres.status() << endl;

		if ( dbres.status (  ) != DB_EMPTY_QUERY )
		{
			//
			// We shouldn't get this far, as we have already checked if the record existed.
			//
			cerr << "Can't insert into table 'dictionary' : " <<
				db.error_message (  ) << endl;
			exit ( 1 );
		}

	}
	else
	{
		update ( s );
	}

	return 1;
}

bool Dictionary::exists ( string s )
{
	char **field;

	db.exec ( &dbres, "SELECT word FROM dictionary WHERE word = \"%s\"",
						s.c_str (  ) );
	field = dbres.getTuple (  );
	if ( field == NULL )
	{
		return false;
	}
	else
	{
		return true;
	}
}

// update the word entry in the databse

bool Dictionary::update ( string s )
{

	db.exec ( &dbres,
						"UPDATE dictionary SET freq=freq+1 WHERE word = \"%s\"",
						s.c_str (  ) );
	if ( dbres.status (  ) != DB_EMPTY_QUERY )
	{
		//
		// This is bad if we get here
		//
		cerr << "Failed to update the dictionary. " << db.error_message (  ) <<
			endl;
		exit ( 1 );
	}
	return true;
}

// Returns the frequency of a particular word

long Dictionary::freq( string s)
{
	char **field;
	long total = 0;

	if (exists(s))	
	{
	
		// Read sorted data and print it out
		db.exec ( &dbres, "SELECT word, freq FROM dictionary WHERE word=\"%s\"", s.c_str() );
		field = dbres.getTuple (  );

		if ( field != NULL )
		{
			total = atoi ( field[1] );	// the 'freqency' is the 2nd field
		}

		return total;
	}
	else
	{
		return 0;
	}
	
	
}

long Dictionary::count (  )
{

	char **field;
	long total = 0;

	// Read sorted data and print it out
	db.exec ( &dbres, "SELECT count(word) FROM dictionary" );
	field = dbres.getTuple (  );

	if ( field != NULL )
	{
		total = atoi ( field[0] );	// the 'count' is the first field
	}

	return total;

}

bool Dictionary::erase (  )
{

	db.exec ( &dbres, "DELETE FROM dictionary" );
	if ( dbres.status (  ) != DB_EMPTY_QUERY )
	{
		//
		// We shouldn't get this far, as we have already checked if the record existed.
		//
		cerr << "Can't delete records from the table 'dictionary' : "
			<< db.error_message (  ) << endl;
		exit ( 1 );
	}
	return 1;
}

Dictionary::~Dictionary (  )
{
}
