// Copyright (C) 2000 Gershon Bialer <gersh@bialer.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// export.cpp
//

#include<iostream>
#include<fstream>
#include<string>
using namespace std;

#include <mysql/mysql.h>

#include "database.h"
#include "dbresult.h"
#include "nicole.h"

int main(int argc, char *argv[])
{
  ofstream fout;
  Database db;
  DBResult dbres;
  char **table;
  long rows;
  long counter = 0;

  cout << "**********************" << endl
       << "Nicole Export Utility" << endl
       << "**********************" << endl;
  if(argc!=2)
    {
      cout << "Export will write the contents of nicole's vocabulary" << endl
           << "database to a file" << endl
           << "Usage: exportdb [exportfile]" << endl << endl;
      exit(0);
    }

  // Open output filestream
  fout.open(argv[1],ios::out);
  if(!fout) // Can't open file print error message and exit
      {
        cerr << "ERROR:" << endl
             << "Unable to open output file for writing" << endl;
        exit(0);
      }
  if(db.init()!=DB_COMMAND_OK)
    {
      cerr << "Unable to initialize database" << endl;
      exit(1);
    }

  if(db.connect(DB_HOST,DB_NAME)!=DB_CONNECTION_OK)
    {
      cerr << "Unable to connect to database" << endl;
      exit(1);
    }

  // Get entire vocabulary table
  db.exec(&dbres,"SELECT w1,w2,w3,w4,w5,freq FROM vocabulary");

  if(dbres.status(  ) == DB_EMPTY_QUERY) // Nothing found
    {
      cout << "Cannot find anything in database" << endl;
      exit(0);
    }

  rows=dbres.nrTuples(); // Find out how many rows in table
  for(int i=0;i<rows;i++)
   {
     // Output each record:

     table = dbres.getTuple(); //Get the row
     fout << table[0] << " " << table[1] << " " << table[2] << " "
          << table[3] << " " << table[4] << " " << table[5]
          << endl;
     counter++;
		 cout << "#";
		 cout.flush();
   }

   cout << endl;
   cout << "Exported " << counter << " phrases." << endl;
     fout.close();

   return(0);
}

/**
 *\page exportdb ExportDB Utility
 *
 * The exportdb utility will write the contents of NICOLE's vocabulary to a
 * simple text file. This utility is used for creating a backup or snapshot
 * of NICOLE's database.
 *
 * The exportdb utility were originally written by Gershon Bialer
 * <gersh@bialer.com> for the NICOLE project.
 *
 * Usage: exportdb [exportfilename]
 *
 * See also:
 * \ref importdb
 */