// Copyright (C) 2000 Gershon Bialer <gersh@bialer.com>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// importdb.cpp
//

#include<iostream>
#include<fstream>
#include<string>
#include<vector>

using namespace std;

#include "dictionary.h"
#include "vocabulary.h"

int main(int argc, char *argv[])
{
  ifstream fin;
  string w1, w2, w3, w4, w5;
  int freq, i;
  long counter = 0;

  cout << "*******************************" << endl
       << "Nicole Database Import Utility" << endl
       << "*******************************" << endl;

  if(argc!=2)
    {
      cout << "importdb will input a file containing" << endl
           << "the contents of another database into its own" << endl
           << "Usage: importdb [importfile]" << endl << endl;
      exit(0);
    }

  // Open input stream
  fin.open(argv[1],ios::in);
  if(!fin)
    {
      cerr << "ERROR:" << endl
           << "Unable to open output file for writing" << endl;
      exit(0);
    }

  Vocabulary vocabulary;
	Dictionary dictionary;
	
  // Repeat inputing all lines
  while(fin >> w1 >> w2 >> w3 >> w4 >> w5 >> freq)
    {
      for(i=0;i<freq;i++) // Add phrase correct number of times for
        {
        	// We need to add the last word in the 'phrase' to the dictionary,
        	// otherwise we end up with a vocabulary entry without an entry in
        	// the dictionary table.
        	dictionary.add(w5);
        	
          // add entry to vocabulary table
          vocabulary.add_phrase(w1,w2,w3,w4,w5);
        }
        counter++;
        cout << "#";
        cout.flush();
    }
	cout << endl;
	cout << "Imported " << counter << " phrases." << endl;
	
  fin.close();

  return(0);
}

/**
 *\page importdb ImportDB Utility
 *
 * The importdb utility will read the contents of an export file (generated
 * by the \e exportdb utility) into NICOLE's vocabulary. It will not overwrite
 * any existing entries in the database, but merge the existing database with
 * the new import file.
 *
 * Tihs utility is mainly used for restoring backup file, or by merging an
 * export of one database with another databsae.
 *
 * The importdb utility were originally written by Gershon Bialer
 * <gersh@bialer.com> for the NICOLE project.
 *
 * Usage: importdb [exportfilename]
 *
 * See also:
 * \ref exportdb
 */