// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// learn.cpp
//

#include <iostream>
#include <fstream>
#include <string>
using namespace std;

#include "matrix.h"
#include "parser.h"


int main ( int argc, char *argv[] )
{

	Matrix *m;
	Parser *p;
	ifstream fin;
	string buff;
	long long tally;
	long newwords;

	// heading
	cout << endl
		<< "**********************" << endl
		<< "NICOLE: Learn Utility" << endl
		<< "**********************" << endl;

	if ( argc == 1 )
	{
		cout << endl
			<< "'learn' will load a file containing a list of sentences for NICOLE to " << endl
			<< "learn.  Each sentence must be on a new line, and only a singe sentence " << endl
			<< "per line is allowed."
			<< endl
			<< "Each sentence must be a response of the previous sentence. This ensures that" << endl
			<< "conversation threadss are added into the knowledge base properly." << endl << endl
			<< "To start a new conversation thread, a line should contain ---" << endl
			<< endl << "Usage:" << endl << "     learn filename" << endl << endl;
		exit ( 0 );
	}

	// create new variables
	m = new Matrix;
	p = new Parser;
	
	tally = 0;
	newwords = 0;

	// open the file input stream
	fin.open ( argv[1] );

	if ( !fin.is_open (  ) )
	{
		//
		// Abort the importing if we can't find the input file
		//
		cerr << "ERROR: Couldn't open file " << argv[1] << " for reading." << endl
			<< "- aborting learning mode." << endl << endl;
		exit ( 0 );
	}

	cout << "Learning. Please wait.";
	cout.flush();
	
	while ( !fin.eof (  ) )
	{
		getline(fin , buff);

		if ( buff != "" )						// skip blank entries
		{
			// Place the sentence onto the matrix.
			if( buff != "---")
			{
				m->add_sentence(p->clean_input(buff));	
				cout << ".";
				cout.flush();		
			}
			else
			{
				// new conversation thread
				m->reset(0);
			}
		}
		buff = "";									// clear the buffer
	}

	cout << endl;
	// close the file input stream
	fin.close (  );

	cout <<	"-Learning complete." << endl;

	delete m; // finished with the matrix object
	delete p; // finished with the parser object

	return 0;
}

/**
 *\page learn Learn Utility
 * This page will describe the learn utility
 *
 * There is nothing hear at this stage.. please be patient
 */