// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// log.cpp
//

#include <string>
#include <iostream>
#include <fstream>
using namespace std;

#include "log.h"

/**
 * Opens up a log file called \e fname for appending.
 *
 * \param fname the name of the file to log to.
 */
Log::Log ( string fname )
{

	logfile.open ( fname.begin (  ), ios::app );
}

/**
 * Records a string to the log file
 *
 * \param s the string to be appended to the log file
 */
void Log::record ( string s )
{
	logfile << s << endl;
}

/**
 * Closes down the log file
 */
Log::~Log (  )
{
	logfile.close (  );
}
