// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// matrix.cpp
//

#include <string>
#include <iostream>
#include <deque>
#include <vector>
#include <algorithm>
using namespace std;

#include "matrix.h"
#include "dictionary.h"
#include "vocabulary.h"

/**
 * Initialises the matrix object.
 */
Matrix::Matrix (  )
{
	int i;

	for ( i = 0; i < 5; i++ )
	{
		phrase.push_back ( "*" );
	}
}

/**
 * Adds a single word to the matrix
 * \param w a single word
 */

void Matrix::add_word ( string w )
{
	Dictionary *dict;
	Vocabulary *voc;

	dict = new Dictionary;
	voc = new Vocabulary;

	// first, add this word to the dictionary.  
	dict->add ( w );

	phrase.push_back ( w );
	phrase.pop_front (  );

	//dump_phrase();
	voc->add_phrase ( phrase[0], phrase[1], phrase[2], phrase[3], phrase[4] );

	delete voc;
	delete dict;

}

/**
 * Adds a complete sentence to the matrix.
 * \param s the sentence to be added.
 *
 * \bug there is a memory leak in this function somewhere which
 * \bug is overwriting the "filename" locaiton in the dictionary/collection
 * \bug object. I'm too tired to find it tonight..
 */

void Matrix::add_sentence ( string s )
{
	string word = "";
	unsigned int i;
	char c;

	// append the full stop '.' to the sentence only if there isn't
	// punctuation finishing the sentence
	
	if ( s.length (  ) > 0 )
	{
		c = s.at ( s.length (  ) - 1 );
		if ( ( c != '?' ) && ( c != '!' ) && (c != '.'))
		{
			s += " .";
		}
	}

	//cout << "ADDING: >" << s << "<" << endl;
	
	// seperate the sentence into words and pass onto add_word(w)

	for ( i = 0; i < s.length (  ); i++ )
	{
		if ( s.at ( i ) == ' ' )
		{
			if (word != "")
			{
				add_word ( word );				// add word to matrix
			}
			word = "";
		}
		else if (s.at(i) == '.')
		{
			add_word(".");
		}
		else
		{
			word += s.at ( i );
		}
	}

	if ( !word.empty (  ) )
	{															// add the last word to the matrix.
		add_word ( word );
	}

  //dump_phrase();
}

void Matrix::reply_sentence ( string s )
{
	string word = "";
	unsigned int i;

	// seperate the sentence into words and pass onto add_word(w)

	//cout << "REPLY:" << s << endl;
	
	for ( i = 0; i < s.length (  ); i++ )
	{
		if ( s.at ( i ) == ' ' )
		{
			if(word != "")
			{
				add_word ( word );				// add word to matrix
			}
			word = "";
		}
		else if (s.at(i) == ',')
		{
		  // allow a comma as a seperate word
			if(word != "")
			{
				add_word ( word );				// add word to matrix
			}
		  add_word(",");    // add the comma
		  word = "";        // reset the word variable
		}
		else if (s.at(i) == '.')
		{
			// add the word as a seperate word
			if(word != "")
			{
				add_word(word);
			}
			word = "";
			add_word(".");
		}
		else
		{
			// add the character to the word
			word += s.at ( i );
		}
	}

	if ( !word.empty (  ) )
	{															// add the last word to the matrix.
		phrase.push_back ( word );
		phrase.pop_front (  );
	}

//  dump_phrase();  
}

void show_word ( string s )
{
	cout << s << " | ";
}

void Matrix::dump_phrase (  )
{
	cout << "| ";
	for_each ( phrase.begin (  ), phrase.end (  ), show_word );
	cout << endl;
}

bool Matrix::get_phrase ( string * a, string * b, string * c, string * d,
													string * e )
{
	*a = phrase[0];
	*b = phrase[1];
	*c = phrase[2];
	*d = phrase[3];
	*e = phrase[4];
	return true;
}

/**
 * Reset's the matrix (as if we restarted the program
 */

void Matrix::reset ( int status )
{
	int i;

	for ( i = 0; i < 5; i++ )
	{
		phrase.push_back ( "*" );
		phrase.pop_front (  );
	}
	if(status == 1)
	{
		// output that we have reset the conversation thread	
		cout << "** Conversation Thread reset **" << endl;
	}
}

/**
 * Destructs the matrix object.
 */
Matrix::~Matrix (  )
{
}
