// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// matrix object
//

#ifndef _MATRIX_H_
#define _MATRIX_H_

#include <string>
#include <deque>
using namespace std;

/**
 * Builds up the matrix of both input and output so that it can be easily stored
 * in the Vocabulary object.
 *
 * \author Phil Howlett
 */

class Matrix
{
private:
	deque < string > phrase;

public:
	Matrix (  );
	void add_word ( string w );
	void add_sentence ( string s );
	void reply_sentence ( string s );
	void dump_phrase (  );
	bool get_phrase ( string * a, string * b, string * c, string * d,
										string * e );
	void reset ( int status );
	 ~Matrix (  );
};

#endif
