// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// nicole.cpp
//

#include <iostream>
#include <string>
#include <vector>
using namespace std;

#include <locale.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "nicole.h"
#include "vocabulary.h"
#include "parser.h"
#include "matrix.h"
#include "log.h"
#include "responder.h"

int main (  )
{

	string output = "";

	string a;
	string b;
	string c;
	string d;
	string e;

	Parser parser;
	Matrix matrix;
	Responder response;

	//
	// Added local info as recommended by Manuel Lpez Moreno
	//
  setlocale( LC_ALL, "es_ES.iso-8859-1" );
	
	Log history ( "/tmp/history.txt" );

	// Initialse the randum number seed thingy.
	srand ( ( unsigned int ) time ( 0 ) );

	//
	// Display the heading
	//
	heading (  );

	//
	// Calculate NICOLE Output based on matrix and vocabulary
	// *first time through*

	if ( ( rand (  ) % 100 + 1 ) <= 75 )
	{
		//
		// There is a 75% chance that NICOLE will start the conversation first
		//
		matrix.get_phrase ( &a, &b, &c, &d, &e );
		output = response.get ( a, b, c, d, e );

		if ( output != "" )
		{
			// If we don't get any answer, lets skip this for now
			matrix.reply_sentence ( output );

			//
			// Output NICOLE responce
			//
			cout << "NICOLE: >" << output << endl;
			history.record ( output );
		}
		else
		{
			matrix.reset ( 1 );
			history.record("---");
		}

	}

	while (!parser.cmd_quit (  ))
	{

		//
		// Get Human Input
		//
		//cout << "PARSER >" << parser.inputvalue() << "<" << endl;
		
		cout << "Human: >";

		parser.reset (  );
		parser.input (  );

		//
		// If a system command has been entered then process the command
		//

		if ( !parser.empty (  ) && !(cin.eof()))
		{
			if ( parser.is_command (  ) )
			{
				// process system commands here
				process_cmd ( &parser, &matrix );

			}
			else
			{
				// Add the input string to the history logs
				history.record ( parser.inputvalue (  ) );

				//
				// Else add the input to the matrix
				//
				matrix.add_sentence ( parser.inputvalue (  ) );

				//
				// Calculate NICOLE Output based on matrix and vocabulary
				//

				matrix.get_phrase ( &a, &b, &c, &d, &e );
				output = response.get ( a, b, c, d, e );
				matrix.reply_sentence ( output );

				if ( output == "" )
				{
					// We couldn't find an output, reset the matrix and let NICOLE
					// pick a new conversation thread
					cout << "NICOLE:> ** I'm speechless **" << endl;
					matrix.reset ( 1 );
					history.record("---");

					// There is a 75% chance that NICOLE will respond
					if ( ( rand (  ) % 100 + 1 ) <= 75 )
					{
						output = response.get ( "*", "*", "*", "*", "*" );
						matrix.reply_sentence ( output );
						if ( output != "" )
						{
							cout << "NICOLE: >" << output << endl;
							history.record ( output );
						}
					}
				}
				else
				{
					//
					// Output NICOLE responce
					//

					cout << "NICOLE: >" << output << endl;
					history.record ( output );

				}
				//
				// Rinse, repeat until quit selected
				//

			}													// if()

		}
	}															// while()
	history.record("---");

}

//
// Process the commands
//

void process_cmd ( Parser * p, Matrix * m )
{
#ifdef DEBUG
	cerr << "DEBUG: Command processing" << endl;
#endif

	if ( p->cmd_help (  ) )
	{
		p->show_help (  );
	}
	else if ( p->cmd_status (  ) )
	{
		p->show_status (  );
	}
	else if ( p->cmd_reset (  ) )
	{
		m->reset ( 1 );
	}
	else if ( p->cmd_erase (  ) )
	{
		p->erase_nicole (  );
		m->reset(0);
	}
	else if ( p->cmd_info())
	{
		p->show_info( p->parameter());
	}

}

/**
 * Display the heading/title banner to stdout
 */

void heading (  )
{

	cout << endl <<
		"---------------------------------------------------------------------"
		<< endl << "N.I.C.O.L.E. - Version " << VERSION << endl <<
		"---------------------------------------------------------------------"
		<< endl << "Nearly Intelligent Computer Operated Language Examiner"
		<< endl <<
		"=====================================================================" <<
		endl << endl << "** Type '/help' for a list of commands **" << endl <<
		endl;
}

/**
 *\page nicole-ocnsole NICOLE console application
 * This page will describe the NICOLE console application
 *
 * There is nothing hear at this stage.. please be patient
 *
 */