// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// nicole.h
//

#include "parser.h"
#include "matrix.h"

//
// setup our own defines
//

/**
 * Where our current MySQL database is hosted at. Should be at 'localhost'
 */
#define DB_HOST       "localhost"

/**
 * Name of the MySQL database that we connect to
 */
#define DB_NAME       "NICOLE"

/**
 * Current username with select/update access to the MySQL Database
 */
#define DB_USER_NAME  "nicoleusr"

/**
 * Current password for the user that connects to the MySQL Database
 */
#define DB_USER_PWD   NULL

void process_cmd ( Parser * p, Matrix * m );
void heading (  );

/**
 *\mainpage
 *\section intro Introduction
 * The documentation found within these pages are only a snapshot of
 * the source base at any given time. As NICOLE continues to grow
 * and develop, these pages will become more outdated (pay attention to
 * the 'last generated' field in the footer).
 *
 * I will do the best that I can to keep the documentations as up to date
 * as possible.
 *
 * Cheers,
 *
 * Phil Howlett <pghowlett@ozemail.com.au>
 *
 * NICOLE Project Administrator
 *
 *\section utilities Utilities
 *
 *\ref exportdb Exports NICOLE's database to an raw datafile.
 *
 *\ref importdb Imports a raw database into NICOLE's database
 *
 *\section licence GNU Licence
 * Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#
 *
 */
