// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// Parser object
//

#ifndef _PARSER_H_
#define _PARSER_H_

#include <iostream>
#include <string>
using namespace std;

/**
 * Translates and 'cleans up' user into into a standard form.
 * The parser object recives text input and converts it into a standard
 * format in which other objects can use.
 *
 * \author Phil Howlett
 */

class Parser
{
private:
	string inputline;


public:
	  Parser (  );
	void reset (  );
	string clean_input ( string rawinput );
	void input (  );
	int is_command (  );
	string inputvalue (  );
	string parameter();
	int empty (  );
	int cmd_quit (  );
	int cmd_help (  );
	int cmd_status (  );
	int cmd_info (  );
	int cmd_reset (  );
	int cmd_erase (  );
	void show_help (  );
	void show_status (  );
	void show_info ( string s );
	void erase_nicole (  );
	 ~Parser (  );
};

#endif
