// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// responder.cpp
//

#include <string>
#include <deque>
using namespace std;

#include "nicole.h"
#include "responder.h"
#include "database.h"

Responder::Responder (  )
{
	//
	// establish a connection to the database
	//
	if ( db.init (  ) != DB_COMMAND_OK )
	{
		cerr << "Unable to initialize database: " << db.error_message (  ) <<
			endl;
		exit ( 1 );
	}

	// Connect to database on localhost
	if ( db.connect ( DB_HOST, DB_NAME ) != DB_CONNECTION_OK )
	{
		cerr << "Unable connect to database 'NICOLE': "
			<< db.error_message (  ) << endl;
		exit ( 1 );
	}

}

//This function will return the 5th word based on the 4 words in the query
//(strings a, b, c, d). It selects all phrases in the vocabulary and adds
//up all the frequency counts. Then it selects a random number between 1
//and this total. It will then search the vocabulary where the first 4
//words match a, b, c, d, and select the 5th word which is returned. It
//doesn't do any check with what is returned.

string Responder::find_word ( string a, string b, string c, string d )
{
	char **field;

//  int i;
	long total = 0;
	long tally = 0;
	long marker = 0;

	string nextword = "";

	// First find out how many occurances we have 
	db.exec ( &dbres,
						"SELECT sum(freq) FROM vocabulary WHERE w1 = \"%s\" AND w2 = \"%s\" AND w3 = \"%s\" AND w4 = \"%s\"",
						a.c_str (  ), b.c_str (  ), c.c_str (  ), d.c_str (  ) );
	field = dbres.getTuple (  );
	if ( field[0] == NULL )
	{
		// we could find a new word.. abort!
		//cout << "find_word() FOUND NOTHING" << endl;
		return "";
	}
	else
	{
		// get the total possible frequency combinations
		total = atoi ( field[0] );
	}

	//cout << "Total: " << total << endl;

	marker = rand (  ) % total + 1;

	//cout << "Marker: " << marker << endl;

	// Now lets find the next word to use
	db.exec ( &dbres,
						"SELECT w1,w2,w3,w4,w5,freq FROM vocabulary WHERE w1 = \"%s\" AND w2 = \"%s\" AND w3 = \"%s\" AND w4 = \"%s\"",
						a.c_str (  ), b.c_str (  ), c.c_str (  ), d.c_str (  ), total );
	field = dbres.getTuple (  );

	while ( ( field != NULL ) && ( tally < marker ) )
	{
		// cout << "Tally: " << tally << endl;

		nextword = field[4];				// the 5th word in the query
		tally += atoi ( field[5] );	// the frequency count

		//for (i = 0; i < dbres.nrFields(); i++)
		//{
		//  cout << field[i] << " | ";
		//}
		//cout << endl;
		field = dbres.getTuple (  );
	}

	return nextword;
}

//This function builds up a reply string. strings a, b, c, d, e currenty
//contain the phrase matrix (on first entering the function, it contains
//the last 5 words used, including the fullstop). It searches for the first
//word in the next sentence (the first fund_word() function). If it can't
//find a starting word to the previous sentence, it returns an empty string
//The while loop will continue to call the find_word() function, shifting
//the matrix to the left, and adding the previous word to the matrix, until
//it encounters either a fullstop or it can't find another word. If it can't
//find another word then the reply string is set to an empty string. If it
//encounters a fullstop then the sentence generated (reply string) is returned.

string Responder::get ( string a, string b, string c, string d, string e )
{
	string reply = "";
	string word = "";

//  cout << "Matrix: " << a
//       << "|" << b
//       << "|" << c
//       << "|" << d
//       << "|" << e << endl;

	// get the next available word
	word = find_word ( b, c, d, e );

	if ( word == "" )
	{
		reply = "";
	}
	else
	{
		reply = word;

		while ( word != "." )
		{
			a = b;
			b = c;
			c = d;
			d = e;
			e = word;
			word = find_word ( b, c, d, e );
			if ( word == "" )
			{
				//We have a missing link. Abort the replyer
				return "";
			}
      if ((word != ".") && (word != ","))
      {
        // add a seperator space between words, but not between punctuation
        reply += " ";
      }
			reply += word;
		}
	}
	return reply;
}

Responder::~Responder (  )
{
}
