// Copyright (C) 2000 Phil Howlett <pghowlett@ozemail.com.au>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.#

//
// vocabulary.cpp
//

#include <string>
#include <iostream>
using namespace std;

#include "nicole.h"
#include "vocabulary.h"
#include "database.h"

Vocabulary::Vocabulary (  )
{
	//
	// establish a connection to the database
	//
	if ( db.init (  ) != DB_COMMAND_OK )
	{
		cerr << "Unable to initialize database: " << db.error_message (  ) <<
			endl;
		exit ( 1 );
	}

	// Connect to database on localhost
	if ( db.connect ( DB_HOST, DB_NAME ) != DB_CONNECTION_OK )
	{
		cerr << "Unable connect to database 'NICOLE': "
			<< db.error_message (  ) << endl;
		exit ( 1 );
	}

}

bool Vocabulary::add_phrase ( string a,
															string b, string c, string d, string e )
{

	if ( !exists ( a, b, c, d, e ) )
	{
//    cout << "Adding phrase ->"
//         << a.c_str() << "|"
//         << b.c_str() << "|"
//         << c.c_str() << "|"
//         << d.c_str() << "|"
//         << e.c_str() << "|"
//         << "<-" << endl;
		// Insert a single row into the vocabulary table

		db.exec ( &dbres,
							"INSERT INTO vocabulary VALUES (\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",1)",
							a.c_str (  ), b.c_str (  ), c.c_str (  ), d.c_str (  ),
							e.c_str (  ) );
		if ( dbres.status (  ) != DB_EMPTY_QUERY )
		{
			//
			// We shouldn't get this far, as we have already checked if the record existed.
			//
			cerr << "Can't insert into table 'vocabulary' : " <<
				db.error_message (  ) << endl;
			exit ( 1 );
		}
	}
	else
	{
		update ( a, b, c, d, e );
	}

	return 1;
}

bool Vocabulary::exists ( string a, string b, string c, string d, string e )
{
	char **field;

	db.exec ( &dbres,
						"SELECT w1,w2,w3,w4,w5 FROM vocabulary WHERE w1 = \"%s\" AND w2 = \"%s\" AND w3 = \"%s\" AND w4 = \"%s\" AND w5 = \"%s\"",
						a.c_str (  ), b.c_str (  ), c.c_str (  ), d.c_str (  ),
						e.c_str (  ) );
	field = dbres.getTuple (  );
	if ( field == NULL )
	{
		return false;
	}
	else
	{
		return true;
	}
}

// update the vocabulary entry in the database

bool Vocabulary::update ( string a, string b, string c, string d, string e )
{

	db.exec ( &dbres,
						"UPDATE vocabulary SET freq=freq+1 WHERE w1 = \"%s\" AND w2 = \"%s\" AND w3 = \"%s\" AND w4 = \"%s\" AND w5 = \"%s\"",
						a.c_str (  ), b.c_str (  ), c.c_str (  ), d.c_str (  ),
						e.c_str (  ) );
	if ( dbres.status (  ) != DB_EMPTY_QUERY )
	{
		//
		// This is bad if we get here
		//
		cerr << "Failed to update the vocabulary. " << db.error_message (  ) <<
			endl;
		exit ( 1 );
	}
	return true;
}

// Returns the frequency of a particular word at a particular level

long Vocabulary::freq( int level, string s)
{
	char **field;
	long total = 0;

	// Read sorted data and print it out
	db.exec ( &dbres, "SELECT sum(freq) FROM vocabulary WHERE w%d=\"%s\"", level, s.c_str() );
	field = dbres.getTuple (  );
	if ( field != NULL )
	{
		total = atoi ( field[0] );	// the count of the 'freqency' is the 1st field
		return total;
	}
	else
	{
		return -1;
	}
	
}

long Vocabulary::count (  )
{

	char **field;
	long total = 0;

	// Read sorted data and print it out
	db.exec ( &dbres, "SELECT count(w1) FROM vocabulary" );
	field = dbres.getTuple (  );

	if ( field != NULL )
	{
		total = atoi ( field[0] );	// the 'count' is the first field
	}

	return total;

}

bool Vocabulary::erase (  )
{

	db.exec ( &dbres, "DELETE FROM vocabulary" );
	if ( dbres.status (  ) != DB_EMPTY_QUERY )
	{
		//
		// We shouldn't get this far, as we have already checked if the record existed.
		//
		cerr << "Unable to Delete from table 'vocabulary' : " <<
			db.error_message (  ) << endl;
		exit ( 1 );
	}
	return 1;
}

Vocabulary::~Vocabulary (  )
{
}
