# -sam k (commport5@lucidx.com)

use Term::ANSIColor;
sub die {
 if ($proto) {
  unless ($ansi) {
   $end .= "\r$top packets recieved by filter ($proto)";
   if ($top == 1) {
    $end =~ s/packets/packet/;
   }
  }
  else {
   $end .= "\r";
   $end .= colored($top, $totpkts);
   $end .= " ";
   if ($packets == 1) {
    $end .= colored("packet", $packets);
   }
   else {
    $end .= colored("packets", $packets);
   }
   $end .= " ";
   $end .= colored("recieved", $rec);
   $end .= " ";
   $end .= colored("by", $by);
   $end .= " ";
   $end .= colored("filter", $filter);
   $end .= " ";
   $end .= colored("(", $paren5);
   $end .= colored($proto, $proto1);
   $end .= colored(")", $paren6);
  }
  print STDERR $end;
  if ($if == ($$ + 1)) {
   die "\n\rpdump: $exits[int(rand(@exits))]\n";
  }
  else {
   die "\n";
  }
 }
 else {
  if ($if == ($$ + 1)) {
   die "\rpdump: $exits[int(rand(@exits))]\n";
  }
  else {
   exit;
  }
 }
}

sub error {
 my $version = shift;
 print STDERR "$0 version $version\n";
 print STDERR "Usage: pdump [ -ACfGhImnNpqSuvVX ] [ -c count ]    [ -E \"expression\" ]\n";
 print STDERR "             [ -F file ]           [ -g \"regexp\" ] [ -H \"regexp\" ]\n";
 print STDERR "             [ -i interface ]      [ -P \"regexp\" ] [ -r file ]\n";
 die "             [ -s snaplen ]        [ -w file ]\n";
}

sub help {
 print STDERR "$0 version $version\n";
 print STDERR "Usage: pdump [ -ACfGhImnNpqSuvVX ] [ -c count ]    [ -E \"expression\" ]\n";
 print STDERR "             [ -F file ]           [ -g \"regexp\" ] [ -H \"regexp\" ]\n";
 print STDERR "             [ -i interface ]      [ -P \"regexp\" ] [ -r file ]\n";
 print STDERR "             [ -s snaplen ]        [ -w file ]\n\n";
 print "\tNow with the power of tcpdump and ngrep!\n\n";
 print "\t-A\t\tprints the arguments you may use with pdump\n";
 print "\t-C\t\tcase-insensitive to the regular expression used with -H\n";
 print "\t-f\t\tdoesn't lookup ips\n";
 print "\t-G\t\tignores regexp's case when using -g\n";
 print "\t-h\t\tdisplays this help menu\n";
 print "\t-I\t\tcase-insensitive to the regular expression used with -P\n";
 print "\t-m\t\tuses a different method of extracting the IPs when the\n\t\t\tdefault method gives incorrect IPs\n";
 print "\t-n\t\tdoesn't lookup ips and only displays port numbers\n\t\t\t[equivalent to -fS]\n";
 print "\t-N\t\tonly prints the first part of domains, e.g. LucidX.com\n\t\t\twould be 'LucidX'\n";
 print "\t-p\t\tinterface doesn't go into promiscuous mode, although the\n\t\t\tinterface may already be in the mode\n";
 print "\t-q\t\tquick/quiet output to print out less protocol\n\t\t\tinformation (works with all output)\n";
 print "\t-S\t\tdisplays port numbers instead of services\n";
 print "\t-t\t\tdoesn't print the timestamp on packets\n";
 print "\t-u\t\tuses ANSI color\n";
 print "\t-v\t\tprint time to live and type of service information in IP\n\t\t\tpackets\n";
 print "\t-V\t\tprints version information\n";
 print "\t-X\t\trequires -g and prints anything NOT matching the regexp\n\t\t\tin -g\n";
 print "\t-c count\twatches <count> packets then dies\n";
 print "\t-E \"expression\"\tuses <\"expression\"> as the bpf filter, e.g.\n\t\t\t-E \"tcp port 6667\"\n";
 print "\t-F file\t\treads <file> and uses it as the input for the filter\n\t\t\texpression in -E\n";
 print "\t-g \"regexp\"\tif any data matches <\"regular expression\"> it will\n\t\t\tprint the data and packet info\n";
 print "\t-H \"regexp\"\tif any IPs/hostnames match <\"regular expression\">\n\t\t\tthe packet will not be printed\n";
 print "\t-i interface\tuses <interface> instead of looking for the interface\n\t\t\titself\n";
 print "\t-P \"regexp\"\tif any source or dest ports/service names match\n\t\t\t<\"regular expression\"> the packet will not be printed\n";
 print "\t-r file\t\treads from <file> and will even read tcpdump output\n";
 print "\t-s snaplen\tcaptures <snaplen> bytes from each packet instead of\n\t\t\tthe default 200\n";
 print "\t-w file\t\twrites to <file> and readable with -r, even readable to\n\t\t\ttcpdump -r\n\n";
 print "\tman pdump for more information\n";
 die "\n";
}

sub exits {
 @exits = (
 "anything else would be uncivilized",
 "for distribution only with a new PC",
 "cleaner, drier, protects even better",
 "don't leave a network without it",
 "good to the last packet",
 "it does a box good",
 "it's everywhere you want to sniff",
 "it's all day strong, all day long",
 "it's not your ordinary sniffer in perl",
 "it's shagadellic, baby",
 "the other unix sniffer",
 "to the rescue",
 "the right choice for a healthy box",
 "the fresh maker",
 "the fizz goes straight to your buffer",
 "strong enough for a man, coded for a box",
 "sanatized for your protection",
 "often imitated, never duplicated",
 "now with 10 percent more code",
 "not from concentrate",
 "no additives or preservatives",
 "nine out of ten hackers reccomend it",
 "three out of four coders reccomend it",
 "need we say more",
 "sniffs in your box, not in your pants",
 "point, click, sniff",
 "made with real code",
 "cools you to the .core",
 "all quiet on the network front",
 "no process killed",
 );
}
1;
