/*  common.c -- just full of poor but useful code!
    Copyright (C) 2000 Synack Systems Corporation
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

char chars[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_X";


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <termios.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <unistd.h>
#include "common.h"
#include "sha1.h"
#include "blowfish.h"

byte bfkey[512];

/* The function returns a file handle to a newly created file.
 *
 * The newly created file's name will be unqiue -- but not random.
 *
 * It's name doesn't need to be random, just nonsense.
 */

FILE *frandcreate() {
    int i;
    char fname[12];
    u32 l;
    int fd;

    /* just use the random function.. we don't need a real RNG here */
    srandom(time(NULL));

    do {

        for(i=0;i<8;i++) {
            l = random();
            l &= 63;
            fname[i] = chars[l];
        }
        fname[8]='.';
        fname[9]='r';
        fname[10]='\0';

        fd = open(fname,O_WRONLY|O_CREAT|O_EXCL,0600);
        if((fd == -1) && (errno != EEXIST)) return NULL;
    } while(fd == -1);

    return fdopen(fd, "w");
}

FILE *fcreate(char *fname) {
    int fd;

    fd = open(fname,O_WRONLY|O_CREAT,0600);
    if(fd == -1) return NULL;

    return fdopen(fd, "w");
}



u32 randu32() {
    FILE *f;
    u32 r;

    if((f = fopen("/dev/random", "r"))) {
        fread(&r, sizeof(r), 1, f);
        fclose(f);
    } else {
        srandom(time(NULL));
        r = random();
    }

    return r;
}

/* this function retuns an array of 14 unsigned longs that are, hopefully,
 * pretty random.
 * returns NULL on error;
 */
u32 *random_key() {
    u32 *r;
    int fd;
    char buf[1024];
    SHA1_CONTEXT sha1;
    BLOWFISH_context bf;
    int i;
    struct timeval tv;
    struct termios term, oldterm;
    int c;

    /* actually allocate 15 u32's to make my loop simpler */
    r = malloc(sizeof(u32)*15);
    if(!r) return NULL;
    memset(r, 0, sizeof(u32)*15);


    /* get 5 of the "random" u32's from /dev/urandom */
    fd = open("/dev/urandom", O_RDONLY);
    read(fd, buf, sizeof(buf));
    close(fd);
    sha1_init(&sha1);
    sha1_write(&sha1, buf, sizeof(buf));
    sha1_final(&sha1);
    memcpy(r, sha1.buf, sizeof(sha1.buf));

    printf("We need to generate some random data.  Please type for a while. (echo off)\n");
    tcgetattr(0, &term);
    tcgetattr(0, &oldterm);
    term.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
    tcsetattr(0, TCSANOW, &term);
    for(i=0;i<160;i++) {
        c = getchar();
        gettimeofday(&tv, NULL);
        r[5 + (i/32)] |= ((tv.tv_usec & 0x01) << (i%32));
        r[10 + (i/32)] |= ((c & 0x01) << (i%32));
    }
    tcsetattr(0, TCSANOW, &oldterm);

    bf_setkey(&bf, (byte*)r, sizeof(u32)*14);
    for(i=0;i<14;i++) encrypt(&bf, r+i, r+i);
    memset(r+14, 0, 4);
    memset(&bf, 0, sizeof(bf));

#ifdef DEBUGGING_NOW
    { byte *bp = (byte*)r;
        for(i=0;i<60;i++) printf("%02X", bp[i]);
        printf("\n");
    }
#endif

    return r;
}

byte * getbfkey(u32 *keylen) {
    struct sockaddr_un saun;
    int s;
    size_t len;
    byte cmd = 0x01;

    if((s = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
        perror("socket");
        return NULL;
    }

    saun.sun_family = AF_UNIX;
    strncpy(saun.sun_path, getenv("HOME"), sizeof(saun.sun_path)-1);
    strncat(saun.sun_path, "/.refugee_key", sizeof(saun.sun_path)-strlen(saun.sun_path)-1);
    len = sizeof(saun.sun_family) + strlen(saun.sun_path) + 1;

    if(connect(s, (struct sockaddr *)&saun, len) < 0) {
        perror("connect");
        return NULL;
    }

    send(s, &cmd, 1, 0);
    recv(s, &cmd, 1, 0);
    switch(cmd) {
    case KEY_SHA1:
        *keylen = 20;
        break;
    case KEY_TIGER:
        *keylen = 24;
        break;
    case KEY_LAME32:
        *keylen = 4;
        break;
    case KEY_MD5:
        *keylen = 16;
        break;
    case KEY_RAND448:
        *keylen = 56;
        break;
    }
    memset(bfkey, 0, sizeof(bfkey));
    recv(s, bfkey, *keylen, 0);

    close(s);

#ifdef DEBUGGING_NOW
    { int i;
        for(i=0;i<*keylen;i++) printf("%02X", bfkey[i]);
        printf("\n");
    }
#endif

    return bfkey;
}

u32 lamehash(char *s) {
    SHA1_CONTEXT sha1;
    u32 *buf;
    u32 key = 0;
    int i;

    sha1_init(&sha1);
    sha1_write(&sha1, s, strlen(s));
    sha1_final(&sha1);

    buf = (u32*)sha1_read(&sha1);

    for(i=0;i<5;i++)
        key ^= buf[i];

    return key;
}

/* I have no idea if this is a good way to wipe a file or not..
 
   what is better to use, zeros or random data?
   is this actually overwriting the same disc sectors where the file 
   originally lived?
*/

void wipe(FILE *f, size_t sz) {
    int fd;
    int cnt;
    int sz2;
    byte zero[2048];

    fd = fileno(f);

    for(cnt=0;cnt<7;cnt++) {
        if(cnt%2) memset(zero, 0x00000000, sizeof(zero));
        else memset(zero, 0xFFFFFFFF, sizeof(zero));
        lseek(fd, 0, SEEK_SET);
        sz2 = sz;

        while(sz2) {
            write(fd, zero, sizeof(zero));
            sz2 = (sz2 > 2048) ? sz2-2048 : 0;
        }

        fsync(fd);
    }

    close(fd);
}

