typedef unsigned char byte;
typedef unsigned int u32;
typedef unsigned long long u64;

/* first magic number is used refugee < 0.95 and in later versions if blowfish
   is being used */
#define BLOWFISH_MAGIC_NUM	0x03
/* next magic num isn't used until refugee 0.95 and indicates that rijndael
   is being used */
#define RIJNDAEL_MAGIC_NUM      0x04

#define KEY_SHA1		0x01
#define KEY_TIGER		0x02
#define KEY_LAME32		0x03
#define KEY_MD5			0x04
#define KEY_RAND448		0x05

    /* the .r file will look like this:
     
        header (152 or 160 bytes)
    	encrypted data (...)
    	thumbprint (40 bytes)
     
     */

typedef struct {
    byte magic;
    byte zero;
    byte random[6];
    u32 fsize;
    u32 fodder1;
    u32 fmode;
    u32 fodder2;
    byte fname[128];
    /* These next 8 bytes don't exist in a blowfish file! */
    byte rijndael_space[8];
} FileHeader;

#define RIJNDAEL_HEADER_SZ 160
#define BLOWFISH_HEADER_SZ 152

FILE *fcreate(char *fname);
FILE *frandcreate();
u32 randu32();
void endianswap(byte *b);
u32 *random_key();
u32 lamehash(char *s);

byte * getbfkey();

void wipe(FILE *f, size_t sz);
