typedef struct {
    u32  h0,h1,h2,h3,h4;
    u32  nblocks;
    byte buf[64];
    int  count;
}
SHA1_CONTEXT;


void sha1_init(SHA1_CONTEXT *hd);

/****************
 * Transform the message X which consists of 16 32-bit-words
 */
void transform( SHA1_CONTEXT *hd, byte *data );

/* Update the message digest with the contents
 * of INBUF with length INLEN.
 */
void sha1_write( SHA1_CONTEXT *hd, byte *inbuf, size_t inlen);


/* The routine final terminates the computation and
 * returns the digest.
 */
void sha1_final(SHA1_CONTEXT *hd);

/*
 * Returns: 20 bytes representing the digest.
 */
byte * sha1_read( SHA1_CONTEXT *hd );
