#!/bin/sh

rm -rf local*

success=0

cp test.data.txt local.data.txt
cp test.data.jpg local.data.jpg

echo "Starting key.. it will die in one minute."
../key -x 1 -f test.key

echo "Testing Rijndael cipher.."
../encrypt -d local.data.txt
../encrypt -d local.data.jpg


../decrypt -u local.data.txt.r
../decrypt -u local.data.jpg.r

diff local.data.txt test.data.txt >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 1 failed"
	success=$(($success + 1))
fi

diff local.data.jpg test.data.jpg >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 2 failed"
	success=$(($success + 1))
fi

../recat local.data.txt.r >local.txt
../recat local.data.jpg.r >local.jpg


diff local.txt test.data.txt >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 3 failed"
	success=$(($success + 1))
fi

diff local.jpg test.data.jpg >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 4 failed"
	success=$(($success + 1))
fi



rm -rf local*
cp test.data.txt local.data.txt
cp test.data.jpg local.data.jpg

echo "Testing Blowfish cipher.."
../encrypt -bd local.data.txt
../encrypt -bd local.data.jpg


../decrypt -u local.data.txt.r
../decrypt -u local.data.jpg.r

diff local.data.txt test.data.txt >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 5 failed"
	success=$(($success + 1))
fi

diff local.data.jpg test.data.jpg >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 6 failed"
	success=$(($success + 1))
fi

../recat local.data.txt.r >local.txt
../recat local.data.jpg.r >local.jpg


diff local.txt test.data.txt >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 7 failed"
	success=$(($success + 1))
fi

diff local.jpg test.data.jpg >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 8 failed"
	success=$(($success + 1))
fi


../decrypt -u b.data.txt.r
../decrypt -u b.data.jpg.r

diff test.data.txt b.data.txt >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 9 failed"
	success=$(($success + 1))
fi

diff test.data.jpg b.data.jpg >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 10 failed"
	success=$(($success + 1))
fi

../decrypt -u r.data.txt.r
../decrypt -u r.data.jpg.r

diff test.data.txt r.data.txt >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 11 failed"
	success=$(($success + 1))
fi

diff test.data.jpg r.data.jpg >/dev/null 2>&1
if [ $? != 0 ] ; then
	echo "Refugee test 12 failed"
	success=$(($success + 1))
fi

rm -rf local* b.data.txt b.data.jpg r.data.txt r.data.jpg

if [ $success = 0 ] ; then
	echo 
	echo All tests were passed.
	echo
else
	echo '*****'
	echo $success tests failed.
	echo Did you use -DBIG_ENDIAN_HOST?  Did you need to?
	echo Please report this failure to ghull@synack.com
	echo '*****'
fi
