/*
** Copyright (C) 2000 Carnegie Mellon University
**
** Author: Jed Pickel <jed@pickel.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: spo_log_database.h,v 1.3 2000/06/03 04:56:04 roesch Exp $ */

#include "snort.h"

#ifndef __SPO_LOG_DATABASE_H__
#define __SPO_LOG_DATABASE_H__

char * dbtype;
char * dbname;
char * password;
char * host;
char * user;
char * port;
int  sid, cid;

#ifdef ENABLE_POSTGRESQL
#include <libpq-fe.h>
PGconn * p_connection;
PGresult * p_result;
#endif

#ifdef ENABLE_MYSQL
#include <mysql.h>
MYSQL * m_sock;
MYSQL_RES * m_result;
MYSQL_ROW m_row;
#endif

#ifdef ENABLE_UNIXODBC
#include <sql.h>
#include <sqlext.h>
#include <sqltypes.h>
SQLHENV u_handle;
SQLHDBC u_connection;
SQLHSTMT u_statement;
SQLINTEGER  u_col;
SQLINTEGER  u_rows;
#endif

/* some constants */
#define MAX_QUERY_LENGTH 600
#define POSTGRESQL   "postgresql"
#define MYSQL        "mysql"
#define UNIXODBC     "unixodbc"
#define POSTGRESQL   "postgresql"

/* list of function prototypes for this preprocessor */
void SetupLogDatabase();
void LogDatabaseInit(u_char *);
void ParseDatabaseArgs(char *);
void LogDatabase(Packet *, char *, void *);
void InitDatabase();
int Insert(char *);
int Select(char *);
void Connect();

#endif  /* __SPO_LOG_DATABASE_H__ */
