#!/usr/bin/perl

# alertset_xml.pl, distributed as part of Snortsnarf v062000.1
# Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
# copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
# Released under GNU General Public License, see the COPYING file included
# with the distribution or http://www.silicondefense.com/snortsnarf/ for
# details.

# alertset_xml.pl contains useful functions in working with the alert set
#   database XML.

# Please send complaints, kudos, and especially improvements and bugfixes to
# hoagland@SiliconDefense.com.  As described in GNU General Public License, no
# warranty is expressed for this program. 

require "xml_help.pl";

sub create_tree_unless_exists {
	my($tree)= shift;
	if (defined($tree) && @$tree) {
		return $tree;
	} else {
		return ['LABELED-EVENTS',[{}]];
	}
}

sub get_all_sets {
	my($tree)= @_;
	my(@sets)= ();
	my @content= @{$tree->[1]};
	shift @content; # ignore LABELED-EVENTS attrs
	while (@content) {
 	   my $tagname=shift(@content);
 	   my $content=shift(@content);
 	   next unless $tagname eq 'EVENT-SET'; # should always be this actually
 	   push(@sets,$content);
	}
	return @sets;
}

sub get_set_named {
	my($tree,$setname)= @_;
	my $settree= &find_set_named($tree,$setname);
	unless (defined($settree)) {
		$settree=[{'name' => $setname, 'created' => time()}];
		push(@{$tree->[1]},'EVENT-SET',$settree);
	}
	return $settree;
}

sub find_set_named {
	my($tree,$setname)= @_;
	my @content= @{$tree->[1]};
	shift @content; # ignore LABELED-EVENTS attrs
	while (@content) {
 	   my $tagname=shift(@content);
 	   my $content=shift(@content);
 	   next unless $tagname eq 'EVENT-SET'; # should always be this actually
 	   my @event_set_trees= @{$content};
 	   my %event_set_attrs= %{shift(@event_set_trees)};
 	   return $content if $event_set_attrs{'name'} eq $setname;
	}
	return undef;
}

sub set_attrs {
	my($settree)= shift;
	return %{$settree->[0]};
}

sub set_events {
	my($root,$setname)= @_;
	my($tree)= &find_set_named($root,$setname);
	return undef unless defined($tree);
	my(@events)= ();
	my @content= @{$tree};
	shift @content; # ignore LABELED-EVENTS attrs
	while (@content) {
 		my $tagname=shift(@content);
 		my $content=shift(@content);
 		next unless $tagname eq 'EVENT'; # should always be this actually
		push(@events,$content);
	}
	return @events;
}


sub add_events_to_set {
	my($setroot,@events)= @_;
	my $e;
	foreach $e (@events) {
		#&reporterr("add_events_to_set: $e\{msg}=".$e->{'sig'},0);
		push(@{$setroot},'EVENT',[
			{},
			'TEXT',[{'format' => $e->{'format'}},0,$e->{'text'}],
			'MESSAGE',[{},0,$e->{'sig'}],
			'DATE',[{},0,$e->{'date'}],
			'MONTH',[{},0,$e->{'month'}],
			'TIME',[{},0,$e->{'time'}],
			'PROTOCOL',[{},0,$e->{'proto'}],
			'SRCIP',[{},0,$e->{'src'}],
			'DESTIP',[{},0,$e->{'dest'}],
			'SRCPORT',[{},0,$e->{'sport'}],
			'DESTPORT',[{},0,$e->{'dport'}],
			'FLAGS',[{},0,$e->{'flags'}]
		]);
	}
}


sub event_field {
    my($eventtree,$fld)= @_;
    my @content= @{$eventtree};
    shift @content;
    my($tagname,$info);
    while (@content) {
        $tagname=shift(@content);
        $info= shift(@content);
        #print "tagname=$tagname; $info=(",join(',',@{$info}),")\n";
        if ($tagname eq $fld) {
            return $info->[2];
        }
    }      
    return undef;
}

sub get_set_event_details {
	my($root,$setname)= @_;
	return map(&event_details($_),&set_events($root,$setname));
}

sub event_details {
    my($eventtree)= @_;
    my %info=();
    my @content= @{$eventtree};
    my %attrs= %{shift @content};
    my $attr;
    foreach $attr (keys %attrs) {
    	$info{"EVENT_$attr"}= $attrs{$attr};
    }
    my($tagname,$info);
#my $debug='';
	my($attrhash,$zero,$text,@should_be_empty);
    while (@content) {
        $tagname=shift(@content);
        ($attrhash,$zero,$text,@should_be_empty)= @{shift(@content)};
#$debug.= $info.'{'.$tagname."}= $text\n";
        $info{$tagname}= $text;
	    %attrs= %{$attrhash};
	    foreach $attr (keys %attrs) {
	    	$info{"$tagname_$attr"}= $attrs{$attr};
	    }
    }      
#&reporterr('debug event_details: '.$debug,0);
    return \%info;
}

1;

# $Id: alertset_xml.pl,v 1.3 2000/06/21 00:30:56 jim Exp $
