#!/usr/bin/perl

# sisr_utils.pl, distributed as part of Snortsnarf v062000.1
# Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
# copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
# Released under GNU General Public License, see the COPYING file included
# with the distribution or http://www.silicondefense.com/snortsnarf/ for
# details.

# sisr_utils.pl is assortment of routines that are used in SISR scripts and
#   modules

# Please send complaints, kudos, and especially improvements and bugfixes to
# hoagland@SiliconDefense.com.  As described in GNU General Public License, no
# warranty is expressed for this program.

require 'web_utils.pl';


# map $field to the value of the field, %var to the value of the environmental variable, and anything else to itself, for each argument
sub arg_to_val {
	my ($input)= shift;
	return map((s/^\$//?join(';',$input->param($_)):(s/^\%//?$ENV{$_}:$_)),@_);
}

# takes 3 args, the CGI object, a output field spec, and a value
# writes the value to the named environmental variable if the output field name starts with % or to field in the CGI object if the field starts with $ or with anything else
sub write_out_to_arg {
	$_[1] =~ s/^([\$\%])//;
	if ($1 eq '%') { # env. var
		$ENV{$_[1]}= $_[2];
	} else {
		$_[0]->param($_[1],$_[2]);
	}

}

sub decode_fldinfo {
	my($incfldinfo)= shift;
	my (%flddescr)= ();
	my ($fld,$descr);
	my(@fldorder);
	foreach (split("\n",$incfldinfo)) {
		($fld,$descr)= split(':',$_,2);
		$flddescr{$fld}= $descr;
		push(@fldorder,$fld);
	}
	return (\%flddescr,\@fldorder);
}

sub get_config_field {
	my($configfile,$fld)= @_;
	open(C,"<$configfile") || die "could not open config file \"$configfile\"";
	while (<C>) {
		if (s/^$fld\s*:\s*//) {
			s/\s+$//;
			close C;
			return $_;
		}
	}
	warn "could not find '$fld' in config file \"$configfile\", assuming empty";
	return '';

}


sub pipeline_form_start {
	my($pipeline,$path)=@_;
print <<">>";
<FORM ACTION="pipeline.pl" METHOD="post">
<INPUT TYPE=hidden NAME="_pipeline" VALUE="$pipeline">
<INPUT TYPE=hidden NAME="_path" VALUE="$path">
>>

}

sub pipeline_submit_url {
	my($pipeline,$path,%rest)= @_;
	return 'pipeline.pl?'.join('&','_path='.&url_encode($path),'_pipeline='.&url_encode($pipeline),map($_.'='.&url_encode($rest{$_}),keys %rest));
}

1;
