/* $Id: au_proto.h,v 1.10 1998/06/12 18:40:54 iarce Exp $ 
 * Secure Syslog daemon
 * CORE SDI S.A. Buenos Aires, Argentina. 1998
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES
 * ARE DISCLAIMED. IN NO EVENT SHALL CORE SDI S.A. BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE USE OR MISUSE OF THIS SOFTWARE.
 *
 * Secure Syslog authentication routines
 *
 * Author: Emiliano Kargieman, CORE SDI S.A.
 */

#ifndef AU_PROTO_H
#define AU_PROTO_H

#include "sha1.h"
#include "auth.h"
/* protocols implemented */
typedef int au_method(int, struct filed *, char *, int *); 

#define AUP_NONE	0
#define AUP_PEO		1

 
/* Test authentication protocol */
extern au_method test;

typedef struct {
        time_t time;
        char log[16];
} au_test_log;

/* 
 * PEO authentication protocol proposed for syslog by
 * Ariel Futoransky <futo@secnet.com> and Emiliano Kargieman <ek@secnet.com>
 *
 * Implementation using SHA1 coded by Peter C. Gutmann <pgut1@cs.aukuni.ac.nz>
 */

extern au_method peo;
typedef struct {
	time_t time;
	u_char sha1digest[SHA1_DIGESTSIZE];
} AU_PEO_LOG;

extern au_method none;

char *au_getprotoname(int);
char *cv_name(char *);

int au_getfiled(int, struct filed *);
int au_putfiled(int, struct filed *);
int au_getfnum(int);
int au_putfnum(int, int);
int au_getauthbuf(int, char *);
int au_putauthbuf(int, char *);
int au_putfile(int, int);
int au_getfile(int, int);

#endif AU_PROTO_H
