/* $Id: audit.h,v 1.15 1998/06/12 18:40:56 iarce Exp $
 * Secure Syslog daemon
 * CORE SDI S.A. Buenos Aires, Argentina. 1998
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES
 * ARE DISCLAIMED. IN NO EVENT SHALL CORE SDI S.A. BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE USE OR MISUSE OF THIS SOFTWARE.
 *
 * audit.h                                              
 * Definitions for the auditing of system logs
 */
#include <sys/time.h>
#define AUD_HOSTLEN	32
#define MAXKEY 56
#define AUDIT_RANDFILE "/audit/.rand"

struct au_key {
	char host[AUD_HOSTLEN];
	time_t addtime;
	char key[MAXKEY];
	int keylen;
}; 

#define AU_OBINFO	32
typedef struct {
	char obscure[AU_OBINFO];
	time_t stamp;
} au_info;

#define AUDIT_PORT	8096
#define AU_BLKSZ	8

#define AU_CMDSZ	1

#define AU_GETLOGS			1
#define AU_AUDIT			2
#define AU_END				3
#define AU_ERROR_NOFILE 	254
#define AU_ERROR_BACKUP 	255
#define AU_OK		0



#define AUTH_INITMSG	"---------- INITIALIZED BY AUDITOR ----------"
