/* $Id: auth.h,v 1.9 1998/06/12 18:40:58 iarce Exp $
 * Secure Syslog daemon
 * CORE SDI S.A. Buenos Aires, Argentina. 1998
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES
 * ARE DISCLAIMED. IN NO EVENT SHALL CORE SDI S.A. BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES RESULTING
 * FROM THE USE OR MISUSE OF THIS SOFTWARE.
 *
 * Secure Syslog authentication routines
 *
 * Author: Emiliano Kargieman, CORE SDI S.A.
 */

/* sys/syslog.h sucks */

#ifndef AUTH_H
#define AUTH_H

#define AUTHTIMEOUT (10)
#define AUTHTIMEH		(30)

#ifndef LOG_AUTHPRIV
#	define LOG_AUTHPRIV  (10<<3) /* security/authorization messages (private) */
#endif

#ifndef LOG_PRIMASK
#	define LOG_PRIMASK     0x07    /* mask to extract priority part (internal) */
#endif
                                /* extract priority */
#ifndef LOG_PRI
#	define LOG_PRI(p)      ((p) & LOG_PRIMASK)
#	define LOG_MAKEPRI(fac, pri)   (((fac) << 3) | (pri))
#endif 

#include <sys/stat.h>

#define MAXAUTHBUF	64
#define AUTHPATH	"/var/ssyslog/"

/* au_method (int action, struct filed *fi, char *buf, int *len); */
typedef int _au_method(int, char *, char *, int *);

/* actions defined for authentication records */
#define AU_INIT		1
#define AU_OPEN		2
#define AU_UPDATE	4
#define AU_COMMIT	8
#define AU_FLUSH	16
#define AU_READ		32
#define AU_CLOSE	64
#define AU_DESTROY	128

struct au_proto {
       char	  *name;
       int	  proto;
       short	  fd; 
       char 	  buf[MAXAUTHBUF];
       _au_method  *method;
};

struct au_proto * getauthproto(char *, char *);
#endif AUTH_H
