/* $Id: compat.h,v 1.4 1998/04/06 11:45:27 gera Exp $
 * Compatibility header file 
 * Author: Ariel Futoransky && Emiliano Kargieman
 */
#ifndef COMPAT

#define COMPAT

#ifdef S__P 
#ifdef P_PROTOTYPE
#define __P(x)	x
#else
#define __P(x)	
#endif
#endif

#ifdef NOUINT
	typedef unsigned long u_int32_t;
	typedef	unsigned short u_int16_t;
	typedef unsigned char u_int8_t;
#endif

#define SCAT(a,b,n) strncat((a), (b), n - strlen(a))
#endif

#ifdef NOFLOCK
#	include <unistd.h>
#	define	LOCK_SH   1    /* shared lock */
#	define	LOCK_EX   2    /* exclusive lock */
#	define	LOCK_NB   4    /* don't block when locking */
#	define	LOCK_UN   8    /* unlock */
#	define	flock(fd,mod)	lockf(fd,(mod)==LOCK_UN?F_ULOCK:F_TLOCK,0)
#endif

#ifdef LOGFAC
#	define       LOG_FAC(p)      (((p) & LOG_FACMASK) >> 3)
#endif
