// 
//    Assembler Code Generator for Cobol Compiler
// 
// 

//#define DEBUG_COMPILER 1

#define PGM_COMPILER 	"TinyCOBOL"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>

#include "htconfig.h"
#include "htversion.h"
#include "htcoboly.h"
#include "htcoblib.h"
#include "htglobals.h"

#define MAXWORDSIZE 	64000

#define MAXNAMEBUF 	300
#define decimal_char() (decimal_comma ? '.' : ',')
int screen_io_enable=0;
int scr_line, scr_column;
int decimal_comma=0;
char currency_symbol='$';

int stabs_on_sw;

extern int lineno;
extern struct lextab literal;
extern FILE *yyin;
extern int yydebug;
extern struct sym *curr_file;

FILE *o_src,*o_lst;
struct sym *curr_paragr=NULL,*curr_section=NULL;
struct sym *curr_field;
unsigned stack_offset=0;	/* offset das variaveis na pilha */
unsigned stack_plus=0;
unsigned global_offset=0;	/* offset das variaveis globais (DATA) */
unsigned file_offset=0;
unsigned literal_offset=0;
unsigned linkage_offset=0;
unsigned using_offset=8;
unsigned last_lineno = 0;
short at_procedure = 0;
static char name_buf[MAXNAMEBUF];

struct list *files_list=NULL;
struct list *disp_list=NULL;
struct list *parameter_list=NULL;
struct list *fields_list=NULL;
struct list *last_field=NULL;
struct index_to_table_list *index2table = NULL;

int screen_label=0;
int para_label=0;
int block_label=0;
int line_label=0;
int paragr_num=1;
int loc_label=1;
char picture[64];
int picix,piccnt,decimals,sign,v_flag,n_flag,digits;
int filler_num=1;
int active[37];
int at_linkage=0;
int stackframe_cnt=0;
char program_id[120] = "main";
char *pgm_label = "main"; 

/*
**	Symbol table management routines
*/

#define HASHLEN 100
static struct sym *vartab[ HASHLEN ]={NULL};
static struct sym *labtab[ HASHLEN ]={NULL};
static struct lit *littab[ HASHLEN ]={NULL};

int hash( char *s ) {
	int val;
	for ( val = 0 ; *s != '\0'; )
		val += toupper(*s++);
	return( val % HASHLEN );
}

char *savename( s )
char *s; {
	char *ap;
	if ((ap = (char *) malloc( strlen(s) + 1 )) != NULL)
		strcpy(ap,s);
	return( ap );
}

struct sym *lookup( char *s, int tab ) {
	if (tab==SYTB_LIT) { /* literals tab */
		struct lit *as;
		char buf[6];
		for ( as = littab[ hash(s) ] ; as != NULL ; as = as->next )
			if ( strcmp( s, as->name ) == 0 )
				return( (struct sym *)as );
		return( NULL );
	}
	else {
		struct sym *as;
		if (tab==SYTB_VAR) 
			as = vartab[ hash(s) ];
		else
			as = labtab[ hash(s) ];
		for ( ; as != NULL ; as = as->next )
			if ( strcmp( s, as->name ) == 0 )
				return( as );
			return( NULL );
	}
}

struct sym *install( char *name, int tab, int cloning ) {
//fprintf(stderr,"install: %s , %d , %d\n",name,tab,cloning); 
	if (tab==SYTB_LIT) {
		struct lit *as;
		int val;
		char buf[6];
		if ( ( as = (struct lit *)lookup(name,tab) ) == NULL ) {
			as = (struct lit *) malloc( sizeof(struct lit) );
			if (as==NULL)
				return NULL;
			if ( (as->name = savename( name ) )  == NULL )
				return NULL;
			val = hash( as->name );
			as->next = littab[ val ];
			littab[ val ] = as;
			as->type = 0;
			as->all = 0;
			as->litflag=1;
			as->nick = NULL;
		}
		return( (struct sym *)as );
    }
    else {
		struct sym *as;
		int val;
		if ( ( as = lookup(name,tab) ) == NULL ) {
			as = (struct sym *) malloc( sizeof(struct sym) );
			if (as==NULL)
				return NULL;
			if ( (as->name = savename( name ) )  == NULL )
				return NULL;
			val = hash( as->name );
			if (tab==SYTB_VAR) { 
//fprintf(stderr,"install: creating %s -> 0x%x\n",as->name,as);
				as->next = vartab[ val ];
				vartab[ val ] = as;
			}
			else {
				as->next = labtab[ val ];
				labtab[ val ] = as;
			}
			as->type = 0;
			as->defined = 0;
			as->value = as->sort_data = NULL;
			as->linkage_flg = 0;
			as->litflag=0;
			as->scr = NULL;
			as->clone = as->parent = NULL;
		} else if ( (cloning && as->defined) || (cloning == 2) ) { 
				/* install clone (cloning==2 -> force) */
			struct sym *clone;
//fprintf(stderr,"install: cloning %s -> 0x%x\n",as->name,as);
			clone = (struct sym *) malloc( sizeof(struct sym) );
			if (clone==NULL)
				return NULL;
			clone->name = as->name;
			clone->type = 0;
			clone->defined = 0;
			clone->value = as->sort_data = NULL;
			clone->linkage_flg = 0;
			clone->litflag=0;
			clone->scr = NULL;
			clone->parent = NULL;
			clone->clone = as->clone;
			as->clone = clone;
			as = clone;
		}
		return( as );
    }
}

struct sym *lookup_label( struct sym *sy, struct sym *parent ) {
//fprintf(stderr,"lookup_label: %s OF %s",sy->name,parent->name);
	while (sy->clone && (sy->parent != parent))
		sy = sy->clone;
	if ((sy->parent == parent) || (sy->parent==NULL) ) {
	/*	if (sy->parent)
			fprintf(stderr," found -> %s\n",sy->parent->name);
		else
			fprintf(stderr," found\n");*/
		return sy;
	} 
	else {
		//fprintf(stderr," not found\n");
		return NULL;
	}
}

struct sym *lookup_variable( struct sym *sy, struct sym *parent ) {
	//sy = lookup(sy->name,SYTB_VAR);
	while (sy->clone && (sy->parent != parent))
		sy = sy->clone;
	if (sy->parent != parent)
		return NULL;
	return sy;
}

int is_variable ( struct sym *sy ) {
	switch (sy->type) {
	case 'A': /* alpha */
	case '9': /* numeric */
	case 'X': /* alphanum */
	case 'B': /* binary (computational) */
	case 'E': /* edited */
	case '8': /* 88 field */
	case 'D': /* screen data */
	case 'G': /* group */
	case 'C': /* compacted (comp-3) */
		return 1;
	default:
		return 0;
	}
}

/*
**	Code Generating Routines
*/

void stabs_line( ) {
	fprintf(o_src,".stabn\t68,0,%d,.LS%d-%s\n",lineno,line_label,pgm_label);
	fprintf(o_src,".LS%d:\n",line_label++);
}

void stabs_block( int end ) {
/*	I just can't get this working. Let's forget it for some time. */
	if (!end) {
		fprintf(o_src,".LSB%d:\n",block_label);
	}
	else {
		fprintf(o_src,".LSE%d:\n",block_label);
		fprintf(o_src,".stabn\t192,0,0,.LSB%d-%s\n",
			block_label,pgm_label);
		fprintf(o_src,".stabn\t224,0,0,.LSE%d-%s\n",
			block_label++,pgm_label);
	}
}

void pgm_header( char *id ) {
	fprintf(o_src,"\t.file\t\"%s.cob\"\n", id);
	strcpy(program_id,id);
}

void data_trail( void ) {
//	fprintf(o_src,"_DATA	ends\n\n");
}

void proc_header( int using ) {
	struct sym *sy,*sy1;
	int i;
	if (using) {
		pgm_label = program_id;
	}
	if (stabs_on_sw) {

	   fprintf(o_src,".stabs\t\"%s\",100,0,0,Ltext\n",inputname,pgm_label);
	   fprintf(o_src,".stabs\t\"%s:F1\",36,0,0,%s\n",pgm_label,pgm_label);
	   fprintf(o_src,".stabs\t\"display:t2=r2;0;255;\",128,0,0,0\n");
	   fprintf(o_src,".stabs\t\"comp:t3=r3;-2147483648;2147483647;\",128,0,0,0\n");
	   fprintf(o_src,".stabs\t\"comp3:t4=r3;0;255;\",128,0,0,0\n");
	
	}
//	fprintf(o_src,"\t.version\t\"%s\"\ntiny_cobol_compiled.:\n", PGM_VERSION);
	fprintf(o_src,"\t.version\t\"01.01\"\ntiny_cobol_compiled.:\n");
	fprintf(o_src,".text\nLtext:\n");

	if (stabs_on_sw) {
	   fprintf(o_src,".stabs\t\":t1\",128,0,0,0\n");
	}

	fprintf(o_src,"\t.align 16\n");
	fprintf(o_src,".globl %s\n\t.type\t%s,@function\n",pgm_label,pgm_label);
	fprintf(o_src,"%s:\n",pgm_label);
	fprintf(o_src,"\tpushl\t%%ebp\n\tmovl\t%%esp, %%ebp\n");
	if (stack_offset & 1) stack_offset++;

        /*  
        Extra 12 bytes holds search all temporary data 
        EOT switch, min, max boundaries. 
        Note: extra 4 bytes is to remove memory corruption problem
        found in test20c.cob, probably due to boundary alignment problem. 
        */
	stack_offset = stack_offset + 16; 

	fprintf(o_src,"\tsubl\t$%u, %%esp\n",stack_offset);
    /********** initialize all VALUES of fields **********/
	for (i=0;i<HASHLEN;i++)
	  for (sy1=vartab[i];sy1!=NULL;sy1=sy1->next)
		for (sy=sy1;sy!=NULL;sy=sy->clone)
		  if (sy->type!='F' && sy->type!='8' && 
		      sy->type!='K' && sy->type!='J' ) {
					if (sy->value != NULL) {
						gen_move( (struct sym *)sy->value,sy );
					}
					if (stabs_on_sw) {

					   if (sy->type == 'B')
						   fprintf(o_src,".stabs\t\"%s:3\",128,0,0,-%d\n",
							sy->name,sy->location);
					   else if (sy->type == 'C')
						   fprintf(o_src,".stabs\t\"%s:(1,%d)=ar3;1;%d;4\",128,0,0,-%d\n",
							sy->name,sy->len,sy->len,sy->location);
					   else
						   fprintf(o_src,".stabs\t\"%s:(1,%d)=ar3;1;%d;2\",128,0,0,-%d\n",
						   sy->name,sy->len,sy->len,sy->location);
					}
		  }
	if (stabs_on_sw) {

	    fprintf(o_src,".stabn\t192,0,0,.LS0-%s\n",pgm_label);
	    fprintf(o_src,".stabn\t224,0,0,.LSend-%s\n",pgm_label);
	
	}
	
	fprintf(o_src,"\tleal\t%s, %%eax\n",pgm_label);
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tleal\t__end_pgm, %%eax\n");
	fprintf(o_src,"\tpushl\t%%eax\n");
	if (!decimal_comma) {
		fprintf(o_src,"\txorl\t%%eax,%%eax\n");
		fprintf(o_src,"\tmovl\t%%eax,decimal_comma\n");	
	}
	if (currency_symbol != '$') {
		fprintf(o_src,"\tmovb\t$%d,cCurrencySymbol\n", currency_symbol);
	}
	at_procedure++;
}

void proc_trail( int using ) {
	int i;
	struct lit *v;
	struct list *list;
	struct sym *sy;
	char s[9];
	char *pgm_label = "main";

	if (using) {
		pgm_label = program_id;
	}
	fprintf(o_src,"__end_pgm:\n");
	asm_call("stop_run");

//	Program return code is stored in register %eax
//	Note:
//        The variable RETURN-CODE is a extention to the 
//        standard, since ANSI COBOL 85 does not support it.

        if ((sy = lookup(SVAR_RCODE, SYTB_VAR)) == NULL) {
 	   fprintf(o_src,"\tmovl\t$0, %%eax\n");
        }
        else {
	   fprintf(o_src,"\tleal\t-%u(%%ebp), %%edx\n",sy->location);
	   fprintf(o_src,"\tmovl\t(%%edx), %%eax\n");
        }

	fprintf(o_src,"\tjmp\t.LSend\n");
	fprintf(o_src,"\t.align 16\n");
	fprintf(o_src,".LSend:\n");

	fprintf(o_src,"\tmov\t%%ebp,%%esp\n");
	fprintf(o_src,"\tpopl\t%%ebp\n");
	fprintf(o_src,"\tret\n");

	/******* screen section field processing *********/
  	dump_scr_proc();	
	
	/********** generate .Lfe statement   ************/
	fprintf(o_src,".Lfe1:\n");
	fprintf(o_src,"\t.size\t%s,.Lfe1-%s\n",pgm_label,pgm_label);


	/********** generate data for literals & fields ************/
//	fprintf(o_src,"_DATA	segment word public 'DATA'\n");
// 	fprintf(o_src,"\t.data\n");
	fprintf(o_src,".data\n\t.align 4\n");
	/* predefined data for special literals */
	
	fprintf(o_src,"v_base:\n");
	/**************** generate data for fields *****************/
for (list=fields_list;list!=NULL;list=list->next) {
	if ( ((struct sym *)list->var)->type=='F' ) { /* sort files */
		char sl[21];	/* para inverter a lista */
		char *s;
		s=sl;
		*s++=0;	/* final da lista invertida */
		sy=(struct sym *)list->var;
#ifdef DEBUG_COMPILER
		fprintf(o_src,"# File: %s, Data loc: v_base+%d, Desc: v_base+%d\n",
 			sy->name,sy->location,sy->descriptor );
#endif
		sy=(struct sym *)sy->sort_data;
		while (sy!=NULL) {
			*s++ = (unsigned char)sy->direction;
			*s++ = (unsigned char)sy->len;
			sy = (struct sym *)(sy->sort_data);
		}
		s--;
		while (*s) {
			fprintf(o_src,"\t.byte\t%u,%u\n",*s--,*s--);
		}
		fprintf(o_src,"\t.byte\t0\n");
	}
	else if (((struct sym *)list->var)->litflag) { /***** it is a literal *****/
		int len;
		v=(struct lit *)list->var;
		len = v->nick ? 1 : strlen(v->name);
#ifdef DEBUG_COMPILER
fprintf(o_src,"# Literal: %s, Data loc: v_base+%d, Desc: v_base+%d\n",
 			v->name,v->location,v->descriptor );
#endif
		if (!v->decimals)
			{       /* print literal string, w/special chars */
				int bcnt,i;
				char *s;
				if (v->nick) {
					s = v->nick;
					i = 1;
				}
				else {
					s = v->name;
					i = strlen(s);
				}
				bcnt=0;
				while (i) {
					if (!(bcnt++ % 8)) {
						if (bcnt > 1)
							putc('\n',o_src);
						fprintf(o_src,"\t.byte\t%d",*s++);
					}
					else {
						fprintf(o_src,",%d",*s++);
					}
					i--;
				}
				fprintf(o_src,",0\n");
			}
		else {
			char *s;
			s=v->name;
			fprintf(o_src,"\t.byte\t\'");
			while (*s &&(*s!=decimal_char()))
				putc(*s++,o_src);
			s++;
			while (*s)
				putc(*s++,o_src);
			fprintf(o_src,"\',0\n");
		}
		fprintf(o_src,"\t.long\t%d\n",
			(v->decimals) ? len-1 : len);
		fprintf(o_src,"\t.byte\t'%c',%d,%d\n",
			v->type,v->decimals,v->all);

#ifdef DEBUG_COMPILER
		fprintf(o_src,"\t.long\tv_base+%d\t# v_base+%x(hex)\n",
			v->descriptor+9, v->descriptor+9);
#else
		fprintf(o_src,"\t.long\tv_base+%d\n",
			v->descriptor+9);  /* pointer to the picture */
#endif

		if (v->decimals) {
			fprintf(o_src,"\t.byte\t'9',%d,'V',1,'9',%d,0\n",
				len-v->decimals-1, v->decimals);
		}
		else
			fprintf(o_src,"\t.byte\t\'%c\',%d,0\n",
				v->type,len);
	}
	else /*if ( ((struct sym *)list->var)->type!='D' )*/ {
	/********* it is a normal field ****************/
		sy=(struct sym *)list->var;
#ifdef DEBUG_COMPILER
 		fprintf(o_src,"# Field: %s, Stack loc: [bp-%d], Desc: v_base+%d\n",
 			sy->name,sy->location,sy->descriptor );
#endif
		if (sy->redefines != NULL)
			sy->location = sy->redefines->location;

		fprintf(o_src,"\t.long\t%d\n",sy->len);

		fprintf(o_src,"\t.byte\t'%c',%d,0\n",
			sy->type,sy->decimals);
		if (sy->type!='G') {
#ifdef DEBUG_COMPILER
			fprintf(o_src,"\t.long\tv_base+%d\t# v_base+%x(hex)\n",sy->pic,sy->pic);
#else
			fprintf(o_src,"\t.long\tv_base+%d\n",sy->pic);
#endif
			for (i=0;i<strlen(sy->picstr);i+=2)
				fprintf(o_src,"\t.byte\t\'%c\',%d\n",
                    *(sy->picstr+i),*((unsigned char *)sy->picstr+i+1));
			fprintf(o_src,"\t.byte\t0\n");
		}
	}
}
/* generate data for files */
	dump_fdesc();
	dump_scr_data();
	data_trail();
// 	fprintf(o_src,"\n\t.ident\t\"TinyCOBOL: %s\"\n", PGM_VERSION);
 	fprintf(o_src,"\n\t.ident\t\"%s: %s\"\n", PGM_COMPILER, PGM_VERSION);
}

void save_field_in_list( struct sym *sy ) {
	struct list *list;
	if (fields_list==NULL) {
		list = (struct list *)malloc(sizeof(struct list));
		last_field = fields_list = list;
		list->next = NULL;
		list->var = sy;
	}
	else {
		list = (struct list *)malloc(sizeof(struct list));
		list->var = sy;
		list->next = NULL;
		last_field->next = list;
		last_field = list;
	}
}

void save_literal( struct lit *v, int type ) {
	char *s;
	char *dp;
	int piclen;
	if (v->type) return; /* already saved */
	s=v->name;
	piclen=3; /* assume 'X'-only literal */
	if (type!='X' && (dp=strchr(s,decimal_char()))!=NULL) {
		piclen += 4; /* reserve space for 'V' and decimal part */
		v->decimals=strlen(s)-(int)(dp-s)-1;
	}
	else v->decimals=0;
	v->type = type;
	/****** save literal in fields list for later *******/
	save_field_in_list( (struct sym *)v );
	/******** save address of const string ************/
	v->location = literal_offset;
	if (v->decimals)
		literal_offset += strlen(s);
			/* it's already one chr plus (decimal point) */
	else
		literal_offset += strlen(s)+1;
	/******** save address of field descriptor ********/
	v->descriptor = literal_offset;
	literal_offset += 11+piclen;
}

struct lit *
save_special_literal( char val, char picc, char *nick ) {
	struct lit *v;
	v = (struct lit *)install(nick,SYTB_LIT,0);	
	if (v->type) return; /* already saved */
	v->decimals = 0;
	v->type = picc;
	v->nick = (char *)malloc(2);
	v->nick[0] = val;
	v->nick[1] = 0;
	v->all = 1;
	save_field_in_list( (struct sym *)v );
	v->location = literal_offset;
	literal_offset += 2; /* we have only 1-char special literals */
	v->descriptor = literal_offset;
	literal_offset += 14;
	return v;
}

void put_disp_list( struct sym *sy ) {
	struct list *list,*tmp;
//fprintf(o_src,"# put_disp_list: %s\n",sy->name);
	list = (struct list *)malloc(sizeof(struct list));
	list->var = sy;
	list->next=NULL;
	if (disp_list==NULL)
		disp_list = list;
	else {
		tmp=disp_list;
		while (tmp->next != NULL) tmp=tmp->next;
		tmp->next = list;
	}
}

/* 
** Use push_eax and push_ebx to generate code for
** passing parameters to the runtime functions.
** Use asm_call to call the runtime and
** automatically clean the stack.
*/
void push_immed( int i ) {
	stackframe_cnt += 4;
	fprintf(o_src,"\tpushl\t$%d\n",i);
}

void push_eax() {
	stackframe_cnt += 4;
	fprintf(o_src,"\tpushl\t%%eax\n");
}

void pop_eax() {
	stackframe_cnt -= 4;
	fprintf(o_src,"\tpopl\t%%eax\n");
}

void push_ebx() {
	stackframe_cnt += 4;
	fprintf(o_src,"\tpushl\t%%ebx\n");
}

void asm_call( char *s ) {
	fprintf(o_src,"\tcall\t%s\n",s);
	/* generate stack cleanup only if there is something to clean */
	if (stackframe_cnt==1)
		fprintf(o_src,"\tpopl\t%%ecx\n");
	else if (stackframe_cnt)
		fprintf(o_src,"\taddl\t$%d, %%esp\n",stackframe_cnt);
	stackframe_cnt = 0;
}

int symlen( struct sym *sy ) {
	if (sy->type == 'C') 
		return sy->len/2+1;
	else if (sy->type == 'B')
		return 4;
	else
		return sy->len;
}

void 
add_alternate_key( struct sym *sy, int duplicates ) {
	struct sym *f = curr_file;
	struct alternate_list *alt,*new;
	alt = (struct alternate_list *)f->alternate;
	new = malloc(sizeof(struct alternate_list));
	new->next = alt;
	new->key = sy;
	new->duplicates = duplicates;
	f->alternate = (struct sym *)new;
}

struct scr_info *
alloc_scr_info() {
	struct scr_info *new;
	new = malloc(sizeof(struct scr_info));
	new->attr = 0;
	new->line = 1;
	new->column = 1;
	new->foreground = 0;
	new->background = 7;
	new->from = NULL;
	new->to = NULL;
}

struct inspect_before_after *
alloc_inspect_before_after( struct inspect_before_after *ba,
	int before_after, struct sym *var ) {
	if (ba == NULL) {
		ba = malloc(sizeof(struct inspect_before_after));	
		ba->before = ba->after = NULL;
	}
	if (before_after == 1) { /* before given */
		if (ba->before) {
			yyerror("only one BEFORE phrase can be given");
		}
		else {
			ba->before = var;
		}
	}
	else if (before_after == 2) { /* after given */
		if (ba->after) {
			yyerror("only one AFTER phrase can be given");
		}
		else {
			ba->after = var;
		}
	}
	return ba;
}

struct tallying_list *
alloc_tallying_list( struct tallying_list *tl, struct sym *count,
	struct tallying_for_list *tfl) {
	struct tallying_list *new;
	new = malloc(sizeof(struct tallying_list));
	new->next = tl;
	new->tflist = tfl;
	new->count = count;
	return new;
}

struct tallying_for_list *
alloc_tallying_for_list( struct tallying_for_list *tfl, int options,
	struct sym *forvar, struct inspect_before_after *ba ) {
	struct tallying_for_list *new;
	new = malloc(sizeof(struct tallying_for_list));
	new->next = tfl;
	new->options = options;
	new->forvar = forvar;
	new->before_after = ba;
	return new;
}

struct replacing_list *
alloc_replacing_list( struct replacing_list *rl, int options,
	struct replacing_by_list *rbl, struct sym *byvar,
	struct inspect_before_after *ba) {

	struct replacing_list *new;
	new = malloc(sizeof(struct replacing_list));
	new->next = rl;
	new->options = options;
	new->replbylist = rbl;
	new->byvar = byvar;
	new->before_after = ba;
	return new;	
}

struct replacing_by_list *
alloc_replacing_by_list( struct replacing_by_list *rbl,
	struct sym *replvar, struct sym *byvar,
	struct inspect_before_after *ba) {
	struct replacing_by_list *new;
	new = malloc(sizeof(struct replacing_by_list));
	new->next = rbl;
	new->replvar = replvar;
	new->byvar = byvar;
	new->before_after = ba;
	return new;
}


struct unstring_delimited *
alloc_unstring_delimited ( short int all, struct sym *var ) {
	struct unstring_delimited *ud;
	ud = malloc(sizeof(struct unstring_delimited));
	ud->next = NULL;
	ud->var = var;
	ud->all = all;
	return ud;
}

struct unstring_destinations *
alloc_unstring_dest( struct sym *var, struct sym *delim, struct sym *count ) {
	struct unstring_destinations *ud;
	ud = malloc(sizeof(struct unstring_destinations));
	ud->next = NULL;
	ud->var = var;
	ud->delim = delim;
	ud->count = count;
	return ud;
}

struct string_from *
alloc_string_from( struct sym *var, struct sym *delim ) {
	struct string_from *sf;
	sf = malloc(sizeof(struct string_from));
	sf->next = NULL;
	sf->var = var;
	sf->delim=delim;
	return sf;
}

void
gen_unstring( struct sym *var, struct unstring_delimited *delim,
	struct unstring_destinations *dest, struct sym *ptr,
	struct sym *tally ) {
	
	struct unstring_destinations *dest1;
	struct unstring_delimited *delim1;
	
	fprintf(o_src,"# UNSTRING %s\n",var->name);
	gen_loadvar( (struct sym *)NULL ); /* mark the end of destinations */
	while (dest)  {
		gen_loadvar( dest->count );
		gen_loadvar( dest->delim );
		gen_loadvar( dest->var );
		dest1 = dest;
		dest = dest->next;
		free(dest1);
	}
	gen_loadvar( (struct sym *)NULL ); /* mark the end of delimiters */
	while (delim)  {
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",delim->all); 
	    push_eax();	/* push "all" flag */
		gen_loadvar( delim->var );
		delim1 = delim;
		delim = delim->next;
		free(delim1);
	}
	gen_loadvar(tally);
	gen_loadvar(ptr);
	gen_loadvar(var);
	asm_call("cob_unstring");
}

void
gen_stringcmd( struct string_from *sf, struct sym *sy, struct sym *ptr ) {
	struct string_from *sf1;
	fprintf(o_src,"# STRING into %s\n",sy->name);
	gen_loadvar( (struct sym *)NULL ); /* mark the end of variables */
	while (sf)  {
		gen_loadvar( sf->delim );
		gen_loadvar( sf->var );
		sf1 = sf;
		sf = sf->next;
		free(sf1);
	}
	gen_loadvar(ptr);
	gen_loadvar(sy);
	asm_call("cob_stringcmd");
}

void gen_display_screen(struct sym *sy, int main) {
	struct sym *tmp;
	struct list *tmpl;
	if (main)
		push_immed(0); /* mark end of screen items */
	if (sy->son == NULL) {
		fprintf(o_src,"\tleal\t.LDD%d, %%eax\n",sy->scr->label);
		push_eax();
	}
	else {
		for (tmp=sy->son;tmp!=NULL;tmp=tmp->brother) {
			gen_display_screen(tmp,0);	
		}
	}
	if (main) {
		asm_call("cob_display_screen");
		if (disp_list->next) {
			yyerror("we do not handle more than one screen");
		}
		tmpl=disp_list;
		disp_list=disp_list->next;
		free(tmpl);
	}
}

void gen_display(int dupon, int nl) {
	struct list *tmp;
	int len;
	struct sym *sy;
	/* separate screen displays from display of regular variables */
	sy = (struct sym *)disp_list->var;
	if (disp_list && sy->litflag!=1 && sy->scr) {
		gen_display_screen(disp_list->var,1);
		return;
	}
	/* continue w/a regular variable display */
	if (nl & 2) {
		fprintf(o_src,"\tmovl\t$%d, %%eax\n", dupon);
		push_eax();
		asm_call("display_erase");
	}
	while (disp_list) {
		sy=disp_list->var;
		if (sy->litflag == 1) {
			if (((struct lit *)sy)->nick)
				len = 1;
			else
				len = strlen(sy->name);
		}
		else if (sy->litflag == 2) { 
			len = ((struct sym *)((struct vref *)sy)->sym)->len;
		}
		else
			len = sy->len;
		fprintf(o_src,"\tmovl\t$%d, %%eax# display: upon %d\n", dupon, dupon);
		push_eax();
		fprintf(o_src,"\tmovl\t$%d, %%eax\t# display: length of field '%s'\n",
			len,sy->name);
		push_eax();
		gen_loadloc( sy );
		asm_call("display");
		tmp=disp_list;
		disp_list=disp_list->next;
		free(tmp);
	}
	if (!(nl & 1)) {
		fprintf(o_src,"\tmovl\t$%d, %%eax\n", dupon);
		push_eax();
		asm_call("newline");
	}
}

void gen_gotoxy( int lin, int col ) {
	fprintf(o_src,"\tmovl\t$%d, %%eax\n",lin);
	push_eax();
	fprintf(o_src,"\tmovl\t$%d, %%eax\n",col);
	push_eax();
	asm_call("goxy");
}

void gen_accept( struct sym *sy, int echo, int main ) {
	struct sym *tmp;
	if (sy->scr) { /* screen or screen-item accept */
		if (main)
			push_immed(0); /* mark end of screen items */
		if (sy->son == NULL) {
			fprintf(o_src,"\tleal\t.LDD%d, %%eax\n",sy->scr->label);
			push_eax();
		}
		else {
			for (tmp=sy->son;tmp!=NULL;tmp=tmp->brother) {
				gen_accept(tmp,echo,0);	
			}
		}
		if (main)
			asm_call("cob_accept_screen");
	}
	else {
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",echo);
		push_eax();
		fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",sy->descriptor);
		push_eax();
		gen_loadloc( sy );
		asm_call("accept_std");
	}
}

void gen_accept_from_time( struct sym *sy ) {
	gen_loadloc( sy );
	asm_call("accept_time");
}

void gen_accept_from_date( struct sym *sy ) {
	gen_loadloc( sy );
	asm_call("accept_date");
}

void gen_accept_from_inkey( struct sym *sy ) {
	gen_loadloc( sy );
	asm_call("accept_inkey");
}

void gen_accept_from_cmdline( struct sym *sy ) {
	/*gen_loadloc( sy );
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",sy->descriptor);
	push_eax();*/
	gen_loadvar( sy );
	fprintf(o_src,"\tmovl\t12(%%ebp), %%eax\n");
	push_eax();
	fprintf(o_src,"\tmovl\t8(%%ebp), %%eax\n");
	push_eax();
	asm_call("accept_cmd_line");
}

void gen_accept_env_var( struct sym *sy ) {
	/*gen_loadloc( sy );
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",sy->descriptor);
	push_eax();*/
	gen_loadvar( sy );
	asm_call("accept_env_var");
}

/******** structure allocation for perform info(s) ***********/

struct perf_info *
create_perf_info(struct sym *sy1, struct sym *sy2, unsigned long lj, unsigned long le) {
	struct perf_info *rf;
	rf = malloc(sizeof(struct perf_info)); 
        rf->pname1 = sy1; 
        rf->pname2 = sy2;  
        rf->ljmp = lj;
        rf->lend = le;
	return rf;
}

struct perform_info *
create_perform_info(void) {
	struct perform_info *rf;
	rf = malloc(sizeof(struct perform_info)); 
        rf->pf[0] = NULL;
        rf->pf[1] = NULL;
        rf->pf[2] = NULL;
        rf->pf[3] = NULL;
	return rf;
}

char *check_perform_variables(struct sym *sy1, struct perform_info *pi1) {

	int i, j, k;
         	
 	j=0;
        for (i=0; i<4; i++) {
            if (pi1->pf[i] != NULL) {
        	j++;
// #ifdef DEBUG_COMPILER
//                fprintf(stderr,
//                        "debug trace: check_perform_variables: var(%d:%d) '%s'\n", 
//                        i, j, pi1->pf[i]->pname2->name); 
// #endif
            }
        }
        
        for (i=0; i<j ; i++) {
// #ifdef DEBUG_COMPILER
//             fprintf(stderr,
//                     "debug trace: check_perform_variables: var1='%s' var2(%d)='%s'\n", 
//                      sy1->name, 
//                      i, pi1->pf[i]->pname2->name); 
// #endif
            if (strcmp(sy1->name, pi1->pf[i]->pname2->name) == 0) {
               return sy1->name;
            }
        }
        
        for (i=0; i<j ; i++) {
            for (k=i+1; k<j; k++) {

// #ifdef DEBUG_COMPILER
//                fprintf(stderr,
//                        "debug trace: check_perform_variables: var1(%d)='%s' var2(%d)='%s'\n", 
//                        i, pi1->pf[i]->pname2->name, 
//                        k, pi1->pf[k]->pname2->name); 
// #endif
                if (strcmp(pi1->pf[i]->pname2->name, pi1->pf[k]->pname2->name) == 0) {
                   return pi1->pf[i]->pname2->name;
                }
            }
        }

	return NULL;
}


/******** functions for subscripted var manipulation ***********/
struct vref *
create_subscripted_var( struct sym * sy, struct vref *subs ) {
	struct vref *ref;
	ref = malloc(sizeof(struct vref)); 
	ref->litflag = 2;
	ref->sym = sy;
	ref->next = subs;
	return ref;
}

struct vref *
create_subscript( struct sym *sy ) {
	struct vref *ref;
	ref = malloc(sizeof(struct vref)); 
	ref->litflag = ',';		/* the end of subscript is here */
 	ref->sym = sy;			/* this is the actual variable */
	ref->next = NULL;
	return ref;
}

struct vref *
add_subscript_item( struct vref *subs, char op, struct sym *item ) {
	struct vref *ref,*tmp;
	ref = malloc(sizeof(struct vref)); 
	tmp = subs;
	while (tmp->next) tmp=tmp->next;
	tmp->next = ref;
	ref->litflag = ',';
 	ref->sym = item;	
	tmp->litflag = op;
	return subs;
}

struct vref *
add_subscript( struct vref *ref, struct vref *subs ) {
	struct vref *tmp;
	tmp = subs;
	while (tmp->next) tmp=tmp->next;
	tmp->next = ref;
	return subs;
}

int
check_subscripts( struct sym *subs ) {
	struct vref *ref;
	struct sym *sy;
	sy = ((struct vref *)subs)->sym;
	for (ref=(struct vref *)subs;ref;ref=ref->next) {

#ifdef DEBUG_COMPILER
		fprintf(stderr,"check_subscripts: symbol: %s, op: '%c'\n",
			((struct sym *)ref->sym)->name, 
			ref->litflag == 2 ? 2 : ref->litflag );
#endif

		if (ref->litflag == ',') {
			while (sy && !sy->occurs_flg) {
				sy = sy->parent;
			}
			if (!sy) {
				hterror(102,4,"check_subscripts: no parent found");
				return 0; /* excess subscripts, error */
			}
			sy = sy->parent;
		}
	}
	while (sy && !sy->occurs_flg) /* any other subscripts needed ? */
		sy = sy->parent;
	return (sy == NULL) ? 1 : 0; 
}

void
gen_subscripted( struct vref *subs ) {
	struct vref *ref;
	struct sym *sy,*var;
	char op;
	ref = subs->next; 			/* here start the subscripts */
	var = sy = subs->sym; 		/* here our array */
	op = ref->litflag;
	fprintf(o_src,"\tmovl\t$0,%%eax\n"); /* to accumulate offsets */
	fprintf(o_src,"\tpushl\t%%eax\n");
	while (ref) {
		value_to_eax( ref->sym );
		fprintf(o_src,"\tpushl\t%%eax\n");
		while ( ref->litflag != ',') {
				op = ref->litflag;
				ref=ref->next;
				value_to_eax(ref->sym);
				if (op=='+')
					fprintf(o_src,"\taddl\t%%eax,0(%%esp)\n"); 
				else
					fprintf(o_src,"\tsubl\t%%eax,0(%%esp)\n"); 
		}
		/* find the first parent var that needs subscripting */
		while (sy && !sy->occurs_flg) 
			sy = sy->parent;
		fprintf(o_src,"\tpopl\t%%eax\n");
		fprintf(o_src,"\tdecl\t%%eax\n"); /* subscript start at 1 */
		if (sy->len != 1) {
			fprintf(o_src,"\tmovl\t$%d, %%edx\n",symlen(sy));
			fprintf(o_src,"\timull\t%%dx\n");
		}
		fprintf(o_src,"\taddl\t%%eax,0(%%esp)\n");
		if (sy) sy = sy->parent;
		ref = ref->next;
	}
	//stackframe_cnt += 4; 		/* update our stack frame counter */
	fprintf(o_src,"\tpopl\t%%eax\n"); /* return offset in %eax */
}

void value_to_eax ( struct sym *sy ) {
	int value,stack_save;
	char *s;
	fprintf(o_src,"# value_to_eax %s\n",sy->name);
	if (sy->litflag) {
		/* if it's an integer, compute it now, not at runtime! */
		value = 0;
		s = sy->name; /* integer's name is just it's value in ascii */
		while (*s) value = value * 10 + *s++ - '0';
		fprintf(o_src,"\tmovl\t$%d,%%eax\n",value);
    }	
	else if (sy->type == 'B') { /* load binary (comp) value directly */
		fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n",sy->location);
	}
	else {
		stack_save=stackframe_cnt;
		stackframe_cnt = 0;
		/*gen_loadloc( sy ); 
		fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
			sy->descriptor);
		push_eax();*/
		gen_loadvar( sy );
		asm_call("get_index");
		stackframe_cnt=stack_save;
	}
}

/* load location for normal (file/working-storage) or linkage variable */
void load_location( struct sym *var ) {
	unsigned base,locoff;
	struct sym *tmp;
	if (!var->litflag && var->linkage_flg) {
		tmp=var;
		while (tmp->linkage_flg==1) tmp=tmp->parent;
		if (tmp==0)
			hterror(103,8,"linkage section broken");
		base = tmp->linkage_flg;
		locoff = tmp->location - var->location;
		fprintf(o_src,"\tmovl\t%d(%%ebp), %%ebx\n",base);
		if (locoff) {
			fprintf(o_src,"\taddl\t$%d, %%ebx\n",locoff);
		}
		fprintf(o_src,"\tpushl\t%%ebx\n");
	}
	else if (!var->litflag) {
		fprintf(o_src,"\tleal\t-%u(%%ebp), %%eax\n",var->location);
		fprintf(o_src,"\tpushl\t%%eax\n");
	}
	else {
		fprintf(o_src,"\tmovl\t$v_base+%d, %%eax\n",var->location);
		fprintf(o_src,"\tpushl\t%%eax\n");
	}
	stackframe_cnt+=4;
}

void gen_loadloc( struct sym *sy ) {
	unsigned base,locoff;
	struct sym *var,*tmp;
	if (sy == NULL) {
		hterror(104,8,"*** fatal error: variable undefined!\n");
		return;
	}
	if (sy->litflag == 2) {
		gen_subscripted( (struct vref *)sy );
		var = (struct sym *)((struct vref *)sy)->sym;
		if (var->linkage_flg) {
			tmp=var;
			while (tmp->linkage_flg==1) tmp=tmp->parent;
			if (tmp==0)
				yyerror("linkage section broken");
			base = tmp->linkage_flg;
			locoff = tmp->location - var->location;
			fprintf(o_src,"\tmovl %d(%%ebp), %%ebx\n",base);
			if (locoff) {
				fprintf(o_src,"\taddl\t$%d, %%ebx\n",locoff);
			}
			fprintf(o_src,"\taddl\t%%eax, %%ebx\n");
			push_ebx();
		}
		else {
			fprintf(o_src,"\tleal\t-%u(%%ebp), %%ebx\n", var->location);
			fprintf(o_src,"\taddl\t%%ebx,%%eax\n");
			push_eax();
		}
	}
	else
		load_location( sy );
}

void gen_loadvar( struct sym *sy ) {
 	struct sym *var;
	if (sy == NULL) {
		push_immed(0);
	}
	else {
		if (sy->litflag == 2) {
			var = ((struct vref *)sy)->sym;
		}
		else
			var = sy;
		gen_loadloc( sy );
#ifdef DEBUG_COMPILER
		fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\t# descriptor of [%s]\n",
			var->descriptor,var->name);
#else
		fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",var->descriptor);
#endif
		push_eax();
	}
}

void gen_inspect( struct sym *var, void *list, int operation ) {
	struct inspect_before_after *ba,*ba1;
	struct tallying_list *tl,*tl1;
	struct tallying_for_list *tfl,*tfl1;
	struct replacing_list *rl,*rl1;
	struct replacing_by_list *rbl,*rbl1;

	if (!operation) {
		if (!list) return;
		fprintf(o_src,"# INSPECT TALLYING %s\n",var->name);
		gen_loadvar((struct sym *) NULL);
		tl = (struct tallying_list *)list;
		while (tl) {
			tfl = tl->tflist;
			push_immed(0);
			while (tfl) {
				gen_loadvar(tfl->before_after->after);
				gen_loadvar(tfl->before_after->before);
				gen_loadvar(tfl->forvar);
				push_immed(tfl->options);
				free(tfl->before_after);
				tfl1 = tfl;
				tfl = tfl->next;
				free(tfl1);
			}
			gen_loadvar(tl->count);
			tl1 = tl;
			tl = tl->next;
			free(tl1);
		}
		gen_loadvar(var);
		asm_call("cob_inspect_tallying");
	}
	else {
		if (!list) return;
		fprintf(o_src,"# INSPECT REPLACING %s\n",var->name);
		rl = (struct replacing_list *)list;
		push_immed(0);
		while (rl) {
			if (rl->options == INSPECT_CHARACTERS) {
				gen_loadvar(rl->before_after->after);
				gen_loadvar(rl->before_after->before);
				gen_loadvar(rl->byvar);
				push_immed(rl->options);
			}
			else {
				rbl = rl->replbylist;
				while (rbl) {
					gen_loadvar(rbl->before_after->after);
					gen_loadvar(rbl->before_after->before);
					gen_loadvar(rbl->byvar);
					gen_loadvar(rbl->replvar);
					free(rbl->before_after);
					rbl1 = rbl;
					rbl = rbl->next;
					free(rbl1);
					push_immed(rl->options);
				}
			}
			rl1 = rl;
			rl = rl->next;
			free(rl1);
		}
		gen_loadvar(var);
		asm_call("cob_inspect_replacing");
	}
}

void gen_move( struct sym *sy_src, struct sym *sy_dst ) {

#ifdef DEBUG_COMPILER
    fprintf(o_src,"# MOVE %s --> %s\n",sy_src->name,sy_dst->name);
#endif

        gen_loadvar( sy_dst );
	gen_loadvar( sy_src );
	asm_call("cob_move");
}

void gen_set( struct sym *idx, int which, struct sym *var ) {
	if (idx->type != 'B') {
		yyerror("only usage comp variables can be used as indices");
		return;
	}
	fprintf(o_src,"# SET %s \n",idx->name);
	/* first get the second operand */
	value_to_eax( var );
	switch (which) {
	case SET_TO: /* just move this value */
		fprintf(o_src,"\tmovl\t%%eax, -%u(%%ebp)\n",idx->location);
		break;
	case SET_UP_BY: /* we need to add this value to the index */
		fprintf(o_src,"\taddl\t%%eax, -%u(%%ebp)\n",idx->location);
		break;	
	case SET_DOWN_BY:
		fprintf(o_src,"\tsubl\t%%eax, -%u(%%ebp)\n",idx->location);
		break;
	default: 
		yyerror("SET option unavailable");
	}
}

void gen_add( struct sym *s1, struct sym *s2 ) {
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("add");
}

void gen_subtract( struct sym *s1, struct sym *s2 ) {
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("subtract");
}

void gen_multiply( struct sym *s1, struct sym *s2, struct sym *s3 ) {
	gen_loadvar( s3 );
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("multiply");
}

void gen_divide( struct sym *s1, struct sym *s2, struct sym *s3 ) {
	gen_loadvar( s3 );
	gen_loadvar( s2 );
	gen_loadvar( s1 );
	asm_call("divide");
}

void gen_goto( struct sym *sy ) {
	fprintf(o_src,"\tjmp\tB_%s\n",label_name(sy));
}

unsigned long gen_at_end( int status ) {
	int i,j;
	union label_def label;
	i=loc_label++;
	j=loc_label++;

        fprintf(o_src,"\tcmp\t$%d, %%eax\n",status);
        fprintf(o_src,"\tjz\t.L%d\n",j);
        fprintf(o_src,"\tjmp\t.L%d\n",i);

// 	fprintf(o_src,"L%d:\n",j);
	fprintf(o_src,"\t.align 16\n");
	fprintf(o_src,".L%d:\n",j);

        if (stabs_on_sw) {
	   stabs_line();
        }

	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

unsigned long gen_testif( void ) {
	int i,j;
	union label_def label;
	i=loc_label++;
	j=loc_label++;
	fprintf(o_src,"\tjz\t.L%d\n",j);
	fprintf(o_src,"\tjmp\t.L%d\n",i);

// 	fprintf(o_src,"L%d:\n",j);
	fprintf(o_src,"\t.align 16\n");
	fprintf(o_src,".L%d:\n",j);

        if (stabs_on_sw) {
          stabs_line(); 
        }

	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

void gen_not( void ) {
	int i,j;
	i=loc_label++;
	j=loc_label++;

	fprintf(o_src,"\tjz\t.L%d\n",i);
	fprintf(o_src,"\txorl\t%%eax,%%eax\n");
	fprintf(o_src,"\tjmp\t.L%d\n",j);
	fprintf(o_src,".L%d:\tincl\t%%eax\n",i);

// 	fprintf(o_src,"L%d:\n",j);
	fprintf(o_src,"\t.align 16\n");
	fprintf(o_src,".L%d:\n",j);

        if (stabs_on_sw) {
          stabs_line(); 
        }

}

unsigned long gen_andstart( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,"\tjnz\t.L%d\n",i);
	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

unsigned long gen_orstart( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,"\tjz\t.L%d\n",i);
	label.l.n = i;
	label.l.off = label.l.defined = 0;
	return label.x;
}

void gen_dstlabel( unsigned long lbl ) {
	char slab[32];
	union label_def label;
	label.x = lbl;
	sprintf( slab,".L%d",label.l.n );
	fprintf(o_src,".L%d:\n",label.l.n);

        if (stabs_on_sw) {
          stabs_line(); 
        }

}

unsigned long gen_passlabel( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,"\tjmp\t.L%d\n",i);
	label.l.off = label.l.defined = 0;
	label.l.n = i;
	return label.x;
}

unsigned long gen_marklabel( void ) {
	int i;
	union label_def label;
	i=loc_label++;
	fprintf(o_src,".L%d:\n",i);

        if (stabs_on_sw) {
          stabs_line(); 
        }

	label.l.defined = 1;
	label.l.n = i;
	return label.x;
}

void gen_jmplabel( unsigned long lbl ) {
	union label_def label;
	label.x = lbl;
	fprintf(o_src,"\tjmp\t.L%d\n",label.l.n);
}

void gen_push_int( struct sym *sy ) {
	gen_loadloc( sy ); 
	fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
		sy->descriptor);
	push_eax();
	asm_call("get_index");
	/* this must be done without calling push_eax */
	fprintf(o_src,"\tpushl\t%%eax\n");
}

void gen_perform_times( unsigned long lbl ) {
	union label_def label;
	label.x = lbl;
	fprintf(o_src,"\tdecl\t0(%%esp)\n");
	fprintf(o_src,"\tjnz\t.L%d\n",label.l.n);
	fprintf(o_src,"\tpopl\t%%ecx\n");
}

void gen_perform_thru( struct sym *s1, struct sym *s2 ) {
	//stabs_block(0);
	fprintf(o_src,"\tleal\t.L%d, %%eax\n",loc_label);
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tleal\tB_%s, %%eax\n",label_name(s1));
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tleal\tE_%s, %%eax\n",label_name(s2));
//	fprintf(o_src,"\tpushl\t%%ax\n");
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tjmp\tB_%s\n",label_name(s1));

	fprintf(o_src,"\t.align 16\n");
	fprintf(o_src,".L%d:\n",loc_label++);
	//stabs_block(1);

        if (stabs_on_sw) {
          stabs_line(); 
        }

}

void gen_perform( struct sym *sy ) {
	gen_perform_thru( sy, sy );
}

void gen_picture( void ) {
	if (curr_field->type!='G') {
		curr_field->picstr = (char *)malloc(strlen(picture)+1);
		strcpy(curr_field->picstr,picture);
	}
}

int
save_pic_char ( char c ) {
	if (picture[picix] == 0) { /* first char? */
		picture[picix] = c;
		picture[picix+1] = 0;
	}
	switch(c) {
	case 'A':
		piccnt++;
		if (curr_field->type != 'X')
			curr_field->type = 'A';
		break;
	case 'X':
		piccnt++;
		if (curr_field->type == '9')
			curr_field->type = 'X';
		break;
	case 'Z':
		curr_field->type='E';
	case '9':
		piccnt++;
		if (v_flag) decimals++;
		n_flag=1;
		break;
	case 'V':
		if (v_flag)
			yyerror("invalid picture: V already given");
		v_flag=1;
		break;
	case 'P':
		if (!n_flag) 
			v_flag=1; /* implicit V just before the first P */
		if (v_flag)
			decimals++;
		else 
			decimals--;
	case 'S':
		sign=1;
		break;
	case '.':
	case ',':
	case '0':
	case 'B':
	case '/':
	case '+':
	case '-':
	case '*':
/*	case '$': handled in the default case by comparison against currency_symbol */
	case 'C':
	case 'R':
	case 'D':
		curr_field->type='E';
		piccnt++;
		break;
	default:
		if (c == currency_symbol) {
			curr_field->type='E';
			piccnt++;
			break;
			}
		else 
			return 0;
	}
	if (picture[picix] == c)
		picture[picix+1]++;
	else {
		picix+=2;
		picture[picix] = c;
		picture[picix+1]=1;
	}
	return 1;
}

/* increment loop index, check for end */
void gen_SearchLoopCheck(unsigned long lbl5, struct sym *syidx, struct sym *sytbl)
{

   struct sym *sy1, *sy2;
   struct lit *v;
   char tblmax[21];
   int len, i;

   strcpy(tblmax, "1");
   v = (struct lit *)install(tblmax,SYTB_LIT,0);
   save_literal(v, '9');

   gen_add((struct sym *)v, syidx);

   sprintf(tblmax, "%d", sytbl->times);
   v = (struct lit *)install(tblmax,SYTB_LIT,0);
   save_literal(v, '9');

   gen_compare(syidx, GREATER, (struct sym *)v);
   fprintf(o_src,"\tjz\t.L%d\n",lbl5);

   if (stabs_on_sw) {
     stabs_line(); 
   }

}

void gen_SearchAllLoopCheck(unsigned long lbl3, struct sym *syidx, struct sym *sytbl, 
                            struct sym *syvar, unsigned long lstart, unsigned long lend)
{

   struct sym *sy1;
   struct vref *vr1;
//   int len, i;
   struct index_to_table_list *it1, *it2;
   unsigned long l1, l2, l3, l4, l5, l6;

   l1=loc_label++;
   l2=loc_label++;
   l3=loc_label++;
   l4=loc_label++;
   l5=loc_label++;
   l6=loc_label++;

   it1 = index2table;
   it2 = NULL;
   while (it1 != NULL) {
     if (strcmp(it1->tablename, sytbl->name) == 0) {
        it2 = it1;
        it1 = NULL;
     }
     else {
        it1 = it1->next;
     }
   }
   
   if (it2 == NULL ) {
      return;
   }

   if ((it2->seq != '1' ) && (it2->seq != '2' )) {
      return;
   }

#ifdef DEBUG_COMPILER
   if (it2->seq == '1') {
      fprintf(stderr,"gen_SearchAllLoopCheck: sequence for table %s is %c=ASCENDING\n", 
              sytbl->name, it2->seq);
   }
   if (it2->seq == '2') {
      fprintf(stderr,"gen_SearchAllLoopCheck: sequence for table %s is %c=DESCENDING\n", 
              sytbl->name, it2->seq);
   }
   fprintf(stderr,"gen_SearchAllLoopCheck: l1=L%u, l2=L%u, l3=L%u, l4=L%u, l5=L%u, l6=L%u\n",
           l1, l2, l3, l4, l5, l6); 
#endif

   vr1 = create_subscript( syidx );
   sy1 = (struct sym *)create_subscripted_var(sytbl,  vr1); 

   /* table sort sequence: '0' = none, '1' = ASCENDING, '2' = DESCENDING */

   /*    if ((bu - bl) > 1) */
      fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n", stack_offset - 12);
      fprintf(o_src,"\tsubl\t-%u(%%ebp), %%eax\n", stack_offset - 8);

      fprintf(o_src,"\tcmpl $1, %%eax\n");
      fprintf(o_src,"\tjle .L%d\n", l1);

      fprintf(o_src,"\t.align 16\n");

//    if (itbl1 > in) { /* '2' = DESCENDING */
      if (it2->seq == '2') {
         gen_compare(sy1, GREATER, syvar);
         fprintf(o_src,"\tjnz\t.L%d\n",l2);
      }
      else {
         gen_compare(sy1, LESS, syvar);
         fprintf(o_src,"\tjnz\t.L%d\n",l2);
      }
      fprintf(o_src,"\t.align 16\n");

//    bl  = idx + 1;
      fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n", syidx->location);
      fprintf(o_src,"\taddl $1, %%eax\n");
      fprintf(o_src,"\tmovl\t%%eax, -%u(%%ebp)\n", stack_offset - 8);

      gen_jmplabel(l3);           
      fprintf(o_src,"\t.align 16\n");

//    else {
      gen_dstlabel(l2);

//    bu  = idx - 1;
      fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n", syidx->location);
      fprintf(o_src,"\tsubl $1, %%eax\n");
      fprintf(o_src,"\tmovl\t%%eax, -%u(%%ebp)\n", stack_offset - 12);

      gen_dstlabel(l3);

//    idx = ((bu - bl)/2 + bl);
      fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n", stack_offset - 12);
      fprintf(o_src,"\tsubl\t-%u(%%ebp), %%eax\n", stack_offset - 8);
      fprintf(o_src,"\tmovl %%eax, %%edx\n");
      fprintf(o_src,"\tsarl $31, %%edx\n");
      fprintf(o_src,"\tmovl %%edx, %%ecx\n");
      fprintf(o_src,"\tsarl $31, %%ecx\n");
      fprintf(o_src,"\tleal (%%ecx,%%eax), %%edx\n");
      fprintf(o_src,"\tmovl %%edx, %%eax\n");
      fprintf(o_src,"\tsarl $1, %%eax\n");
      fprintf(o_src,"\taddl\t-%u(%%ebp), %%eax\n", stack_offset - 8);
      fprintf(o_src,"\tmovl\t%%eax, -%u(%%ebp)\n", syidx->location);

      gen_jmplabel(l6);
      fprintf(o_src,"\t.align 16\n");

//    else { /* l1 */
      gen_dstlabel(l1);

      if (it2->seq == '2') {
//       if (itbl1 > in) {
         gen_compare(sy1, GREATER, syvar);
         fprintf(o_src,"\tjnz\t.L%d\n",l4);
      }
      else {
//       if (itbl1 < in) {
         gen_compare(sy1, LESS, syvar);
         fprintf(o_src,"\tjnz\t.L%d\n",l4);
      }
      fprintf(o_src,"\t.align 16\n");


//    if (bu > idx) {
      fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n", syidx->location);
      fprintf(o_src,"\tcmpl\t%%eax, -%u(%%ebp)\n", stack_offset - 12);

      fprintf(o_src,"\tjle\t.L%d\n",l5);
      fprintf(o_src,"\t.align 16\n");


//    idx = bu;
      fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n", stack_offset - 12);
      fprintf(o_src,"\tmovl %%eax, -%u(%%ebp)\n", syidx->location);

      gen_jmplabel(l6);
      fprintf(o_src,"\t.align 16\n");

//    else {
      gen_dstlabel(l5);


//    r++;
      fprintf(o_src,"\taddl\t$1, -%u(%%ebp)\n", stack_offset - 4);

      gen_jmplabel(l6); 
      fprintf(o_src,"\t.align 16\n");

//       }
//    }
//    else {
      gen_dstlabel(l4);

//    r++;
      fprintf(o_src,"\taddl\t$1, -%u(%%ebp)\n", stack_offset - 4);

      gen_dstlabel(l6);

      fprintf(o_src,"\tmovl\t-%u(%%ebp), %%eax\n", stack_offset - 4);
      fprintf(o_src,"\tcmpl $1, %%eax\n");
      fprintf(o_src,"\tjz\t.L%d\n",lbl3);


      gen_jmplabel(lstart);
      fprintf(o_src,"\t.align 16\n");
      gen_dstlabel(lend);  

      if (stabs_on_sw) {
        stabs_line(); 
      }

}

void define_special_fields() 
{

	struct sym *sy, *tmp;
	struct lit *ly;

        sy   = install (SVAR_RCODE, SYTB_VAR, 0); 
        ly   = save_special_literal('0','9', "%ZEROS%");
		
	sy->len=5; 
	sy->decimals=0; 
	sy->level=1;
	sy->type='B'; /* assume numeric "usage is comp" item */
	sy->redefines = NULL;
	sy->linkage_flg=at_linkage;
	sy->times=1;
	sy->occurs_flg=0;
	sy->son = sy->brother = NULL;
        picture[0] = '9';
        picture[1] = '5';
        picture[2] = 0;
	tmp=curr_field;
	curr_field = sy;

	curr_field->value=ly;
	curr_field->value2=ly;

        update_field();
	close_fields();
	curr_field=tmp;

	tmp=NULL;
	ly=NULL;

}


int  define_implicit_field(struct sym *sy, struct sym *sykey, int idxlen) 
{
 	int i=1, m=0, d, r=0;
	struct sym *tmp=NULL;
        struct index_to_table_list *i2t;
		
  	for (i=1; i<idxlen; i=i*10) {
     	     m++;
	}
	d = idxlen;
	while (d != 0) {
	  m++;
	  i=i*10;
	  d = idxlen / i;
	}
	
	sy->len=m; 
	sy->decimals=0; /* suppose no decimals yet */
	sy->level=1;
	sy->type='B'; /* assume numeric "usage is comp" item */
	sy->redefines = NULL;
	sy->linkage_flg=at_linkage;
	sy->times=1;
	sy->occurs_flg=0;
	sy->son = sy->brother = NULL;
        picture[0] = '9';
        picture[1] = (char)m;
        picture[2] = 0;
	tmp=curr_field;
	curr_field = sy;
        update_field();
	close_fields();
	curr_field=tmp;
	tmp=NULL;
        
        i2t = malloc(sizeof(struct index_to_table_list));
        if (i2t == NULL) {
           return;
        }
        i2t->next = NULL;
        
        i = strlen(sy->name);
        i2t->idxname = malloc(i + 1);
        if (i2t->idxname == NULL) {
           free(i2t);
           return;
        }
        strcpy(i2t->idxname, sy->name); 

        i = strlen(curr_field->name);
        i2t->tablename = malloc(i + 1);
        if (i2t->tablename == NULL) {
           free(i2t->idxname);
           free(i2t);
           return;
        }
        strcpy(i2t->tablename, curr_field->name); 
        
        i2t->seq = '0'; /* no sort sequence is yet defined for the table */
        i2t->keyname = NULL;
        if (sykey != NULL) {

           if (sykey->level == -1) {
              i2t->seq = '1';
           }

           if (sykey->level == -2) {
              i2t->seq = '2';
           }

           i = strlen(sykey->name);
           i2t->keyname = malloc(i + 1);
           if (i2t->keyname == NULL) {
              free(i2t->idxname);
              free(i2t->tablename);
              free(i2t);
              return;
           }
           strcpy(i2t->keyname, sykey->name); 
        }
                   
        if (index2table == NULL) {
          index2table = i2t;
        }
        else {
          i2t->next = index2table;
          index2table = i2t;
        }

#ifdef DEBUG_COMPILER
      fprintf(stderr, "trace (define_implicit_field): index '%s' table '%s' tablekey '%s' sequence '%c'\n", 
                     i2t->idxname,
                     i2t->tablename,
                     i2t->keyname,
                     i2t->seq
                     );
#endif

        i2t = NULL;

        return r;                
}

void Initialize_SearchAll_Boundaries(struct sym *sy, struct sym *syidx) 
{
   int i;
   struct lit *v;
   char tblmax[21];
   struct index_to_table_list *i2t1, *i2t2;
	
   i = sy->times / 2;

   sprintf(tblmax, "%d", i);
   v = (struct lit *)install(tblmax,SYTB_LIT,0);
#ifdef DEBUG_COMPILER
   if (v->type) { /* not already saved */
      fprintf(stderr,"Initialize_SearchAll_Boundaries: literal is saved: %s\n", tblmax);
    }
    else {
      fprintf(stderr,"Initialize_SearchAll_Boundaries: literal not saved: %s\n", tblmax);
    }
#endif

   save_literal(v, '9');
   gen_move((struct sym *)v, syidx);

   fprintf(o_src,"\tmovl\t$0, %%eax\n");
   fprintf(o_src,"\tmovl\t%%eax,-%u(%%ebp)\n", stack_offset - 4);

   fprintf(o_src,"\tmovl\t$1, %%eax\n");
   fprintf(o_src,"\tmovl\t%%eax,-%u(%%ebp)\n", stack_offset - 8);

   fprintf(o_src,"\tmovl\t$%d, %%eax\n", sy->times);
   fprintf(o_src,"\tmovl\t%%eax,-%u(%%ebp)\n", stack_offset - 12);

   i2t2 = NULL;
   i2t1 = index2table;
   while (i2t1 != NULL) {
     if ( strcmp(i2t1->tablename, sy->name) == 0) {
        if (i2t1->seq != '0') {
           i2t2 = i2t1;
        }        
        i2t1 = NULL;
     }
     else {
        i2t1 = i2t1->next;
     }
   }
   
   if (i2t2 == NULL) {
      yyerror("Undefined sort order and key for table ");
   }
      
}

struct sym* determine_table_index_name(struct sym *sy) 
{
        struct sym *rsy = NULL;
        struct index_to_table_list *i2t;

	i2t=index2table;
	while (i2t != NULL) {
	    if (strcmp(i2t->tablename, sy->name) == 0) 
	    {
              rsy = lookup(i2t->idxname, SYTB_VAR);
	      i2t = NULL;
	    }
	    else {
	      i2t=i2t->next;
	    }
	}

#ifdef DEBUG_COMPILER
      if (rsy == NULL) {
           fprintf(stderr, "trace (determine_table_index_name): table name '%s' index name '(NULL)'\n", 
                     sy->name
                     );
      }
      else {
           fprintf(stderr, "trace (determine_table_index_name): table name '%s' index name '%s'\n", 
                     sy->name,
                     rsy->name
                     );
      }
#endif
        return rsy;
}


void define_field( int level, struct sym *sy ) {
	struct sym *tmp;
	if (sy == NULL) {
		sy = malloc(sizeof(struct sym));
		sy->name = "%noname%";
	}
	if (level == 88) {
		sy->type='8';
		sy->defined=1;
		sy->len=0;
		sy->decimals=0;
		sy->level=level;
		sy->linkage_flg=at_linkage;
		sy->times=1;
		sy->occurs_flg=0;
		sy->son=sy->brother=NULL;
		if (curr_field->level==88) {
			curr_field->brother=sy;
			sy->parent=curr_field->parent;
		}
		else
			sy->parent=curr_field;
		curr_field=sy;
		return;
	}
	sy->len=0;
	sy->decimals=-1; /* suppose no decimals yet */
	sy->level=level;
	sy->type='9'; /* assume numeric (elementary) item */
	sy->redefines = NULL;
	sy->linkage_flg=at_linkage;
	sy->times=1;
	sy->occurs_flg=0;
	sy->son = sy->brother = NULL;
	tmp=curr_field;
	if (tmp && ((level == 1) || (level == 77)))
		close_fields();
	if (!tmp && (level > 1) && (level < 49)) {
		yyerror("data field hierarchy broken");
	}
	if (level != 77) {
		while (tmp != NULL && tmp->level > level)
			tmp=tmp->parent;
		if (tmp == NULL)
			sy->parent = NULL;
		else if (tmp->level < level) {
			sy->parent=tmp;
			if (tmp->son == NULL)
				tmp->son = sy;
			else
				yyerror("malformed data hierarchy");
		}
		else {
			tmp->brother = sy;
			sy->parent = tmp->parent;
		}
	}
	curr_field=sy;
}

void dump_scr_proc() {
	struct list *list;
	struct sym *sy;
	int sw = 0;

	for (list=fields_list;list!=NULL;list=list->next) {
		if ( ((struct sym *)list->var)->type=='D' ) {
	                if (sw == 0) {
	                   fprintf(o_src,"######## screen processing functions ########\n");
	                   sw++;
	                }
			sy=(struct sym *)list->var;
			fprintf(o_src,".LDP%d:\n",sy->scr->label);
			fprintf(o_src,"\tleal\t.LDD%d, %%eax\n",
				sy->scr->label);
			push_eax();
			gen_loadvar(sy->scr->to);
			gen_loadvar(sy->scr->from);
			asm_call("cob_scr_process");
			fprintf(o_src,"\tret\n");
		}
	}
}

void dump_scr_data() {
	struct list *list;
	struct sym *sy;
	for (list=fields_list;list!=NULL;list=list->next) {
		if ( ((struct sym *)list->var)->type=='D' ) {
			sy=(struct sym *)list->var;
			fprintf(o_src,".LDD%d:\n",sy->scr->label);
			fprintf(o_src,"\t.long\t%d,%d,%d\n",
				sy->scr->attr,sy->scr->line,sy->scr->column);
			fprintf(o_src,"\t.word\t%d,%d\n",
				sy->scr->foreground,sy->scr->background);
			fprintf(o_src,"\t.long\t.LDP%d\n",sy->scr->label);
		}
	}
}

struct sym *alloc_filler( void ) {
	char s[15];
	struct sym *sy;
	sprintf(s,"FIL$%05d",filler_num++);
	sy = install(s,SYTB_VAR,0);
	sy->defined=1;
	return sy;
}

int set_field_length( struct sym *sy, int times ) {
	struct sym *tmp;
	int len,tmplen;
	if (sy->son != NULL) {
		len = 0;
		sy->type = 'G';
		for (tmp=sy->son;tmp!=NULL;tmp=tmp->brother) {
			tmplen = tmp->times * set_field_length( tmp, times );
			if (tmp->redefines == NULL)
				len += tmplen;
		}
		sy->len = len;
	}
	len = symlen(sy);
	return len * times;
}

void set_field_location( struct sym *sy, unsigned location ) {
	struct sym *tmp;
	/********* allocate field descriptor *************/
	sy->descriptor = literal_offset;
	literal_offset += (sy->type=='G' ? 7 : 11);
	/********* generate picture for field ************/
	if (sy->type!='G') {
		sy->pic = literal_offset;
		literal_offset += (strlen(sy->picstr)+1);
	}
	else
		sy->decimals = sy->pic = 0;
	save_field_in_list( sy );
	if (sy->redefines != NULL)
		location = sy->redefines->location;
	sy->location = location;
	for (tmp=sy->son;tmp!=NULL;tmp=tmp->brother) {
		set_field_location( tmp,location );
		if (tmp->redefines == NULL)
			location -= symlen(tmp) * tmp->times;	
				/* negative for it's at the stack */
	}
}

void scr_set_column( struct scr_info *si, int val, int plus_minus) {
	switch (plus_minus) {
	case -1:
			scr_column -= val;
			break;
	case 1:
			scr_column += val;
			break;
	case 0:
			scr_column = val;
			break;
	}
	si->column = scr_column;
}

void scr_set_line( struct scr_info *si, int val, int plus_minus) {
	switch (plus_minus) {
	case -1:
			scr_line -= val;
			break;
	case 1:
			scr_line += val;
			break;
	case 0:
			scr_line = val;
			break;
	}
	si->line = scr_line;
}

void update_screen_field( struct sym *sy, struct scr_info *si ) { 
	update_field();
	sy->type = 'D';
	sy->scr = si;	
	si->label = screen_label++;
}

void update_field( void ) {
	if (curr_field->level != 88)
		gen_picture();
}

void close_fields( void ) {
	struct sym *sy;
	if (curr_field == NULL) return;
	/********** locate level 01 field   **************/
	for (sy=curr_field;sy->parent!=NULL;sy=sy->parent) ;
	if (sy->level != 1 && sy->level != 77) {
		yyerror("field not subordinate to any other: %s",sy->name);
	}
	/********** update length of fields  *************/
	if (sy->linkage_flg) {
		linkage_offset += (set_field_length( sy,1 ) * sy->times);
		set_field_location( sy,linkage_offset );
	}
	else {
		stack_offset += (set_field_length( sy,1 ) * sy->times);
		set_field_location( sy,stack_offset );
	}
	curr_field=NULL;
}

void open_section( struct sym *sect ) {
	sect->type='S';
	fprintf(o_src,"B_%s:\n",label_name(sect));
//	fprintf(o_src,"B_%s:\n",sect->name);
	curr_section=sect;
}

void close_section( void ) {
	if (curr_section)
		fprintf(o_src,"E_%s:\n",label_name(curr_section));
//		fprintf(o_src,"E_%s:\n",curr_section->name);
	close_paragr();
}

char * label_name ( struct sym *lab ) {
	if (lab->parent) { 
		strcpy(name_buf,lab->name);
		strcat(name_buf,"__");
		strcat(name_buf,lab->parent->name);
                chg_underline(name_buf);
		return name_buf;
	}
	strcpy(name_buf,lab->name);
        chg_underline(name_buf);
	return name_buf;
//	return lab->name;
}

char * var_name ( struct sym *sy ) {
	int n;
	n = MAXNAMEBUF;
	strcpy(name_buf,"");
    while (n > strlen(sy->name)+4) {
		if (n < MAXNAMEBUF) 
			strcat( name_buf," OF ");
		strcat( name_buf,sy->name );
		n -= strlen(sy->name)+4;
		if ((lookup(sy->name,SYTB_VAR)->clone == NULL)
			|| (sy->parent == NULL))
				break;
		sy = sy->parent;
	}
	return name_buf;
}

void close_paragr( void ) {
	if (curr_paragr) {
		fprintf(o_src,"E_%s:\n", label_name( curr_paragr ) );
		/*fprintf(o_src,".stabn\t192,0,0,B_%s-main\n",
			label_name( curr_paragr ));
		fprintf(o_src,".stabn\t224,0,0,E_%s-main\n",
			label_name( curr_paragr ));*/
		gen_exit(0);
		curr_paragr=NULL;
	}
}

void open_paragr( struct sym *paragr ) {
	paragr->type='P';
	curr_paragr=paragr;
	fprintf(o_src,"B_%s:\n", label_name( paragr ) );
}

void gen_stoprun( void ) {
	fprintf(o_src,"\tleal\t__end_pgm, %%eax\n");
	fprintf(o_src,"\tpushl\t%%eax\n");
	fprintf(o_src,"\tjmp\t__end_pgm\n");	
}

void gen_exit( int code ) {
	int l1,l2;
	if (code) {
		fprintf(o_src,"\tmov\t%%ebp,%%esp\n");
		fprintf(o_src,"\tpop\t%%ebp\n");
		fprintf(o_src,"\tret\n");
	}
	else {
		//fprintf(o_src,"\tleal\tE_%s, %%eax\n",label_name(curr_paragr));
		//push_eax();
		//asm_call("exit_paragraph");
		l1 = loc_label++;
		l2 = loc_label++;
		fprintf(o_src,"\tleal\tE_%s, %%eax\n",label_name(curr_paragr));
		fprintf(o_src,"\tcmpl\t4(%%esp), %%eax\n");
		fprintf(o_src,"\tjb\t\t.L%d\n",l1);
		fprintf(o_src,"\tcmpl\t0(%%esp), %%eax\n");
		fprintf(o_src,"\tjb\t\t.L%d\n",l2);
		fprintf(o_src,".L%d:\n",l1);
		fprintf(o_src,"\taddl\t$8,%%esp\n");
		fprintf(o_src,"\tret\n");
		fprintf(o_src,".L%d:\n",l2);
	}
}

void gen_condition( struct sym *sy ) {
	gen_loadvar((struct sym *)sy->value2);
	gen_loadvar((struct sym *)sy->value);
	gen_loadvar(sy->parent);
	asm_call("check_condition");
	fprintf(o_src,"\tand\t%%eax,%%eax\n");
}

void gen_compare( struct sym *s1, int value, struct sym *s2 ) {
	/*gen_loadloc(s2);
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",s2->descriptor);
	push_eax();
	gen_loadloc(s1);
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",s1->descriptor);
	push_eax();*/
	gen_loadvar(s2);
	gen_loadvar(s1);
	asm_call("compare");
	switch (value) {
	case 0: fprintf(o_src,"\txor\t%%eax,%%eax\n\tinc\t%%eax\n"); /* false */
		break;
	case 1: fprintf(o_src,"\tand\t%%eax,%%eax\n"); /* equal */
		break;
	case 2: fprintf(o_src,"\tinc\t%%eax\n"); /* less */
		break;
	case 3: fprintf(o_src,"\tdec\t%%eax\n"); /* less or equal */
		gen_not();
		break;
	case 4:	fprintf(o_src,"\tdec\t%%eax\n"); /* greater */
		break;
	case 5: fprintf(o_src,"\tinc\t%%eax\n"); /* greater or equal */
		gen_not();
		break;
	case 6: fprintf(o_src,"\tand\t%%eax,%%eax\n"); /* not equal */
		gen_not();
		break;
	case 7:	fprintf(o_src,"\txor\t%%eax,%%eax\n"); /* true */
		break;
	}
}

void assign_expr( struct sym *sy ) {
	gen_loadvar( sy );
	stackframe_cnt += 8; /* value to be poped too */
	asm_call("assign_double");
//	fprintf(o_src,"\taddl\t$16, %%esp\n"); /* pop expr also */
}

void push_expr( struct sym *sy ) {
	fprintf(o_src,"\tsubl\t$8, %%esp\n");
	gen_loadvar( sy );
	asm_call("push_double");
}

void add_expr( void ) {
	asm_call("add_double");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
}

void subtract_expr( void ) {
	asm_call("subtract_double");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
}

void multiply_expr( void ) {
	asm_call("multiply_double");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
}

void divide_expr( void ) {
	asm_call("divide_double");
	fprintf(o_src,"\taddl\t$8, %%esp\n");
}

static void gen_save_filevar( struct sym *f, struct sym *buf ) {
	if (buf!=NULL) {
		gen_loadloc( buf );
	}
	else {
#ifdef DEBUG_COMPILER
    		fprintf(o_src,"# File '%s' Record Description Stack Location\n",f->name);
#endif

		fprintf(o_src,"\tleal\t-%u(%%ebp), %%eax\n",f->record);
		push_eax();
	}
	if (f->type=='K')
		fprintf(o_src,"\tmovl\t$_%s, %%eax\n",f->name);
	else
#ifdef DEBUG_COMPILER
    		fprintf(o_src,"# File name '%s', Record name '%s'\n",f->name, f->recordsym->name);
#endif
		fprintf(o_src,"\tmovl\t$s_base+%u, %%eax\n",f->location);
	push_eax();
}

static void gen_prtvar( struct sym *r, struct sym *buf ) {
	struct sym *f;
	f=r->ix_desc;
	if (buf!=NULL)
		gen_loadloc( buf );
	fprintf(o_src,"\tleal\t-%u(%%ebp), %%eax\n",f->record);
	push_eax();
	if (buf != NULL)
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",buf->len);
	else
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",r->len);
	push_eax();
}

static void
gen_save_sort_fields( struct sym *f, struct sym *buf ) {
	struct sym *datafld;
	datafld = (struct sym *)f->sort_data;
	while (datafld!=NULL) {
		gen_loadloc( datafld );
		datafld=(struct sym *)(datafld->sort_data);
	}
	fprintf(o_src,"\tmovl\t$v_base+%u, %%eax\n",f->descriptor);
	push_eax();
	gen_save_filevar( f,buf );
	/* returns number of stack levels used in storing fields */
}

void alloc_file_entry( struct sym *f ) {
	f->record = stack_offset;
#ifdef DEBUG_COMPILER
//  	fprintf(o_src,"# Alloc space for file ENTRY, Stack Addr: %d\n",
//  			stack_offset);
 	fprintf(o_src,"# Allocate space for file '%s' Stack Addr: %d\n",
 			f->name, stack_offset);
#endif
}

void
dump_alternate_keys( struct sym *r, struct alternate_list *alt ) {
	struct alternate_list *tmp;
	struct sym *key;
	while (alt) {
		key = alt->key;
		fprintf(o_src,"# alternate key %s\n",key->name);
		fprintf(o_src,
//			"\t.word\t%d\n\t.long\tv_base+%d,0\n\t.word\t%d\n",
			"\t.word\t%d\n\t.long\tv_base+%d\n\t.word\t%d\n\t.long\t0\n",
			r->location - key->location,
			key->descriptor,alt->duplicates );
		tmp = alt;
		alt = alt->next;
		free(tmp);
	}
	fprintf(o_src,"# end of alternate keys\n.word\t-1\n");
}

/* 
** dump all file descriptors in file_list
*/
void dump_fdesc() {

	struct sym *f;
	struct sym *r;
	struct list *list,*visited;
	//fprintf(o_src,".data\n\t.align 4\n");
//	fprintf(o_src,"s_base:\n");
	if (files_list != NULL) {
	   fprintf(o_src,"s_base:\n");
	}
	for (list=files_list;list!=NULL;list=list->next) {
		f=(struct sym *)list->var;
		r=f->recordsym;
#ifdef DEBUG_COMPILER
// 	fprintf(o_src,"# FILE DESCRIPTOR, File: %s, Record: %s, Data Loc: %d(%x)\n",
// 			f->name,r->name,global_offset);
	fprintf(o_src,"# FILE DESCRIPTOR, File: %s, Record: %s, Data Loc: %d(hex: %x)\n",
			f->name,r->name,f->location,f->location);
#endif
		if (f->type=='K') {
			fprintf(o_src,"\t.extern\t_%s:far\n",f->name);
			continue;
		}
		if (f->type=='J') {
			fprintf(o_src,"\tpublic\t_%s\n",f->name);
			fprintf(o_src,"_%s\tlabel\tbyte\n",f->name);
		}
		fprintf(o_src,"\t.long\tv_base+%u\n",
			f->filenamevar->descriptor);
		fprintf(o_src,"\t.word\t%u\n",r->len);
		fprintf(o_src,"\t.byte\t%d,%d\n",f->organization,f->access_mode);
		fprintf(o_src,"\t.long\t0\n");  /* open_mode */
		fprintf(o_src,"\t.long\t0\n"); /* struct DBT (libdb) */
		if (f->organization==1) {  /* indexed file */
			if (f->ix_desc) {
				fprintf(o_src,"\t.word\t%d\n\t.long\tv_base+%d\n",
					r->location - f->ix_desc->location,
					f->ix_desc->descriptor );
			}
			else {
				/* no key field was given for this file */
				fprintf(o_src,"\t.word\t0\n\t.long\t0\n");
			}
			fprintf(o_src,"\t.long\t0\n"); /* struct altkey_desc *key_in_use */
			dump_alternate_keys( r,
				(struct alternate_list *)f->alternate);
		}
	}
}

/*
** define a file, but don't generate code yet.
** (will be done later at dump_fdesc())
*/
void gen_fdesc( struct sym *f, struct sym *r ) {
	int len;
	struct list *list, *templist;
	struct alternate_list *alt;
	list = (struct list *)malloc(sizeof(struct list));
	
	if (files_list==NULL) { 
	   files_list = list;
	}
	else {
  	   templist=files_list; 
  	   while (templist->next != NULL) {
  	     templist=templist->next;
  	   }
	   templist->next = list;
	}
	list->var = f;
	list->next = NULL;

	r->ix_desc = f;
	f->recordsym = r;
	len=16; /* suppose without indexes */

	f->location = file_offset;

	if (f->organization==1) { /* indexed file */
		len += 11;
		/* now count each alternate description size */
		alt = (struct alternate_list *)f->alternate;
		while (alt) {
			len += 12;
			alt = alt->next;
		}
	}
	f->fdesc = global_offset;
	global_offset += len;
	
	file_offset += len;

}

void gen_status( struct sym *f ) {
	if (f->parent) {
		push_eax();
		gen_loadloc( f->parent );
		asm_call("cob_save_status");
	}
}

void gen_sort( struct sym *f ) {
	gen_loadloc( f->filenamevar );
	gen_save_filevar( f,NULL );
	asm_call("sort_open");
	gen_status(f);
}

void gen_open( int mode, struct sym *f ) {
	fprintf(o_src,"\tmovl\t$%d, %%eax\n",mode);
	push_eax();
	gen_loadloc( f->filenamevar );
	gen_save_filevar( f,NULL );
	asm_call("cob_open");
	gen_status(f);
}

void gen_close_sort( struct sym *f ) {
	struct sym *sortf;
	/********** allocate memory for SORT descriptor ***********/
	save_field_in_list( f );
	f->descriptor = literal_offset;
	sortf=(struct sym *)(f->sort_data);
	while (sortf!=NULL) {
		literal_offset += 2;
		sortf = (struct sym *)(sortf->sort_data);
	}
	literal_offset++;
}

void gen_close( struct sym *f ) {
	gen_save_filevar( f,NULL );
	asm_call("cob_close");
	gen_status(f);
}

void gen_return( struct sym *f, struct sym *buf ) {
	gen_save_filevar( f,buf );
	asm_call("sort_return");
	gen_status(f);
}

void gen_read( struct sym *f, struct sym *buf, struct sym *key ) {
	if (f->organization==ORG_RELATIVE) {
			/*gen_loadloc( f->ix_desc );
			fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
				f->ix_desc->descriptor);
			push_eax();*/
			gen_loadvar( f->ix_desc );
			asm_call("get_index");
			push_eax();
	}
	if (f->organization==ORG_INDEXED) {
		gen_loadvar( key );
	}
	gen_save_filevar( f,buf );
	asm_call("cob_read");
	gen_status(f);
}

void gen_read_next( struct sym *f, struct sym *buf, int next_prev ) {
	gen_save_filevar( f,buf );
	if (next_prev == 1)
		asm_call("cob_read_next");
	else
		asm_call("cob_read_prev");
	gen_status(f);
}

void gen_release( struct sym *r, struct sym *buf ) {
	struct sym *f;
	f=r->ix_desc;
	if (buf!=NULL)
	{
		gen_move(buf, r);
	}
	gen_save_sort_fields( f,buf );
	asm_call("sort_release");
	gen_status(f);
}

void gen_write( struct sym *r, int opt, struct sym *buf ) {
	struct sym *f;
	f=r->ix_desc;
	if (opt) {
		fprintf(o_src,"\tmovl\t$%d, %%eax\n",opt);
		push_eax();
	}
	if (opt) {
		gen_save_filevar( f,buf );
		if (buf==NULL)
			asm_call("cob_write_adv");
		else
		{
			gen_move(buf, r);
//			asm_call("cob_write_adv_from");
			asm_call("cob_write_adv");
		}
	}
	else {
		if (f->organization==ORG_RELATIVE) { 
				/*gen_loadloc( f->ix_desc );
				fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
					f->ix_desc->descriptor);
				push_eax();*/
				gen_loadvar( f->ix_desc );
				asm_call("get_index");
				push_eax();
		}
		gen_save_filevar( f,buf );
		asm_call("cob_write");
	}
	gen_status(f);
}

void gen_rewrite( struct sym *r, struct sym *buf ) {
	struct sym *f;
	f=r->ix_desc;
	if (f->organization==ORG_RELATIVE) { 
			/*gen_loadloc( f->ix_desc );
			fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
				f->ix_desc->descriptor);
			push_eax();*/
			gen_loadvar( f->ix_desc );
			asm_call("get_index");
			push_eax();
	}
	gen_save_filevar( f,buf );
	asm_call("cob_rewrite");
	gen_status(f);
}

void gen_start( struct sym *f, int cond, struct sym *key ) {
	if (f->organization==ORG_RELATIVE) { 
			/*gen_loadloc( f->ix_desc );
			fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
				f->ix_desc->descriptor);
			push_eax();*/
			gen_loadvar( f->ix_desc );
			asm_call("get_index");
			push_eax();
	} else {
		gen_loadvar(key);
	}
	push_immed(cond);	
	gen_save_filevar( f,NULL );
	asm_call("cob_start");
	gen_status(f);
}

void gen_delete( struct sym *f ) {
	if (f->organization==ORG_RELATIVE) { 
			/*gen_loadloc( f->ix_desc );
			fprintf(o_src,"\tmovl $v_base+%u, %%eax\n",
				f->ix_desc->descriptor);
			push_eax();*/
			gen_loadvar( f->ix_desc );
			asm_call("get_index");
			push_eax();
	}
	gen_save_filevar( f,NULL );
	asm_call("cob_delete");
	gen_status(f);
}

void gen_push_using( struct sym *sy ) {
	struct list *list;
	if (sy->type=='F')
		yyerror("file could not be used as parameter in a CALL");
	list = (struct list *)malloc(sizeof(struct list));
	list->var = (void *)sy;
	list->next = parameter_list;
	parameter_list = list;
}

void gen_save_using( struct sym *sy ) {
	sy->linkage_flg = using_offset;
	using_offset += 4;
}

void gen_call( struct lit *v, int stack_size ) {
	struct list *list,*tmp;
	/******** get the parameters from the parameter list ********/
	for (list=parameter_list;list!=NULL;) {
		//gen_loadvar((struct sym *)list->var);
		gen_loadloc((struct sym *)list->var);
		tmp=list;
		list=list->next;
		free(tmp);
	}
	parameter_list=NULL;
	asm_call(v->name);
	//fprintf(o_src,"\taddl\t$%d, %%esp\n",stack_size*2);
}

void gen_init_field( struct sym *sy ) {
	struct sym *spe_sy;
	static struct sym *spe_sy_x = NULL;
	static struct sym *spe_sy_9 = NULL;
	
	if (sy->type=='F') {
		yyerror("file could not be used as parameter in an INITIALIZE");
		return;
	}
#ifdef DEBUG_COMPILER
	fprintf(o_src,"# INITIALIZE %s, type %c\n",sy->name,sy->type);
#endif
	if (sy->type=='B' || sy->type=='9' || sy->type=='C') {
		if (spe_sy_9==NULL) {
		    spe_sy_9 = lookup("%ZEROS%", SYTB_LIT);
		    if (spe_sy_9==NULL) {
			    spe_sy_9 = (struct sym *)save_special_literal('0','9',"%ZEROS%");
			}   
		}	
		spe_sy = spe_sy_9;
	}
	else {
		if (spe_sy_x==NULL) {
		    spe_sy_x = lookup("%SPACES%", SYTB_LIT);
		    if (spe_sy_x==NULL) {
			    spe_sy_x = (struct sym *)save_special_literal(' ','X',"%SPACES%");
			}   
		}	
		spe_sy = spe_sy_x;
	}
	gen_move(spe_sy, sy);
}

void gen_init_group(struct sym *sy_start ) {
	struct sym *sy;

	for(sy=sy_start->son;sy!=NULL;sy=sy->brother) {
		if (sy->type=='G')
			gen_init_group(sy);
		else
			gen_init_field(sy);	
	}
}

void gen_initialize( struct sym *sy_start ) {
	struct sym *sy;
//	Possible optimizations in case of groups:
//	1) One big literal and one gen_move
//	2) One gen_move with spaces for complete length and one gen_move for each non space elementary field
//      Currently brute force
	if (sy_start==NULL) return;
	if (sy_start->type=='G') {
		gen_init_group(sy_start);
	}
	else {
		gen_init_field(sy_start);
	}
}

void mark_actives( int first, int last ) {
	int i;
	if (last<first) last=first;
	if (first<0 || first>36) first=0;
	if (last<0 || last>36) last=0;
	for (i=first;i<=last;i++) active[i]=1;
}

void dump_symbols( ) {
	int i;
	struct sym *sy,*sy1;
	char t,*s;
	if (!HTG_list_flag) return;
	fprintf(o_lst,"-------------------------------------------------+---------------\n");
	fprintf(o_lst,"Symbol ( Variables )      Type Level Len Dec Mul | Desc Loc  Pic\n");
	fprintf(o_lst,"-------------------------------------------------+---------------\n");
	for (i=0;i<HASHLEN;i++) {
	    for (sy1=vartab[i];sy1!=NULL;sy1=sy1->next) {
			t=sy1->type;
			for (sy=sy1;sy;sy=sy->clone) {
				if (sy->type == 0) {
					fprintf(stderr,
						"\n*** Fatal error, variable %s not defined ***\n",
						sy->name);
					exit(8);
				}
				s = var_name(sy);
				fprintf(o_lst,
					"%26.26s%4c %5d %3d %3d %3d%c| %04X %04X%c%04X\n",
					s,
					sy->type,
					sy->level,
					sy->len,
					sy->decimals,
					sy->times,
					sy->occurs_flg ? '*' : ' ',
					sy->descriptor,
					sy->location,
					sy->linkage_flg ? '*' : ' ',
					sy->pic );
				/* print exceeding part of qualified symbol name */
				while (strlen(s) > 26) {
					s+=26;
					fprintf(o_lst,"%-26.26s\n",s);
				}
			}
	    }
	}
	fprintf(o_lst,"\n-----------------------------------------------\n");
	fprintf(o_lst,"Symbol ( 88-condition )       Variable tested");
	fprintf(o_lst,"\n-----------------------------------------------\n");
	for (i=0;i<HASHLEN;i++) {
	    for (sy=vartab[i];sy!=NULL;sy=sy->next) {
			t=sy->type;
			if (t=='8')
				fprintf(o_lst,"%22.22s %22.22s\n",
					sy->name,
					sy->parent->name);
	    }
	}
	fprintf(o_lst,"\n------------------------------------------\n");
	fprintf(o_lst,"Symbol ( Paragraphs & Sections ) Type Def \n");
	fprintf(o_lst,"------------------------------------------\n");
	for (i=0;i<HASHLEN;i++) {
	    for (sy=labtab[i];sy!=NULL;sy=sy->next) {
			t=sy->type;
			sy1 = sy;
			while (sy1) {
				fprintf(o_lst,"%32.32s %4c %3d\n",
					sy1->name,
//					label_name(sy1),
					sy1->type,
					sy1->defined );
				sy1=sy1->clone;
			}	
		}
  	}
}

void chg_underline( char *s ) {
	char *s1;
	while ((s1=strchr(s,'-'))!=NULL) *s1='_';
}

int main(int argc, char *argv[] )
{
int rc;

	rc=process_command_line(argc,argv);
	if (rc > 4)
           { exit(rc); }

        if (HTG_verbose == TRUE )  {
	   printf("Processing '%s'\n", inputname);
	}
//	printf("Processing '%s'\n", inputname);

	install_reserved();

        if (HTG_verbose == TRUE ) {
	   printf("Begining compile process ...\n");
	}
//	printf("Begining compile process ...\n");

//yydebug=1;
	yyparse();
// dcs(); /* this is to test the copy statement replacements */

        if (HTG_verbose == TRUE ) {
// 	    printf("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
// 	    printf("+                                                            +\n");
// 	    printf("+                    COMPILER SUMMARY                        +\n");
// 	    printf("+                                                            +\n");
// 	    printf("+ Lines compiled        : %4d                               +\n",lineno);
// 	    printf("+ Number of warnings    : %4d                               +\n",wrncnt);
// 	    printf("+ Number of errors found: %4d                               +\n",errcnt);
// 	    printf("+                                                            +\n");
// 	    printf("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
// 	    printf("Writing listing tables...");

	    printf("Compiler summary:\n");
	    printf("Lines compiled        : %4d\n",lineno);
	    printf("Number of warnings    : %4d\n",wrncnt);
	    printf("Number of errors found: %4d\n",errcnt);
	    printf("Writing listing tables ... ");
	}

	dump_symbols();

        if (HTG_verbose == TRUE ) {
	   printf("(done)\nUsed stack words: %d\n",stack_offset/2);
	}
//	printf("(done)\nUsed stack words: %d\n",stack_offset/2);
	if (HTG_list_flag)
		fclose(o_lst);
	fclose(o_src);
	fclose(yyin);

	if (lineno < 1)
	   {
	   exit(16);
	   }

	rc=process_assemble();
	if (rc > 0)
	   {
	   exit (8);
	   }
	
	rc=process_ld();
	if (rc > 0)
	   {
	   exit(8);
	   }
	do_file_cleanup();

//	printf("\nCompiling done!\n");
        if (HTG_verbose == TRUE ) {
	   printf("Compiler return code %d\n", HTG_RETURN_CODE);
	}
//	printf("Compiler return code %d\n", HTG_RETURN_CODE);

	return HTG_RETURN_CODE;
	
}

/* end of MCOBGEN.C */
