%{
/* 
**  Parser for Cobol Compiler
**
 */
#define YYDEBUG 1


#include <stdio.h>
#include <stdlib.h>
#include <string.h> 

#include <stdarg.h>
#if defined(SunOS)
va_list __builtin_va_alist;
#endif

#include <ctype.h>

#include "htcoboly.h"
#include "htcoblib.h"
#include "htglobals.h"

extern int screen_io_enable,scr_line,scr_column;
extern int decimal_comma;
extern char currency_symbol;
extern int errcnt;
extern int lineno;
extern FILE *lexin;
extern FILE *o_src;
extern struct sym *curr_paragr,*curr_section;
extern struct sym *curr_field;
extern struct sym *pgm_id;
extern unsigned stack_offset;   /* offset das variaveis na pilha */
extern unsigned global_offset;  /* offset das variaveis globais (DATA) */
extern int paragr_num;
extern int loc_label;
extern char picture[];
extern int picix,piccnt,decimals,sign,v_flag;
extern int at_linkage,stack_plus;
extern char *toktext;
extern int yylex(void);
extern struct index_to_table_list *index2table;

struct sym *curr_file;
struct sym *alloc_filler( void );
int curr_division=0;
extern char *include_filename;
extern char *yytext;

extern int stabs_on_sw;

unsigned long lbend, lbstart;
unsigned int perform_after_sw;

%}

%union {
    struct sym *sval;       /* symbol */
    int ival;               /* int */
    struct coord_pair pval; /* lin,col */
    struct lit *lval;       /* literal */
    unsigned long dval;     /* label definition, compacted */
    char *str;
    struct vref *rval;      /* variable reference (with subscripts) */
    struct string_from *sfval; /* variable list in string statement */
    struct unstring_delimited *udval;
    struct unstring_destinations *udstval;
    struct tallying_list *tlval;
    struct tallying_for_list *tfval;
    struct replacing_list *repval;
    struct replacing_by_list *rbval;
    struct inspect_before_after *baval;
    struct scr_info *sival;
    struct perf_info *pfval;
    struct perform_info *pfvals;
}

%nonassoc LOW_PREC

%token <str>  IDSTRING
%token <sval> STRING,VARIABLE
%token <sval> LABELSTR,CMD_LINE,ENVIRONMENT_VARIABLES
%token <ival> CHAR,MULTIPLIER
%token <ival> USAGENUM,ZERONUM,DIVISNUM,CONNECTIVE,CONDITIONAL
%token <ival> COMMENTING,DIRECTION,READ,WRITE,INPUT_OUTPUT
%token <lval> NLITERAL,CLITERAL
%token <ival> PORTNUM,OPENMD,DATE_TIME

%left   '+','-'
%left   '*','/'

%left  OR
%left  AND
%right NOT

%token BEFORE,AFTER,SCREEN,REVERSEVIDEO,NUMBERTOK,PLUS,MINUS,SEPARATE
%token FOREGROUNDCOLOR,BACKGROUNDCOLOR,UNDERLINE,HIGHLIGHT,LOWLIGHT
%token RIGHT,AUTO,REQUIRED,FULL,JUST,BLINK,SECURE,BELL,COLUMN
%token INITIALTOK,FIRSTTOK,ALL,LEADING,OF,IN,COPY,BY,STRINGCMD,UNSTRING
%token START,DELETE,DATE_TIME,PROGRAM,GLOBAL,EXTERNAL,SIZE,DELIMITED
%token GIVING,ERASE,INSPECT,TALLYING,REPLACING,ONTOK,POINTER,OVERFLOWTK
%token DELIMITER,COUNT,LEFT,TRAILING,CHARACTER
%token ADD,SUBTRACT,MULTIPLY,DIVIDE
%token FD,SD,REDEFINES,PIC,FILLER,OCCURS,TIMES
%token PROGRAM_ID,DIVISION,CONFIGURATION,SPECIAL_NAMES
%token FILE_CONTROL,I_O_CONTROL
%token SAME,AREA,ESCAPE
%token ECHOT,FROM,UPDATE
%token WORKING_STORAGE,LINKAGE,DECIMAL_POINT,COMMA
%token FILEN,USAGE,BLANK
%token SIGN,VALUE,MOVE,LABEL,DARK
%token RECORD,OMITTED,STANDARD,RECORDS,BLOCK
%token CONTAINS,CHARACTERS,COMPUTE,GO,STOP,RUN
%token ACCEPT,PERFORM,VARYING,UNTIL,EXIT
%token IF,ELSE,NEXT,SENTENCE,LINE,PAGETOK
%token OPEN,CLOSE,REWRITE
%token ADVANCING,INTO,AT,END,NEGATIVE,POSITIVE,SPACES,NOT
%token CALL,USING,INVALID
%token SELECT,ASSIGN,DISPLAY,UPON,CONSOLE,STD_OUTPUT,STD_ERROR
%token ORGANIZATION,ACCESS,MODE,KEY,STATUS,ALTERNATE
%token SEQUENTIAL,INDEXED,DYNAMIC,RANDOM,RELATIVE
%token SECTION,SORT,DUPLICATES,WITH
%token QUOTES,LOWVALUES,HIGHVALUES,LISTSEP,NOTEXCEP
%token SET,UP,DOWN
%token TRACE,READY,RESET
%token SEARCH,WHEN,TEST
%token END_ADD,END_CALL,END_COMPUTE,END_DELETE,END_DIVIDE,END_EVALUATE
%token END_IF,END_MULTIPLY,END_PERFORM,END_READ,END_REWRITE,END_SEARCH
%token END_START,END_STRINGCMD,END_SUBTRACT,END_UNSTRING,END_WRITE
%token THEN,EVALUATE,OTHER,ALSO,CONTINUE,CURRENCY,REFERENCE,INITIALIZE

%right OF
%nonassoc EOS

%type <ival> organization_options,access_options,open_mode
%type <ival> integer,cond_op,before_after
%type <ival> IF,ELSE,usage,write_options,opt_next,echo_options
%type <ival> division_id,pic_char,opt_program,using_options,using_parameters
%type <dval> if_part 
%type <sval> anystring,name,gname,opt_def_name,def_name,procedure_section
%type <sval> field_description,label,filename,noallname,paragraph
%type <lval> literal,gliteral,without_all_literal,all_literal,special_literal
%type <lval> nliteral
%type <pval> coordinates
%type <sval> accept_part,sort_keys,opt_perform_thru
%type <sval> read_into,write_from
%type <sval> variable,def_var,perform_range,perform_options,name_or_lit,delimited_by
%type <sval> string_with_pointer
%type <ival> opt_all,with_duplicates,opt_with_test
%type <rval> subscript,subscripts
%type <sfval> string_from_list,string_from
%type <sval> opt_unstring_count,opt_unstring_delim,unstring_tallying
%type <udval> unstring_delimited_vars,unstring_delimited
%type <udstval> unstring_destinations,unstring_dest_var
%type <baval> inspect_before_after
%type <tlval> tallying_list, tallying_clause
%type <tfval> tallying_for_list
%type <ival> replacing_kind,opt_plus_minus
%type <repval> replacing_list, replacing_clause
%type <rbval> replacing_by_list
%type <sval> var_or_nliteral,read_key
%type <sival> screen_clauses
%type <ival> screen_attrib,sign_clause,opt_separate
%type <sval> variable_indexed,search_opt_varying,opt_key_is
%type <dval> search,search_all,search_when,search_all_when,search_opt_at_end
%type <sval> parm_list,parameter
%type <pfval> perform_after
%type <pfvals> opt_perform_after

%%
%{
void yyunion( YYSTYPE *to, YYSTYPE *from );
%}
/************   Parser for Cobol Source  **************/

program:
    division_id DIVISION EOS {
        if ($1!=IDENTIFICATION)
            hterror(1,12,"IDENTIFICATION DIVISION expected");
        curr_division = CDIV_IDENT;
        }
        identification_division { }
    division_id DIVISION EOS {
        if ($7!=ENVIRONMENT)
            yyerror("ENVIRONMENT DIVISION expected");
        { define_special_fields(); }
        curr_division = CDIV_ENVIR;
        }
        environment_division
    division_id DIVISION EOS {
        if ($12!=DATA)
            yyerror("DATA DIVISION expected");
        curr_division = CDIV_DATA;
        }
        data_division       { data_trail(); }
    division_id DIVISION { curr_division = CDIV_PROC; }
        using_parameters EOS {
            if ($18!=PROCEDURE)
                yyerror("PROCEDURE DIVISION expected");
            proc_header($21);
        }
        procedure_division  {
            /* close procedure_division sections & paragraphs */
            close_section(); /* this also closes paragraph */
            proc_trail($21); }
    ;
division_id:
    DIVISNUM
    ;
identification_division:
    PROGRAM_ID "." IDSTRING EOS { 
        curr_division = CDIV_COMMENT;
        pgm_header($3); }
    ;
environment_division:
    opt_configuration
    opt_input_output
    ;
opt_configuration:
    CONFIGURATION SECTION EOS configuration_section 
    | copy_stat
    | /*nothing */
    ;
opt_input_output:
    INPUT_OUTPUT SECTION EOS input_output_section
    | /*nothing */
    ;
configuration_section:
    configuration_section configuration_option  { }
    | /* nothing */                 { }
    ;
configuration_option:
    COMMENTING "." STRING EOS { $3->type = ';'; }
    | SPECIAL_NAMES EOS special_names_sentences_or_copy
    | error { yyerror("invalid format in CONFIGURATION SECTION"); }
    ;
special_names_sentences_or_copy:
    special_names_sentences
    | copy_stat
    ;
special_names_sentences:
    currency_details_opt
    decimal_point_details_opt
    EOS
    ;
currency_details_opt:
    currency_details
    | /* nothing */
    ;
currency_details:
    CURRENCY opt_sign CONNECTIVE CLITERAL {
                if($3!=IS)
                    yyerror("IS expected");
                currency_symbol = $<lval>4->name[0];
		}
    ;
opt_sign:
    SIGN
    | /* nothing */
    ;
decimal_point_details_opt:
    decimal_point_details
    | /* nothing */
    ;
decimal_point_details:
    DECIMAL_POINT CONNECTIVE COMMA {
                if($2!=IS)
                    yyerror("IS expected");
                decimal_comma=1; }
    ;
input_output_section:
    input_output_section i_o_option { }
    | /* nothing */     { }
    ;
i_o_option:
    FILE_CONTROL EOS file_control 
    | I_O_CONTROL EOS io_control 
    | copy_stat
    | error { yyerror("I-O SECTION format wrong"); }
    ;
file_control:
    file_control file_select 
    | /* nothing */
    ;
file_select:
    SELECT def_name ASSIGN opt_to filename {
            $2->type='F';   /* mark as file variable */
            curr_file=$2;
            $2->pic=0;  /* suppose not indexed yet */
            $2->defined=1;
            $2->parent=NULL; /* assume no STATUS yet 
                            this is "file status" var in files */
            $2->organization = 2;
            $2->access_mode = 1;
            $2->times=-1;
            $2->filenamevar=$5; /* this is the variable w/filename */
            $2->alternate=NULL; /* reset alternate key list */
         }
      select_clauses EOS {
	  		if ((curr_file->organization==ORG_INDEXED) &&
				!(curr_file->ix_desc)) {
				yyerror("indexed file must have a record key");
				YYABORT;
			}
	  	}
    ;
select_clauses:
    select_clauses select_clause 
    | /* nothing */
    ;
select_clause:
    ORGANIZATION opt_is organization_options
                { curr_file->organization=$3; }
    | ACCESS opt_mode opt_is access_options
                { curr_file->access_mode=$4; }
    | FILEN STATUS opt_is STRING
                { curr_file->parent=$4; }
    | RECORD KEY opt_is STRING { curr_file->ix_desc=$4; }
    | RELATIVE KEY opt_is STRING { curr_file->ix_desc=$4; }
    | ALTERNATE RECORD KEY opt_is STRING 
        with_duplicates { add_alternate_key($5,$6); } 
    | error         { yyerror("invalid clause in select"); }
    ;
with_duplicates:
    WITH DUPLICATES     { $$=1; }
    | /* nothing */     { $$=0; }
    ;
opt_is:
    CONNECTIVE  { if ($1!=IS) yyerror("IS expected"); }
    | /* nothing */
    ;
opt_mode:
    MODE
    | /* nothing */
    ;
organization_options:
    INDEXED     { $$=1; }
    | SEQUENTIAL    { $$=2; }
    | RELATIVE  { $$=3; }
    | LINE SEQUENTIAL { $$=4; }
    | anystring { yyerror("invalid option, %s",
            $1->name); }
    ;
access_options:
    SEQUENTIAL  { $$=1; }
    | DYNAMIC   { $$=2; }
    | RANDOM    { $$=3; }
    | anystring { yyerror("invalid access option, %s",
            $1->name); }
    ;
io_control:
    io_control io_ctrl
    | /* nothing */
    ;
io_ctrl:
    SAME AREA CONNECTIVE name_list EOS {
            if ($3!=FOR) yyerror("FOR expected");
        }
    ;
name_list:
    variable    
    | name_list variable
    | error { yyerror("variable expected"); } 
    ;
data_division:
    opt_file_section
    opt_working_storage
    opt_linkage_section
    opt_screen_section
    ;
opt_screen_section:
    SCREEN SECTION EOS  { 
					/*screen_io_enable++;*/ 
					curr_field=NULL;
					scr_line = scr_column = 1;
			}
    screen_section      { close_fields(); }
    | /* nothing */
    ;
opt_file_section:
    FILEN SECTION EOS  { curr_field=NULL; }
    file_section   { close_fields();  }
    | /* nothing */
    ;
opt_working_storage:
    WORKING_STORAGE SECTION EOS     { curr_field=NULL; }
    working_storage_section         { close_fields(); }
    | /* nothing */
    ;
opt_linkage_section:
    LINKAGE SECTION EOS     { at_linkage=1; curr_field=NULL; }
    linkage_section         { close_fields(); at_linkage=0; }
    | /* nothing */
    ;
screen_section:
    screen_section screen_item
    | /* nothing */
    ;
screen_item:
    integer opt_def_name    { define_field($1,$2); }
        screen_clauses EOS  { update_screen_field($2,$4); }
    | copy_stat             
    ;
screen_clauses:
    screen_clauses LINE 
        opt_number_is 
        opt_plus_minus
        integer     		{ scr_set_line($1,$5,$4); $$=$1; }
    | screen_clauses COLUMN 
        opt_number_is 
        opt_plus_minus
        integer     		{ scr_set_column($1,$5,$4); $$=$1; }
    | screen_clauses
		screen_attrib		{ $1->attr |= $2; $$=$1; }
	| screen_clauses FOREGROUNDCOLOR
		integer				{ $1->foreground = $3; $$=$1; }
	| screen_clauses BACKGROUNDCOLOR
		integer				{ $1->background = $3; $$=$1; }
	| screen_clauses
		screen_source_destination
	| screen_clauses
		VALUE opt_is gliteral { curr_field->value = $4; $$=$1; }
	| screen_clauses pictures
	| /* nothing */         { $$ = alloc_scr_info(); }
    ;
screen_source_destination:
	USING			{ curr_division = CDIV_PROC; } 
		name_or_lit	{
			curr_division = CDIV_DATA;
			$<sival>0->from = $<sival>0->to = $3;  
		}
	| FROM 			{ curr_division = CDIV_PROC; }
		name_or_lit
		req_to name	{ 
			curr_division = CDIV_DATA;
			$<sival>0->from = $3; $<sival>0->to = $5;
		}
	;
screen_attrib:
	BLANK SCREEN			{ $$ = SCR_BLANK_SCREEN; }
	| BLANK LINE			{ $$ = SCR_BLANK_LINE; }
	| BELL					{ $$ = SCR_BELL; }
	| sign_clause			{ $$ = $1; }
	| FULL					{ $$ = SCR_FULL; }
	| REQUIRED				{ $$ = SCR_REQUIRED; }
	| SECURE				{ $$ = SCR_SECURE; }
	| AUTO					{ $$ = SCR_AUTO; }
	| JUST RIGHT			{ $$ = SCR_JUST_RIGHT; }
	| JUST LEFT				{ $$ = SCR_JUST_LEFT; }
	| BLINK					{ $$ = SCR_BLINK; }
	| REVERSEVIDEO			{ $$ = SCR_REVERSE_VIDEO; }
	| UNDERLINE				{ $$ = SCR_UNDERLINE; }
	| LOWLIGHT				{ $$ = SCR_LOWLIGHT; }
	| HIGHLIGHT				{ $$ = SCR_HIGHLIGHT; }
	| BLANK opt_when 
		ZERONUM				{ $$ = SCR_BLANK_WHEN_ZERO; }
	;
sign_clause:
	SIGN opt_is LEADING 
		opt_separate		{ $$ = SCR_SIGN_LEADING |
								   SCR_SIGN_PRESENT | $4; }
	| SIGN opt_is TRAILING
		opt_separate		{ $$ = SCR_SIGN_PRESENT | $4; }
	;
opt_separate:
	SEPARATE opt_character	{ $$ = SCR_SIGN_SEPARATE; }
	| /* nothing */			{ $$ = 0; }
	;
opt_character:
	CHARACTER
	| /* nothing */
	;
opt_plus_minus:
    PLUS            { $$ = 1; }
    | MINUS         { $$ = -1; }
    | /* nothing */ { $$ = 0; }
    ;
opt_number_is:
	NUMBERTOK opt_is
	| /* nothing */
	;
file_section:
    file_section FD         { curr_division = CDIV_FD; } 
        STRING              { curr_division = CDIV_DATA; }
        file_attrib EOS
            {
                curr_field=NULL;
            }
    file_description        {   
                close_fields();
                alloc_file_entry($4);
                gen_fdesc($4,$<sval>9); 
            }
    | file_section SD { curr_division = CDIV_FD; } 
         STRING { curr_division = CDIV_DATA; }
         sort_attrib EOS
            {
                $4->organization=2;
                curr_field=NULL;
            }
    file_description    {   
                close_fields();
                alloc_file_entry($4);
                gen_fdesc($4,$<sval>9);
            }
    | copy_stat 
    | /* nothing */
    ;
file_description:
    field_description       { $<sval>$=$1; }
    | file_description field_description
    ;


field_description:   integer def_name   { define_field($1,$2); }
        redefines_clause 
        data_clauses EOS    { $$=$2; update_field(); }
    | copy_stat  { $$=NULL; }
    ;

redefines_clause:
    REDEFINES 
    { curr_division = CDIV_REDEF; } 
    def_var 
    { 
            curr_division = CDIV_DATA;
            $<sval>-1->redefines = $3;
        }
    |  /* nothing */ 
    ;
    
data_clauses:  
    /* nothing */
    | data_clauses data_clause
    ;
data_clause:
    array_options 
    | pictures 
    | usage_option
    | value_option
    ;

array_options:  OCCURS integer opt_TIMES
        { curr_field->times = $2; curr_field->occurs_flg++; }
            opt_indexed_by
     ;            

opt_key_is:  
      DIRECTION KEY CONNECTIVE STRING
     { 
       if ($3 !=IS) {
           yyerror("IS expected"); YYERROR; }
       $4->level=0;
       if ($1 == ASCENDING) {
          $4->level=-1;
       }
       if ($1 == DESCENDING) {
          $4->level=-2;
       }
       $$=$4; 
     }
     | { $$=NULL; }
     ;            

opt_indexed_by: opt_key_is INDEXED opt_by def_name
                { 
                  define_implicit_field($4, $1, curr_field->times);
                  /* Fix Me: Does not work, thus dup vars can be defined
                  if ($4->defined) {
                     yyerror("variable redefined, '%s'",$4->name);
                     $4->defined=1;
                  }
                  else { 
                     define_implicit_field($4, $1, curr_field->times);
                  } */
                } 
         | /* nothing */
         ;
              
pictures :  PIC { 
  			curr_division = CDIV_PIC;
		  	/* first pic char found */ 
          	picix=piccnt=v_flag=decimals=0;
          	picture[picix]=0;
         }
        opt_is picture { 
            /* finish picture */
            picture[picix+2]=0;
            curr_field->len=piccnt;
            curr_field->decimals=decimals;
         }
    ;

usage_option : 
    opt_USAGE opt_is usage {
            if ($3==COMP3) {
                /*curr_field->len = (piccnt/2)+1;*/
                curr_field->type='C';
            }
            else if ($3==COMP) {
                /*curr_field->len = 4;*/
                curr_field->type='B'; /* binary field */
            }
        }
    ;

value_option:  VALUE opt_is value
    ;
    
value:
    gliteral            { curr_field->value=$1;
                      curr_field->value2=$1; }
    | gliteral CONNECTIVE gliteral  { if ($2!=THRU)
                        yyerror("THRU expected");
                      curr_field->value=$1;
                      curr_field->value2=$3;
                    }
    ;
picture: /* nothing */
    | picture pic_elem
    ;
pic_elem:
    pic_char
    | pic_char MULTIPLIER {
            picture[picix+1] += $2-1;
            piccnt += $2-1;
        }
    ;
pic_char: CHAR {  
            if (!save_pic_char ( $1 )) {
                yyerror("invalid char in picture");
                YYERROR;
            }
        }
    ;
file_attrib:
    /* nothing */
    | file_attrib opt_is GLOBAL     { $<sval>0->type = 'J'; }
    | file_attrib opt_is EXTERNAL   { $<sval>0->type = 'K'; }
    | file_attrib LABEL rec_or_recs opt_is_are std_or_omitt
    ;
sort_attrib:
    /* nothing */
    | file_attrib DIVISNUM RECORD opt_is STRING 
        { if ($2!=DATA) { yyerror("DATA expected"); YYABORT; } }
    ;
rec_or_recs:
    RECORD
    | RECORDS
    ;
std_or_omitt:
    STANDARD
    | OMITTED
    ;
opt_USAGE:
    /* nothing */
    | USAGE
    ;
opt_TIMES:
    /* nothing */
    | TIMES
    ;
opt_when:
    /* nothing */
    | WHEN  
    ;
opt_is_are:
    /* nothing */
    | CONNECTIVE    { if ($1!=IS && $1!=ARE) {
                yyerror("IS/ARE expected"); YYERROR; } }
    ;
opt_no:
    /* nothing */
    | CONNECTIVE    { if ($1!=NO) { yyerror("NO expected"); YYERROR;} }
    ;
usage:  USAGENUM    { $$=$1; }
    | DISPLAY   { $$=9; }
    ;
working_storage_section:
    working_storage_section
        field_description
    | /* nothing */
    ;
linkage_section:
    /* nothing */
    | linkage_section
        field_description
    ;
procedure_division:
    /* nothing */
    | procedure_division procedure_decl
    ;
procedure_decl:
    procedure_section { close_section(); open_section($1); }
    | paragraph { close_paragr(); open_paragr($1); }
    | 
     {
      if (stabs_on_sw) {
        stabs_line(); 
      }
     } sentence opt_EOS
    /* } statement opt_EOS */
    ;
procedure_section:
     LABELSTR SECTION EOS {
            struct sym *lab;
            lab=install($1->name,SYTB_LAB,0);
            lab->defined=1;
            $$=lab;
        }   
    ;
paragraph:
    LABELSTR EOS {
            struct sym *lab;
            if ((lab=lookup_label($1,curr_section))==NULL) {
                lab=install($1->name,SYTB_LAB,2);
                /*lab->parent=curr_section;*/
                lab->defined=1;
            }
            $$=lab;
        }
    ;

sentence:
    statement
    | sentence statement
    | if_part { gen_dstlabel($1); } opt_end_if
    | if_part ELSE
      { $<dval>$=gen_passlabel(); gen_dstlabel($1); }
/*      sentence { gen_dstlabel($<dval>3); } */
      conditional_statement { gen_dstlabel($<dval>3); }
      opt_end_if 
    | SEARCH search opt_end_search
    | SEARCH ALL search_all opt_end_search
    | EVALUATE { } END_EVALUATE
    ;
    
if_part:
    IF  condition  { $<dval>$=gen_testif(); }
        opt_end_then 
        conditional_statement { $<dval>$=$<dval>3; }  
/*         sentence   { $<dval>$=$<dval>3; } */
    ;

/* 
  Fix me: This does not conform to the ANSI85 standard.
  However, it does reduce the number of conflicts.
*/     
conditional_statement: sentence
    |  NEXT SENTENCE 
    |  CONTINUE 
    ;


opt_end_if:
    | END_IF
    ;

opt_end_then:
    | THEN
    ;

search:
      variable_indexed 
      { 
        $<dval>$=loc_label++; /* determine END label name */
        gen_marklabel(); 
      } 
      search_opt_varying 
      { 
        $<dval>$=loc_label++; /* determine search loop start label */ 
        if ($3 == NULL) {
          $3=determine_table_index_name($1);
          if ($3 == NULL) {
             yyerror("Unable to determine search index for table '%s'", $1->name); 
          }
        }
        gen_jmplabel($<dval>$); /* generate GOTO search loop start  */ 
      } 
      search_opt_at_end 
      { 
        gen_jmplabel($2); /* generate GOTO END  */ 
        gen_dstlabel($4); /* generate search loop start label */
      }
      search_when  
      { 
        gen_jmplabel($2); /* generate GOTO END  */ 
        gen_dstlabel($7);

        /* increment loop index, check for end */
        gen_SearchLoopCheck($5, $3, $1);   

        gen_jmplabel($4); /* generate goto search loop start label */  
        gen_dstlabel($2); /* generate END label */ 
      }
    ;
    
search_all:
     variable_indexed
     { 
        lbend=loc_label++; /* determine END label name */
        gen_marklabel(); 

        lbstart=loc_label++; /* determine search_all loop start label */ 

        $<sval>$=determine_table_index_name($1); 
        if ($<sval>$ == NULL) {
           yyerror("Unable to determine search index for table '%s'", $1->name); 
        }
        else {
          /* Initilize and store search table index boundaries */
          Initialize_SearchAll_Boundaries($1, $<sval>$);
        }

        gen_jmplabel(lbstart); /* generate GOTO search_all loop start  */ 
     }
     search_opt_at_end 
     { 
        gen_jmplabel(lbend); /* generate GOTO END  */ 
        gen_dstlabel(lbstart); /* generate search loop start label */
     }
     search_all_when 
     { 
        gen_jmplabel(lbend); /* generate GOTO END  */ 
        gen_dstlabel($5);

        /* adjust loop index, check for end */
        gen_SearchAllLoopCheck($3, $<sval>2, $1, curr_field, lbstart, lbend);   
     }
    ;    

search_opt_varying:
    VARYING variable {  $$=$2; }
    | { $$=NULL; }
    ;

search_opt_at_end:
     opt_at END 
     { 
       $<dval>$=loc_label++; /* determine ATEND label name */
       gen_dstlabel($<dval>$); /* determine ATEND label name */
     } 
     statement 
     { 
       $<dval>$=$3;
     } 
    | 
     { 
       $<dval>$=loc_label++; /* determine ATEND label name */
       gen_dstlabel($<dval>$); /* determine ATEND label name */
     }
    ;

search_when:
     WHEN 
     search_when_conditional
     { $<dval>$=gen_testif(); } 
     search_when_statement
     { $<dval>$=$3;  } 
    ;

search_when_statement:
    search_when_statements
    |  NEXT SENTENCE 
    ;

search_when_statements:
     statement 
    | search_when_statements statement
    ;

search_when_conditional:
    name cond_op name { gen_compare($1,$2,$3); }
    | name cond_op nliteral { gen_compare($1,$2,(struct sym *)$3); }
    | nliteral cond_op name { gen_compare((struct sym *)$1,$2,$3); }
    | nliteral cond_op nliteral { gen_compare((struct sym *)$1,$2,(struct sym *)$3); }
    ;

search_all_when:
     WHEN { curr_field = NULL; }
     search_all_when_conditional 
     { $<dval>$=gen_testif(); } 
     search_all_when_statement
     { $<dval>$=$4;  } 
    ;

search_all_when_statement:
    statement
    |  NEXT SENTENCE 
    ;

search_all_when_conditional:
     VARIABLE CONDITIONAL name 
        { 
          if ($2 != EQUAL) 
             yyerror("Only = conditional allowed in search all statement");
          if (curr_field == NULL) 
             curr_field = $1; 
          gen_compare($1,$2,$3); 
        }
     | VARIABLE CONDITIONAL literal 
        { 
          if ($2 != EQUAL) 
             yyerror("Only = conditional allowed in search all statement");
          if (curr_field == NULL) 
             curr_field = $1; 
          gen_compare($1,$2,(struct sym *)$3); 
        } 
    | search_all_when_conditional AND { $<dval>$=gen_andstart(); }
      search_all_when_conditional  { gen_dstlabel($<dval>3); }
    ;

opt_end_search:
    | END_SEARCH
    ;

statement:
    MOVE { }
        gname req_to        { $<ival>$=MOVE; }
        var_list
    | INITIALIZE { $<ival>$=INITIALIZE; }
        var_list
    | ADD { }
        gname req_to        { $<ival>$=ADD; }
        var_list
        opt_end_add
    | SUBTRACT { }
      gname FROM name { gen_subtract($3,$5); }
      opt_end_subtract
    | MULTIPLY { }
        gname BY gname GIVING name
        {
            gen_multiply($3,$5,$7);
        }
        opt_end_multiply
    | DIVIDE { }
        gname BY gname GIVING name
        {
            gen_divide($3,$5,$7);
        }
        opt_end_divide
    | COMPUTE { }
        name CONDITIONAL expr
        { if ($4!=EQUAL) yyerror("= expected");
            assign_expr($3); }
        opt_end_compute
    | accept_part
        accept_options
    | DISPLAY { }
        disp_at_xy
        disp_stat
    | OPEN { }
        open_mode name   {
                    gen_open($3,$4);
                }
    | CLOSE { }
            name { gen_close($3); }
    | READ 
        name opt_next
        read_into
        read_key    
        {
            if ($1==1)
                gen_read_next($2,$4,1); /*gen_return($2,$4);*/
            else if ($3>=1 && ($2->organization==1 || $2->organization==3) &&
                ($2->access_mode==2 || $2->access_mode==1))
                    gen_read_next($2,$4,$3); /* modificado para NEXT/PREV */
            else gen_read($2,$4,$5);
        }
        read_clauses
        opt_end_read
    | WRITE { }
        name write_from write_options
            {
                if ($3->level != 1)
                    yyerror("variable %s could not be used for WRITE",
                        $3->name);
                if ($1==1)
                    gen_release($3,$4);
                else
                    gen_write($3,$5,$4);
            }
        opt_end_write
    | REWRITE {  }
        name write_from
            {
                if ($3->level != 1)
                    yyerror("variable %s could not be used for REWRITE",
                        $3->name);
                gen_rewrite($3,$4);
            }
        opt_end_rewrite
    | DELETE {  }
        name opt_record { gen_delete($3); } 
        opt_end_delete
    | START name
        start_key_option 
	opt_invalid_key
	opt_end_start
    | PERFORM perform_options 
    | GO  opt_to label          { gen_goto($3); }
    | EXIT  {  }
        opt_program     { gen_exit($3); }
    | STOP RUN          { gen_stoprun(); }
    | CALL  {  }
        CLITERAL
        using_options       { gen_call($3,$4); }
        opt_end_call

    | SET  set_list
    
    | SORT  
        name
        sort_keys   { gen_sort($2); }
        OPENMD DIVISNUM opt_is perform_range
        OPENMD DIVISNUM opt_is perform_range
        {
            if (($6!=PROCEDURE) || ($10!=PROCEDURE)
                || ($5!=INPUT) || ($9!=OUTPUT)) {
                yyerror("INPUT or OUTPUT PROCEDURE expected");
                YYABORT;
            }
            gen_close_sort($2);
        }
    | INSPECT 
        name 
        tallying_clause     { gen_inspect($2,(void *)$3,0); }
        replacing_clause    { gen_inspect($2,(void *)$5,1); }
    | STRINGCMD string_from_list
        INTO name string_with_pointer {
                gen_stringcmd( $2, $4, $5 );    
            }
        opt_on_overflow
        opt_end_stringcmd
    | UNSTRING name
        unstring_delimited
        INTO unstring_destinations
        string_with_pointer
        unstring_tallying {
                gen_unstring( $2, $3, $5, $6, $7 );
            }
        opt_on_overflow
        opt_end_unstring
    | copy_stat
    | READY TRACE { }
    | RESET TRACE { } 
    | error { yyerror("unknown or wrong statement"); }
        EOS
    ;

opt_end_add:
    | END_ADD  
    ;
opt_end_call:
    | END_CALL
    ;
opt_end_compute:
    | END_COMPUTE
    ;
        
opt_end_delete:
    | END_DELETE
    ;
    
opt_end_divide:
    | END_DIVIDE
    ;
opt_end_multiply:
    | END_MULTIPLY
    ;
opt_end_read:
    | END_READ
    ;
opt_end_rewrite:
    | END_REWRITE
    ;
opt_end_start:
    | END_START
    ;
opt_end_stringcmd:
    | END_STRINGCMD
    ;
opt_end_subtract:
    | END_SUBTRACT
    ;
opt_end_unstring:
    | END_UNSTRING
    ;
opt_end_write:
    | END_WRITE
    ;

set_list: VARIABLE req_to var_or_nliteral  { 
            gen_set($1,SET_TO,$3); /*gen_move($3,$1);*/ }
    | VARIABLE UP BY var_or_nliteral   { 
            gen_set($1,SET_UP_BY,$4); /*gen_add($4,$1);*/ }
    | VARIABLE DOWN BY var_or_nliteral { 
            gen_set($1,SET_DOWN_BY,$4); /*gen_subtract($4,$1);*/ }
    /*| VARIABLE UP BY NLITERAL   
      { 
       save_literal($4,'9'); $4->all=0; gen_add((struct sym *)$4,$1); 
      }
    | VARIABLE DOWN BY NLITERAL 
      { 
       save_literal($4,'9'); $4->all=0; gen_subtract((struct sym *)$4,$1); 
      }
    | VARIABLE req_to NLITERAL  
      { 
       save_literal($3,'9'); $3->all=0; gen_move((struct sym *)$3,$1); 
      }*/
    ;

unstring_delimited:
    DELIMITED opt_by unstring_delimited_vars { $$=$3; }
    | /* nothing */                          { $$=NULL; }
    ;
unstring_delimited_vars:
    opt_all gname       { $$=alloc_unstring_delimited($1,$2); }
    | unstring_delimited_vars OR opt_all gname { 
            struct unstring_delimited *ud;
            ud=alloc_unstring_delimited($3,$4);
            ud->next = $1;
            $$=ud;
        }
    ;
unstring_destinations:
    unstring_dest_var       { $$=$1; }
    | unstring_destinations 
        unstring_dest_var   { 
            $2->next = $1;
            $$ = $2;
        }                       
    ;
unstring_dest_var:
    name opt_unstring_delim opt_unstring_count {
            $$ = alloc_unstring_dest( $1, $2, $3 );
        }
    ;
opt_unstring_delim:
    /* nothing */           { $$=NULL; }
    | DELIMITER opt_in name { $$=$3; }
    ;
opt_unstring_count:
    /* nothing */           { $$=NULL; }
    | COUNT opt_in name   { $$=$3; }
    ;
unstring_tallying:
    /* nothing */           { $$=NULL; }
    | TALLYING opt_in name  { $$=$3; }
    ;
opt_all:
    /* nothing */           { $$=0; }
    | ALL                   { $$=1; }
    ;
opt_on_overflow:
    { curr_division = CDIV_EXCEPTION; }
    on_overflow 
    on_not_overflow
    { curr_division = CDIV_PROC; }
    ;
on_overflow:
    ONTOK OVERFLOWTK          { $<dval>$ = gen_at_end(-1); }
        sentence            { gen_dstlabel($<dval>3); }
    | /* nothing */
    ;
on_not_overflow:
    NOTEXCEP ONTOK OVERFLOWTK { $<dval>$ = gen_at_end(0); }
        sentence            { gen_dstlabel($<dval>4); }
    | /* nothing */
    ;
opt_invalid_key:
    { curr_division = CDIV_EXCEPTION; }
    invalid_key 
    not_invalid_key
    { curr_division = CDIV_PROC; }
    ;
not_invalid_key:
    NOTEXCEP INVALID KEY { $<dval>$ = gen_at_end(0); }
        sentence         { gen_dstlabel($<dval>4); }
	| /* nothing */
	;
invalid_key:
	INVALID KEY        	{ $<dval>$ = gen_at_end(23); }
        sentence         { gen_dstlabel($<dval>3); }
    | /* nothing */
    ;
string_with_pointer:
    opt_with POINTER name  { $$ = $3; }
    | /* nothing */        { $$ = NULL; }
    ;
string_from_list:
    string_from             { $$ = $1; }
    | string_from_list opt_sep string_from  {
            $3->next = $1;
            $$ = $3;
        }
    | error { yyerror("variable expected"); }
    ;
string_from:
    name_or_lit   {
                $$ = alloc_string_from( $1, NULL );
            }
    | name_or_lit DELIMITED opt_by delimited_by {
                $$ = alloc_string_from( $1, $4 );
            }
    ;
delimited_by:
    name_or_lit     { $$=$1; }
    | SIZE          { $$=NULL; }
    | error { yyerror("SIZE or identifier expected"); }
    ;
copy_stat:
    COPY { curr_division = CDIV_COPYFILE;  }
    IDSTRING { include_filename = $3; } 
        copy_replace EOS 
    ;
copy_replace:
    REPLACING copy_replacements
    | /* nothing */
    | error { yyerror("COPY statement not complete"); }
    ;
copy_replacements:  
    copy_replacement
    | copy_replacements copy_replacement
    ;
copy_replacement:
    IDSTRING BY IDSTRING { add_copy_replacement($1,$3); }
    | error { yyerror("wrong replacement for COPY"); }
    ;
/**************** inspect statement **************/
tallying_clause:
    TALLYING tallying_list { $$=$2; }
    | /* nothing */        { $$=NULL; }
    ;
tallying_list:
    tallying_list
        name req_for tallying_for_list  { 
            $$ = alloc_tallying_list($1,$2,$4); }
    | /* nothing */     { $$ = NULL; }
    ;
tallying_for_list:
    tallying_for_list
        CHARACTERS inspect_before_after { 
            $$ = alloc_tallying_for_list($1,INSPECT_CHARACTERS,NULL,$3); } 
    | tallying_for_list
        ALL noallname inspect_before_after {
            $$ = alloc_tallying_for_list($1,INSPECT_ALL,$3,$4); } 
    | tallying_for_list
        LEADING noallname inspect_before_after {
            $$ = alloc_tallying_for_list($1,INSPECT_LEADING,$3,$4); } 
    | /* nothing */     { $$ = NULL; }
    ;
replacing_clause:
    REPLACING
        replacing_list      { $$ = $2; } 
    | /* nothing */         { $$ = NULL; }
    ;
replacing_list:
    replacing_list
        CHARACTERS BY noallname inspect_before_after {
            $$ = alloc_replacing_list($1,INSPECT_CHARACTERS,NULL,$4,$5); }
    | replacing_list
        replacing_kind replacing_by_list {
            $$ = alloc_replacing_list($1,$2,$3,NULL,NULL); }
    | /* nothing */     { $$ = NULL; }
    ;
replacing_by_list:
    replacing_by_list
        noallname BY noallname inspect_before_after {
            $$ = alloc_replacing_by_list($1,$2,$4,$5); }
    | /* nothing */         { $$ = NULL; }
    ;
replacing_kind:
    ALL         { $$ = INSPECT_ALL; }
    | LEADING   { $$ = INSPECT_LEADING; }
    | FIRSTTOK  { $$ = INSPECT_FIRST; }
    ;
inspect_before_after:
    inspect_before_after 
        BEFORE opt_initial noallname 
            { $$ = alloc_inspect_before_after($1,1,$4); }
    | inspect_before_after 
        AFTER opt_initial noallname  
            { $$ = alloc_inspect_before_after($1,2,$4); }
    | /* nothing */  { $$ = alloc_inspect_before_after(NULL,0,NULL); }
    ;
opt_initial:
    INITIALTOK
    | /* nothing */
    ;
req_for:
    CONNECTIVE  { if ($1!=FOR) yyerror("FOR expected"); }
    ;
/**************** sort statement ********************/
sort_keys:
    /* nothing */   { $$ = NULL; }
    | sort_keys DIRECTION KEY name
        {
            $4->direction = $2;
            (struct sym *)$4->sort_data =
                (struct sym *)($<sval>0->sort_data);
            (struct sym *)($<sval>0->sort_data) = $4;
            $$ = $4;
        }
    ;
expr:
    gname           { push_expr($1); }
    | expr '*' expr     { multiply_expr(); }
    | expr '/' expr     { divide_expr(); }
    | expr '+' expr         { add_expr(); }
    | expr '-' expr     { subtract_expr(); }
    | '(' expr ')'
    ;
using_options:
    /* nothing */   { $$=0; }
    | USING     { $<ival>$=0; /* to save how many parameters */ }
      dummy     { $<ival>$=CALL; }
      parm_list  { $$=$<ival>2; } /* modified to signal calling pgm */
    ;
dummy: /* nothing */ ;
using_parameters:   /* defined at procedure division */
    /* nothing */       { $$=0; }
    | USING         { $<ival>$=USING; }
        var_list    { $$=1; }
    ;
accept_part:
    ACCEPT  {  }
        coordinates name    { gen_gotoxy($3.lin,$3.col);
                        $<sval>$=$4; }
    | ACCEPT  {  }
        name            { $<sval>$=$3; }
    ;
accept_options:
    echo_options          { gen_accept($<sval>0,$1,1); }
    | echo_options
        ONTOK ESCAPE        { gen_accept($<sval>0,$1,1);
                      $<dval>$=gen_at_end(-1); }
        sentence        { gen_dstlabel($<dval>4); }
    | FROM DATE_TIME      { if ($2==DATE)
                    gen_accept_from_date($<sval>0);
                else if ($2==TIME)
                    gen_accept_from_time($<sval>0);
                else if ($2==INKEY)
                    gen_accept_from_inkey($<sval>0); }
    | FROM CMD_LINE      { gen_accept_from_cmdline($<sval>0); }
    | FROM ENVIRONMENT_VARIABLES  { gen_accept_env_var($<sval>0); }
    ;
echo_options:
    opt_no ECHOT    { $$=0; }
    | opt_with FILLER   { $$=2; }
    | opt_with UPDATE   { $$=8; }
    | DARK          { $$=4; }
	| /* nothing */	{ $$=1; /* default is with echo */}
	;
var_list:
    var_list opt_sep gname
        {   if ($<ival>0 == MOVE)
                gen_move($<sval>-2,$<sval>3);
            else if ($<ival>0 == INITIALIZE)
                gen_initialize($<sval>3);
            else if ($<ival>0 == ADD)
                gen_add($<sval>-2,$<sval>3);
            else if ($<ival>0 == USING)
                gen_save_using($<sval>3);
            else if ($<ival>0 == CALL) {
                gen_push_using($<sval>3);
                $<ival>-2 += 4; /* stack used */
            }
        }
	| gname
        {   if ($<ival>0 == MOVE)
                gen_move($<sval>-2,$<sval>1);
            else if ($<ival>0 == INITIALIZE)
                gen_initialize($<sval>1);
            else if ($<ival>0 == ADD)
                gen_add($<sval>-2,$<sval>1);
            else if ($<ival>0 == USING)
                gen_save_using($<sval>1);
            else if ($<ival>0 == CALL) {
                gen_push_using($<sval>1);
                $<ival>-2 += 4; /* stack used */
            }
        }
    ;
parm_list:
    parm_list opt_sep parameter
        {   if ($<ival>0 == USING)
                gen_save_using($<sval>3);
            else if ($<ival>0 == CALL) {
                gen_push_using($<sval>3);
                $<ival>-2 += 4; /* stack used */
            }
        }
	| parameter
        {   if ($<ival>0 == USING)
                gen_save_using($<sval>1);
            else if ($<ival>0 == CALL) {
                gen_push_using($<sval>1);
                $<ival>-2 += 4; /* stack used */
            }
        }
    ;
parameter:
    gname
    | BY parm_type gname {$$=$3;}
    ;
parm_type:
    REFERENCE
    | VALUE
    ;
disp_stat:
    disp_var_list 
    opt_upon 
    disp_upon 
    disp_options  { gen_display($<ival>3, $<ival>4); }
    ;
disp_var_list:
    /* nothing */
    | disp_var_list opt_sep gname { put_disp_list($3); }
    ;
disp_upon: { $<ival>$=1; }  /* default is CONSOLE (STD_OUTPUT) */
    | CONSOLE { $<ival>$=1; }
    | STD_OUTPUT { $<ival>$=1; }
    | STD_ERROR { $<ival>$=2; }
    ;

perform_range: label opt_perform_thru
      { 
	if ($2 == NULL) {
            gen_perform_thru($1,$1);
	    $$ = $1;
	}
	else  {
	    $$ = $2;
            gen_perform_thru($1,$2);
	} 
      }   
    ;

perform_options: perform_statements END_PERFORM { $$ = NULL; } 
    | gname TIMES 
      {
        gen_push_int($1);
        $<dval>$=gen_marklabel(); 
      }
      perform_statements 
      {
        gen_perform_times($<dval>3); 
      }
      END_PERFORM { $$ = NULL; }
    | opt_with_test UNTIL 
      { 
 	if ($1 == 2) {
 	   lbstart=gen_passlabel();
	}
        $<dval>$=gen_marklabel(); 
      }
      condition   
      { 
        $<dval>$=gen_orstart();
 	if ($1 == 2) {
 	   lbend=gen_passlabel();
           gen_dstlabel(lbstart);
	}
      }
      perform_statements 
      {
 	if ($1 == 2) {
           gen_jmplabel($<dval>3);
           gen_dstlabel(lbend);
           gen_jmplabel(lbstart);
           gen_dstlabel($<dval>5);
 	} 
 	else {
           gen_jmplabel($<dval>3);
           gen_dstlabel($<dval>5);
        }
      }
      END_PERFORM { $$ = NULL; }
    | opt_with_test VARYING name FROM gname opt_by gname UNTIL
      {
        gen_move($5,$3);
 	/* BEFORE=1 AFTER=2 */
 	if ($1 == 2) {
 	   lbstart=gen_passlabel();
	}
        $<dval>$=gen_marklabel();
      }
      condition 
      { 
        $<dval>$=gen_orstart();
 	/* BEFORE=1 AFTER=2 */
 	if ($1 == 2) {
           gen_add($7,$3);
           gen_dstlabel(lbstart);
	}
      }
      opt_perform_after 
      perform_statements 
      {
        int i;
        struct perf_info *rf;
        struct perform_info *rpi;
        char *vn;

	/* Check for duplicate varaibles in VARYING/AFTER */
 	if ($12 != NULL) {
	   if ((vn = check_perform_variables($3, $12)) != NULL) {
              yyerror("Duplicate variable '%s' in VARYING/AFTER clause", vn);        
           }
        }

 	if ($1 == 2) {
 	   if ($12 != NULL) {
 	      for (i=3; i>=0; i--) {
 	         rf = $12->pf[i];
 	         if (rf != NULL) {
                    gen_jmplabel(rf->ljmp);
                    gen_dstlabel(rf->lend);
 	         }
 	      }
 	   }
           gen_jmplabel($<dval>9);
           gen_dstlabel($<dval>11);
 	} 
 	else {
 	   if ($12 != NULL) {
 	      for (i=3; i>=0; i--) {
 	         rf = $12->pf[i];
 	         if (rf != NULL) {
                    gen_add(rf->pname1, rf->pname2);
                    gen_jmplabel(rf->ljmp);
                    gen_dstlabel(rf->lend);
 	         }
 	      }
 	   }
           gen_add($7,$3);
           gen_jmplabel($<dval>9);
           gen_dstlabel($<dval>11);
        }
      }
      END_PERFORM { $$ = NULL; }
    | label opt_perform_thru 
      { 
        if ($2 == NULL) {
            gen_perform_thru($1,$1);
        }
        else  {
            gen_perform_thru($1,$2);
        } 
        $$ = NULL;
      } 
    | label opt_perform_thru opt_with_test UNTIL 
      { 
        $<dval>$=gen_marklabel(); 
 	/* BEFORE=1 AFTER=2 */
 	if ($3 == 2) { 
	   if ($2 == NULL) {
               gen_perform_thru($1,$1);
	   }
	   else  {
               gen_perform_thru($1,$2);
	   } 
	}
      }
      condition   
      { 
        unsigned long lbl;
        lbl=gen_orstart();
 	/* BEFORE=1 AFTER=2 */
 	if ($3 == 1) { 
	   if ($2 == NULL) {
               gen_perform_thru($1,$1);
	   }
	   else  {
               gen_perform_thru($1,$2);
	   } 
	} 
        gen_jmplabel($<dval>5);
        gen_dstlabel(lbl);
      }
    | label opt_perform_thru gname TIMES 
      {
        unsigned long lbl;	    
        gen_push_int($3);
        lbl = gen_marklabel();
	if ($2 == NULL) {
            gen_perform_thru($1,$1);
	}
	else  {
            gen_perform_thru($1,$2);
	} 
        gen_perform_times(lbl); 
      }
    | label opt_perform_thru opt_with_test VARYING name 
      FROM gname opt_by gname UNTIL
      {
        gen_move($7,$5);
        if ($3 == 2) {
 	   lbstart=gen_passlabel();
	}
        $<dval>$ = gen_marklabel();
      }
      condition 
      {
        $<dval>$ = gen_orstart();
 	/* BEFORE=1 AFTER=2 */
        if ($3 == 2) {
           gen_add($9,$5);
           gen_dstlabel(lbstart);
	}
      }
      opt_perform_after 
      { 
        int i;
        struct perf_info *rf;
        struct perform_info *rpi;
        char *vn = NULL;
        
	/* Check for duplicate varaibles in VARYING/AFTER */
 	if ($14 != NULL) {
	   if ((vn = check_perform_variables($5, $14)) != NULL) {
              yyerror("Duplicate variable '%s' in VARYING/AFTER clause", vn);        
           }
        }

	if ($2 == NULL) {
            gen_perform_thru($1,$1);
	}
	else  {
            gen_perform_thru($1,$2);
	} 
 	/* BEFORE=1 AFTER=2 */
 	if ($3 == 2) {
 	   if ($14 != NULL) {
 	      for (i=3; i>=0; i--) {
 	         rf = $14->pf[i];
 	         if (rf != NULL) {
                    gen_jmplabel(rf->ljmp);
                    gen_dstlabel(rf->lend);
 	         }
 	      }
 	   }
           gen_jmplabel($<dval>11);
           gen_dstlabel($<dval>13);
 	} 
 	else {
 	   if ($14 != NULL) {
 	      for (i=3; i>=0; i--) {
 	         rf = $14->pf[i];
 	         if (rf != NULL) {
                    gen_add(rf->pname1, rf->pname2);
                    gen_jmplabel(rf->ljmp);
                    gen_dstlabel(rf->lend);
 	         }
 	      }
 	   }
           gen_add($9,$5);
           gen_jmplabel($<dval>11);
           gen_dstlabel($<dval>13);
        }
        $$ = NULL; 
      }
    ;

opt_perform_thru: { $$ = NULL; } 
    | CONNECTIVE label 
      {
        if ($1 != THRU) 
	    yyerror("THRU expected");
	$$ = $2;
      }
    ;

opt_with_test: { $<ival>$=1; perform_after_sw=1; }
    | opt_with TEST before_after
      {
       $$=$3;
       perform_after_sw=$3; 
      }
    ;

opt_perform_after:   /* nothing */ { $$=NULL; }
    | AFTER perform_after 
     { 
      $<pfvals>$=create_perform_info(); 
      $<pfvals>$->pf[0] = $2; 
      $$=$<pfvals>$;
     }
    | AFTER perform_after AFTER perform_after 
     { 
      $<pfvals>$=create_perform_info(); 
      $<pfvals>$->pf[0] = $2; 
      $<pfvals>$->pf[1] = $4; 
      $$=$<pfvals>$;
     }
    | AFTER perform_after AFTER perform_after 
      AFTER perform_after 
     { 
      $<pfvals>$=create_perform_info(); 
      $<pfvals>$->pf[0] = $2; 
      $<pfvals>$->pf[1] = $4; 
      $<pfvals>$->pf[2] = $6; 
      $$=$<pfvals>$;
     }
    | AFTER perform_after AFTER perform_after 
      AFTER perform_after AFTER perform_after 
     { 
      $<pfvals>$=create_perform_info(); 
      $<pfvals>$->pf[0] = $2; 
      $<pfvals>$->pf[1] = $4; 
      $<pfvals>$->pf[2] = $6; 
      $<pfvals>$->pf[3] = $8; 
      $$=$<pfvals>$;
     }
    ;

perform_after: name FROM gname 
       opt_by gname UNTIL       
      {
        gen_move($3,$1);
 	/* BEFORE=1 AFTER=2 */
 	if (perform_after_sw == 2) { 
 	   lbstart=gen_passlabel();
	}
        $<dval>$ = gen_marklabel();
      }
       condition   
      { 
        unsigned long lbl;
        lbl=gen_orstart();
 	/* BEFORE=1 AFTER=2 */
 	if (perform_after_sw == 2) { 
           gen_add($5,$1);
           gen_dstlabel(lbstart);
           $$ = create_perf_info($5, $1, $<dval>7, lbl);
	}
	else {
           $$ = create_perf_info($5, $1, $<dval>7, lbl);
        }
      } 
    ;

perform_statements: sentence
    | CONTINUE
    ;

disp_options:
    /* nothing */           { $<ival>$=0; }
    | disp_options
       CONNECTIVE ADVANCING     { if ($2!=NO)
                        yyerror("NO expected");
                      $<ival>$|=1;
                    }
    | disp_options ERASE        { $<ival>$|=2; }
    ;
disp_at_xy:
    /* nothing */
    | coordinates           { gen_gotoxy($1.lin,$1.col); }
    ;
start_key_option:
    /* nothing */			{ gen_start($<sval>0,0,NULL); }
	| KEY opt_is cond_op name { gen_start($<sval>0,$3,$4); }
    ;
read_into:
    /* nothing */       { $$ = NULL; }
    | INTO name     { $$ = $2; }
    ;
write_from:
    /* nothing */       { $$ = NULL; }
    | FROM gname        { $$ = $2; }
    ;
write_options:
    /* nothing */                   { $$=0; }
    | before_after opt_advancing
        gname opt_line      { gen_loadvar($3); $$=$1; }
    | before_after
        opt_advancing PAGETOK  { $$=-$1; }
    ;
before_after:
    BEFORE  { $$=1; }
    | AFTER { $$=2; }
    ;
read_key:
    KEY opt_is name     { $$ = $3; }
    | /* nothing */     { $$ = NULL; }
    ;
read_clauses:
    /* nothing */
    | opt_at END            { 
                      $<dval>$=gen_at_end(10); }
        sentence        { gen_dstlabel($<dval>3); }
    | INVALID KEY           { 
                      $<dval>$=gen_at_end(23); }
        sentence        { gen_dstlabel($<dval>3); }
    ;

condition:
    gname  cond_op gname { gen_compare($1,$2,$3); }
    | NOT condition     { gen_not(); }
    | condition AND     { $<dval>$=gen_andstart(); }
        condition       { gen_dstlabel($<dval>3); }
    | condition OR      { $<dval>$=gen_orstart(); }
        condition       { gen_dstlabel($<dval>3); }
    | '(' condition ')' { $<dval>$ = $<dval>2; }
    | name              { if ($1->level != 88)
                        yyerror("condition unknown");
                        gen_condition($1);
                    }
    ;
cond_op:
    CONDITIONAL opt_than_to         { $$ = $1; }
    | NOT CONDITIONAL opt_than_to       { $$ = $2 ^ 7; }
    | CONDITIONAL OR CONDITIONAL opt_than_to
                        { $$ = $1 | $3; }
    ;
opt_sep:
    /* nothing */
    | LISTSEP
    ;
opt_EOS:
    /* nothing */
    | EOS
    ;
opt_next:
    /* nothing */ { $$=0; } 
    | NEXT      { $<ival>-1=$<ival>1; }  /* NEXT/PREV */
    ;
opt_line:
    /* nothing */
    | LINE
    ;
opt_advancing:
    /* nothing */
    | ADVANCING
    ;
opt_than_to:
    /* nothing */
    | CONNECTIVE    { if ($1!=TOTOK && $1!=THAN)
                yyerror("THAN or TO expected");
            }
    ;
opt_program:
    /* nothing */   { $$=0; }
    | PROGRAM   { $$=1; }
    ;
opt_record:
    /* nothing */
    | RECORD
    ;
opt_at: /* nothing */
    | AT
    ;
opt_in: /* nothing */
    | IN
    ;
in_of:
    IN
    | OF
    ;
opt_by: /* nothing */
    | BY 
    ;
opt_upon: /* nothing */
    | UPON 
    ;
opt_with:
    /* nothing */
    | WITH  
    ;
opt_to: /* nothing */
    | CONNECTIVE    { if ($1!=TOTOK) yyerror("TO expected"); }
    ;
req_to: CONNECTIVE  { if ($1!=TOTOK) yyerror("TO required"); }
    ;
coordinates:
    '(' NLITERAL NLITERAL ')'   {
              char *s;
              $$.lin=0;
              s=$2->name;
              while (isdigit(*s) || *s==' ')
                if (*s==' ') { s++; continue; }
                else
                    $$.lin = $$.lin * 10 + *s++ - '0';
              if (*s++!=',')
                yyerror("must have a comma here");
              $$.col=0;
              while (isdigit(*s) || *s==' ')
                if (*s==' ') { s++; continue; }
                else
                    $$.col = $$.col * 10 + *s++ - '0';
              if (*s && *s!=' ')
                yyerror("wrong format for pair");
        }
    ;
open_mode:
    OPENMD                 { $$=$1; }
    | error  { yyerror("unknown OPEN mode"); }
    ;
gname:  name    { 	
		  /* if (!is_variable($1)) {
			yyerror("I need a variable here");
		     } */
			$$ = $1; }
    | gliteral      { $$ = (struct sym *)$1; }
    ;
name_or_lit:
    name      { $$ = $1; }
    | literal { $$ = (struct sym *)$1; }
    ;
noallname:
    name      { $$ = $1; }
    | without_all_literal { $$ = (struct sym *)$1; }
    ;
gliteral:
    without_all_literal
    | all_literal
    ;
without_all_literal:
    literal             { $$=$1; }
    | special_literal   { $$ = $1; }
    ;
all_literal:
    ALL literal { $2->all=1; $$=$2; } 
    | ALL special_literal { $$ = $2; }
    ;
special_literal:
    SPACES          { $$=save_special_literal(' ','X', "%SPACES%"); }
    | ZERONUM       { $$=save_special_literal('0','9', "%ZEROS%"); }
    | QUOTES        { $$=save_special_literal('"','X', "%QUOTES%"); }
    | HIGHVALUES    { $$=save_special_literal('\xff','X', "%HIGH-VALUES%"); }
    | LOWVALUES     { $$=save_special_literal('\0','X', "%LOW-VALUES%"); }
    ;
var_or_nliteral:
    variable        { $$ = $1; }
    | nliteral      { $$ = (struct sym *)$1; }
    ;
nliteral:
    NLITERAL        { save_literal($1,'9'); $1->all = 0; $$=$1; }
    ;
literal:
    NLITERAL        { save_literal($1,'9'); $1->all=0; $$=$1; }
    | CLITERAL      { save_literal($1,'X'); $1->all=0; $$=$1; }
    ;
opt_def_name:
    def_name        { $$ = $1; }
    | /* nothing */ { $$ = NULL; }
    ;
def_name:
    STRING  { if ($1->defined)
                yyerror("variable redefined, %s",$1->name);
              $1->defined=1;
              $$=$1;
            }
    | FILLER    { $<sval>$=alloc_filler(); }
    ;
def_var:
    STRING  { if (!$1->defined)
                    yyerror("variable not defined, %s",
                    $1->name);
                  /*if ($1->times>0) {
                    yyerror("%s must be indexed",$1->name);
                  }*/
                  $<sval>$=$1;
                }
    ;

variable_indexed:
    VARIABLE 
    { 
      if ($1->occurs_flg == 0)
         yyerror("\"%s\" is not an indexed variable ", $1->name);
      $$=$1; 
    } 
    ;

variable:
    VARIABLE {  $$=$1; } 
    | VARIABLE in_of variable { /* unfortunately, this must be
                                right recursive */
            $$=lookup_variable($1,$3); 
            if ($$==NULL)
                yyerror("\"%s\" is not child of \"%s\"",$1,$3);
        }
    | LABELSTR { yyerror("%s is not a defined variable",$1->name); }
    ;
filename:
    literal { $$=(struct sym *)$1; }
    | STRING {$$=$1; }
    ;
name:
    variable '(' {  curr_division = CDIV_SUBSCRIPTS; }
        subscripts  ')' {
                  curr_division = CDIV_PROC;
                  $$ = (struct sym *)create_subscripted_var( $1, $4 ); 
                    check_subscripts($$);
            }
    | variable  { $<sval>$=$1; }
    ;
subscripts:
    subscript   { $$ = $1; }
    | subscripts ',' subscript { 
        $$ = add_subscript( $1, $3 ); }
    ;
subscript:
    gname                   { $$ = create_subscript( $1 ); }
    | subscript '+' gname   { $$ = add_subscript_item( $1, '+', $3 ); } 
    | subscript '-' gname   { $$ = add_subscript_item( $1, '-', $3 ); } 
    ;
integer:
    NLITERAL    {
              char *s;
              $$=0;
              s=$1->name;
              while (isdigit(*s))
                $$ = $$ * 10 + *s++ - '0';
              if (*s)
                yyerror("only integers accepted here");
            }
    ;
label:
    LABELSTR in_of LABELSTR {
            struct sym *lab;
            if ((lab=lookup_label($1,$3))==NULL) { 
                lab = install($1->name,SYTB_LAB,2);
            }
            lab->parent = $3;
            $$ = lab;
        }
    | LABELSTR { $$=$1; }
    ;
anystring:
    STRING
    | LABELSTR
    ;
%%

/*
**  Yacc auxiliary routines
*/

/* ***********************************************
   * hterror is called where yyerror is normally *
   * called within the parser, but it also passes*
   * an error number and severity.  The error    *
   * number identifies the longer description of *
   * the error message in the compiler document- *
   * ation.  The severity is used to set the     *
   * return code that the compiler will return.  *
   ***********************************************/
void hterror(int erno, int severity, char *s,...)
{
HTG_temporary_error_code = erno;
HTG_temporary_severity = severity;

yyerror(s);

HTG_temporary_error_code = 256;
HTG_temporary_severity = 8;
return;
}


extern FILE *o_lst;

void yyerror(char *s,...)
   {
   va_list argptr;
   va_start( argptr, s);
   switch(HTG_temporary_severity)
      {
      case 0:
         {
         fprintf( stderr,"* INFO  * : %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
         if (HTG_list_flag) 
            {
            fprintf( o_lst,"* INFO  * %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
            }
         break;
         }
      case 4:
         {
         fprintf( stderr,"*WARNING* %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
         if (HTG_list_flag) 
            {
            fprintf( o_lst,"*WARNING* %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
            }
         if (HTG_RETURN_CODE < 4)
            { HTG_RETURN_CODE = 4; }
         wrncnt++;
         break;
         }
      case 8:
         {
         fprintf( stderr,"* ERROR * %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
         if (HTG_list_flag) 
            {
            fprintf( o_lst,"* ERROR * %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
            }
         if (HTG_RETURN_CODE < 8)
            { HTG_RETURN_CODE = 8; }
         errcnt++;
         break;
         }
      default:
         {
         fprintf( stderr,"*!ERROR!* %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
         if (HTG_list_flag) 
            {
            fprintf( o_lst,"*!ERROR!* %3d : line %6d, symbol %s: ",
                          HTG_temporary_error_code,lineno,yytext );
            }
         if (HTG_RETURN_CODE < HTG_temporary_severity)
            { HTG_RETURN_CODE = HTG_temporary_severity; }
         errcnt++;
         break;
         }
      }
   vfprintf( stderr, s, argptr );
   fprintf( stderr," ***\n");

if (HTG_list_flag) 
   {
   vfprintf( o_lst, s, argptr );
   fprintf( o_lst," ***\n");
   }
va_end( argptr );

return;
}

void yyunion( YYSTYPE *to, YYSTYPE *from ) {
    memcpy( to, from, sizeof( *from ) );
}

