#ifndef __HTCOBOL_H
#define __HTCOBOL_H

#define organization decimals
#define fdesc location
#define direction access_mode
#define call_mode access_mode
#define sort_data value2
#define record pic
#define recordsym redefines
#define filenamevar son
#define alternate brother
#define scrinfo index

/* current division (cobol source) */
#define CDIV_IDENT 1
#define CDIV_ENVIR 2
#define CDIV_DATA 3
#define CDIV_PROC 4
#define CDIV_COMMENT 5
#define CDIV_FD 6
#define CDIV_REDEF 7
#define CDIV_SUBSCRIPTS 8
#define CDIV_COPY 9
#define CDIV_COPYFILE 10 
#define CDIV_EXCEPTION 11
#define CDIV_PIC 12

/* symbol table selector */
#define SYTB_LIT 1
#define SYTB_VAR 2
#define SYTB_LAB 3

/* set operations */
#define SET_TO 1
#define SET_UP_BY 2
#define SET_DOWN_BY 3

/*
 * Storage for subscripted variable references.
 * First node is the variable, other are subscripts as 
 * variable/literals with operations.
 * For instance: VAR ( SUB1 - 5, SUB2 + 3 ) is represented as
 * 5 nodes: (sy,op) = (VAR,0) (SUB1,'-') (5,',') (SUB2,'+') (3,',')
 * where the numbers are (struct lit *) pointers and the variables
 * are (struct sym *) pointers.
 */
struct vref {
	char litflag;		/* ',' = end of subscript, 
						   '+','-' = subscript arith */	
	struct vref *next;	/* link to next in list or NULL */
	void *sym;     		/* variable/literal at this node */
};

struct lit {
	char litflag;		/* 1 for literals */
	struct lit *next;	/* next in literals list */
	char *name;			/* name (value) of literal */
	char type;
	int  decimals;
	unsigned location;	/* data area for literal @lit+n */
	unsigned descriptor; /* descriptor @lit+n */
	unsigned char all;
	char *nick;
};
/* note: "sym" and "lit" must share the same structure */

struct sym {
	char litflag;		/* 1 for literals, 2 for variables */
	struct sym *next;	/* pointer to next symbol with same hash */
	char *name;			/* symbol (variable) name */
	char type;        	/* label or elementary item or group item */
						/* 9,A,X,B,C=elem; G=group; F=file; R=record; S=screen */
	int decimals;		/* decimal places */
						/* or organization (files ) */
	unsigned location;	/* offset of variable in stack area */
						/* or offset file descriptor in data area */
	unsigned descriptor; /* field descriptor offset in data seg */
						/* or index field descriptor (files) */
	struct sym *clone;	/* NULL if this symbol is unique
						   otherwise, it must be further qualified */	
	int times;		/* occurs times */
	char *picstr;		/* pointer to picture string saved */
	struct sym *parent;	/* pointer to parent node (level)
				   		   pointer to STATUS var (files) */
	struct sym *son; 	/* used in field heirarchy
	                  	   for files this is the assign 
						   variable (filename) */
	struct sym *brother; /* field variable at the same level or
							alternate key list pointer (for indexed files) */
	struct sym *ix_desc; /* key variable (in file descriptor)
				  		    pointer to fdesc (in record) */
	struct scr_info *scr;	/*  screen info in screen items */
	struct lit *value;	/* pointer to literal with initial value */
	struct lit *value2;	/* pointer to first/next key (sort files) */
	int level;			/* level of field */
						/* or ASSIGN TO DISK/PRINTER (files) */
	int access_mode;	/* access mode (files) */
						/* or direction (sort files data ) or call_mode for variables*/
	int sign;			/* signal type (0=no signal,1=trailing) */
	int len;			/* length of item */
	char defined;		/* first time defined? */
	unsigned pic;		/* picture offset in data segment */
						/* or record offset in stack (files) */
	int occurs_flg;
	int linkage_flg;
	struct sym *redefines; /* points to a redefined field 
							or record symbol (files) */
};

/* information required by the 'perform ... varying ... after' statements */
struct perf_info { 
	struct sym *pname1;	  /* symbol name */
	struct sym *pname2;	  /* symbol name */
	unsigned long ljmp;       /* jump label  */
	unsigned long lend;       /* end  label  */
};

struct perform_info { 
       struct perf_info *pf[4]; 
};


/******* supplemental information for screen items **********/
/* this is linked at the sym->index (aliased scrinfo) */
struct scr_info { 
	int attr;
	int line;
	int column;
	short int foreground;
	short int background;
	struct sym *from;
	struct sym *to;
	int label;
};

struct tallying_list {
	struct tallying_list *next;
	struct tallying_for_list *tflist;
	struct sym *count;
};

struct tallying_for_list {
	struct tallying_for_list *next;
	int options;
	struct sym *forvar;
	struct inspect_before_after *before_after;
};

struct replacing_list {
	struct replacing_list *next;
	int options;
	struct sym *byvar;
	struct replacing_by_list *replbylist;
	struct inspect_before_after *before_after;
};

struct replacing_by_list {
	struct replacing_by_list *next;
	struct sym *replvar;
	struct sym *byvar;
	struct inspect_before_after *before_after;
};

struct inspect_before_after {
	struct sym *before;
	struct sym *after;
};


struct alternate_list {
	struct alternate_list *next;
	struct sym *key;
	int duplicates;
};

struct unstring_delimited {
	struct unstring_delimited *next;
	short int all;
	struct sym *var;
};

struct unstring_destinations {
	struct unstring_destinations *next;
	struct sym *var;
	struct sym *delim;
	struct sym *count;
};

struct string_from {
	struct string_from *next;
	struct sym *var;
	struct sym *delim;
};

struct list {
	struct list *next;
	void *var;
};

struct coord_pair {
	int lin;
	int col;
};

struct index_to_table_list {
	struct index_to_table_list *next;
	char *idxname;
	char *tablename;
	char *keyname;
	char seq; /* '0' = none, '1' = ASCENDING, '2' = DESCENDING */
};

union label_def {
	struct {
		unsigned n:15;
		unsigned defined:1;
		unsigned off;
	}l;
	unsigned long x;
};

/* minor token numbers */

/* CONNECTIVES */

#define IS 0
#define ARE 1
/*#define WHEN 2*/
#define TOTOK 3
/*#define FROM 4*/
/*#define	BY 5*/
#define	THAN 6
/*#define OF 7*/
#define NO 8
#define FOR 9
#define THRU 10
/*#define ON 11*/
/*#define WITH 12*/

/* USAGETOK */

#define COMP 0
#define INDEX 1
#define COMP3 2
/*  DISPLAY  e' um token independente deste grupo */

/* DATE-TIME */
#define DATE 0
#define TIME 1
#define INKEY 2

/* OPENMD */

#define INPUT 	1
#define I_O 	2
#define OUTPUT 	3
#define EXTEND  4

/* ZERONUM */

#define ZERO 0
#define ZEROS 1
#define ZEROES 2

/* DIVISNUM */

#define IDENTIFICATION 0
#define ENVIRONMENT 1
#define DATA 2
#define PROCEDURE 3

/* CONDITIONAL */

#define EQUAL 	1
#define LESS  	2
#define GREATER	4
#define GEQ 	5
#define LEQ 	3
#define NEQ 	6

/* COMMENTING */

#define SOURCE_COMPUTER 1
#define OBJECT_COMPUTER 2
#define AUTHOR		3
#define DATE_WRITTEN	4

/* DIRECTION */

#define ASCENDING  1
#define DESCENDING 2

/* SPECIAL VARIABLES  */

#define SVAR_RCODE  	"RETURN-CODE"

/* htcobgen.c */
int hash(char *s);
char *savename(char *s);
struct sym *lookup(char *s, int tab);
struct sym *install(char *name, int tab, int cloning);
struct sym *lookup_label(struct sym *sy, struct sym *parent);
struct sym *lookup_variable(struct sym *sy, struct sym *parent);
void stabs_line(void);
void stabs_block(int end);
void pgm_header(char *id);
void data_trail(void);
void proc_header(int using);
void proc_trail(int using);
void save_field_in_list(struct sym *sy);
void save_literal(struct lit *v, int type);
struct lit *save_special_literal(char val, char picc, char *nick);
void put_disp_list(struct sym *sy);
void push_immed(int i);
void push_eax(void);
void pop_eax(void);
void push_ebx(void);
void asm_call(char *s);
int symlen(struct sym *sy);
void add_alternate_key(struct sym *sy, int duplicates);
struct scr_info *alloc_scr_info(void);
struct inspect_before_after *alloc_inspect_before_after(struct inspect_before_after *ba, int before_after, struct sym *var);
struct tallying_list *alloc_tallying_list(struct tallying_list *tl, struct sym *count, struct tallying_for_list *tfl);
struct tallying_for_list *alloc_tallying_for_list(struct tallying_for_list *tfl, int options, struct sym *forvar, struct inspect_before_after *ba);
struct replacing_list *alloc_replacing_list(struct replacing_list *rl, int options, struct replacing_by_list *rbl, struct sym *byvar, struct inspect_before_after *ba);
struct replacing_by_list *alloc_replacing_by_list(struct replacing_by_list *rbl, struct sym *replvar, struct sym *byvar, struct inspect_before_after *ba);
struct unstring_delimited *alloc_unstring_delimited(short int all, struct sym *var);
struct unstring_destinations *alloc_unstring_dest(struct sym *var, struct sym *delim, struct sym *count);
struct string_from *alloc_string_from(struct sym *var, struct sym *delim);
void gen_unstring(struct sym *var, struct unstring_delimited *delim, struct unstring_destinations *dest, struct sym *ptr, struct sym *tally);
void gen_stringcmd(struct string_from *sf, struct sym *sy, struct sym *ptr);
void gen_display(int dupon, int nl);
void gen_gotoxy(int lin, int col);
void gen_accept(struct sym *sy, int echo, int main);
void gen_accept_from_time(struct sym *sy);
void gen_accept_from_date(struct sym *sy);
void gen_accept_from_inkey(struct sym *sy);
void gen_accept_from_cmdline(struct sym *sy);
void gen_accept_env_var(struct sym *sy);
struct perf_info *create_perf_info(struct sym *sy1, struct sym *sy2, unsigned long lj, unsigned long le);
struct perform_info *create_perform_info(void);
char *check_perform_variables(struct sym *sy1, struct perform_info *pi1);
struct vref *create_subscripted_var(struct sym *sy, struct vref *subs);
struct vref *create_subscript(struct sym *sy);
struct vref *add_subscript_item(struct vref *subs, char op, struct sym *item);
struct vref *add_subscript(struct vref *ref, struct vref *subs);
int check_subscripts(struct sym *subs);
void gen_subscripted(struct vref *subs);
void value_to_eax(struct sym *sy);
void load_location(struct sym *var);
void gen_loadloc(struct sym *sy);
void gen_loadvar(struct sym *sy);
void gen_inspect(struct sym *var, void *list, int operation);
void gen_move(struct sym *sy_src, struct sym *sy_dst);
void gen_initialize(struct sym *sy_dst);
void gen_set(struct sym *idx, int which, struct sym *var);
void gen_add(struct sym *s1, struct sym *s2);
void gen_subtract(struct sym *s1, struct sym *s2);
void gen_multiply(struct sym *s1, struct sym *s2, struct sym *s3);
void gen_divide(struct sym *s1, struct sym *s2, struct sym *s3);
void gen_goto(struct sym *sy);
unsigned long gen_at_end(int status);
unsigned long gen_testif(void);
void gen_not(void);
unsigned long gen_andstart(void);
unsigned long gen_orstart(void);
void gen_dstlabel(unsigned long lbl);
unsigned long gen_passlabel(void);
unsigned long gen_marklabel(void);
void gen_jmplabel(unsigned long lbl);
void gen_push_int(struct sym *sy);
void gen_perform_times(unsigned long lbl);
void gen_perform_thru(struct sym *s1, struct sym *s2);
void gen_perform(struct sym *sy);
void gen_picture(void);
int save_pic_char(char c);
void define_special_fields();
int  define_implicit_field(struct sym *sy, struct sym *sykey, int idxlen); 
struct sym* determine_table_index_name(struct sym *sy);
void gen_SearchLoopCheck(unsigned long lbl5, struct sym *syidx, struct sym *sytbl);
void gen_SearchAllLoopCheck(unsigned long lbl3, struct sym *syidx, struct sym *sytbl, struct sym *syvar, unsigned long lstart, unsigned long lend);
void Initialize_SearchAll_Boundaries(struct sym *sy, struct sym *syidx);
void define_field(int level, struct sym *sy);
void dump_scr_proc(void);
void dump_scr_data(void);
struct sym *alloc_filler(void);
int set_field_length(struct sym *sy, int times);
void set_field_location(struct sym *sy, unsigned location);
void scr_set_column(struct scr_info *si, int val, int plus_minus);
void scr_set_line(struct scr_info *si, int val, int plus_minus);
void update_screen_field(struct sym *sy, struct scr_info *si);
void update_field(void);
void close_fields(void);
void open_section(struct sym *sect);
void close_section(void);
char *label_name(struct sym *lab);
char *var_name(struct sym *sy);
void close_paragr(void);
void open_paragr(struct sym *paragr);
void gen_stoprun(void);
void gen_exit(int code);
void gen_condition(struct sym *sy);
void gen_compare(struct sym *s1, int value, struct sym *s2);
void assign_expr(struct sym *sy);
void push_expr(struct sym *sy);
void add_expr(void);
void subtract_expr(void);
void multiply_expr(void);
void divide_expr(void);
void alloc_file_entry(struct sym *f);
void dump_alternate_keys(struct sym *r, struct alternate_list *alt);
void dump_fdesc(void);
void gen_fdesc(struct sym *f, struct sym *r);
void gen_status(struct sym *f);
void gen_sort(struct sym *f);
void gen_open(int mode, struct sym *f);
void gen_close_sort(struct sym *f);
void gen_close(struct sym *f);
void gen_return(struct sym *f, struct sym *buf);
void gen_read(struct sym *f, struct sym *buf, struct sym *key);
void gen_read_next(struct sym *f, struct sym *buf, int next_prev);
void gen_release(struct sym *r, struct sym *buf);
void gen_write(struct sym *r, int opt, struct sym *buf);
void gen_rewrite(struct sym *r, struct sym *buf);
void gen_start(struct sym *f, int cond, struct sym *key);
void gen_delete(struct sym *f);
void gen_push_using(struct sym *sy);
void gen_save_using(struct sym *sy);
void gen_call(struct lit *v, int stack_size);
void mark_actives(int first, int last);
void dump_symbols(void);
void chg_underline(char *s);
int main(int argc, char *argv[]);
/* htcobol.c */
void hterror(int erno, int severity, char *s, ...);
void yyerror(char *s, ...);
int yyparse(void);
/* htglobals.c */
int process_command_line(int argc, char *argv[]);
int do_file_cleanup(void);
int process_assemble(void);
int process_ld(void);
int read_compiler_options(void);
int check_option(char *option_in, char *arg);
void turn_on_list_mode(void);
void turn_off_list_mode(void);
void turn_on_xref(void);
void turn_off_xref(void);
/* scan.c */
int yylex(void);
void yyrestart(FILE *input_file);
int lex_fgets(char *buf, int maxsize);
void dcs(void);
char *copy_strip_spaces(char *s);
void add_copy_replacement(char *orig_value, char *replacement);
void copy_do_replacements(char *buffer);
void copy_switch(char *filename);
struct reserved_sym *lookup_reserved(char *s);
void install_reserved(void);
int reserved(char *s);
void scdebug(char *fmt, ...);
int yywrap(void);

#endif
