

/* This portion of the compiler processes the
   compiler options files, compiler environment
   variables, and processes the command line for
   flags and options used to determine the 
   compiler behavior.

   This file was formated using indent -gnu -blp


 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "htconfig.h"
#include "htversion.h"
#define __HTGLOBALS_H
#include "htglobals.h"

/* Internal function declarations */
void turn_off_list_mode ();
void turn_on_list_mode ();
void turn_off_xref ();
void turn_on_xref ();
int check_option (char *, char *);

char OPTFILE[PATHMAX];

extern int stabs_on_sw;

int
process_command_line (int argc, char *argv[])
{
  int i, j, x;
  int nargc;
  int sw;
  int rc;
  char **nargv, **tmpargv, *p, *pt, *tmpt;
  char **argval;

  char file_path[PATHMAX];
  char file_base[PATHMAX];
  char file_ext[PATHMAX];
  char ofile[PATHMAX];
  char COBFLAGS[64];

  char COBDIR[PATHMAX];
  char COBOPT[PATHMAX];
  char PWD[PATHMAX];

  char argtmp[120];

/* ***********************************************
 * * Establish our addressability.               *
 * ***********************************************/
  tmpargv = argv;
  argval = argv;
  nargc = argc;

/* ***********************************************
 * * Hard load all of the default compiler       *
 * * behaviors before checking for options.      *
 * ***********************************************/
  turn_off_list_mode ();
  turn_off_xref ();
  HTG_offset_flag = FALSE;
  HTG_full_compile_flag = FALSE;
  HTG_verbose = FALSE;
  HTG_verbose_verbose = FALSE;
  HTG_remove_source_flag = FALSE;
  HTG_retain_symbols = FALSE;
  HTG_dynamic_flag = 0;

  HTG_RETURN_CODE = 0;
  HTG_temporary_error_code = 256;
  HTG_temporary_severity = 12;

  stabs_on_sw = 0;

/* ***********************************************
 * * Clear out all of the name spaces just to    *
 * * be sure that core garbage dosen't get us.   *
 * * This only happens once, so there shouldn't  *
 * * be any real performance issues.             *
 * ***********************************************/
  for (i = 0; i < PATHMAX; i++)
    {
      inputname[i] = 0;
      outputname[i] = 0;
      ofile[i] = 0;
      lstname[i] = 0;
      file_path[i] = 0;
      file_base[i] = 0;
      file_ext[i] = 0;
      HTG_TMPDIR[i] = 0;
//      HTG_COPYDIR[i] = 0;
      COBDIR[i] = 0;
      COBOPT[i] = 0;
      PWD[i] = 0;
    }

  strcpy(HTG_COPYDIR, "./");

  for (i = 0; i < 64; i++)
    {
      COBFLAGS[i] = 0;
    }

/* **********************************************
 * * Print compiler banner                      *
 * **********************************************/
//   if (HTG_verbose == TRUE )
//     { 
//       fprintf (stdout, "\nTiny COBOL 74 Compiler -- Version  '%s'\n\n", PGM_VERSION);
//       fprintf (stdout, "(C) 1999-2000 Rildo Pragana et. al.\n");
//     }
//   fprintf (stdout, "\nTiny COBOL 74 Compiler -- Version  '%s'\n\n", PGM_VERSION);
//   fprintf (stdout, "(C) 1999-2000 Rildo Pragana et. al.\n");

/* **********************************************
 * * Extract relevent environment variables     *
 * **********************************************/
  if (getenv ("COBFLAGS") != NULL)
    {
      strcpy (COBFLAGS, getenv ("COBFLAGS"));
    }
  if (getenv ("TMPDIR") != NULL)
    {
      strcpy (HTG_TMPDIR, getenv ("TMPDIR"));
    }
  else
    {
      strcpy (HTG_TMPDIR, "/tmp/");
    }
  if (HTG_TMPDIR[strlen (HTG_TMPDIR) - 1] != '/')
    {
      strcat (HTG_TMPDIR, "/");
    }
  if (getenv ("COBDIR") != NULL)
    {
      strcpy (COBDIR, getenv ("COBDIR"));
    }
  else
    {
      strcpy (COBDIR, COBDIR_DEFAULT);
//       if (HTG_verbose == TRUE)
//        {
//          printf ("Warning: $COBDIR not set, using %s\n", COBDIR_DEFAULT);
//        }
      fprintf (stderr, "Warning: $COBDIR not set, using %s\n", COBDIR_DEFAULT);
    }
  strcpy (OPTFILE, COBDIR);
  strcat (OPTFILE, "/");
  strcat (OPTFILE, OPTFILE_DEFAULT);

  if (getenv ("PWD") != NULL)
    {
      strcpy (PWD, getenv ("PWD"));
    }
  else
    {
      strcpy (PWD, COBDIR_DEFAULT);
    }

  HTG_LD_OPTIONS[0] = 0;
  HTG_LD_DYNAMIC[0] = 0;

  read_compiler_options ();

/* **********************************************
 * * Parse the command line, determining what   *
 * * features have been selected                *
 * **********************************************/
  i = 0;
  while ((sw = getopt (argc, argv, "B:C:Do:I:PvzVxc?h")) != EOF)
    switch (sw)
      {
      case 'B':
	strcpy (argtmp, optarg);
	if (strcmp (argtmp, "static") == 0)
	  {
	    HTG_dynamic_flag = 1;
	    strcpy (HTG_LD_DYNAMIC, "-static");
	    break;
	  }
	if (strcmp (argtmp, "dynamic") == 0)
	  {
	    strcpy (HTG_LD_DYNAMIC, "-dynamic");
	    HTG_dynamic_flag = 2;
	    break;
	  }
	fprintf (stderr, "Unknown link option %s specified, (static,dynamic) ignoring\n", argtmp);
	break;
      case 'C':
	check_option (optarg, "");
	break;
      case 'o':
	strcpy (ofile, optarg);
	break;
      case 'I':
        if (i == 0) 
         {
	  strcpy (HTG_COPYDIR, optarg);
	  i++;
         }
        else 
         {
	  strcat (HTG_COPYDIR, ":");
	  strcat (HTG_COPYDIR, optarg);
         }
        if (HTG_verbose_verbose == TRUE )
         { 
	  printf ("Adding '%s' to include (copybooks) search path\n", optarg);
         }
	break;
      case 'D':
        stabs_on_sw = 1;
	HTG_retain_symbols = TRUE;
	strcat (HTG_LD_OPTIONS, " -g ");
	break;
      case 'P':
	turn_on_list_mode ();
	break;
      case 'x':
	if (HTG_make_object_flag == TRUE)
	  {
	    fprintf (stderr, "\n*** ERROR *** Incompatible use of compile flag 'x'\n");
	    fprintf (stderr, "              can not select 'x' and 'c' flags\n");
	    exit (16);
	  }
	else
	  {
	    HTG_full_compile_flag = TRUE;
	    break;
	  }
      case 'c':
	if (HTG_full_compile_flag == TRUE)
	  {
	    fprintf (stderr, "\n*** ERROR *** Incompatible use of compile flag 'c'\n");
	    fprintf (stderr, "              can not select 'x' and 'c' flags\n");
	    exit (16);
	  }
	else
	  {
	    HTG_make_object_flag = TRUE;
	    break;
	  }
      case 'z':
	HTG_verbose_verbose = TRUE;
	HTG_verbose = TRUE;
	break;
      case 'v':
	HTG_verbose = TRUE; 
	break;
      case 'V': 
	fprintf (stdout, "%s - %s\n%s: %s\n", HTG_PGM_NAME, PGM_VERSION, PGM_SYS, PGM_COMP_DATE);
	fprintf (stdout, "%s", HTG_COPYWR);
	exit (0);
      case '?':
      case 'h':
      default:
//	fprintf (stdout, "%s - %s", HTG_PGM_NAME, PGM_VERSION);
	fprintf (stdout, "%s - %s\n%s: %s\n", HTG_PGM_NAME, PGM_VERSION, PGM_SYS, PGM_COMP_DATE);
	fprintf (stdout, "%s", HTG_COPYWR);
	fprintf (stdout, "\n%s", HTG_USAGE);
	exit (0);
      }

  if (optind == argc)
    {
      fprintf (stderr, "No input file name provided\n");
      exit (8); 
    }
  strcpy (file_path, argv[optind]);

  if (strlen (HTG_LD_PATHS) == 0) 
    {
      strcpy (HTG_LD_PATHS, HTG_LD_PATHS_DEFAULT);
    }
  if (strlen (HTG_LD_ARGS) == 0)
    {
      if (HTG_dynamic_flag == 2)
	{
	  strcpy (HTG_LD_ARGS, HTG_LD_ARGS_DEFAULT1);
	}
      else
	{
	  strcpy (HTG_LD_ARGS, HTG_LD_ARGS_DEFAULT2);
	}
    }

/* *******************************************
 * * Isolate the base name of the file from  *
 * * the path.                               *
 * *******************************************/
  i = strlen (file_path);
  while (i > 0 && file_path[i] != '/')
    {
      i--;
    }
  if (i > 0)
    {
      i++;
    }
  j = 0;
  x = strlen (file_path);
  while (i < x && i < PATHMAX)
    {
      file_base[j++] = file_path[i];
      file_path[i++] = 0;
    }
  file_base[i] = 0;

/* *******************************************
 * * We have basename, now look for suffix   *
 * *******************************************/

  while (i > 0 && file_base[i] != '.')
    {
      i--;
    }
  if (file_base[i - 1] == '.')
    {
      i++;
    }
  j = 0;
  x = strlen (file_base);
  while (i < x && i < PATHMAX)
    {
      file_ext[j++] = file_base[i];
      file_base[i++] = 0;
    }
  file_ext[i] = 0;
  if (strlen (file_base) <= 0)
    {
      strcpy (file_base, file_ext);
      file_ext[0] = 0;
    }
  if (HTG_verbose_verbose == TRUE)
    {
      printf ("GEC=> path: (%s) base (%s) ext: (%s)\n", file_path, file_base, file_ext);
    }
/* ***************************************************
 * * Fumble around for file extension                *
 * * Force an extension to prevent overwriting exe   *
 * ***************************************************/
  if (strlen (file_ext) == 0)
    {
      strcpy (file_ext, ".cob");
    }
  if (strcmp (file_ext, ".cob") == 0 || strcmp (file_ext, ".COB") == 0)
    {
      strcpy (inputname, file_path);
      strcat (inputname, file_base);
      strcat (inputname, file_ext);
    }
  if (strcmp (file_ext, ".cbl") == 0 || strcmp (file_ext, ".CBL") == 0)
    {
      sprintf (sys_buf, "cobpp -f %s%s%s > %s%s.cob", file_path, file_base, file_ext, HTG_TMPDIR, file_base);
      rc = system (sys_buf);
      if (rc != 0)
	{
	  fprintf (stderr, "error return from cobpp preprocessor - aborting\n");
	  exit (12);
	}
      HTG_remove_source_flag = TRUE;
      strcpy (inputname, HTG_TMPDIR);
      strcat (inputname, file_base);
      strcat (inputname, ".cob");
    }
  if (HTG_full_compile_flag == TRUE && HTG_retain_symbols == FALSE)
    {
      strcpy (outputname, HTG_TMPDIR);
      strcpy (HTG_ASMLST, HTG_TMPDIR);
      strcpy (HTG_OBJECT, HTG_TMPDIR);
    }
  else
    {
      strcpy (outputname, file_path);
      strcpy (HTG_ASMLST, file_path);
      strcpy (HTG_OBJECT, file_path);
    }

  strcpy (lstname, file_path);
  strcat (lstname, file_base);
  strcat (lstname, ".lis");
  strcat (outputname, file_base);
  strcat (outputname, ".s");
  strcat (HTG_ASMLST, file_base);
  strcat (HTG_ASMLST, ".asm.lis");
  strcat (HTG_OBJECT, file_base);
  strcat (HTG_OBJECT, ".o");
  if (strlen (ofile) > 0)
    {
      strcpy (HTG_EXECUTABLE, ofile);
    }
  else
    {
      strcpy (HTG_EXECUTABLE, file_path);
      strcat (HTG_EXECUTABLE, file_base);
    }



  if ((yyin = fopen (inputname, "r")) == NULL)
    {
      printf ("Input file '%s' not found or not readable\n", inputname);
      exit (12);
    }

/* **********************************************
 * * Print compiler banner                      *
 * **********************************************/
  if (HTG_verbose == TRUE )
    { 
      printf ("Tiny COBOL Compiler - (C) 1999-2000 Rildo Pragana et. al.\n");
      printf ("Version  '%s'\n", PGM_VERSION);
    }

  if (HTG_verbose == TRUE ) 
    {
      printf ("Processing '%s'\n", inputname);
      printf ("Full include (copybooks) search path '%s'\n", HTG_COPYDIR);
      printf ("Output file '%s'\n", outputname);
    }
  
//  printf ("Processing '%s'\n", inputname);
//  printf ("Output file '%s'\n", outputname);

  if ((o_src = fopen (outputname, "w")) == NULL)
    {
      fprintf (stderr, "Output file '%s' could not be opened for writing ... aborting\n", outputname);
      exit (12);
    }
  if (HTG_list_flag)
    {
      if (HTG_verbose == TRUE ) 
        {
          printf ("Listing file '%s'\n", lstname);
        }
//      printf ("Listing file '%s'\n", lstname);
      if ((o_lst = fopen (lstname, "w")) == NULL)
	{
	  fprintf (stderr, "* WARNING * Listings file %s could not be opened for writing ...\n", lstname);
	  turn_off_list_mode ();
	  HTG_RETURN_CODE = 4;
	}
    }
  return (0);
}
/* **********************************************
 * * Clean up working files as needed.          *
 * **********************************************/
int
do_file_cleanup ()
{
  if (HTG_retain_symbols == TRUE)
    {
      return (0);
    }
  if (HTG_remove_source_flag == TRUE)
    {
      sprintf (sys_buf, "rm %s", inputname);
      system (sys_buf);
    }
  return (0);
}

/* **********************************************
 * * Execute assembler to generate object file  *
 * **********************************************/
int
process_assemble ()
{
  int rc;

  if (HTG_full_compile_flag == TRUE || HTG_make_object_flag == TRUE)
    {
      sprintf (sys_buf, "as -D -o %s -a=%s %s", HTG_OBJECT, HTG_ASMLST, outputname);
      if (HTG_verbose == TRUE)
	{
          if (HTG_verbose == TRUE)
	    {
	      printf ("%s\n", sys_buf);
 	    }
         printf ("Compiler assembly phase ... ");
	}
//      printf ("Compiler assembly phase ... ");
      rc = system (sys_buf);
      if (HTG_verbose == TRUE ) 
        {
          printf ("return code = %2d\n", rc);
        }
//      printf ("return code = %2d\n", rc);
      if (rc > 0)
	{
	  return (8);
	}
      else
	{
	  if (HTG_retain_symbols != TRUE)
	    {
	      sprintf (sys_buf, "rm -f %s %s\n", outputname, HTG_ASMLST);
	      system (sys_buf);
	    }
	}
    }
  else
    {
      if (HTG_verbose == TRUE ) {
         printf ("Assembler step bypassed\n");
      }
//      printf ("Assembler step bypassed\n");
    }
  return (0);
}


/* **************************************************
 * * Execute link edit to generate executable file  *
 * **************************************************/
int
process_ld ()
{
  int rc;

  if (HTG_full_compile_flag == TRUE)
    {
      sprintf (sys_buf, "gcc %s -o %s %s %s %s %s",
	       HTG_LD_OPTIONS, HTG_EXECUTABLE, HTG_OBJECT,
	       HTG_LD_PATHS, HTG_LD_DYNAMIC, HTG_LD_ARGS);
      if (HTG_verbose_verbose == TRUE)
	{
	  printf ("%s\n", sys_buf);
	}
      if (HTG_verbose_verbose == TRUE)
	{
         printf ("linking %s ... ", HTG_EXECUTABLE);
	}
//      printf ("linking %s ... ", HTG_EXECUTABLE);
      rc = system (sys_buf);
      if (HTG_verbose_verbose == TRUE)
	{
         printf ("return code = %2d\n", rc);
	}
//      printf ("return code = %2d\n", rc);
      if (rc > 0)
	{
	  return (12);
	}
      else
	{
	  sprintf (sys_buf, "rm -f %s\n", HTG_OBJECT);
	  system (sys_buf);
	}
    }
  else
    {
      if (HTG_verbose == TRUE ) {
         printf ("Link Edit step bypassed\n");
      }
//      printf ("Link Edit step bypassed\n");
    }

  return (0);
}

/* **************************************************
 * * Read $COBDIR/cobopt for compiler options       *
 * **************************************************/
int
read_compiler_options ()
{
  FILE *cobopt;
  char optbfr[200];
  char optstr[100];
  char optarg[100];
  int i, j;

  i = 0;
  j = 0;

  if ((cobopt = fopen (OPTFILE, "r")) == NULL)
    {
//       if (HTG_verbose == TRUE)
//        {
//         printf ("Cobol parameter file '%s' not found - using defaults\n", OPTFILE);
//        }
      fprintf (stderr, "Cobol parameter file '%s' not found - using defaults\n", OPTFILE);
      return (1);
    }
//  printf ("Processing compiler parameters\n");
  fprintf (stderr, "Processing compiler parameters\n");
  while (!feof (cobopt))
    {
      i = 0;
      j = 0;
      optstr[0] = 0;
      optarg[0] = 0;
      fgets (optbfr, 200, cobopt);
      if (!feof (cobopt))
	{
	  while (optbfr[i] != ' ' && i < strlen (optbfr))
	    {
	      optstr[j] = optbfr[i];
	      i++;
	      j++;
	      optstr[j] = 0;
	    }
	  j = 0;
	  while (i < strlen (optbfr))
	    {
	      optarg[j] = optbfr[i];
	      i++;
	      j++;
	      optarg[j] = 0;
	    }
	  if (strlen (optarg) == 0)
	    {
	      optstr[strlen (optstr) - 1] = 0;
	    }
	  else
	    {
	      optarg[strlen (optarg) - 1] = 0;
	    }
	  if (strlen (optstr) > 0 && optstr[0] != '#')
	    {
	      check_option (optstr, optarg);
	    }
	}
    }
  fclose (cobopt);
}

#define ARGCOUNT 13
int
check_option (char *option_in, char *arg)
{
  char *option[ARGCOUNT] =
  {
    "ANS85", "NOANS85",
    "COPYEXT",
    "COPYLBR",
    "COPYLIST", "NOCOPYLIST",
    "LIST", "NOLIST",
    "LD_PATH:",
    "LD_LIBS:",
    "XREF", "NOXREF",
    ""};

  int s;
  for (s = 0; s < ARGCOUNT; s++)
    {
      if (strcmp (option[s], option_in) == 0)
	{
	  break;
	}
    }

  switch (s)
    {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      fprintf (stderr, "Option File Option %s is not yet implemented\n", option_in);
      break;
    case 6:
      turn_on_list_mode ();
      break;
    case 7:
      turn_off_list_mode ();
      break;
    case 8:
      strcpy (HTG_LD_PATHS, arg);
      break;
    case 9:
      strcpy (HTG_LD_ARGS, arg);
      break;
    case 10:
      turn_on_xref;
      break;
    case 11:
      turn_off_xref;
      break;
    default:
      fprintf (stderr, "* WARNING * Unknown Compiler Option %s - ignoring\n", option_in);
      HTG_RETURN_CODE = 4;
    }

  return (0);
}

void
turn_on_list_mode ()
{
  HTG_list_flag = TRUE;
  return;
}

void
turn_off_list_mode ()
{
  HTG_list_flag = FALSE;
  return;
}

void
turn_on_xref ()
{
  HTG_sym_flag = TRUE;
  return;
}

void
turn_off_xref ()
{
  HTG_sym_flag = FALSE;
  return;
}

int
find_copybook_file (char *fname)
{
  int r = 1, len;
  char del[2] = ":", *pt, fpath[PATHMAX1];
  struct stat sbuf;
  
  strcpy(fpath, HTG_COPYDIR);
  pt = strtok(fpath, del); 
  if (pt == NULL) {
     len = strlen(fpath);
     if (*(fpath + len - 1) == '/') {
        sprintf(include_full_filename, "%s%s", fpath, fname);
     }
     else {
        sprintf(include_full_filename, "%s/%s", fpath, fname);
     }
     if (HTG_verbose_verbose == TRUE ) {
        printf("filename (fullpath) =%s\n", include_full_filename);
     } 
     if (stat(include_full_filename, &sbuf) == 0) {
        r = 0;
     }
  }
  else {
     len = strlen(pt);
     if (*(pt + len - 1) == '/') {
        sprintf(include_full_filename, "%s%s", pt, fname);
     }
     else {
        sprintf(include_full_filename, "%s/%s", pt, fname);
     }
     if (HTG_verbose_verbose == TRUE ) {
        printf("filename (fullpath) =%s\n", include_full_filename);
     } 
     if (stat(include_full_filename, &sbuf) == 0) {
        r = 0;
     }
     else {
        pt = strtok(NULL, del);
        while (pt != NULL) {
          len = strlen(pt);
          if (*(pt + len - 1) == '/') {
              sprintf(include_full_filename, "%s%s", pt, fname);
          }
          else {
             sprintf(include_full_filename, "%s/%s", pt, fname);
          }
          if (HTG_verbose_verbose == TRUE ) {
             printf("filename (fullpath) =%s\n", include_full_filename);
          } 
          if (stat(include_full_filename, &sbuf) == 0) {
             r = 0;
             pt = NULL;
          }
          else {
             pt = strtok(NULL, del);
          }
        }
     }
  }

  return r;
}
