/* ***********************************************
 * * Global compiler variables                   *
 * ***********************************************/

#define PATHMAX 120
#define PATHMAX1 1024

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define HTG_PGM_NAME	 "TinyCOBOL"
#define HTG_COPYWR       "(C) 1999-2000 Rildo Pragana et. al.\n"
#define HTG_USAGE        "Command line usage: htcobol -[BDcoPxvV] source_file\n\
\t-B mode\tSpecify binding mode (static/dynamic)\n\
\t-c\tCompile to a statically linked object module\n\
\t-C\tPass option to COBOL Compiler\n\
\t-D\tGenerate compiler debugging output\n\
\t-o file\tSpecify executable name (default input x ext)\n\
\t-Ipath\tDefine include(copybooks) search path(s) (default -I./)\n\
\t-P\tGenerate output listing file\n\
\t-v\tGenerate verbose compiler output\n\
\t-z\tGenerate very verbose compiler output\n\
\t-V\tDisplay compiler version information and exit\n\
\t-x\tCompile to an executable module\n\
\n\
\t\t************************************************\n\
\t\t*	    PLANNED BUT NOT YET IMPLEMENTED	   *\n\
\t\t************************************************\n\
\t-A\tPass option to assembler phase\n\
\t-k\tRecognize source files with non-standard extensions\n\
\t-L dir\tpass option to system linker - mantain ordering\n\
\t+L dir\tpass option to system linker - changing ordering\n\
\t-l lib\tpass option to system linker - mantain ordering\n\
\t+l lib\tpass option to system linker - changing ordering\n\
\n"

#include <stdarg.h>

#ifdef __HTGLOBALS_H
/* ******************************************
 * * Define flags and storage for global    *
 * * compiler options                       *
 * ******************************************/
int   HTG_RETURN_CODE = 0;
int   HTG_temporary_error_code = 0;
int   HTG_temporary_severity = 0;
int   wrncnt = 0;
int   errcnt = 0;
short HTG_full_compile_flag = 0;
short HTG_make_object_flag = 0;
short HTG_list_flag = 0;
short HTG_sym_flag = 0;
short HTG_offset_flag = 0;
short HTG_verbose = 0;
short HTG_verbose_verbose = 0;
short HTG_remove_source_flag = 0;
short HTG_retain_symbols = 0;
short HTG_dynamic_flag = 0;
char inputname[PATHMAX];
char outputname[PATHMAX];
char lstname[PATHMAX];
char sys_buf[300];
//char HTG_COPYDIR[PATHMAX];
char HTG_COPYDIR[PATHMAX1];
char HTG_TMPDIR[PATHMAX];
char HTG_ASMLST[PATHMAX];
char HTG_OBJECT[PATHMAX];
char HTG_EXECUTABLE[PATHMAX];
char HTG_LD_OPTIONS[20];
char HTG_LD_PATHS[120];
char HTG_LD_ARGS[120];
char HTG_LD_DYNAMIC[10];

FILE *yyin;
FILE *o_src;
FILE *o_lst;

#else
extern int   HTG_RETURN_CODE;
extern int   HTG_temporary_error_code;
extern int   HTG_temporary_severity;
extern int   wrncnt;
extern int   errcnt;
extern short HTG_full_compile_flag;
extern short HTG_make_object_flag;
extern short HTG_list_flag;
extern short HTG_sym_flag;
extern short HTG_offset_flag;
extern short HTG_verbose;
extern short HTG_verbose_verbose;
extern short HTG_remove_source_flag;
extern short HTG_retain_symbols;
extern short HTG_dynamic_flag;
extern char inputname[PATHMAX];
extern char outputname[PATHMAX];
extern char lstname[PATHMAX];
extern char sys_buf[300];
extern char HTG_COPYDIR[PATHMAX];
extern char HTG_TMPDIR[PATHMAX];
extern char HTG_ASMLST[PATHMAX];
extern char HTG_OBJECT[PATHMAX];
extern char HTG_EXECUTABLE[PATHMAX];
extern char HTG_LD_OPTIONS[20];
extern char HTG_LD_PATHS[120];
extern char HTG_LD_ARGS[120];
extern char HTG_LD_DYNAMIC[10];

extern FILE *yyin;
extern FILE *o_src;
extern FILE *o_lst;

#endif

extern char include_full_filename[];

int process_command_line(int argc, char *argv[]);
int process_assemble( void);
int process_ld( void);
int do_file_cleanup( void);
int find_copybook_file(char *fname);

