//
//  Cobol Compiler Run Time Library -- Accept/Display basic I/O functions
//
//


#include <termios.h>
#include "htcoblib.h"

extern int decimal_comma;
extern int scrio_init;

char *rlbuf=NULL;

#ifdef WANT_READLINE
#ifdef WANT_DYNAMIC_LIBS
char *readline_stub( char *s );
char *(* _readline)( char *s ) = readline_stub;
void add_history_stub( char *s ) { }
void (* _add_history)( char * ) = add_history_stub;

char *
readline_stub( char *s ) {
	char *libname = "libreadline.so";
	void *handle = dlopen(libname,RTLD_LAZY);
	if (!handle) {
		fprintf(stderr,"*ERROR* loading %s: %s\n",libname,dlerror());
		return NULL;
	}
	_readline = dlsym(handle,"readline");
	_add_history = dlsym(handle,"add_history");
	return _readline( s );
}
#else
#define _readline readline
#define _add_history add_history
#endif
#endif

void newline(int dupon) 
{ 
	if (dupon == 1) {
	   putc('\n', stdout);
	}
	else {
	   putc('\n', stderr);
	}
}


void display( buffer,len,dupon )
char *buffer;
int len;
int dupon;
{
	if (dupon == 1) {
	   while (len--) {
		putc(*buffer++, stdout);
	   }
	}
	else {
	   while (len--) {
		putc(*buffer++, stderr);
	   }
	}
	
}


void display_erase(int dupon) 
{ 
	if (dupon == 1) {
	   putc('\f', stdout);
	}
	else {
	   putc('\f', stderr);
	}
}


int accept_time( buffer )
char *buffer;
{
	time_t tnow;
        struct tm *timep;
        char s[7];
        time(&tnow);
	timep = localtime(&tnow);
        sprintf(s,"%02d%02d%02d",timep->tm_hour,timep->tm_min,timep->tm_sec);
        move_bytes(buffer,s,6);
        return 0;
}


int accept_date( buffer )
char *buffer;
{
	time_t tnow;
        struct tm *timep;
        char s[7];
        time(&tnow);
	timep = localtime(&tnow);
        sprintf(s,"%02d%02d%02d",(timep->tm_year)%100,
                (timep->tm_mon)+1,timep->tm_mday);
        move_bytes(buffer,s,6);
        return 0;
}


int accept_std( buffer, f, echo )
char *buffer;
struct fld_desc *f;
int echo;
{
	struct termios attr;
	int r;
	char pic1[3] = "X\000";
	struct fld_desc f1 = {0,'X',0,0,pic1};

	if (echo == 0) {
	
	   // Get terminal attributes
	   //
           if( tcgetattr(STDIN_FILENO, &attr) != 0) 
        	return (-1);

	   // Turn off echo flag 
	   //
           attr.c_lflag &= ~(ECHO); 


	   // Set terminal attributes 
	   // Discard any typed but un-read characters
	   //
           if( tcsetattr(STDIN_FILENO, TCSAFLUSH, &attr) != 0) 
        	 return (-1);

	}

#ifdef WANT_READLINE
	if (isatty(fileno(stdin))) {
		rlbuf = _readline("");
	}
	else {
		gets(rlbuf);
	}
#else
	/* we alloc the line buffer only at the first time */
	if (!rlbuf)
		rlbuf=malloc(8192);
	gets(rlbuf);
#endif	
	r = strlen(rlbuf) ? 0 : -1; /* it's not really "on escape", but... */
	pic1[1] = f1.len = strlen(rlbuf);
#ifdef WANT_READLINE
	if (f1.len)
		_add_history(rlbuf);
#endif
	cob_move( &f1,rlbuf,f,buffer );
#ifdef WANT_READLINE
	/* free the buffer only if it came from a readline call */
	if (isatty(fileno(stdin))
		free(rlbuf);	
#endif

	if (echo == 0) {
	
	   // Turn on echo flag 
	   //
           attr.c_lflag |= ECHO; 


	   // Set terminal attributes 
	   //
           if( tcsetattr(STDIN_FILENO, TCSANOW, &attr) != 0) 
        	return (-1);

	}

    return r;		

}


int accept_cmd_line( ac, av, f, buffer)
int   ac;
char **av;
struct fld_desc *f;
char *buffer;
{

 int len=0, cmderr, cmdac, cmdmaxlen, cmdmaxnum;
 int i, j, r=0;
 char *pt, *pt1;

//  test only
//  fprintf(stderr, "accept_cmd_line : ac=%d;\n", ac);
//  fprintf(stderr, "accept_cmd_line : f.type=%c, f.len=%d\n", f->type, f->len);

 // Test actual buffer length(f->len) is less than min.
 if (f->len < 21 ) {
    fprintf(stderr, 
           "run time error: basic.c @ accept_cmd_line: unacceptable length(%d<21) in command line parms\n",
           f->len);
   return -1;
 }

 sscanf(buffer, "%04d %04d %04d %04d", &cmderr, &cmdac, &cmdmaxnum, &cmdmaxlen);
// test only
//  fprintf(stderr, "cmderr=%04d, cmdac=%04d, cmdmaxnum=%04d, cmdmaxlen=%04d;\n", cmderr, cmdac, cmdmaxnum, cmdmaxlen);
 

 // Test actual buffer length(f->len) and expected length from copybook are equal.
 len = (cmdmaxlen * cmdmaxnum) + 20;

//  test only
//  fprintf(stderr, "expected len=%d, actual len=%d\n", len, f->len);

 if (f->len != len ) {
    fprintf(stderr, 
           "run time error: basic.c @ accept_cmd_line: actual length=%d not equal expected length=%d, in command line parms\n",
            f->len, len);
    sprintf(buffer, "%04d %04d %04d %04d", 1, cmdac, cmdmaxnum, cmdmaxlen);
    return -1;
 }


 // Test if number if input parms exceeds copybook expected max.
 if (ac > cmdmaxnum) {
    fprintf(stderr, 
           "run time error: basic.c @ accept_cmd_line: command line arguments overflow, max=%d actual=%d\n",
            ac, cmdmaxnum);
    sprintf(buffer, "%04d %04d %04d %04d", 1, cmdac, cmdmaxnum, cmdmaxlen);
    return -1;
 }


 // Process input parms 
 // Padd copybook array with spaces.
 // Truncate parms with excess length
 cmderr  = 0;
 pt = buffer + 20;
 for (i=0, pt; i<ac; i++, pt=( buffer + 20) + i*cmdmaxlen) {
     len = strlen(av[i]);
     if (len <= cmdmaxlen) {
        sprintf(pt, "%s", av[i]);
        pt = pt + len;
        for (j=len; j<cmdmaxlen; j++, pt++) {
           *pt = ' ';
        }
     }
     else {
        pt1 = av[i];
        for (j=0; j<cmdmaxlen; j++, pt++, pt1++) {
           *pt = *pt1;
        }
        cmderr = 1;
     }
//      test only
//      fprintf(stderr, "accept_cmd_line : av[%d]=%s;\n", i, av[i]);
 }

 cmdac =  ac;
 sprintf(buffer, "%04d %04d %04d %04d", cmderr, cmdac, cmdmaxnum, cmdmaxlen);
 pt = buffer + 19;
 *pt = ' ';

 return r;
}


int accept_env_var(f, buffer)
struct fld_desc *f;
char *buffer;
{

 int len=0, env_err, env_name_maxlen, env_var_maxlen;
 int i, j, r=0;
 char *pt, *pt1, *envpt;
// const char *envpt;

//  test only
//  fprintf(stderr, "accept_env_var : f.type=%c, f.len=%d\n", f->type, f->len);

 // Test actual buffer length(f->len) is less than min.
 if (f->len < 16 ) {
    fprintf(stderr, 
           "run time error: basicio.c @ accept_env_var: unacceptable length(%d<16) in get environment parms\n",
           f->len);
   return -1;
 }

 sscanf(buffer, "%04d %04d %04d ", &env_err, &env_name_maxlen, &env_var_maxlen);
// test only
//  fprintf(stderr, "env_err=%04d, env_name_maxlen=%04d, env_var_maxlen=%04d\n", 
//          env_err, env_name_maxlen, env_var_maxlen);
 

 // Test actual buffer length(f->len) and expected length from copybook are equal.
 len = env_name_maxlen + env_var_maxlen + 15;

//  test only
//  fprintf(stderr, "expected len=%d, actual f->len=%d\n", len, f->len);

 if (f->len != len ) {
    fprintf(stderr, 
           "run time error: basicio.c @ accept_env_var: actual length=%d not equal expected length=%d, in get environment parms\n",
            f->len, len);
    sprintf(buffer, "%04d %04d %04d ", 100, env_name_maxlen, env_var_maxlen);
    return -1;
 }


 // Process input parms 
 // Determine variable name length and allocate memory
 
 env_err  = 0;
 pt = buffer + 15;
 for (i=0, pt; i<env_name_maxlen; i++, pt++) {
     if (*pt == CHR_BLANK) {
        j = i;
        if ( (envpt = malloc(j)) == NULL) {
           fprintf(stderr, 
                  "run time error: basicio.c @ accept_env_var: memory allocation error, in get environment parms\n");
           sprintf(buffer, "%04d %04d %04d ", 100, env_name_maxlen, env_var_maxlen);
           return -1;
        }
        i = env_name_maxlen + 1;
     }
 }

//  test only
//  fprintf(stderr, "environment variable(string) length=%d;\n", j);

 // Copy to envpt(null terminated string)
 pt  = buffer + 15;
 pt1 = envpt;
 for (i=0, pt; i<j; i++, pt++, pt1++) {
      *pt1 = *pt;
 }
 *pt1 = '\0';

//  test only
//  fprintf(stderr, "environment variable(string)=%s, length=%d;\n", envpt, j);


 // Get environment variable, if it exists
 if ((pt = getenv(envpt)) == NULL) {
    sprintf(buffer, "%04d %04d %04d ", 1, env_name_maxlen, env_var_maxlen);
    r = 1;
 }
 else {
    len = strlen(pt);
    pt1 = buffer + 15 + env_name_maxlen;
    for (i=0; i<env_var_maxlen; i++) {
      if (i<len) {
         *pt1 = *pt;
         pt++;
         pt1++;
      }
      else {
         *pt1 = CHR_BLANK;
         pt1++;
      }
    }
    if (len>env_var_maxlen) {
       sprintf(buffer, "%04d %04d %04d ", 2, env_name_maxlen, env_var_maxlen);
       r = 2;
    }
    else {
       sprintf(buffer, "%04d %04d %04d ", 0, env_name_maxlen, env_var_maxlen);
    }
 }

 free(envpt);

 return r;
}

/* end of basicio.c */

